/*
 * Decompiled with CFR 0.152.
 */
package com.hisilicon.fastboot.model.config;

import com.hisilicon.fastboot.Messages;
import com.hisilicon.fastboot.log.Log;
import com.hisilicon.fastboot.model.BoardConfig;
import com.hisilicon.fastboot.model.LocalConfig;
import com.hisilicon.fastboot.model.ToolType;
import com.hisilicon.fastboot.model.TransferWay;
import com.hisilicon.fastboot.model.cmdline.adapter.CommonAdapter;
import com.hisilicon.fastboot.utilitily.FileUtils;
import com.hisilicon.fastboot.utilitily.IPUtils;
import com.hisilicon.fastboot.utilitily.PropertiesUtility;
import java.io.File;
import java.util.ArrayList;
import org.eclipse.osgi.util.NLS;

public class BurnConfig
extends PropertiesUtility {
    public static final String KEY_CHIPNAME = "chipName";
    public static final String KEY_XMLPATH = "xmlPath";
    public static final String KEY_PROGRAMMER = "programmer";
    public static final String KEY_SERIALPORT = "comport";
    public static final String KEY_SERVERIP = "serverip";
    public static final String KEY_IPADDR = "ipaddr";
    public static final String KEY_NETMASK = "netmask";
    public static final String KEY_GATEWAYIP = "gatewayip";
    public static final String KEY_ETHADDR = "ethaddr";
    public static final String PORT_CONFIGURABLE = "portConfigurable";
    public static final String PORT = "port";
    public static final String TFTP_TIMEOUT = "tftpTimeout";
    public static final String KEY_TRANSFER_MODE = "mode";
    public static final String KEY_TRANSFER_USBTOETHERNET = "usbToEthernet";
    public static final String KEY_JTAG_CONFIG_FREQUENCY = "frequency";
    public static final String KEY_JTAG_SMALL_BOARD_MODEL = "smallboardmodel";
    public static final String BURN_CONFIG_FILE = "burn.config";
    private static String chipName;
    private static String xmlPath;
    private static String programmer;
    private static LocalConfig localConfig;
    private static BoardConfig boardConfig;
    private static boolean portConfigurable;
    private static int port;
    private static int tftpTimeout;
    private static TransferWay transferway;
    private static boolean isUSBToEthernet;
    private boolean loadResult = false;

    public BurnConfig() {
        this.loadResult = this.loadBurnConfig();
    }

    public BurnConfig(String xmlPath) {
        BurnConfig.setXmlPath(xmlPath);
        this.loadResult = this.loadBurnConfig();
    }

    protected boolean getParamBoolValue(String keyName) {
        return super.getParamBoolValue(keyName, BURN_CONFIG_FILE);
    }

    protected int getParamIntValue(String keyName) {
        return super.getParamIntValue(keyName, BURN_CONFIG_FILE);
    }

    protected boolean loadBurnConfig() {
        String programmerPath;
        String path = FileUtils.toAbsolutePath("config" + File.separator + BURN_CONFIG_FILE, ToolType.Cmdline);
        if (!FileUtils.isExists(path)) {
            Log.errorln(NLS.bind((String)Messages.MESSAGE_ERROR_FILE_PATH_DONT_EXIST, (Object)BURN_CONFIG_FILE));
            return false;
        }
        ArrayList<String> definitionLines = FileUtils.readAllLines(path);
        if (definitionLines == null) {
            Log.errorln(NLS.bind((String)"Failed to read the file, the file path is as follows: ", (Object)path));
            return false;
        }
        for (String s : definitionLines) {
            String[] ppt;
            String line = s.trim().replace("\t", "");
            if (line.startsWith("[") || !line.contains("=") || (ppt = line.split("=")).length <= 1) continue;
            this.set(ppt[0], ppt[1]);
        }
        String chipNameStr = BurnConfig.queryForString(KEY_CHIPNAME);
        if (chipNameStr == null || chipNameStr.isEmpty()) {
            Log.errorln(NLS.bind((String)Messages.MESSAGE_ERROR_PARAMETER_DONT_FIND, (Object)KEY_CHIPNAME));
            return false;
        }
        String upperCaseChipName = CommonAdapter.convertChipName(chipNameStr);
        BurnConfig.setChipName(upperCaseChipName);
        if (xmlPath == null) {
            String xmlPathStr = BurnConfig.queryForString(KEY_XMLPATH);
            if (xmlPathStr != null && !xmlPathStr.isEmpty()) {
                BurnConfig.setXmlPath(xmlPathStr);
            } else {
                Log.errorln(NLS.bind((String)Messages.MESSAGE_ERROR_PARAMETER_DONT_FIND, (Object)KEY_XMLPATH));
                return false;
            }
        }
        if ((programmerPath = BurnConfig.queryForString(KEY_PROGRAMMER)) != null && !programmerPath.isEmpty()) {
            BurnConfig.setProgrammer(programmerPath);
        }
        if (!this.loadLocalConfig(ToolType.Cmdline)) {
            return false;
        }
        if (!this.loadBoardConfig(ToolType.Cmdline)) {
            return false;
        }
        Log.println(NLS.bind((String)Messages.MESSAGE_LOAD_FILE_SUCCESS, (Object)BURN_CONFIG_FILE));
        return true;
    }

    private boolean loadBoardConfig(ToolType toolType) {
        String transferModeStr;
        boardConfig = new BoardConfig(toolType);
        String ipaddrStr = BurnConfig.queryForString(KEY_IPADDR);
        if (ipaddrStr == null || ipaddrStr.isEmpty()) {
            Log.errorln(NLS.bind((String)Messages.MESSAGE_ERROR_PARAMETER_DONT_FIND, (Object)KEY_IPADDR));
            return false;
        }
        boardConfig.setIp(ipaddrStr);
        String netmaskStr = BurnConfig.queryForString(KEY_NETMASK);
        if (netmaskStr == null || netmaskStr.isEmpty()) {
            Log.errorln(NLS.bind((String)Messages.MESSAGE_ERROR_PARAMETER_DONT_FIND, (Object)KEY_NETMASK));
            return false;
        }
        boardConfig.setSubnetMask(netmaskStr);
        String gatewayipStr = BurnConfig.queryForString(KEY_GATEWAYIP);
        if (gatewayipStr == null || gatewayipStr.isEmpty()) {
            Log.errorln(NLS.bind((String)Messages.MESSAGE_ERROR_PARAMETER_DONT_FIND, (Object)KEY_GATEWAYIP));
            return false;
        }
        boardConfig.setGateway(gatewayipStr);
        String ethaddrStr = BurnConfig.queryForString(KEY_ETHADDR);
        if (ethaddrStr != null && !ethaddrStr.isEmpty()) {
            boardConfig.setMac(ethaddrStr);
        } else {
            String generatorMAC = IPUtils.generatorMAC();
            boardConfig.setMac(generatorMAC);
        }
        String frequency = BurnConfig.queryForString(KEY_JTAG_CONFIG_FREQUENCY);
        if (frequency != null && !frequency.isEmpty()) {
            try {
                boardConfig.setFrequency(Integer.parseInt(frequency.trim().toString()));
            }
            catch (NumberFormatException numberFormat) {
                Log.errorln(NLS.bind((String)Messages.MESSAGE_ERROR_PARAMETER_DONT_FIND, (Object)KEY_JTAG_CONFIG_FREQUENCY));
                return false;
            }
        } else {
            Log.errorln(NLS.bind((String)Messages.MESSAGE_ERROR_PARAMETER_DONT_FIND, (Object)KEY_JTAG_CONFIG_FREQUENCY));
            return false;
        }
        String portConfigurable = BurnConfig.queryForString(PORT_CONFIGURABLE);
        if (portConfigurable != null && !portConfigurable.isEmpty()) {
            try {
                BurnConfig.setPortConfigurable(Boolean.valueOf(portConfigurable));
            }
            catch (Exception e) {
                Log.errorln(NLS.bind((String)Messages.MESSAGE_ERROR_PARAMETER_DONT_FIND, (Object)PORT_CONFIGURABLE));
                return false;
            }
        } else {
            Log.errorln(NLS.bind((String)Messages.MESSAGE_ERROR_PARAMETER_DONT_FIND, (Object)PORT_CONFIGURABLE));
            return false;
        }
        String port = BurnConfig.queryForString(PORT);
        if (port != null && !port.isEmpty()) {
            try {
                BurnConfig.setPort(Integer.parseInt(port.trim().toString()));
            }
            catch (NumberFormatException numberFormat) {
                Log.errorln(NLS.bind((String)Messages.MESSAGE_ERROR_PARAMETER_DONT_FIND, (Object)PORT));
                return false;
            }
        } else {
            Log.errorln(NLS.bind((String)Messages.MESSAGE_ERROR_PARAMETER_DONT_FIND, (Object)PORT));
            return false;
        }
        String tftpTimeout = BurnConfig.queryForString(TFTP_TIMEOUT);
        if (tftpTimeout != null && !tftpTimeout.isEmpty()) {
            try {
                BurnConfig.setTftpTimeout(Integer.parseInt(tftpTimeout.trim().toString()));
            }
            catch (NumberFormatException numberFormat) {
                Log.errorln(NLS.bind((String)Messages.MESSAGE_ERROR_PARAMETER_DONT_FIND, (Object)TFTP_TIMEOUT));
                return false;
            }
        } else {
            Log.errorln(NLS.bind((String)Messages.MESSAGE_ERROR_PARAMETER_DONT_FIND, (Object)TFTP_TIMEOUT));
            return false;
        }
        String smallboradmodel = BurnConfig.queryForString(KEY_JTAG_SMALL_BOARD_MODEL);
        if (smallboradmodel != null && !smallboradmodel.isEmpty()) {
            try {
                boardConfig.setSmallboradmodel(Integer.parseInt(smallboradmodel.trim().toString()));
            }
            catch (NumberFormatException numberFormat) {
                Log.errorln(NLS.bind((String)Messages.MESSAGE_ERROR_PARAMETER_DONT_FIND, (Object)KEY_JTAG_SMALL_BOARD_MODEL));
                return false;
            }
        } else {
            Log.errorln(NLS.bind((String)Messages.MESSAGE_ERROR_PARAMETER_DONT_FIND, (Object)KEY_JTAG_SMALL_BOARD_MODEL));
            return false;
        }
        String transferUSBToEtherNetStr = BurnConfig.queryForString(KEY_TRANSFER_USBTOETHERNET);
        if (transferUSBToEtherNetStr != null && !transferUSBToEtherNetStr.isEmpty()) {
            BurnConfig.setUSBToEthernet(TransferWay.converntUSBToEtherNet(transferUSBToEtherNetStr));
        }
        if ((transferModeStr = BurnConfig.queryForString(KEY_TRANSFER_MODE)) == null || transferModeStr.isEmpty()) {
            Log.errorln(NLS.bind((String)Messages.MESSAGE_ERROR_PARAMETER_DONT_FIND, (Object)KEY_TRANSFER_MODE));
            return false;
        }
        BurnConfig.setTransferway(TransferWay.convernt(transferModeStr));
        return true;
    }

    private boolean loadLocalConfig(ToolType toolType) {
        localConfig = new LocalConfig(toolType);
        String comPortStr = BurnConfig.queryForString(KEY_SERIALPORT);
        if (comPortStr == null || comPortStr.isEmpty()) {
            Log.errorln(NLS.bind((String)Messages.MESSAGE_ERROR_PARAMETER_DONT_FIND, (Object)KEY_SERIALPORT));
            return false;
        }
        localConfig.setComPort(comPortStr);
        String serveripStr = BurnConfig.queryForString(KEY_SERVERIP);
        if (serveripStr == null || serveripStr.isEmpty()) {
            Log.errorln(NLS.bind((String)Messages.MESSAGE_ERROR_PARAMETER_DONT_FIND, (Object)KEY_SERVERIP));
            return false;
        }
        localConfig.setServerIp(serveripStr);
        return true;
    }

    public static String getChipName() {
        return chipName;
    }

    public static void setChipName(String chipName) {
        BurnConfig.chipName = chipName;
    }

    public static String getXmlPath() {
        return xmlPath;
    }

    public static void setXmlPath(String xmlPath) {
        BurnConfig.xmlPath = xmlPath;
    }

    public static String getProgrammer() {
        return programmer;
    }

    public static void setProgrammer(String programmer) {
        BurnConfig.programmer = programmer;
    }

    public static LocalConfig getLocalConfig() {
        return localConfig;
    }

    public static void setLocalConfig(LocalConfig localConfig) {
        BurnConfig.localConfig = localConfig;
    }

    public static BoardConfig getBoardConfig() {
        return boardConfig;
    }

    public static void setBoardConfig(BoardConfig boardConfig) {
        BurnConfig.boardConfig = boardConfig;
    }

    public static boolean isPortConfigurable() {
        return portConfigurable;
    }

    public static void setPortConfigurable(boolean portConfigurable) {
        BurnConfig.portConfigurable = portConfigurable;
    }

    public static int getPort() {
        return port;
    }

    public static void setPort(int port) {
        BurnConfig.port = port;
    }

    public static int getTftpTimeout() {
        return tftpTimeout;
    }

    public static void setTftpTimeout(int tftpTimeout) {
        BurnConfig.tftpTimeout = tftpTimeout;
    }

    public static TransferWay getTransferway() {
        return transferway;
    }

    public static void setTransferway(TransferWay transferway) {
        BurnConfig.transferway = transferway;
    }

    public static boolean isUSBToEthernet() {
        return isUSBToEthernet;
    }

    public static void setUSBToEthernet(boolean isUSBToEthernet) {
        BurnConfig.isUSBToEthernet = isUSBToEthernet;
    }

    public boolean isLoadResult() {
        return this.loadResult;
    }

    public void setLoadResult(boolean loadResult) {
        this.loadResult = loadResult;
    }
}

