/*
 * Decompiled with CFR 0.152.
 */
package com.hisilicon.fastboot.log;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.osgi.service.datalocation.Location;

public class Log {
    static long max_size = 0x8000000L;
    public static final String NEW_LINE = "\n";

    private static IPath getCachePath() {
        Location installLocation = Platform.getInstallLocation();
        String file = installLocation.getURL().getFile();
        return new Path(file);
    }

    public static IPath getLogFile() {
        return Log.getCachePath().append("HiBurn").addFileExtension("log");
    }

    public static FileOutputStream getLog() throws FileNotFoundException {
        File file = Log.getLogFile().toFile();
        if (file.length() > max_size) {
            return new FileOutputStream(file, false);
        }
        return new FileOutputStream(file, true);
    }

    public static void print(String message) {
        System.out.print(message);
    }

    public static void println(String message) {
        Log.print(String.valueOf(message) + NEW_LINE);
    }

    public static void info(String message) {
        Log.print(message);
    }

    public static void infoln(String message) {
        Log.print(String.valueOf(message) + NEW_LINE);
    }

    public static void error(String message) {
        System.out.print(message);
    }

    public static void errorln(String message) {
        System.out.println("Error: " + message);
    }

    public static void received(String received) {
        System.out.print(received);
    }

    public static void receivedln(String received) {
        System.out.println(received);
    }

    public static void warn(String warning) {
        Log.print(warning);
    }

    public static void warningln(String warning) {
        Log.print(String.valueOf(warning) + NEW_LINE);
    }

    public static void returnError(String error) {
        Log.errorln(error);
    }
}

