/*
 * Decompiled with CFR 0.152.
 */
package com.hisilicon.fastboot.commands;

import com.hisilicon.fastboot.commands.SerialCommand;
import com.hisilicon.fastboot.model.config.BurnConfig;
import com.hisilicon.fastboot.model.config.PreferenceConfig;
import com.hisilicon.fastboot.preferences.FastbootPreferences;
import com.hisilicon.fastboot.utilitily.CRC16;
import com.hisilicon.fastboot.utilitily.HiToolUtils;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.zip.CRC32;

public class CrcCommand
extends SerialCommand {
    private static final String KEY_CRC32 = "crc32";
    private static final String KEY_FLAG = "==>";
    private static int defaultTftpPort = 69;

    private CrcCommand(String command) {
        this.setCommand(command);
    }

    public static CrcCommand sendCRCCommand(File file, String address) {
        long fileSize = file.length();
        StringBuilder commandStr = new StringBuilder();
        commandStr.append(KEY_CRC32);
        commandStr.append(" ");
        commandStr.append(address);
        commandStr.append(" ");
        commandStr.append(Long.toHexString(fileSize));
        CrcCommand crcCommand = new CrcCommand(commandStr.toString());
        crcCommand.setTimeout(CrcCommand.calculateTimeout(file.length()));
        return crcCommand;
    }

    public static int getTFTPPort() {
        int port = HiToolUtils.isCmdLine() ? BurnConfig.getPort() : defaultTftpPort;
        return port;
    }

    private static long calculateTimeout(long length) {
        int speed = 0;
        speed = HiToolUtils.isCmdLine() ? PreferenceConfig.getTftpSpeed() : FastbootPreferences.getInt("hisilicon.fastboot.tftp.speed");
        if (speed == 0) {
            speed = 1;
        }
        return (length / (long)speed + 2L) * 1000L;
    }

    public static int calculateCheckSum(File file) throws IOException {
        int checkSum = 0;
        InputStream inputStream = null;
        try {
            try {
                inputStream = new BufferedInputStream(new FileInputStream(file.getPath()));
                byte[] tempBytes = new byte[32];
                while (inputStream.read(tempBytes) != -1) {
                    int i = 0;
                    while (i < tempBytes.length) {
                        checkSum += tempBytes[i] & 0xFF;
                        ++i;
                    }
                }
            }
            catch (IOException e) {
                try {
                    if (inputStream != null) {
                        inputStream.close();
                    }
                }
                catch (IOException e2) {
                    e2.printStackTrace();
                }
                return 0;
            }
        }
        finally {
            try {
                if (inputStream != null) {
                    inputStream.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return checkSum;
    }

    public static int calculateCRC16(File file) throws IOException {
        int crc16 = 65535;
        InputStream inputStream = null;
        try {
            try {
                inputStream = new BufferedInputStream(new FileInputStream(file.getPath()));
                byte[] tempBytes = new byte[32];
                while (inputStream.read(tempBytes) != -1) {
                    int[] dataList = new int[8];
                    byte[] bytes = null;
                    int k = 0;
                    while (k < dataList.length) {
                        bytes = new byte[4];
                        int i = 0;
                        while (i < 4) {
                            bytes[i] = tempBytes[4 * k + 3 - i];
                            ++i;
                        }
                        dataList[k] = CRC16.bytesToInt(bytes);
                        ++k;
                    }
                    crc16 = CRC16.CRC_CAL_4B(crc16, 1, dataList);
                }
            }
            catch (IOException e) {
                try {
                    if (inputStream != null) {
                        inputStream.close();
                    }
                }
                catch (IOException e2) {
                    e2.printStackTrace();
                }
                return 0;
            }
        }
        finally {
            try {
                if (inputStream != null) {
                    inputStream.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return crc16 & 0xFFFF;
    }

    public static long calculateCRC(File file) throws IOException {
        CRC32 crc32 = new CRC32();
        InputStream inputStream = null;
        try {
            try {
                inputStream = new BufferedInputStream(new FileInputStream(file.getPath()));
                int read = 0;
                while ((read = inputStream.read()) != -1) {
                    crc32.update(read);
                }
            }
            catch (IOException e) {
                try {
                    if (inputStream != null) {
                        inputStream.close();
                    }
                }
                catch (IOException e2) {
                    e2.printStackTrace();
                }
                return 0L;
            }
        }
        finally {
            try {
                if (inputStream != null) {
                    inputStream.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return crc32.getValue();
    }

    public static long receiveCRC(String crcStr) {
        String substring = crcStr.substring(crcStr.indexOf(KEY_FLAG) + KEY_FLAG.length(), crcStr.indexOf("\r\n")).trim();
        long crcValue = Long.parseLong(substring, 16);
        return crcValue;
    }

    public static boolean compareFileCRC(long fileCrc, long receiveCrcValue) {
        return fileCrc == receiveCrcValue;
    }
}

