/*
 * Decompiled with CFR 0.152.
 */
package com.hisilicon.fastboot;

import com.hisilicon.fastboot.consoles.FastbootConsoleFactory;
import com.hisilicon.fastboot.log.Log;
import com.hisilicon.fastboot.model.devices.ISaveable;
import com.hisilicon.fastboot.model.event.FastbootEvent;
import com.hisilicon.fastboot.utilitily.FileUtils;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashSet;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.osgi.framework.BundleContext;

public class Activator
extends AbstractUIPlugin {
    public static final String PLUGIN_ID = "com.hisilicon.fastboot";
    private static Activator plugin;
    private static long max_size;
    private HashSet<ISaveable> saveables = new HashSet();
    private FastbootEvent event;

    static {
        max_size = 0x8000000L;
    }

    public static Image getImage(String imagePath) {
        ImageDescriptor imageDesc = null;
        if (!PlatformUI.isWorkbenchRunning()) {
            URL url = Activator.class.getResource(".");
            if (url == null) {
                return null;
            }
            String urlStr = url.toString();
            int index = urlStr.indexOf(PLUGIN_ID);
            urlStr = urlStr.substring(0, index + PLUGIN_ID.length());
            urlStr = String.valueOf(urlStr) + (imagePath.startsWith("/") ? imagePath : "/" + imagePath);
            try {
                url = new URL(urlStr);
                InputStream sourceStream = url.openStream();
                ImageData source = new ImageData(sourceStream);
                ImageData mask = source.getTransparencyMask();
                return new Image(null, source, mask);
            }
            catch (MalformedURLException e) {
                e.printStackTrace();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        } else {
            imageDesc = Activator.imageDescriptorFromPlugin((String)PLUGIN_ID, (String)imagePath);
        }
        if (imageDesc == null) {
            return null;
        }
        return imageDesc.createImage();
    }

    public void start(BundleContext context) throws Exception {
        super.start(context);
        Activator.setPlugin(this);
        try {
            File file = Log.getLogFile().toFile();
            if (file.exists() && file.length() > max_size) {
                FileUtils.deleteFile(file);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void stop(BundleContext context) throws Exception {
        Activator.setPlugin(null);
        super.stop(context);
        FastbootConsoleFactory.clearConsole();
    }

    public static Activator getDefault() {
        return plugin;
    }

    public FastbootEvent getEvent() {
        return this.event;
    }

    public void setEvent(FastbootEvent event) {
        this.event = event;
    }

    public void add(ISaveable saveable) {
        this.saveables.add(saveable);
    }

    public HashSet<ISaveable> getSaveables() {
        return this.saveables;
    }

    public static void setPlugin(Activator plugin) {
        Activator.plugin = plugin;
    }
}

