/*
 * Decompiled with CFR 0.152.
 */
package com.soyatec.hisilicon.platform.ui.tool;

import com.soyatec.hisilicon.platform.core.ToolDescriptor;
import com.soyatec.hisilicon.platform.ui.Messages;
import com.soyatec.hisilicon.platform.ui.internal.ControlFactory;
import com.soyatec.hisilicon.platform.ui.internal.RegisterUtils;
import com.soyatec.hisilicon.platform.ui.internal.TestBuildUtils;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class RegisterDialog
extends Dialog {
    private Label registerStatus;
    private Text registerCode;
    private ToolDescriptor tool;
    private Pattern pswPattern = Pattern.compile("[0-9A-Za-z_]+");

    public RegisterDialog(Shell parentShell, ToolDescriptor tool) {
        super(parentShell);
        this.setShellStyle(this.getShellStyle() | 0x10);
        this.tool = tool;
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText(Messages.RegisterDialog_0);
    }

    protected Control createDialogArea(Composite parent) {
        Composite comp = (Composite)super.createDialogArea(parent);
        Display d = this.getShell().getDisplay();
        this.registerStatus = ControlFactory.createLabel(comp, Messages.RegisterDialog_1, 1);
        ControlFactory.setColor(d.getSystemColor(3), this.registerStatus);
        ControlFactory.createLabel(comp, Messages.RegisterDialog_2, 1);
        this.registerCode = ControlFactory.createLongTextField(comp, 1, 2048);
        GridData layoutData = (GridData)this.registerCode.getLayoutData();
        layoutData.widthHint = 260;
        this.registerCode.setLayoutData((Object)layoutData);
        this.updateStatus();
        return comp;
    }

    protected Control createContents(Composite parent) {
        Control createContents = super.createContents(parent);
        this.getShell().pack();
        return createContents;
    }

    private void updateStatus() {
        if (TestBuildUtils.isTestBuild(this.tool.getProperties())) {
            this.registerStatus.setText(Messages.RegisterDialog_3);
            this.registerCode.setEnabled(false);
        } else if (RegisterUtils.isUnlimited(this.tool.getProperties())) {
            this.registerStatus.setText(Messages.RegisterDialog_3);
            this.registerCode.setEnabled(false);
        } else if (RegisterUtils.getRegisterDate(this.tool.getProperties()) != null) {
            this.registerStatus.setText(Messages.RegisterDialog_4);
        } else {
            this.registerStatus.setText(Messages.RegisterDialog_5);
        }
    }

    protected void createButtonsForButtonBar(Composite parent) {
        GridData data = new GridData(4, 0x1000000, true, false);
        parent.setLayoutData((Object)data);
        Button registerButton = this.createButton(parent, 0, Messages.RegisterDialog_6, true);
        Button closeButton = this.createButton(parent, 1, Messages.RegisterDialog_7, false);
        GridData registerGD = (GridData)registerButton.getLayoutData();
        registerGD.horizontalAlignment = 0x1000000;
        registerGD.grabExcessHorizontalSpace = true;
        GridData closeGD = (GridData)closeButton.getLayoutData();
        closeGD.horizontalAlignment = 0x1000000;
        closeGD.grabExcessHorizontalSpace = true;
    }

    void setRegiserStatus(String state) {
        if (state == null) {
            this.registerStatus.setText("");
        } else {
            this.registerStatus.setText(state);
        }
    }

    protected void okPressed() {
        try {
            String code = this.registerCode.getText();
            if (code == null || code.length() == 0) {
                MessageDialog.openError((Shell)this.getShell(), (String)Messages.RegisterDialog_9, (String)Messages.RegisterDialog_10);
                return;
            }
            Matcher matcher = this.pswPattern.matcher(code);
            if (!matcher.matches()) {
                MessageDialog.openWarning((Shell)this.getShell(), (String)Messages.RegisterDialog_20, (String)Messages.RegisterDialog_21);
                return;
            }
            if (!this.process()) {
                MessageDialog.openError((Shell)this.getShell(), (String)Messages.RegisterDialog_11, (String)Messages.RegisterDialog_12);
                return;
            }
        }
        catch (Exception e) {
            MessageDialog.openError((Shell)this.getShell(), (String)Messages.RegisterDialog_13, (String)(String.valueOf(Messages.RegisterDialog_14) + e.getMessage()));
            return;
        }
        MessageDialog.openInformation((Shell)this.getShell(), (String)Messages.RegisterDialog_15, (String)Messages.RegisterDialog_16);
        this.setReturnCode(0);
        this.close();
    }

    private boolean process() {
        String code = this.registerCode.getText();
        return RegisterUtils.registerCode(this.tool.getProperties(), code);
    }
}

