/*
 * Decompiled with CFR 0.152.
 */
package com.soyatec.hisilicon.platform.ui.internal;

import com.soyatec.hisilicon.platform.core.PlatformCoreActivator;
import com.soyatec.hisilicon.platform.core.ToolDescriptor;
import com.soyatec.hisilicon.platform.ui.PlatformUIActivator;
import com.soyatec.hisilicon.platform.ui.internal.BundleUtils;
import java.io.IOException;
import java.util.List;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.Status;
import org.eclipse.equinox.internal.p2.core.helpers.ServiceHelper;
import org.eclipse.equinox.internal.p2.ui.ProvUI;
import org.eclipse.equinox.internal.p2.ui.ProvUIActivator;
import org.eclipse.equinox.internal.p2.ui.ProvUIMessages;
import org.eclipse.equinox.internal.p2.ui.dialogs.ApplyProfileChangesDialog;
import org.eclipse.equinox.internal.provisional.configurator.Configurator;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.osgi.framework.BundleContext;

public class ToolUpdateUtils {
    public static void requestRestart(final int restartPolicy) {
        if (restartPolicy == 1) {
            PlatformUI.getWorkbench().restart();
            return;
        }
        if (restartPolicy == 2) {
            ToolUpdateUtils.applyProfileChanges();
            return;
        }
        PlatformUI.getWorkbench().getDisplay().asyncExec(new Runnable(){

            @Override
            public void run() {
                if (PlatformUI.getWorkbench().isClosing()) {
                    return;
                }
                int retCode = ApplyProfileChangesDialog.promptForRestart((Shell)ProvUI.getDefaultParentShell(), (restartPolicy == 3 ? 1 : 0) != 0);
                if (retCode == 1) {
                    ToolUpdateUtils.applyProfileChanges();
                } else if (retCode == 2) {
                    PlatformUI.getWorkbench().restart();
                }
            }
        });
    }

    public static void applyProfileChanges() {
        Configurator configurator = (Configurator)ServiceHelper.getService((BundleContext)ProvUIActivator.getContext(), (String)Configurator.class.getName());
        if (configurator == null) {
            return;
        }
        try {
            configurator.applyConfiguration();
        }
        catch (IOException e) {
            PlatformCoreActivator.getLogger((Plugin)PlatformUIActivator.getDefault()).logError(e.getMessage(), (Throwable)e);
            ProvUI.handleException((Throwable)e, (String)ProvUIMessages.ProvUI_ErrorDuringApplyConfig, (int)5);
        }
        catch (IllegalStateException e) {
            PlatformCoreActivator.getLogger((Plugin)PlatformUIActivator.getDefault()).logError(e.getMessage(), (Throwable)e);
            Status illegalApplyStatus = new Status(2, "org.eclipse.equinox.p2.ui", 0, ProvUIMessages.ProvisioningOperationRunner_CannotApplyChanges, (Throwable)e);
            ProvUI.reportStatus((IStatus)illegalApplyStatus, (int)5);
        }
    }

    public static void setToolEnableState(ToolDescriptor toolDescriptor, boolean enable) {
        List plugins = toolDescriptor.getPlugins();
        for (Object o : plugins) {
            ToolDescriptor.PluginDetail p = (ToolDescriptor.PluginDetail)o;
            BundleUtils.setBundleEnabled(p.getPluginId(), enable);
        }
    }
}

