/*
 * Decompiled with CFR 0.152.
 */
package com.soyatec.hisilicon.platform.ui.internal;

import com.soyatec.hisilicon.platform.ui.Messages;
import java.lang.reflect.InvocationTargetException;
import java.net.URI;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.equinox.p2.core.IProvisioningAgent;
import org.eclipse.equinox.p2.core.ProvisionException;
import org.eclipse.equinox.p2.metadata.IInstallableUnit;
import org.eclipse.equinox.p2.operations.ProvisioningJob;
import org.eclipse.equinox.p2.operations.ProvisioningSession;
import org.eclipse.equinox.p2.operations.Update;
import org.eclipse.equinox.p2.operations.UpdateOperation;
import org.eclipse.equinox.p2.query.IQueryResult;
import org.eclipse.equinox.p2.query.QueryUtil;
import org.eclipse.equinox.p2.repository.artifact.IArtifactRepositoryManager;
import org.eclipse.equinox.p2.repository.metadata.IMetadataRepositoryManager;

public class P2Utils {
    public static IStatus checkForUpdates(IProvisioningAgent agent, URI repoLocation, IProgressMonitor monitor) throws OperationCanceledException, InvocationTargetException {
        P2Utils.addUpdateSite(agent, repoLocation);
        IMetadataRepositoryManager metadataManager = (IMetadataRepositoryManager)agent.getService(IMetadataRepositoryManager.SERVICE_NAME);
        P2Utils.logRepositories(metadataManager);
        ProvisioningSession session = new ProvisioningSession(agent);
        UpdateOperation operation = new UpdateOperation(session);
        SubMonitor sub = SubMonitor.convert((IProgressMonitor)monitor, (String)Messages.P2Utils_0, (int)200);
        IStatus status = operation.resolveModal((IProgressMonitor)sub.newChild(100));
        if (status.getCode() == 10000) {
            return status;
        }
        if (status.getSeverity() == 8) {
            return status;
        }
        if (status.getSeverity() != 4) {
            try {
                Update[] updates = operation.getPossibleUpdates();
                ProvisioningJob job = operation.getProvisioningJob(null);
                status = job.runModal((IProgressMonitor)sub.newChild(100));
                if (status.getSeverity() == 8) {
                    return status;
                }
            }
            catch (Exception e) {
                status = new Status(4, "com.soyatec.hisilicon.platform.ui", e.getMessage());
            }
        }
        return status;
    }

    private static void logRepositories(IMetadataRepositoryManager metadataManager) {
        URI[] repos = metadataManager.getKnownRepositories(0);
        P2Utils.logRespositories(repos);
    }

    private static void logRespositories(URI[] repos) {
        URI[] uRIArray = repos;
        int n = repos.length;
        int n2 = 0;
        while (n2 < n) {
            URI uRI = uRIArray[n2];
            ++n2;
        }
    }

    private static IQueryResult<IInstallableUnit> queryIusFromMetadataManager(IMetadataRepositoryManager metadataManager) {
        IQueryResult ius = metadataManager.query(QueryUtil.createIUGroupQuery(), (IProgressMonitor)new NullProgressMonitor());
        for (IInstallableUnit iInstallableUnit : ius) {
        }
        return ius;
    }

    private static void addUpdateSite(IProvisioningAgent provisioningAgent, URI repoLocation) throws InvocationTargetException {
        IMetadataRepositoryManager metadataManager = (IMetadataRepositoryManager)provisioningAgent.getService(IMetadataRepositoryManager.SERVICE_NAME);
        if (metadataManager == null) {
            Throwable throwable = new Throwable(Messages.P2Utils_1);
            throwable.fillInStackTrace();
            throw new InvocationTargetException(throwable);
        }
        IArtifactRepositoryManager artifactManager = (IArtifactRepositoryManager)provisioningAgent.getService(IArtifactRepositoryManager.SERVICE_NAME);
        if (artifactManager == null) {
            Throwable throwable = new Throwable(Messages.P2Utils_2);
            throwable.fillInStackTrace();
            throw new InvocationTargetException(throwable);
        }
        try {
            metadataManager.loadRepository(repoLocation, null);
            artifactManager.loadRepository(repoLocation, null);
        }
        catch (ProvisionException pe) {
            throw new InvocationTargetException(pe);
        }
    }
}

