/*
 * Decompiled with CFR 0.152.
 */
package com.soyatec.hisilicon.platform.ui.internal;

import com.soyatec.hisilicon.platform.ui.Messages;
import com.soyatec.hisilicon.platform.ui.internal.IniUtils;
import com.soyatec.hisilicon.platform.ui.internal.PlatformStateControlUtils;
import java.util.Locale;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;

public class LanguageMenuBuilder
implements IMenuListener {
    private Action chineseLanguageAction = new Action(Messages.LanguageMenuBuilder_0, 8){

        public void run() {
            if (this.isChecked()) {
                Locale recordLocal = LanguageMenuBuilder.this.getCurrentLocale();
                IniUtils.updateIniConfiguration("osgi.nl", Locale.SIMPLIFIED_CHINESE.toString());
                if (!PlatformUI.getWorkbench().restart()) {
                    if (recordLocal == Locale.US) {
                        IniUtils.updateIniConfiguration("osgi.nl", Locale.US.toString());
                        if (LanguageMenuBuilder.this.chineseLanguageAction.isChecked()) {
                            LanguageMenuBuilder.this.chineseLanguageAction.setChecked(false);
                        }
                        LanguageMenuBuilder.this.enLanguageAction.setChecked(true);
                    }
                    MessageDialog.openWarning((Shell)Display.getDefault().getActiveShell(), (String)Messages.SwitchLanguageFailed, (String)Messages.SwitchLanguageFailedInfo);
                }
            }
        }
    };
    private Action enLanguageAction;

    public LanguageMenuBuilder() {
        this.chineseLanguageAction.setId("com.soyatec.hisilicon.switchChineseLanguage");
        this.enLanguageAction = new Action(Messages.LanguageMenuBuilder_2, 8){

            public void run() {
                if (this.isChecked()) {
                    Locale recordLocal = LanguageMenuBuilder.this.getCurrentLocale();
                    IniUtils.updateIniConfiguration("osgi.nl", Locale.US.toString());
                    if (!PlatformUI.getWorkbench().restart()) {
                        if (recordLocal == Locale.SIMPLIFIED_CHINESE) {
                            IniUtils.updateIniConfiguration("osgi.nl", Locale.SIMPLIFIED_CHINESE.toString());
                            if (LanguageMenuBuilder.this.enLanguageAction.isChecked()) {
                                LanguageMenuBuilder.this.enLanguageAction.setChecked(false);
                            }
                            LanguageMenuBuilder.this.chineseLanguageAction.setChecked(true);
                        }
                        MessageDialog.openWarning((Shell)Display.getDefault().getActiveShell(), (String)Messages.SwitchLanguageFailed, (String)Messages.SwitchLanguageFailedInfo);
                    }
                }
            }
        };
        this.enLanguageAction.setId("com.soyatec.hisilicon.switchEnglishLanguage");
    }

    public void menuAboutToShow(IMenuManager manager) {
        this.fillMenu(manager);
        boolean platformEnabled = PlatformStateControlUtils.isPlatformEnabled();
        this.enLanguageAction.setEnabled(platformEnabled);
        this.chineseLanguageAction.setEnabled(platformEnabled);
    }

    public void fillMenu(IMenuManager manager) {
        manager.removeAll();
        String nl = IniUtils.getIniConfiguration("osgi.nl");
        if (nl.length() == 0 && !(nl = Locale.getDefault().toString()).equals(Locale.US.toString()) && !nl.equals(Locale.SIMPLIFIED_CHINESE.toString())) {
            if (nl.startsWith("en_")) {
                nl = Locale.US.toString();
            } else if (nl.startsWith("zh_")) {
                nl = Locale.SIMPLIFIED_CHINESE.toString();
            }
        }
        if (nl.equals(Locale.US.toString())) {
            this.enLanguageAction.setChecked(true);
        } else if (nl.equals(Locale.SIMPLIFIED_CHINESE.toString())) {
            this.chineseLanguageAction.setChecked(true);
        }
        manager.add((IAction)this.chineseLanguageAction);
        manager.add((IAction)this.enLanguageAction);
    }

    public Locale getCurrentLocale() {
        String nl = IniUtils.getIniConfiguration("osgi.nl");
        if (nl.length() == 0) {
            nl = Locale.getDefault().toString();
        }
        if (nl.equals(Locale.US.toString())) {
            return Locale.US;
        }
        if (nl.equals(Locale.SIMPLIFIED_CHINESE.toString())) {
            return Locale.SIMPLIFIED_CHINESE;
        }
        return Locale.getDefault();
    }
}

