/*
 * Decompiled with CFR 0.152.
 */
package com.soyatec.hisilicon.platform.ui.internal;

import com.soyatec.hisilicon.platform.api.chips.Chips;
import com.soyatec.hisilicon.platform.core.PlatformCoreActivator;
import com.soyatec.hisilicon.platform.core.ToolDescriptor;
import com.soyatec.hisilicon.platform.core.internal.DeviceManager;
import com.soyatec.hisilicon.platform.ui.Messages;
import com.soyatec.hisilicon.platform.ui.PlatformUIActivator;
import com.soyatec.hisilicon.platform.ui.internal.PerspectiveUtil;
import com.soyatec.hisilicon.platform.ui.internal.RegisterUtils;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.Status;
import org.eclipse.help.internal.HelpPlugin;
import org.eclipse.osgi.service.resolver.BundleDescription;
import org.eclipse.osgi.service.resolver.BundleSpecification;
import org.eclipse.osgi.service.resolver.DisabledInfo;
import org.eclipse.osgi.service.resolver.ImportPackageSpecification;
import org.eclipse.osgi.service.resolver.PlatformAdmin;
import org.eclipse.osgi.service.resolver.ResolverError;
import org.eclipse.osgi.service.resolver.State;
import org.eclipse.osgi.service.resolver.VersionConstraint;
import org.eclipse.osgi.service.resolver.VersionRange;
import org.eclipse.osgi.util.NLS;
import org.eclipse.ui.internal.registry.PerspectiveDescriptor;
import org.eclipse.ui.internal.registry.PerspectiveRegistry;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleException;
import org.osgi.service.packageadmin.PackageAdmin;
import org.osgi.util.tracker.ServiceTracker;

public class BundleUtils {
    private ServiceTracker packageAdminTracker;
    private ServiceTracker platformAdminTracker;
    public static final Map<String, String> PERS_BUNDLE_ID_MAP = new HashMap<String, String>();
    private static BundleUtils instance;

    public static String findBundleIDByPersID(PerspectiveRegistry perspectiveReg, String id) {
        PerspectiveDescriptor perspective = (PerspectiveDescriptor)perspectiveReg.findPerspectiveWithId(id);
        String bundleId = null;
        if (perspective != null) {
            Bundle bundle = Platform.getBundle((String)perspective.getPluginId());
            bundleId = String.valueOf(bundle.getBundleId());
        }
        return bundleId;
    }

    public static synchronized void insertMapping(String persID, String bundleID) {
        if (bundleID != null && bundleID.length() > 0) {
            PERS_BUNDLE_ID_MAP.put(persID, bundleID);
        }
    }

    private BundleUtils(BundleContext context) {
        this.packageAdminTracker = new ServiceTracker(context, PackageAdmin.class.getName(), null);
        this.packageAdminTracker.open();
        this.platformAdminTracker = new ServiceTracker(context, PlatformAdmin.class.getName(), null);
        this.platformAdminTracker.open();
    }

    public static synchronized BundleUtils getInstance() {
        if (instance == null) {
            instance = new BundleUtils(PlatformUIActivator.getDefault().getContext());
        }
        return instance;
    }

    public State getBundlesState() {
        PackageAdmin packageAdmin = (PackageAdmin)this.getPlatformAdmin();
        if (packageAdmin == null) {
            return null;
        }
        return this.getPlatformAdmin().getState(false);
    }

    public PackageAdmin getPackageAdmin() {
        if (this.packageAdminTracker == null) {
            return null;
        }
        return (PackageAdmin)this.packageAdminTracker.getService();
    }

    public PlatformAdmin getPlatformAdmin() {
        if (this.platformAdminTracker == null) {
            return null;
        }
        return (PlatformAdmin)this.platformAdminTracker.getService();
    }

    public static void startBundle(long id) throws BundleException {
        PlatformCoreActivator.getDefault();
        PlatformCoreActivator.getBundleContext().getBundle(id).start();
    }

    public static void stopBundle(long id) throws BundleException {
        PlatformCoreActivator.getDefault();
        PlatformCoreActivator.getBundleContext().getBundle(id).stop();
    }

    public static void startBundle(String name) throws BundleException {
        if (BundleUtils.getBundleId(name) != null) {
            BundleUtils.startBundle(BundleUtils.getBundleId(name));
        }
    }

    public static void stopBundle(String name) throws BundleException {
        if (BundleUtils.getBundleId(name) != null) {
            BundleUtils.stopBundle(BundleUtils.getBundleId(name));
        }
    }

    public static Long getBundleId(String name) {
        BundleDescription descr = PlatformCoreActivator.getDefault().getPlatformAdmin().getState(false).getBundle(name, null);
        return descr == null ? null : Long.valueOf(descr.getBundleId());
    }

    public static boolean isToolEnabled(ToolDescriptor tool) {
        List list = tool.getPlugins();
        if (list.size() == 0) {
            return true;
        }
        return BundleUtils.isBundleEnabled(((ToolDescriptor.PluginDetail)list.get(0)).getPluginId());
    }

    public static boolean isToolRegistered(ToolDescriptor tool) {
        Date d = RegisterUtils.getRegisterDate(tool.getProperties());
        return d != null;
    }

    public static boolean isBundleEnabled(String name) {
        State state = PlatformCoreActivator.getDefault().getPlatformAdmin().getState(false);
        BundleDescription descr = state.getBundle(name, null);
        if (descr != null) {
            return BundleUtils.isBundleEnabled(descr.getBundle());
        }
        return false;
    }

    public static boolean isBundleEnabled(Bundle bundle) {
        PlatformAdmin plaformAdmin = PlatformCoreActivator.getDefault().getPlatformAdmin();
        State state = plaformAdmin.getState(false);
        if (state != null && bundle != null) {
            BundleDescription description = state.getBundle(bundle.getBundleId());
            return state.getDisabledInfos(description).length == 0;
        }
        return false;
    }

    public static void setBundleEnabled(String name, boolean enabled) {
        Long bundleId = BundleUtils.getBundleId(name);
        if (bundleId != null) {
            BundleUtils.setBundleEnabled(bundleId, enabled);
        }
    }

    public static void setBundleEnabled(long id, boolean enabled) {
        State state = PlatformCoreActivator.getDefault().getState();
        BundleDescription desc = state.getBundle(id);
        if (desc == null) {
            return;
        }
        if (enabled) {
            DisabledInfo[] infos = state.getDisabledInfos(desc);
            if (infos != null) {
                int i = 0;
                while (i < infos.length) {
                    PlatformAdmin platformAdmin = PlatformCoreActivator.getDefault().getPlatformAdmin();
                    platformAdmin.removeDisabledInfo(infos[i]);
                    ++i;
                }
            }
        } else {
            DisabledInfo info = new DisabledInfo("org.eclipse.pde.ui", "Disabled via PDE", desc);
            PlatformAdmin platformAdmin = PlatformCoreActivator.getDefault().getPlatformAdmin();
            platformAdmin.addDisabledInfo(info);
        }
        PlatformCoreActivator.getDefault();
        Bundle b = PlatformCoreActivator.getBundleContext().getBundle(id);
        PackageAdmin packageAdmin = PlatformCoreActivator.getDefault().getPackageAdmin();
        if (packageAdmin != null) {
            packageAdmin.refreshPackages(new Bundle[]{b});
        }
        try {
            HelpPlugin.getTocManager().clearCache();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static synchronized void closeToolPerspective(ToolDescriptor tool) {
        Map<String, IExtension> reg = PerspectiveUtil.loadPerspectiveRegistry();
        List<String> ids = PerspectiveUtil.finPerspectiveDeclareIds(tool, reg);
        if (ids.size() == 0) {
            return;
        }
        String id = ids.get(0);
        PerspectiveUtil.closePerpective(id);
    }

    public static synchronized void closeToolPerspective(Map<String, IExtension> perspectiveRegistry, Plugin plugin) {
        IExtension ext = perspectiveRegistry.get(plugin.getBundle().getHeaders().get("Bundle-Name"));
        if (ext == null) {
            return;
        }
        List<String> ids = PerspectiveUtil.finPerspectiveDeclareIds(ext);
        if (ids.isEmpty()) {
            return;
        }
        String id = ids.get(0);
        PerspectiveUtil.closePerpective(id);
    }

    public MultiStatus diagnoseBundleStatus(long id) {
        Status status;
        PlatformAdmin plaformAdmin = PlatformCoreActivator.getDefault().getPlatformAdmin();
        State state = plaformAdmin.getState(false);
        BundleDescription desc = state.getBundle(id);
        PlatformAdmin platformAdmin = PlatformCoreActivator.getDefault().getPlatformAdmin();
        VersionConstraint[] unsatisfied = platformAdmin.getStateHelper().getUnsatisfiedConstraints(desc);
        ResolverError[] resolverErrors = platformAdmin.getState(false).getResolverErrors(desc);
        MultiStatus problems = new MultiStatus("com.soyatec.hisilicon.platform.core", 1, Messages.BundleUtils_0, null);
        int i = 0;
        while (i < resolverErrors.length) {
            if ((resolverErrors[i].getType() & 0x8007) == 0) {
                status = new Status(2, "com.soyatec.hisilicon.platform.core", resolverErrors[i].toString());
                problems.add((IStatus)status);
            }
            ++i;
        }
        i = 0;
        while (i < unsatisfied.length) {
            status = new Status(2, "com.soyatec.hisilicon.platform.core", MessageHelper.getResolutionFailureMessage(unsatisfied[i]));
            problems.add((IStatus)status);
            ++i;
        }
        return problems;
    }

    public Bundle getBundle(String symbolicName) {
        PackageAdmin packageAdmin = this.getPackageAdmin();
        if (packageAdmin == null) {
            return null;
        }
        Bundle[] bundles = packageAdmin.getBundles(symbolicName, null);
        if (bundles == null) {
            return null;
        }
        int i = 0;
        while (i < bundles.length) {
            if ((bundles[i].getState() & 1) == 0) {
                return bundles[i];
            }
            ++i;
        }
        return null;
    }

    public static boolean suitableForChip(ToolDescriptor tool, String chip) {
        Chips chips = DeviceManager.getCurrentChips();
        ArrayList suiltableToolIDs = chips.getSuitableToolIDs(chip);
        return suiltableToolIDs != null && suiltableToolIDs.size() > 0 && suiltableToolIDs.contains(tool.getProperties().get("build.id"));
    }

    static class MessageHelper {
        MessageHelper() {
        }

        public static String getResolutionFailureMessage(VersionConstraint unsatisfied) {
            if (unsatisfied.isResolved()) {
                throw new IllegalArgumentException();
            }
            if (unsatisfied instanceof ImportPackageSpecification) {
                return NLS.bind((String)Messages.BundleUtils_1, (Object)MessageHelper.toString(unsatisfied));
            }
            if (unsatisfied instanceof BundleSpecification) {
                if (((BundleSpecification)unsatisfied).isOptional()) {
                    return NLS.bind((String)Messages.BundleUtils_2, (Object)MessageHelper.toString(unsatisfied));
                }
                return NLS.bind((String)Messages.BundleUtils_3, (Object)MessageHelper.toString(unsatisfied));
            }
            return NLS.bind((String)Messages.BundleUtils_4, (Object)MessageHelper.toString(unsatisfied));
        }

        private static String toString(VersionConstraint constraint) {
            VersionRange versionRange = constraint.getVersionRange();
            if (versionRange == null) {
                return constraint.getName();
            }
            return String.valueOf(constraint.getName()) + '_' + versionRange;
        }
    }
}

