/*
 * Decompiled with CFR 0.152.
 */
package com.hisilicon.hiregbin.ui;

import com.hisilicon.hiregbin.Messages;
import com.hisilicon.hiregbin.preferences.PanelPreferences;
import com.hisilicon.hiregbin.utility.LayoutUtils;
import java.io.File;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class TempExcelSelectDialog
extends Dialog {
    private String[] excelSuffix = EXCEL_SUFFIX_BIN;
    private String tempFilePath;
    private Text imageText;
    private static final String[] EXCEL_SUFFIX_BIN = new String[]{"*.bin", "*.xlsm", "*.*"};
    private static final String[] EXCEL_SUFFIX_TEMP = new String[]{"*.xlsm", "*.bin", "*.*"};

    public TempExcelSelectDialog(Shell parentShell, String[] excelSuffix) {
        super(parentShell);
        this.setExcelSuffix(excelSuffix);
    }

    protected int getShellStyle() {
        return super.getShellStyle() | 0x10 | 0x400;
    }

    protected Control createContents(Composite parent) {
        parent.getShell().setText(Messages.PanelComposite_TempPath_Title);
        parent.setSize(650, 180);
        parent.setLayout((Layout)new GridLayout(1, false));
        LayoutUtils.centerShell(parent.getDisplay(), parent.getShell());
        Composite compositeDemo = new Composite(parent, 0);
        compositeDemo.setLayout((Layout)new GridLayout(3, false));
        compositeDemo.setLayoutData((Object)new GridData(1808));
        Label labDemoType = new Label(compositeDemo, 0);
        labDemoType.setText(Messages.PanelComposite_TempPath);
        GridData labDemoTypeGD = new GridData();
        labDemoTypeGD.horizontalIndent = 0;
        labDemoType.setLayoutData((Object)labDemoTypeGD);
        this.imageText = new Text(compositeDemo, 2048);
        this.imageText.addListener(24, new Listener(){

            public void handleEvent(Event event) {
                TempExcelSelectDialog.this.tempFilePath = TempExcelSelectDialog.this.imageText.getText();
                TempExcelSelectDialog.this.imageText.setToolTipText(TempExcelSelectDialog.this.tempFilePath);
            }
        });
        GridData gridData = new GridData(4, 1, true, false);
        gridData.verticalIndent = 2;
        this.imageText.setLayoutData((Object)gridData);
        String tempFilePath = PanelPreferences.CONFIG.getTempFilePath();
        this.imageText.setText(tempFilePath);
        this.imageText.setToolTipText(tempFilePath);
        Button button = new Button(compositeDemo, 0);
        button.setText(Messages.PanelComposite_TempFile_Browse);
        button.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                FileDialog dialog = new FileDialog(TempExcelSelectDialog.this.getShell(), 4096);
                dialog.setFilterExtensions(TempExcelSelectDialog.this.excelSuffix);
                dialog.setFileName(TempExcelSelectDialog.this.imageText.getText());
                String open = dialog.open();
                if (open == null) {
                    return;
                }
                if (TempExcelSelectDialog.this.checkTempFilePath(open)) {
                    TempExcelSelectDialog.this.imageText.setText(open);
                }
            }
        });
        return super.createContents(parent);
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.createButton(parent, 0, IDialogConstants.OK_LABEL, true);
        this.createButton(parent, 1, IDialogConstants.CANCEL_LABEL, false);
    }

    public boolean checkTempFilePath(String fileName) {
        if (fileName == null || fileName.length() <= 0) {
            MessageDialog.openInformation((Shell)Display.getDefault().getActiveShell(), (String)Messages.Message_Warning, (String)Messages.PanelComposite_TempFile_Isvalid);
            return false;
        }
        if (!new File(fileName).exists()) {
            MessageDialog.openInformation((Shell)Display.getDefault().getActiveShell(), (String)Messages.Message_Warning, (String)Messages.PanelComposite_TempFile_Not_Exist);
            return false;
        }
        return true;
    }

    public String getTempFilePath() {
        return this.tempFilePath;
    }

    public void setTempFilePath(String tempFilePath) {
        this.tempFilePath = tempFilePath;
    }

    public static String[] getExcelSuffixBin() {
        return (String[])EXCEL_SUFFIX_BIN.clone();
    }

    public static String[] getExcelSuffixTemp() {
        return (String[])EXCEL_SUFFIX_TEMP.clone();
    }

    private void setExcelSuffix(String[] excelSuffix) {
        this.excelSuffix = (String[])excelSuffix.clone();
    }

    static /* synthetic */ Text access$0(TempExcelSelectDialog tempExcelSelectDialog) {
        return tempExcelSelectDialog.imageText;
    }

    static /* synthetic */ void access$1(TempExcelSelectDialog tempExcelSelectDialog, String string) {
        tempExcelSelectDialog.tempFilePath = string;
    }

    static /* synthetic */ String access$2(TempExcelSelectDialog tempExcelSelectDialog) {
        return tempExcelSelectDialog.tempFilePath;
    }

    static /* synthetic */ String[] access$3(TempExcelSelectDialog tempExcelSelectDialog) {
        return tempExcelSelectDialog.excelSuffix;
    }
}

