/*
 * Decompiled with CFR 0.152.
 */
package com.hisilicon.hiregbin.ui;

import com.hisilicon.hiregbin.Messages;
import com.hisilicon.hiregbin.utility.BytesArrayUtils;
import com.hisilicon.hiregbin.utility.BytesUtils;
import com.hisilicon.hiregbin.utility.FileUtils;
import com.hisilicon.hiregbin.utility.LayoutUtils;
import com.hisilicon.hiregbin.views.RegbinView;
import java.io.File;
import java.nio.ByteOrder;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class ReplaceRegDialog
extends Dialog {
    private Label labInputBoot;
    private Label labOutputBoot;
    private Text textInputBoot;
    private Text textOutputBoot;
    private Button btnInputBoot;
    private Button btnOutputBoot;
    private Button btnIsSupportMutiForm;
    private String inputBoot;
    private String outputBoot;
    private int multiFormFlag;
    private boolean isSupportMutiForm;

    protected ReplaceRegDialog(Shell parentShell, String inputBoot, String outputBoot) {
        super(parentShell);
        this.inputBoot = inputBoot;
        this.outputBoot = outputBoot;
    }

    protected void okPressed() {
        if (this.inputBoot == null || this.inputBoot.isEmpty()) {
            MessageDialog.openError((Shell)this.getShell(), (String)Messages.Message_Error, (String)NLS.bind((String)Messages.File_Cannot_Empty, (Object)Messages.ReplaceRegDialog_InputBoot));
            return;
        }
        if (this.outputBoot == null || this.outputBoot.isEmpty()) {
            MessageDialog.openError((Shell)this.getShell(), (String)Messages.Message_Error, (String)NLS.bind((String)Messages.File_Cannot_Empty, (Object)Messages.ReplaceRegDialog_OutputBoot));
            return;
        }
        super.okPressed();
    }

    protected Control createContents(Composite parent) {
        parent.getShell().setText(Messages.ReplaceRegDialog_Title);
        parent.setSize(600, 220);
        parent.setLayout((Layout)new GridLayout(1, false));
        LayoutUtils.centerShell(parent.getDisplay(), parent.getShell());
        Composite compositeDemo = new Composite(parent, 0);
        compositeDemo.setLayout((Layout)new GridLayout(3, false));
        compositeDemo.setLayoutData((Object)new GridData(1808));
        GridData labelGD = new GridData();
        labelGD.widthHint = 100;
        Label labMutiForm = new Label(compositeDemo, 0);
        labMutiForm.setText(String.valueOf(Messages.GetSupport_MultipleForm) + ":");
        labMutiForm.setLayoutData((Object)labelGD);
        GridData btnIsSupportMutiFormGD = new GridData(1, 1, false, false);
        btnIsSupportMutiFormGD.horizontalIndent = 5;
        btnIsSupportMutiFormGD.horizontalSpan = 2;
        this.btnIsSupportMutiForm = new Button(compositeDemo, 32);
        this.btnIsSupportMutiForm.setLayoutData((Object)btnIsSupportMutiFormGD);
        this.btnIsSupportMutiForm.setEnabled(false);
        this.btnIsSupportMutiForm.setSelection(false);
        GridData comboGD = new GridData();
        comboGD.horizontalIndent = 5;
        comboGD.widthHint = 50;
        comboGD.horizontalSpan = 2;
        this.labInputBoot = new Label(compositeDemo, 0);
        this.labInputBoot.setText(String.valueOf(Messages.ReplaceRegDialog_InputBoot) + ":");
        this.labInputBoot.setLayoutData((Object)labelGD);
        GridData textGD = new GridData(4, 1, true, false);
        textGD.horizontalIndent = 5;
        this.textInputBoot = new Text(compositeDemo, 2048);
        if (this.inputBoot != null) {
            this.textInputBoot.setText(this.inputBoot);
            this.textInputBoot.setToolTipText(this.inputBoot);
            this.checkMultiformFlag(this.inputBoot);
        }
        this.textInputBoot.addListener(24, new Listener(){

            public void handleEvent(Event event) {
                ReplaceRegDialog.this.inputBoot = ReplaceRegDialog.this.textInputBoot.getText();
                ReplaceRegDialog.this.textInputBoot.setToolTipText(ReplaceRegDialog.this.inputBoot);
            }
        });
        this.textInputBoot.setLayoutData((Object)textGD);
        this.btnInputBoot = new Button(compositeDemo, 0);
        this.btnInputBoot.setText(Messages.PanelComposite_TempFile_Browse);
        this.btnInputBoot.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                FileDialog dialog = new FileDialog(ReplaceRegDialog.this.getShell(), 4096);
                dialog.setFilterExtensions(new String[]{"*.bin", "*"});
                dialog.setFileName(ReplaceRegDialog.this.textInputBoot.getText());
                String open = dialog.open();
                if (open == null) {
                    return;
                }
                ReplaceRegDialog.this.textInputBoot.setText(open);
                if (ReplaceRegDialog.this.inputBoot == null || ReplaceRegDialog.this.inputBoot.isEmpty()) {
                    MessageDialog.openError((Shell)ReplaceRegDialog.this.getShell(), (String)Messages.Message_Error, (String)NLS.bind((String)Messages.File_Cannot_Empty, (Object)Messages.ReplaceRegDialog_InputBoot));
                    return;
                }
                ReplaceRegDialog.this.checkMultiformFlag(ReplaceRegDialog.this.inputBoot);
            }
        });
        this.labOutputBoot = new Label(compositeDemo, 0);
        this.labOutputBoot.setText(String.valueOf(Messages.ReplaceRegDialog_OutputBoot) + ":");
        this.labOutputBoot.setLayoutData((Object)labelGD);
        this.textOutputBoot = new Text(compositeDemo, 2048);
        if (this.outputBoot != null) {
            this.textOutputBoot.setText(this.outputBoot);
        }
        this.textOutputBoot.addListener(24, new Listener(){

            public void handleEvent(Event event) {
                ReplaceRegDialog.this.outputBoot = ReplaceRegDialog.this.textOutputBoot.getText();
                ReplaceRegDialog.this.textOutputBoot.setToolTipText(ReplaceRegDialog.this.outputBoot);
            }
        });
        this.textOutputBoot.setLayoutData((Object)textGD);
        this.btnOutputBoot = new Button(compositeDemo, 0);
        this.btnOutputBoot.setText(Messages.PanelComposite_TempFile_Browse);
        this.btnOutputBoot.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                FileDialog dialog = new FileDialog(ReplaceRegDialog.this.getShell(), 4096);
                dialog.setFilterExtensions(new String[]{"*.bin", "*"});
                dialog.setFileName(ReplaceRegDialog.this.textOutputBoot.getText());
                String open = dialog.open();
                if (open == null) {
                    return;
                }
                ReplaceRegDialog.this.textOutputBoot.setText(open);
            }
        });
        return super.createContents(parent);
    }

    private void checkMultiformFlag(String inputBoot) {
        File file = new File(inputBoot);
        if (file == null || !file.exists()) {
            MessageDialog.openError((Shell)this.getShell(), (String)Messages.Message_Error, (String)(String.valueOf(Messages.MultiperTableComposite_import_reg_file_is_not_exist) + "\n" + inputBoot));
            return;
        }
        byte[] inputBootBuffer = FileUtils.readAllBytes(inputBoot);
        if (inputBootBuffer == null || inputBootBuffer.length <= 0) {
            MessageDialog.openError((Shell)this.getShell(), (String)Messages.Message_HiRegBin, (String)Messages.AbstractBaseComposite_read_File_failed);
            return;
        }
        int multiformAddrFlag = 12256;
        if (RegbinView.isHi3796MV200Series()) {
            multiformAddrFlag += 65536;
        }
        byte[] multiFormFlagBytes = BytesUtils.genSubBytes(inputBootBuffer, multiformAddrFlag, 4);
        this.multiFormFlag = BytesArrayUtils.getInt(multiFormFlagBytes, 0, ByteOrder.LITTLE_ENDIAN);
        if (this.multiFormFlag == 0) {
            if (this.btnIsSupportMutiForm != null && !this.btnIsSupportMutiForm.isDisposed()) {
                this.btnIsSupportMutiForm.setSelection(false);
            }
            this.isSupportMutiForm = false;
        } else {
            if (this.btnIsSupportMutiForm != null && !this.btnIsSupportMutiForm.isDisposed()) {
                this.btnIsSupportMutiForm.setSelection(true);
            }
            this.isSupportMutiForm = true;
        }
    }

    public String getInputBoot() {
        return this.inputBoot;
    }

    public String getOutputBoot() {
        return this.outputBoot;
    }

    public boolean isSupportMutiForm() {
        return this.isSupportMutiForm;
    }

    static /* synthetic */ Text access$0(ReplaceRegDialog replaceRegDialog) {
        return replaceRegDialog.textInputBoot;
    }

    static /* synthetic */ void access$1(ReplaceRegDialog replaceRegDialog, String string) {
        replaceRegDialog.inputBoot = string;
    }

    static /* synthetic */ String access$2(ReplaceRegDialog replaceRegDialog) {
        return replaceRegDialog.inputBoot;
    }

    static /* synthetic */ void access$3(ReplaceRegDialog replaceRegDialog, String string) {
        replaceRegDialog.checkMultiformFlag(string);
    }

    static /* synthetic */ Text access$4(ReplaceRegDialog replaceRegDialog) {
        return replaceRegDialog.textOutputBoot;
    }

    static /* synthetic */ void access$5(ReplaceRegDialog replaceRegDialog, String string) {
        replaceRegDialog.outputBoot = string;
    }

    static /* synthetic */ String access$6(ReplaceRegDialog replaceRegDialog) {
        return replaceRegDialog.outputBoot;
    }
}

