/*
 * Decompiled with CFR 0.152.
 */
package com.hisilicon.hiregbin.ui;

import com.hisilicon.hiregbin.Messages;
import com.hisilicon.hiregbin.model.FunctionParam;
import com.hisilicon.hiregbin.model.GlobleInfo;
import com.hisilicon.hiregbin.model.PinDemuxHead;
import com.hisilicon.hiregbin.model.Setting;
import com.hisilicon.hiregbin.model.StarupInfo;
import com.hisilicon.hiregbin.model.reg.DriectionConfig;
import com.hisilicon.hiregbin.model.reg.GpioData;
import com.hisilicon.hiregbin.model.reg.LevelConfig;
import com.hisilicon.hiregbin.model.reg.ParsedMainData;
import com.hisilicon.hiregbin.model.reg.PinDemuxInfo;
import com.hisilicon.hiregbin.model.reg.PinDemuxRegisterInfo;
import com.hisilicon.hiregbin.model.reg.PinDemuxType;
import com.hisilicon.hiregbin.model.reg.bin.RegBinAction;
import com.hisilicon.hiregbin.model.reg.bin.RegBinData;
import com.hisilicon.hiregbin.model.reg.bin.RegBinItem;
import com.hisilicon.hiregbin.model.reg.cfg.CfgBinData;
import com.hisilicon.hiregbin.model.reg.cfg.CfgBinItem;
import com.hisilicon.hiregbin.model.reg.cfg.CfgBinModule;
import com.hisilicon.hiregbin.model.reg.cfg.CfgBinType;
import com.hisilicon.hiregbin.model.reg.excel.ExcelData;
import com.hisilicon.hiregbin.model.reg.hi98cv200bin.BinData;
import com.hisilicon.hiregbin.model.reg.hi98cv200bin.BinItem;
import com.hisilicon.hiregbin.model.reg.hi98cv200bin.BinModule;
import com.hisilicon.hiregbin.model.reg.hi98cv200bin.BinModuleHead;
import com.hisilicon.hiregbin.model.reg.hi98cv200bin.BinModuleType;
import com.hisilicon.hiregbin.processor.PrepareSetting;
import com.hisilicon.hiregbin.ui.AbstractBaseComposite;
import com.hisilicon.hiregbin.utility.BytesArrayUtils;
import com.hisilicon.hiregbin.utility.ExcelDataHelper;
import com.hisilicon.hiregbin.views.RegbinView;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.layout.TableColumnLayout;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.ComboBoxCellEditor;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICellModifier;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Widget;

public class PinDemuxComposite
extends AbstractBaseComposite {
    static String[] registerColumnNames = new String[]{"Register", "Pin Num(QFP/BGA)", "Function", "Driver", "Slew rate", "PuPd"};
    static String[] gpioColumnNames = new String[]{"GPIO", "direction", "level"};
    static int baseAddr = 0;
    private static final String PIN_NUM_PACKAGE = "Pin Num(BGA21x21/BGA15x15)";
    private static final String UNDER_LINE = "_";
    private static String LAYERS = "layers";
    private static ArrayList<PinDemuxRegisterInfo> pinDemuxRegisterInfos;
    private String DEMONAME;
    private Object REGBINDATA;
    private String DATANAME;
    private ParsedMainData parsedMainData = null;
    private ExcelData excelData = null;
    private PinDemuxInfo pinDemuxInfo;
    private PinDemuxInfo originalDemuxInfo;
    private Map<String, GpioData> map = null;
    private List<GpioData> gpioParams = null;
    private PinDemuxType dataResour;
    private String ImportDataStartUp;
    private TableViewer registerTableViewer;
    private TableViewer gpioTableViewer;
    private ComboBoxCellEditor functionCellEditor;
    private Combo comboStartup;
    private int lastSelIndexForStartup;
    private ComboBoxCellEditor direction;
    private ComboBoxCellEditor level;
    private Label labCustomDemoName;

    public PinDemuxComposite(Composite parent, Setting setting, Label labName) {
        super(parent, setting);
        this.labCustomDemoName = labName;
    }

    @Override
    protected Control createControl(Composite parent) {
        Group startupGroup = new Group(parent, 64);
        startupGroup.setLayoutData((Object)new GridData(4, 1, true, false));
        startupGroup.setLayout((Layout)new GridLayout(2, false));
        startupGroup.setBackground(GlobleInfo.white);
        startupGroup.setText(Messages.PinDemuxComposite_StartMode);
        Label labStartup = new Label((Composite)startupGroup, 0);
        labStartup.setText(Messages.PinDemuxComposite_StartMode);
        PinDemuxComposite.fillHorizontalLabel((Control)labStartup, 30);
        this.comboStartup = new Combo((Composite)startupGroup, 8);
        PinDemuxComposite.fillHorizontalCombo((Control)this.comboStartup);
        this.comboStartup.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                String selectName = PinDemuxComposite.this.comboStartup.getText();
                if (selectName != null) {
                    PinDemuxComposite.this.updateLblCustomDemoName(PinDemuxComposite.this.labCustomDemoName, selectName);
                }
                PinDemuxComposite.this.refreshDemoInfoToUI(PinDemuxComposite.this.DEMONAME, PinDemuxComposite.this.REGBINDATA, PinDemuxComposite.this.DATANAME, PinDemuxType.Select, null);
                PinDemuxComposite.this.lastSelIndexForStartup = PinDemuxComposite.this.comboStartup.getSelectionIndex();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        AbstractBaseComposite.changeControlListener((Control)this.comboStartup);
        this.CreatePinDemux(parent);
        this.registerTableViewer.setInput(null);
        AbstractBaseComposite.changeControlListener((Control)this.registerTableViewer.getTable());
        if (!ExcelDataHelper.isV135XlsFomatVersion(ExcelDataHelper.getExcelData())) {
            this.CreateGPIO(parent);
            this.gpioTableViewer.setInput(null);
            AbstractBaseComposite.changeControlListener((Control)this.gpioTableViewer.getTable());
        }
        return parent;
    }

    public void updateLblCustomDemoName(Label labCustomDemoName, String start) {
        String labCustomDemoNameValue = labCustomDemoName.getText();
        if (RegbinView.getCurrentChip().equalsIgnoreCase("Hi3716MV410") || RegbinView.getCurrentChip().equalsIgnoreCase("Hi3716MV420")) {
            String[] startupItems;
            String[] names = labCustomDemoNameValue.split(UNDER_LINE);
            String customStartup = null;
            int layersIndex = 0;
            int i = 0;
            while (i < names.length) {
                if (names[i].indexOf(LAYERS) > 0) {
                    layersIndex = i;
                }
                if (i == layersIndex + 1) {
                    customStartup = names[i];
                }
                ++i;
            }
            String[] stringArray = startupItems = this.comboStartup.getItems();
            int n = startupItems.length;
            int n2 = 0;
            while (n2 < n) {
                String startup = stringArray[n2];
                if (startup.equalsIgnoreCase(customStartup)) {
                    labCustomDemoNameValue = labCustomDemoNameValue.replace(customStartup, start);
                    break;
                }
                ++n2;
            }
            labCustomDemoName.setText(labCustomDemoNameValue);
            labCustomDemoName.update();
        } else if (RegbinView.isHi3716V550Series()) {
            String[] names = labCustomDemoNameValue.split(UNDER_LINE);
            labCustomDemoNameValue = labCustomDemoNameValue.replace(names[names.length - 1], start);
            labCustomDemoName.setText(labCustomDemoNameValue);
            labCustomDemoName.update();
        }
    }

    @Override
    protected PinDemuxInfo getPinDemuxParam() {
        return this.pinDemuxInfo;
    }

    @Override
    protected boolean checkAllValidValue() {
        Map<String, GpioData> getGpioMap;
        if (this.pinDemuxInfo != null && (getGpioMap = this.pinDemuxInfo.getGpioMap()) != null) {
            for (GpioData data : getGpioMap.values()) {
                if (data.getGpioDirection().equals((Object)DriectionConfig.Input)) {
                    if (data.getGpioLevel().equals((Object)LevelConfig.NA)) continue;
                    MessageDialog.openInformation((Shell)this.getShell(), (String)Messages.Message_Warning, (String)NLS.bind((String)Messages.PinDemuxComposite_GpioValue, (Object)data.getGpioName(), (Object)((Object)data.getGpioLevel())));
                    return false;
                }
                if (!data.getGpioDirection().equals((Object)DriectionConfig.Output) || !data.getGpioLevel().equals((Object)LevelConfig.NA)) continue;
                MessageDialog.openInformation((Shell)this.getShell(), (String)Messages.Message_Warning, (String)NLS.bind((String)Messages.PinDemuxComposite_GpioValue, (Object)data.getGpioName(), (Object)((Object)data.getGpioLevel())));
                return false;
            }
        }
        return true;
    }

    public void refreshDemoInfoToUI(String selectDemoName, Object regBinData, String binDataName, PinDemuxType type, String volDvdd) {
        this.DEMONAME = selectDemoName;
        this.REGBINDATA = regBinData;
        this.DATANAME = binDataName;
        if (!type.equals((Object)PinDemuxType.Select)) {
            this.dataResour = type;
        }
        String comboStartupStr = this.comboStartup.getText();
        if (RegbinView.getCurrentChip().equalsIgnoreCase("Hi3716MV410") || RegbinView.getCurrentChip().equalsIgnoreCase("Hi3716MV420")) {
            this.createInitialPinDemuxForMv410Or420(selectDemoName, regBinData, binDataName, type, volDvdd);
        } else if (type.equals((Object)PinDemuxType.Demo) || this.dataResour.equals((Object)PinDemuxType.Demo) && !type.equals((Object)PinDemuxType.Select)) {
            this.CreateInitialPinDemux(selectDemoName, type, volDvdd);
        } else if (type.equals((Object)PinDemuxType.Select)) {
            String lastSelectStarup = this.comboStartup.getItem(this.lastSelIndexForStartup);
            this.savePinMuxDrvToMap(comboStartupStr, lastSelectStarup);
            this.excelData.copyPinDemuxReg(comboStartupStr, this.pinDemuxInfo, false, this.comboStartup.getItems());
            PinDemuxComposite.setPinDemuxRegisterInfos(this.pinDemuxInfo.getPinDemuxRegisterList());
            List<String> selectGPIO = this.genEachGpioID();
            this.gpioParams = new ArrayList<GpioData>();
            this.map = this.pinDemuxInfo.getGpioMap();
            int j = 0;
            while (j < selectGPIO.size()) {
                GpioData gpioDate = this.map.get(selectGPIO.get(j));
                if (gpioDate != null) {
                    this.gpioParams.add(gpioDate);
                }
                ++j;
            }
        } else if (regBinData != null && (type.equals((Object)PinDemuxType.ImportBin) || this.ImportDataStartUp.equals(comboStartupStr))) {
            String startUp = "";
            if (this.comboStartup.getItemCount() > 0) {
                boolean isExistEmmc = false;
                int emmcIndex = 0;
                int i = 0;
                while (i < this.comboStartup.getItems().length) {
                    String startup = this.comboStartup.getItems()[i];
                    if (startup.equalsIgnoreCase("emmc")) {
                        isExistEmmc = true;
                        emmcIndex = i;
                        break;
                    }
                    if (startup.equalsIgnoreCase("emmc-phy")) {
                        isExistEmmc = true;
                        emmcIndex = i;
                        break;
                    }
                    ++i;
                }
                startUp = isExistEmmc ? this.comboStartup.getItem(emmcIndex) : this.comboStartup.getItem(0);
                this.ImportDataStartUp = startUp;
            } else if (RegbinView.isHi3798CV200Series() || RegbinView.isHi3798MV200Series() || RegbinView.isHi3796MV200Series()) {
                startUp = "emmc";
                this.ImportDataStartUp = "emmc";
            } else {
                startUp = "spi";
                this.ImportDataStartUp = "spi";
            }
            this.CreatePinDemuxImportData(regBinData, selectDemoName, startUp);
        } else if (!this.ImportDataStartUp.equals(comboStartupStr)) {
            this.CreateInitialPinDemux(selectDemoName, type, volDvdd);
        }
        Collections.sort(pinDemuxRegisterInfos);
        this.registerTableViewer.setInput(pinDemuxRegisterInfos);
        this.registerTableViewer.refresh();
        if (this.gpioTableViewer != null) {
            this.gpioTableViewer.setInput(this.gpioParams);
            this.gpioTableViewer.refresh();
        }
        GlobleInfo.setNeedSave(false);
    }

    private void createInitialPinDemuxForMv410Or420(String selectDemoName, Object regBinData, String binDataName, PinDemuxType type, String volDvdd) {
        if (type.equals((Object)PinDemuxType.Demo) || this.dataResour.equals((Object)PinDemuxType.Demo) && type.equals((Object)PinDemuxType.Select)) {
            this.CreateInitialPinDemux(selectDemoName, type, volDvdd);
        } else if (regBinData != null && binDataName != null && (type.equals((Object)PinDemuxType.ImportBin) || this.ImportDataStartUp.equals(this.comboStartup.getText()))) {
            String[] names = binDataName.split(UNDER_LINE);
            String selectStartup = null;
            int layersIndex = 0;
            int i = 0;
            while (i < names.length) {
                if (names[i].indexOf(LAYERS) > 0) {
                    layersIndex = i;
                }
                if (i == layersIndex + 1) {
                    selectStartup = names[i];
                }
                ++i;
            }
            String startUp = null;
            if (selectStartup != null) {
                startUp = selectStartup.split("\\.").length > 1 ? selectStartup.split("\\.")[0] : selectStartup;
            }
            this.ImportDataStartUp = startUp;
            this.CreatePinDemuxImportData(regBinData, selectDemoName, startUp);
        } else if (!this.ImportDataStartUp.equals(this.comboStartup.getText())) {
            this.CreateInitialPinDemux(selectDemoName, type, volDvdd);
        }
    }

    private void savePinMuxDrvToMap(String comboStartupStr, String lastSelectStarup) {
        String needSavePinMuxFunction;
        String needSavePinMuxRegName;
        String pinMuxFunction;
        String pinMuxRegName;
        ArrayList<PinDemuxRegisterInfo> pinDemuxRegisterList = this.pinDemuxInfo.getPinDemuxRegisterList();
        Map<String, ArrayList<PinDemuxRegisterInfo>> pinDemuxForFlashMap = this.pinDemuxInfo.getPinDemuxForFlashMap();
        if (this.gpioParams != null) {
            int i = 0;
            while (i < this.gpioParams.size()) {
                GpioData needSaveGpioData = this.gpioParams.get(i);
                if (needSaveGpioData != null) {
                    String gpioID = needSaveGpioData.getGpioID();
                    GpioData gpioData = this.pinDemuxInfo.getGpioMap().get(gpioID);
                    if (gpioData != null) {
                        gpioData.setGpioDirection(needSaveGpioData.getGpioDirection());
                        gpioData.setGpioLevel(needSaveGpioData.getGpioLevel());
                    }
                }
                ++i;
            }
        }
        if (!comboStartupStr.equalsIgnoreCase(lastSelectStarup) && pinDemuxForFlashMap.containsKey(lastSelectStarup)) {
            ArrayList<PinDemuxRegisterInfo> pinDemuxRegisterInfoList = pinDemuxForFlashMap.get(lastSelectStarup);
            for (PinDemuxRegisterInfo pinDemuxRegisterInfo : pinDemuxRegisterInfoList) {
                pinMuxRegName = pinDemuxRegisterInfo.getPinMuxRegName();
                pinMuxFunction = pinDemuxRegisterInfo.getPinMuxFunction();
                String pinMuxModuleName = pinDemuxRegisterInfo.getPinDemuxHead().getPinMuxModuleName();
                for (PinDemuxRegisterInfo needSavePinDemuxRegister : pinDemuxRegisterList) {
                    String needSaveFlagStr;
                    String needSavePinMuxRegName2 = needSavePinDemuxRegister.getPinMuxRegName();
                    String needSavePinMuxFunction2 = needSavePinDemuxRegister.getPinMuxFunction();
                    String needSavePinMuxModuleName = pinDemuxRegisterInfo.getPinDemuxHead().getPinMuxModuleName();
                    String flagStr = String.valueOf(pinMuxRegName) + pinMuxModuleName;
                    if (!flagStr.equalsIgnoreCase(needSaveFlagStr = String.valueOf(needSavePinMuxRegName2) + needSavePinMuxModuleName) || pinMuxFunction.equalsIgnoreCase(needSavePinMuxFunction2)) continue;
                    pinDemuxRegisterInfo = needSavePinDemuxRegister;
                }
            }
        }
        if (pinDemuxForFlashMap.containsKey("pin_mux_drv")) {
            ArrayList<PinDemuxRegisterInfo> pinMuxDrvRegList = pinDemuxForFlashMap.get("pin_mux_drv");
            for (PinDemuxRegisterInfo pinDemuxRegisterInfo : pinMuxDrvRegList) {
                pinMuxRegName = pinDemuxRegisterInfo.getPinMuxRegName();
                pinMuxFunction = pinDemuxRegisterInfo.getPinMuxFunction();
                for (PinDemuxRegisterInfo needSavePinDemuxRegister : pinDemuxRegisterList) {
                    needSavePinMuxRegName = needSavePinDemuxRegister.getPinMuxRegName();
                    needSavePinMuxFunction = needSavePinDemuxRegister.getPinMuxFunction();
                    if (!pinMuxRegName.equalsIgnoreCase(needSavePinMuxRegName) || pinMuxFunction.equalsIgnoreCase(needSavePinMuxFunction)) continue;
                    pinDemuxRegisterInfo = needSavePinDemuxRegister;
                }
            }
        }
        if (pinDemuxForFlashMap.containsKey("fp_pin_mux_drv")) {
            ArrayList<PinDemuxRegisterInfo> fpPinMuxDrvRegList = pinDemuxForFlashMap.get("fp_pin_mux_drv");
            for (PinDemuxRegisterInfo pinDemuxRegisterInfo : fpPinMuxDrvRegList) {
                String fpPinMuxRegName = pinDemuxRegisterInfo.getPinMuxRegName();
                pinMuxFunction = pinDemuxRegisterInfo.getPinMuxFunction();
                for (PinDemuxRegisterInfo needSavePinDemuxRegister : pinDemuxRegisterList) {
                    needSavePinMuxRegName = needSavePinDemuxRegister.getPinMuxRegName();
                    needSavePinMuxFunction = needSavePinDemuxRegister.getPinMuxFunction();
                    if (!fpPinMuxRegName.equalsIgnoreCase(needSavePinMuxRegName) || pinMuxFunction.equalsIgnoreCase(needSavePinMuxFunction)) continue;
                    pinDemuxRegisterInfo = needSavePinDemuxRegister;
                }
            }
        }
    }

    private void CreatePinDemuxImportData(Object regBinData, String selectDemoName, String customStartup) {
        PinDemuxInfo processPinDemuxInfo;
        this.parsedMainData = ExcelDataHelper.getParsedMainData();
        if (customStartup == null) {
            return;
        }
        if (this.comboStartup.getItems().length < 1) {
            ArrayList<String> startupList = this.parsedMainData.getStartupList();
            if (startupList != null) {
                this.comboStartup.setItems(this.listToArray(startupList));
                String[] starups = this.comboStartup.getItems();
                boolean updateStartupSuccess = false;
                int i = 0;
                while (i < starups.length) {
                    if (starups[i].equalsIgnoreCase(customStartup)) {
                        this.comboStartup.select(i);
                        this.lastSelIndexForStartup = i;
                        updateStartupSuccess = true;
                        break;
                    }
                    ++i;
                }
                if (!updateStartupSuccess) {
                    i = 0;
                    while (i < starups.length) {
                        if (starups[i].contains(customStartup)) {
                            this.comboStartup.select(i);
                            this.lastSelIndexForStartup = i;
                            break;
                        }
                        ++i;
                    }
                }
            }
        } else {
            String[] starups = this.comboStartup.getItems();
            boolean updateStartupSuccess = false;
            int i = 0;
            while (i < starups.length) {
                if (starups[i].equalsIgnoreCase(customStartup)) {
                    this.comboStartup.select(i);
                    this.lastSelIndexForStartup = i;
                    updateStartupSuccess = true;
                    break;
                }
                ++i;
            }
            if (!updateStartupSuccess) {
                i = 0;
                while (i < starups.length) {
                    if (starups[i].contains(customStartup)) {
                        this.comboStartup.select(i);
                        this.lastSelIndexForStartup = i;
                        break;
                    }
                    ++i;
                }
            }
        }
        StarupInfo starupInfo = new StarupInfo();
        starupInfo.setStarup(customStartup);
        starupInfo.setStartupItem(this.comboStartup.getItems());
        this.excelData = ExcelDataHelper.getExcelData();
        if (RegbinView.getCurrentChip().equalsIgnoreCase("Hi3716MV410") || RegbinView.getCurrentChip().equalsIgnoreCase("Hi3716MV420")) {
            processPinDemuxInfo = this.excelData.getOriginalpinDemuxInfo(selectDemoName, customStartup);
            this.originalDemuxInfo = this.excelData.getOriginalpinDemuxInfo(selectDemoName, customStartup);
            this.processImportPinDemuxInfo(processPinDemuxInfo, regBinData);
        } else {
            processPinDemuxInfo = this.excelData.getPinDemuxInfoByStartup(selectDemoName, starupInfo, false, false, null);
            int selectIndex = this.comboStartup.getSelectionIndex();
            String tempCustomStartup = customStartup;
            if (selectIndex == -1) {
                selectIndex = 0;
                if (this.comboStartup.getItemCount() > 0) {
                    tempCustomStartup = this.comboStartup.getItem(0);
                    this.comboStartup.select(0);
                }
            }
            this.originalDemuxInfo = this.excelData.getPinDemuxInfoByStartup(selectDemoName, starupInfo, false, true, null);
            this.processImportPinDemuxInfo(processPinDemuxInfo, regBinData, this.comboStartup.getItems(), selectIndex);
        }
    }

    private PinDemuxInfo processImportPinDemuxInfo(PinDemuxInfo processPinDemuxInfo, Object binData, String[] startups, int startupSelectIndex) {
        PinDemuxHead pinDemuxHead;
        ArrayList<PinDemuxRegisterInfo> registerList;
        ArrayList<String> selectGPIO = new ArrayList<String>();
        this.pinDemuxInfo = new PinDemuxInfo();
        Map<String, ArrayList<PinDemuxRegisterInfo>> pinDemuxForFlashMap = this.pinDemuxInfo.getPinDemuxForFlashMap();
        Map<String, ArrayList<PinDemuxRegisterInfo>> originalPinDemuxForFlashMap = processPinDemuxInfo.getPinDemuxForFlashMap();
        if (binData instanceof BinData) {
            BinData binDataObj = (BinData)binData;
            binDataObj.initBinDataExport(binDataObj);
        }
        int startupIndex = 0;
        while (startupIndex < startups.length) {
            registerList = new ArrayList<PinDemuxRegisterInfo>();
            String startup = startups[startupIndex];
            if (originalPinDemuxForFlashMap.containsKey(startup)) {
                ArrayList<PinDemuxRegisterInfo> startupPinDemuxRegList = originalPinDemuxForFlashMap.get(startup);
                for (PinDemuxRegisterInfo pinDemuxRegisterInfo : startupPinDemuxRegList) {
                    PinDemuxHead pinDemuxHead2 = pinDemuxRegisterInfo.getPinDemuxHead();
                    pinDemuxRegisterInfo.setPinDemuxHead(pinDemuxHead2);
                    this.selectGpioDataByBin(binData, pinDemuxHead2, pinDemuxRegisterInfo, selectGPIO, registerList, startup, startups[startupSelectIndex]);
                }
            }
            pinDemuxForFlashMap.put(startup, registerList);
            ++startupIndex;
        }
        if (originalPinDemuxForFlashMap.containsKey("pin_mux_drv")) {
            ArrayList<PinDemuxRegisterInfo> pinDemuxRegList = originalPinDemuxForFlashMap.get("pin_mux_drv");
            registerList = new ArrayList();
            for (PinDemuxRegisterInfo pinDemuxRegisterInfo : pinDemuxRegList) {
                pinDemuxHead = pinDemuxRegisterInfo.getPinDemuxHead();
                pinDemuxRegisterInfo.setPinDemuxHead(pinDemuxHead);
                this.selectGpioDataByBin(binData, pinDemuxHead, pinDemuxRegisterInfo, selectGPIO, registerList);
                pinDemuxForFlashMap.put("pin_mux_drv", registerList);
            }
        }
        if (originalPinDemuxForFlashMap.containsKey("fp_pin_mux_drv")) {
            ArrayList<PinDemuxRegisterInfo> fpPinDemuxRegList = originalPinDemuxForFlashMap.get("fp_pin_mux_drv");
            registerList = new ArrayList();
            for (PinDemuxRegisterInfo pinDemuxRegisterInfo : fpPinDemuxRegList) {
                pinDemuxHead = pinDemuxRegisterInfo.getPinDemuxHead();
                pinDemuxRegisterInfo.setPinDemuxHead(pinDemuxHead);
                this.selectGpioDataByBin(binData, pinDemuxHead, pinDemuxRegisterInfo, selectGPIO, registerList);
                pinDemuxForFlashMap.put("fp_pin_mux_drv", registerList);
            }
        }
        if (originalPinDemuxForFlashMap.containsKey("pin_mux_drv_aon")) {
            ArrayList<PinDemuxRegisterInfo> pinAnoDemuxRegList = originalPinDemuxForFlashMap.get("pin_mux_drv_aon");
            registerList = new ArrayList();
            for (PinDemuxRegisterInfo pinDemuxRegisterInfo : pinAnoDemuxRegList) {
                pinDemuxHead = pinDemuxRegisterInfo.getPinDemuxHead();
                pinDemuxRegisterInfo.setPinDemuxHead(pinDemuxHead);
                this.selectGpioDataByBin(binData, pinDemuxHead, pinDemuxRegisterInfo, selectGPIO, registerList);
                pinDemuxForFlashMap.put("pin_mux_drv_aon", registerList);
            }
        }
        if (startupSelectIndex == -1) {
            startupSelectIndex = 0;
        }
        this.excelData.copyPinDemuxReg(startups[startupSelectIndex], this.pinDemuxInfo, false, this.comboStartup.getItems());
        ArrayList<PinDemuxRegisterInfo> pinDemuxRegisterList = this.pinDemuxInfo.getPinDemuxRegisterList();
        this.pinDemuxInfo.setPinDemuxRegisterList(pinDemuxRegisterList);
        pinDemuxRegisterInfos = this.pinDemuxInfo.getPinDemuxRegisterList();
        this.map = this.pinDemuxInfo.getGpioMap();
        this.gpioParams = new ArrayList<GpioData>();
        int j = 0;
        while (j < selectGPIO.size()) {
            GpioData gpioDate = this.map.get(selectGPIO.get(j));
            if (gpioDate != null) {
                this.gpioParams.add(gpioDate);
            }
            ++j;
        }
        return this.pinDemuxInfo;
    }

    private PinDemuxInfo processImportPinDemuxInfo(PinDemuxInfo processPinDemuxInfo, Object binData) {
        ArrayList<String> selectGPIO = new ArrayList<String>();
        this.pinDemuxInfo = new PinDemuxInfo();
        ArrayList<PinDemuxRegisterInfo> registerList = new ArrayList<PinDemuxRegisterInfo>();
        if (binData instanceof BinData) {
            BinData binDataObj = (BinData)binData;
            binDataObj.initBinDataExport(binDataObj);
        }
        int i = 0;
        while (i < processPinDemuxInfo.getPinDemuxRegisterList().size()) {
            PinDemuxHead head = processPinDemuxInfo.getPinDemuxRegisterList().get(i).getPinDemuxHead();
            PinDemuxRegisterInfo registerInfo = processPinDemuxInfo.getPinDemuxRegisterList().get(i);
            registerInfo.setPinDemuxHead(head);
            this.selectGpioDataByBin(binData, head, registerInfo, selectGPIO, registerList);
            ++i;
        }
        this.pinDemuxInfo.setPinDemuxRegisterList(registerList);
        pinDemuxRegisterInfos = this.pinDemuxInfo.getPinDemuxRegisterList();
        this.map = this.pinDemuxInfo.getGpioMap();
        this.addGpio(this.map, this.originalDemuxInfo.getGpioMap());
        this.gpioParams = new ArrayList<GpioData>();
        int j = 0;
        while (j < selectGPIO.size()) {
            GpioData gpioDate = this.map.get(selectGPIO.get(j));
            if (gpioDate != null) {
                this.gpioParams.add(gpioDate);
            }
            ++j;
        }
        return this.pinDemuxInfo;
    }

    public void addGpio(Map<String, GpioData> map, Map<String, GpioData> originalMap) {
        Collection<GpioData> c = originalMap.values();
        for (GpioData gpio : c) {
            String name = gpio.getGpioName();
            GpioData temp = map.get(name);
            if (temp != null) continue;
            map.put(name, gpio);
        }
    }

    private void selectGpioDataByBin(Object binDataObj, PinDemuxHead head, PinDemuxRegisterInfo registerInfo, List<String> selectGPIO, ArrayList<PinDemuxRegisterInfo> registerList) {
        int mAddress = 0;
        if (binDataObj instanceof RegBinData) {
            mAddress = head.getPinMuxBaseAddress() + registerInfo.getPinMuxOffsetAddress();
            RegBinData regBinData = (RegBinData)binDataObj;
            int value = registerInfo.getPinMuxValue();
            int bit = registerInfo.getRegStartBit();
            RegBinItem item = regBinData.seekForItem(mAddress, bit, value);
            if (item != null) {
                RegBinAction action = null;
                if (item.isActionEnabled(RegBinAction.READ)) {
                    action = RegBinAction.READ;
                } else if (item.isActionEnabled(RegBinAction.WRITE)) {
                    action = RegBinAction.WRITE;
                }
                if (action != null) {
                    head.setExeForNormalBoot(item.isExecutionRequiredForNormalBoot(action));
                    head.setExeForStandyWakeup(item.isExecutionRequiredForStandbyWakeup(action));
                }
                if (registerInfo.getPinMuxFunction().toUpperCase().startsWith("GPIO")) {
                    String function = registerInfo.getPinMuxFunction();
                    GpioData gpio = null;
                    ArrayList<GpioData> gpioData = this.excelData.getGpioParsedDataList();
                    int j = 0;
                    while (j < gpioData.size()) {
                        if (gpioData.get(j).getGpioName().equals(function)) {
                            gpio = new GpioData();
                            gpio.setGpioName(function);
                            int gpioDataAbsoluteAddr = gpioData.get(j).getGpioAbsoluteAddr();
                            RegBinItem gpioItem = regBinData.seekForItem(gpioDataAbsoluteAddr);
                            if (gpioItem == null) {
                                gpio.setGpioDirection(DriectionConfig.Input);
                                gpio.setGpioLevel(LevelConfig.NA);
                            } else {
                                gpio.setGpioDirection(DriectionConfig.Output);
                                if (gpioItem.getValue() == 0) {
                                    gpio.setGpioLevel(LevelConfig.Low);
                                } else if (gpioItem.getValue() == 1) {
                                    gpio.setGpioLevel(LevelConfig.High);
                                }
                            }
                            gpio.setPinDemuxHead(head);
                            int gpioGroupAddress = ExcelDataHelper.getExcelDataforImport().getExcelMainData().getBaseGpioGroupAddress(function);
                            gpio.setGpioGroupAddress(gpioGroupAddress);
                            String gpioID = PinDemuxComposite.genGpioID(function, registerInfo.getPinDemuxHead().getPinMuxModuleName(), registerInfo.getPinMuxRegName());
                            gpio.setGpioID(gpioID);
                            this.pinDemuxInfo.setGpioMap(gpioID, gpio);
                            selectGPIO.add(gpioID);
                            break;
                        }
                        ++j;
                    }
                }
                registerList.add(registerInfo);
            }
        } else if (binDataObj instanceof CfgBinData) {
            int startBit;
            int offsetAddr;
            CfgBinData cfgBinData = (CfgBinData)binDataObj;
            mAddress = head.getPinMuxBaseAddress();
            CfgBinItem cfgBin = cfgBinData.seekForItemForBase(mAddress, offsetAddr = registerInfo.getPinMuxOffsetAddress(), startBit = registerInfo.getRegStartBit());
            if (cfgBin != null) {
                CfgBinModule module = cfgBin.getModuleRef();
                if (module.getType() == CfgBinType.WAKEUP) {
                    head.setExeForStandyWakeup(true);
                    head.setExeForNormalBoot(false);
                } else if (module.getType() == CfgBinType.INIT) {
                    head.setExeForStandyWakeup(true);
                    head.setExeForNormalBoot(false);
                } else {
                    head.setExeForStandyWakeup(true);
                    head.setExeForNormalBoot(true);
                }
                int value = registerInfo.getPinMuxValue();
                if (cfgBin.getValue() == value) {
                    if (registerInfo.getPinMuxFunction().toUpperCase().startsWith("GPIO")) {
                        String function = registerInfo.getPinMuxFunction();
                        GpioData gpio = null;
                        ArrayList<GpioData> gpioData = this.excelData.getGpioParsedDataList();
                        int j = 0;
                        while (j < gpioData.size()) {
                            if (gpioData.get(j).getGpioName().equals(function)) {
                                gpio = new GpioData();
                                gpio.setGpioName(function);
                                int gpioDataAbsoluteAddr = gpioData.get(j).getGpioAbsoluteAddr();
                                CfgBinItem gpioCfgBin = cfgBinData.seekForItemForBase(baseAddr, gpioDataAbsoluteAddr, 0);
                                if (gpioCfgBin != null) {
                                    gpio.setGpioDirection(DriectionConfig.Output);
                                    if (gpioCfgBin.getValue() == 0) {
                                        gpio.setGpioLevel(LevelConfig.Low);
                                    } else if (gpioCfgBin.getValue() == 1) {
                                        gpio.setGpioLevel(LevelConfig.High);
                                    }
                                } else {
                                    gpio.setGpioDirection(DriectionConfig.Input);
                                    gpio.setGpioLevel(LevelConfig.NA);
                                }
                                gpio.setPinDemuxHead(head);
                                int gpioGroupAddress = ExcelDataHelper.getExcelDataforImport().getExcelMainData().getBaseGpioGroupAddress(function);
                                gpio.setGpioGroupAddress(gpioGroupAddress);
                                String gpioID = PinDemuxComposite.genGpioID(function, registerInfo.getPinDemuxHead().getPinMuxModuleName(), registerInfo.getPinMuxRegName());
                                gpio.setGpioID(gpioID);
                                this.pinDemuxInfo.setGpioMap(gpioID, gpio);
                                selectGPIO.add(gpioID);
                                break;
                            }
                            ++j;
                        }
                    }
                    registerList.add(registerInfo);
                }
            }
        } else if (binDataObj instanceof BinData) {
            mAddress = head.getPinMuxBaseAddress();
            BinData binData = (BinData)binDataObj;
            int offsetAddr = registerInfo.getPinMuxOffsetAddress();
            int startBit = registerInfo.getRegStartBit();
            int pinMuxValue = registerInfo.getPinMuxValue();
            RegBinAction regReadOrWrite = registerInfo.getRegReadOrWrite();
            int absoluteAddr = mAddress + offsetAddr;
            int regBit = registerInfo.getRegBit();
            BinModuleType pinModuleType = registerInfo.getPinDemuxHead().getPinModuleType();
            BinItem binItem = binData.seekForItemForBase(absoluteAddr, offsetAddr, startBit, regBit, pinMuxValue, regReadOrWrite.ordinal(), pinModuleType);
            if (binItem != null) {
                BinModuleHead binModuleHead;
                BinModule module = binItem.getmModuleRef();
                if (module != null && (binModuleHead = module.getBinModuleHead()) != null) {
                    int normalBoot = binModuleHead.getNormalBoot();
                    int standbyWakeup = binModuleHead.getStandbyWakeup();
                    BinModuleType moduleType = binModuleHead.getModuleType();
                    int normalChip = binModuleHead.getNormalChip();
                    head.setExeForStandyWakeup(PrepareSetting.convertIntToBoot(standbyWakeup));
                    head.setExeForNormalBoot(PrepareSetting.convertIntToBoot(normalBoot));
                    head.setPinModuleType(moduleType);
                    head.setPinNormalChip(PrepareSetting.convertIntToBoot(normalChip));
                }
                int value = registerInfo.getPinMuxValue();
                if (binItem.getValue() == value) {
                    if (registerInfo.getPinMuxFunction().toUpperCase().startsWith("GPIO") || registerInfo.getPinMuxFunction().toUpperCase().startsWith("AON")) {
                        String function = registerInfo.getPinMuxFunction();
                        GpioData gpio = null;
                        ArrayList<GpioData> gpioData = this.excelData.getGpioParsedDataList();
                        int j = 0;
                        while (j < gpioData.size()) {
                            if (gpioData.get(j).getGpioName().equals(function)) {
                                gpio = new GpioData();
                                gpio.setGpioName(function);
                                String gpioName = gpioData.get(j).getGpioName();
                                String gpioDataNumStr = "";
                                String gpioStartBitStr = gpioName.substring(gpioName.lastIndexOf(UNDER_LINE) + UNDER_LINE.length());
                                if (function.startsWith("GPIO_AON")) {
                                    gpioDataNumStr = gpioName;
                                    gpioStartBitStr = gpioName.substring(gpioName.length() - 1);
                                } else if (function.startsWith("AON")) {
                                    gpioStartBitStr = gpioName.substring(gpioName.length() - 1);
                                    gpioDataNumStr = "AON_GPIOX_" + gpioStartBitStr;
                                } else {
                                    gpioDataNumStr = "GPIOX_" + gpioStartBitStr;
                                }
                                int gpioDataValue = GlobleInfo.getGpioXDataMap().get(gpioDataNumStr);
                                int gpioGroupAddress = ExcelDataHelper.getExcelDataforImport().getExcelMainData().getBaseGpioGroupAddress(function);
                                int gpioDataAbsoluteAddr = gpioGroupAddress + gpioDataValue;
                                int gpioStartBit = 0;
                                try {
                                    gpioStartBit = Integer.parseInt(gpioStartBitStr);
                                }
                                catch (NumberFormatException e) {
                                    e.printStackTrace();
                                }
                                BinItem gpioBinItem = binData.seekForItemForGPIO(gpioDataAbsoluteAddr, BytesArrayUtils.get1LowBytesFromInt(gpioDataAbsoluteAddr), gpioStartBit, registerInfo.getPinDemuxHead());
                                if (gpioBinItem != null) {
                                    gpio.setGpioDirection(DriectionConfig.Output);
                                    if (gpioBinItem.getValue() == 0) {
                                        gpio.setGpioLevel(LevelConfig.Low);
                                    } else if (gpioBinItem.getValue() == 1) {
                                        gpio.setGpioLevel(LevelConfig.High);
                                    }
                                } else {
                                    gpio.setGpioDirection(DriectionConfig.Input);
                                    gpio.setGpioLevel(LevelConfig.NA);
                                }
                                gpio.setPinDemuxHead(head);
                                gpio.setGpioGroupAddress(gpioGroupAddress);
                                String gpioID = PinDemuxComposite.genGpioID(function, registerInfo.getPinDemuxHead().getPinMuxModuleName(), registerInfo.getPinMuxRegName());
                                gpio.setGpioID(gpioID);
                                this.pinDemuxInfo.setGpioMap(gpioID, gpio);
                                if (selectGPIO.contains(function)) break;
                                selectGPIO.add(gpioID);
                                break;
                            }
                            ++j;
                        }
                    }
                    registerList.add(registerInfo);
                }
            }
        }
    }

    private void selectGpioDataByBin(Object binDataObj, PinDemuxHead head, PinDemuxRegisterInfo registerInfo, List<String> selectGPIO, ArrayList<PinDemuxRegisterInfo> registerList, String startup, String curSelectStartup) {
        int mAddress = 0;
        if (binDataObj instanceof RegBinData) {
            int value;
            mAddress = head.getPinMuxBaseAddress() + registerInfo.getPinMuxOffsetAddress();
            RegBinData regBinData = (RegBinData)binDataObj;
            int regValue = registerInfo.getPinMuxValue();
            RegBinItem item = null;
            item = startup.equalsIgnoreCase("spi") ? regBinData.seekForItem(mAddress) : regBinData.seekForSecondSameItem(mAddress);
            if (item != null && regValue == (value = item.getValue())) {
                String function;
                RegBinAction action = null;
                if (item.isActionEnabled(RegBinAction.READ)) {
                    action = RegBinAction.READ;
                } else if (item.isActionEnabled(RegBinAction.WRITE)) {
                    action = RegBinAction.WRITE;
                }
                if (action != null) {
                    head.setExeForNormalBoot(item.isExecutionRequiredForNormalBoot(action));
                    head.setExeForStandyWakeup(item.isExecutionRequiredForStandbyWakeup(action));
                }
                if ((function = registerInfo.getPinMuxFunction()).toUpperCase().startsWith("GPIO")) {
                    GpioData gpio = null;
                    ArrayList<GpioData> gpioData = this.excelData.getGpioParsedDataList();
                    int j = 0;
                    while (j < gpioData.size()) {
                        if (gpioData.get(j).getGpioName().equals(function)) {
                            gpio = new GpioData();
                            gpio.setGpioName(function);
                            int gpioDataAbsoluteAddr = gpioData.get(j).getGpioAbsoluteAddr();
                            RegBinItem gpioItem = regBinData.seekForItem(gpioDataAbsoluteAddr);
                            if (gpioItem == null) {
                                gpio.setGpioDirection(DriectionConfig.Input);
                                gpio.setGpioLevel(LevelConfig.NA);
                            } else {
                                gpio.setGpioDirection(DriectionConfig.Output);
                                if (gpioItem.getValue() == 0) {
                                    gpio.setGpioLevel(LevelConfig.Low);
                                } else if (gpioItem.getValue() == 1) {
                                    gpio.setGpioLevel(LevelConfig.High);
                                }
                            }
                            gpio.setPinDemuxHead(head);
                            int gpioGroupAddress = ExcelDataHelper.getExcelDataforImport().getExcelMainData().getBaseGpioGroupAddress(function);
                            gpio.setGpioGroupAddress(gpioGroupAddress);
                            String gpioID = PinDemuxComposite.genGpioID(function, registerInfo.getPinDemuxHead().getPinMuxModuleName(), registerInfo.getPinMuxRegName());
                            gpio.setGpioID(gpioID);
                            this.pinDemuxInfo.setGpioMap(gpioID, gpio);
                            if (selectGPIO.contains(function) || !curSelectStartup.equalsIgnoreCase(startup)) break;
                            selectGPIO.add(gpioID);
                            break;
                        }
                        ++j;
                    }
                }
                registerList.add(registerInfo);
            }
        } else if (binDataObj instanceof CfgBinData) {
            int startBit;
            int offsetAddr;
            CfgBinData cfgBinData = (CfgBinData)binDataObj;
            mAddress = head.getPinMuxBaseAddress();
            CfgBinItem cfgBin = cfgBinData.seekForItemForBase(mAddress, offsetAddr = registerInfo.getPinMuxOffsetAddress(), startBit = registerInfo.getRegStartBit());
            if (cfgBin != null) {
                CfgBinModule module = cfgBin.getModuleRef();
                if (module.getType() == CfgBinType.WAKEUP) {
                    head.setExeForStandyWakeup(true);
                    head.setExeForNormalBoot(false);
                } else if (module.getType() == CfgBinType.INIT) {
                    head.setExeForStandyWakeup(true);
                    head.setExeForNormalBoot(false);
                } else {
                    head.setExeForStandyWakeup(true);
                    head.setExeForNormalBoot(true);
                }
                int value = registerInfo.getPinMuxValue();
                if (cfgBin.getValue() == value) {
                    if (registerInfo.getPinMuxFunction().toUpperCase().startsWith("GPIO")) {
                        String function = registerInfo.getPinMuxFunction();
                        GpioData gpio = null;
                        ArrayList<GpioData> gpioData = this.excelData.getGpioParsedDataList();
                        int j = 0;
                        while (j < gpioData.size()) {
                            if (gpioData.get(j).getGpioName().equals(function)) {
                                gpio = new GpioData();
                                gpio.setGpioName(function);
                                int gpioDataAbsoluteAddr = gpioData.get(j).getGpioAbsoluteAddr();
                                CfgBinItem gpioCfgBin = cfgBinData.seekForItemForBase(baseAddr, gpioDataAbsoluteAddr, 0);
                                if (gpioCfgBin != null) {
                                    gpio.setGpioDirection(DriectionConfig.Output);
                                    if (gpioCfgBin.getValue() == 0) {
                                        gpio.setGpioLevel(LevelConfig.Low);
                                    } else if (gpioCfgBin.getValue() == 1) {
                                        gpio.setGpioLevel(LevelConfig.High);
                                    }
                                } else {
                                    gpio.setGpioDirection(DriectionConfig.Input);
                                    gpio.setGpioLevel(LevelConfig.NA);
                                }
                                gpio.setPinDemuxHead(head);
                                int gpioGroupAddress = ExcelDataHelper.getExcelDataforImport().getExcelMainData().getBaseGpioGroupAddress(function);
                                gpio.setGpioGroupAddress(gpioGroupAddress);
                                String gpioID = PinDemuxComposite.genGpioID(function, registerInfo.getPinDemuxHead().getPinMuxModuleName(), registerInfo.getPinMuxRegName());
                                gpio.setGpioID(gpioID);
                                this.pinDemuxInfo.setGpioMap(gpioID, gpio);
                                if (selectGPIO.contains(function) || !curSelectStartup.equalsIgnoreCase(startup)) break;
                                selectGPIO.add(gpioID);
                                break;
                            }
                            ++j;
                        }
                    }
                    registerList.add(registerInfo);
                }
            }
        } else if (binDataObj instanceof BinData) {
            mAddress = head.getPinMuxBaseAddress();
            BinData binData = (BinData)binDataObj;
            int offsetAddr = registerInfo.getPinMuxOffsetAddress();
            int startBit = registerInfo.getRegStartBit();
            int pinMuxValue = registerInfo.getPinMuxValue();
            int absoluteAddr = mAddress + offsetAddr;
            RegBinAction regReadOrWrite = registerInfo.getRegReadOrWrite();
            int regBit = registerInfo.getRegBit();
            BinModuleType pinModuleType = registerInfo.getPinDemuxHead().getPinModuleType();
            BinItem binItem = binData.seekForItemForBase(absoluteAddr, offsetAddr, startBit, regBit, pinMuxValue, regReadOrWrite.ordinal(), pinModuleType);
            if (binItem != null) {
                BinModuleHead binModuleHead;
                BinModule module = binItem.getmModuleRef();
                if (module != null && (binModuleHead = module.getBinModuleHead()) != null) {
                    int normalBoot = binModuleHead.getNormalBoot();
                    int standbyWakeup = binModuleHead.getStandbyWakeup();
                    BinModuleType moduleType = binModuleHead.getModuleType();
                    int normalChip = binModuleHead.getNormalChip();
                    head.setExeForStandyWakeup(PrepareSetting.convertIntToBoot(standbyWakeup));
                    head.setExeForNormalBoot(PrepareSetting.convertIntToBoot(normalBoot));
                    head.setPinModuleType(moduleType);
                    head.setPinNormalChip(PrepareSetting.convertIntToBoot(normalChip));
                }
                int value = registerInfo.getPinMuxValue();
                if (binItem.getValue() == value) {
                    if (registerInfo.getPinMuxFunction().toUpperCase().startsWith("GPIO")) {
                        String function = registerInfo.getPinMuxFunction();
                        GpioData gpio = null;
                        ArrayList<GpioData> gpioData = this.excelData.getGpioParsedDataList();
                        int j = 0;
                        while (j < gpioData.size()) {
                            if (gpioData.get(j).getGpioName().equals(function)) {
                                gpio = new GpioData();
                                gpio.setGpioName(function);
                                String gpioName = gpioData.get(j).getGpioName();
                                String gpioStartBitStr = gpioName.substring(gpioName.lastIndexOf(UNDER_LINE) + UNDER_LINE.length());
                                String gpioDataNumStr = "GPIOX_" + gpioStartBitStr;
                                int gpioDataValue = GlobleInfo.getGpioXDataMap().get(gpioDataNumStr);
                                int gpioGroupAddress = ExcelDataHelper.getExcelDataforImport().getExcelMainData().getBaseGpioGroupAddress(function);
                                int gpioDataAbsoluteAddr = gpioGroupAddress + gpioDataValue;
                                int gpioStartBit = 0;
                                try {
                                    gpioStartBit = Integer.parseInt(gpioStartBitStr);
                                }
                                catch (NumberFormatException e) {
                                    e.printStackTrace();
                                }
                                BinItem gpioBinItem = binData.seekForItemForGPIO(gpioDataAbsoluteAddr, BytesArrayUtils.get1LowBytesFromInt(gpioDataAbsoluteAddr), gpioStartBit, registerInfo.getPinDemuxHead());
                                if (gpioBinItem != null) {
                                    gpio.setGpioDirection(DriectionConfig.Output);
                                    if (gpioBinItem.getValue() == 0) {
                                        gpio.setGpioLevel(LevelConfig.Low);
                                    } else if (gpioBinItem.getValue() == 1) {
                                        gpio.setGpioLevel(LevelConfig.High);
                                    }
                                } else {
                                    gpio.setGpioDirection(DriectionConfig.Input);
                                    gpio.setGpioLevel(LevelConfig.NA);
                                }
                                gpio.setPinDemuxHead(head);
                                gpio.setGpioGroupAddress(gpioGroupAddress);
                                String gpioID = PinDemuxComposite.genGpioID(function, registerInfo.getPinDemuxHead().getPinMuxModuleName(), registerInfo.getPinMuxRegName());
                                gpio.setGpioID(gpioID);
                                this.pinDemuxInfo.setGpioMap(gpioID, gpio);
                                if (selectGPIO.contains(function) || !curSelectStartup.equalsIgnoreCase(startup)) break;
                                selectGPIO.add(gpioID);
                                break;
                            }
                            ++j;
                        }
                    }
                    registerList.add(registerInfo);
                }
            }
        }
    }

    private void CreateInitialPinDemux(String selectDemoName, PinDemuxType type, String volDvdd) {
        ArrayList<String> startupList;
        this.parsedMainData = ExcelDataHelper.getDemoParsedMainData();
        this.excelData = ExcelDataHelper.getExcelData();
        if (this.parsedMainData != null && (startupList = this.parsedMainData.getStartupList()) != null && type.equals((Object)PinDemuxType.Demo)) {
            this.comboStartup.setItems(this.listToArray(startupList));
            String selectStartup = this.excelData.getComboStartup(selectDemoName);
            if (selectStartup == null) {
                return;
            }
            String[] starups = this.comboStartup.getItems();
            boolean updateStartupSuccess = false;
            int i = 0;
            while (i < starups.length) {
                if (starups[i].equalsIgnoreCase(selectStartup)) {
                    this.comboStartup.select(i);
                    this.lastSelIndexForStartup = i;
                    updateStartupSuccess = true;
                    break;
                }
                ++i;
            }
            if (!updateStartupSuccess) {
                i = 0;
                while (i < starups.length) {
                    if (starups[i].contains(selectStartup)) {
                        this.comboStartup.select(i);
                        this.lastSelIndexForStartup = i;
                        break;
                    }
                    ++i;
                }
            }
        }
        String starup = this.comboStartup.getText();
        StarupInfo starupInfo = new StarupInfo();
        starupInfo.setStartupItem(this.comboStartup.getItems());
        starupInfo.setStarup(starup);
        if (this.excelData != null) {
            if (RegbinView.getCurrentChip().equalsIgnoreCase("Hi3716MV410") || RegbinView.getCurrentChip().equalsIgnoreCase("Hi3716MV420")) {
                this.pinDemuxInfo = this.excelData.getPinDemuxInfo(selectDemoName, starup);
                this.originalDemuxInfo = this.excelData.getOriginalpinDemuxInfo(selectDemoName, starup);
            } else {
                this.pinDemuxInfo = this.excelData.getPinDemuxInfoByStartup(selectDemoName, starupInfo, true, false, volDvdd);
                this.originalDemuxInfo = this.excelData.getPinDemuxInfoByStartup(selectDemoName, starupInfo, false, true, volDvdd);
            }
            pinDemuxRegisterInfos = this.pinDemuxInfo.getPinDemuxRegisterList();
            List<String> selectGPIO = this.genEachGpioID();
            this.gpioParams = new ArrayList<GpioData>();
            this.map = this.pinDemuxInfo.getGpioMap();
            int j = 0;
            while (j < selectGPIO.size()) {
                GpioData gpioDate = this.map.get(selectGPIO.get(j));
                if (gpioDate != null) {
                    this.gpioParams.add(gpioDate);
                }
                ++j;
            }
        }
    }

    private List<String> genEachGpioID() {
        ArrayList<String> selectGPIO = new ArrayList<String>();
        int i = 0;
        while (i < pinDemuxRegisterInfos.size()) {
            PinDemuxRegisterInfo pinDemuxRegisterInfo = pinDemuxRegisterInfos.get(i);
            if (pinDemuxRegisterInfo != null && pinDemuxRegisterInfo.isGpio()) {
                String gpioID = PinDemuxComposite.genGpioID(pinDemuxRegisterInfo.getPinMuxFunction(), pinDemuxRegisterInfo.getPinDemuxHead().getPinMuxModuleName(), pinDemuxRegisterInfo.getPinMuxRegName());
                selectGPIO.add(gpioID);
            }
            ++i;
        }
        return selectGPIO;
    }

    private void CreatePinDemux(Composite parent) {
        Composite control = new Composite(parent, 2048);
        TableColumnLayout tcl = new TableColumnLayout();
        control.setLayout((Layout)tcl);
        GridData layoutData2 = new GridData(1808);
        layoutData2.minimumHeight = 210;
        control.setLayoutData((Object)layoutData2);
        this.registerTableViewer = new TableViewer(control, 66050);
        this.registerTableViewer.getTable().setLayoutData((Object)new GridData(1, 4, false, true));
        this.registerTableViewer.setContentProvider((IContentProvider)new IStructuredContentProvider(){

            public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            }

            public void dispose() {
            }

            public Object[] getElements(Object inputElement) {
                if (inputElement instanceof Collection) {
                    Collection c = (Collection)inputElement;
                    return c.toArray(new Object[c.size()]);
                }
                return new Object[0];
            }
        });
        this.registerTableViewer.setLabelProvider((IBaseLabelProvider)new ITableLabelProvider(){

            public void addListener(ILabelProviderListener listener) {
            }

            public void dispose() {
            }

            public boolean isLabelProperty(Object element, String property) {
                return false;
            }

            public void removeListener(ILabelProviderListener listener) {
            }

            public Image getColumnImage(Object element, int columnIndex) {
                return null;
            }

            public String getColumnText(Object element, int columnIndex) {
                if (element instanceof PinDemuxRegisterInfo) {
                    PinDemuxRegisterInfo pinDemux = (PinDemuxRegisterInfo)element;
                    if (columnIndex == 0) {
                        return pinDemux.getPinMuxRegName();
                    }
                    if (columnIndex == 1) {
                        return String.valueOf(pinDemux.getPinNum());
                    }
                    if (columnIndex == 2) {
                        String function = pinDemux.getPinMuxFunction();
                        return function == null ? "" : function;
                    }
                    if (columnIndex == 3) {
                        return pinDemux.getPinMuxDriver();
                    }
                    if (columnIndex == 4) {
                        return pinDemux.getPinMuxSlewRate();
                    }
                    if (columnIndex == 5 && ExcelDataHelper.isV120RegFomatVersion(ExcelDataHelper.getExcelData()) && pinDemux.getPinMuxPupd() != null) {
                        return pinDemux.getPinMuxPupd();
                    }
                }
                return "";
            }
        });
        Table table = this.registerTableViewer.getTable();
        table.setHeaderVisible(true);
        table.setLinesVisible(true);
        table.addListener(42, new Listener(){

            public void handleEvent(Event event) {
                PinDemuxComposite.this.handlePaintTableItem(event);
            }
        });
        int minWeidth = 10;
        TableColumn column = new TableColumn(table, 0x1000000, 0);
        column.setResizable(false);
        column.setMoveable(true);
        column.setText(registerColumnNames[0]);
        column.setAlignment(0x1000000);
        tcl.setColumnData((Widget)column, (ColumnLayoutData)new ColumnWeightData(1, 10, true));
        column = new TableColumn(table, 0x1000000, 1);
        column.setResizable(false);
        column.setMoveable(true);
        if (RegbinView.isHi3796MV200Series()) {
            PinDemuxComposite.registerColumnNames[1] = PIN_NUM_PACKAGE;
        }
        column.setText(registerColumnNames[1]);
        column.setAlignment(0x1000000);
        tcl.setColumnData((Widget)column, (ColumnLayoutData)new ColumnWeightData(1, 10, true));
        column = new TableColumn(table, 0x1000000, 2);
        column.setResizable(false);
        column.setMoveable(true);
        column.setText(registerColumnNames[2]);
        column.setAlignment(0x1000000);
        tcl.setColumnData((Widget)column, (ColumnLayoutData)new ColumnWeightData(1, 10, true));
        column = new TableColumn(table, 0x1000000, 3);
        column.setResizable(false);
        column.setMoveable(true);
        column.setText(registerColumnNames[3]);
        column.setAlignment(0x1000000);
        tcl.setColumnData((Widget)column, (ColumnLayoutData)new ColumnWeightData(1, 10, true));
        column = new TableColumn(table, 0x1000000, 4);
        column.setResizable(false);
        column.setMoveable(true);
        column.setText(registerColumnNames[4]);
        column.setAlignment(0x1000000);
        tcl.setColumnData((Widget)column, (ColumnLayoutData)new ColumnWeightData(1, 10, true));
        if (ExcelDataHelper.isV120RegFomatVersion(ExcelDataHelper.getExcelData())) {
            column = new TableColumn(table, 0x1000000, 5);
            column.setResizable(false);
            column.setMoveable(true);
            column.setText(registerColumnNames[5]);
            column.setAlignment(0x1000000);
            tcl.setColumnData((Widget)column, (ColumnLayoutData)new ColumnWeightData(1, 10, true));
        } else {
            column = new TableColumn(table, 0x1000000, 5);
            column.setResizable(false);
            column.setMoveable(true);
            column.setAlignment(0x1000000);
            tcl.setColumnData((Widget)column, (ColumnLayoutData)new ColumnWeightData(1, 10, true));
        }
        column = new TableColumn(table, 0x1000000, 6);
        column.setResizable(false);
        column.setMoveable(true);
        column.setAlignment(0x1000000);
        tcl.setColumnData((Widget)column, (ColumnLayoutData)new ColumnWeightData(1, 10, false));
        this.registerTableViewer.setColumnProperties(registerColumnNames);
        this.registerTableViewer.setCellModifier(new ICellModifier(){

            public boolean canModify(Object element, String property) {
                return true;
            }

            public Object getValue(Object element, String property) {
                PinDemuxRegisterInfo value = null;
                if (!(element instanceof PinDemuxRegisterInfo)) {
                    return null;
                }
                value = (PinDemuxRegisterInfo)element;
                if (property.equalsIgnoreCase(registerColumnNames[0])) {
                    return value.getPinMuxRegName();
                }
                if (property.equalsIgnoreCase(registerColumnNames[1]) || property.equalsIgnoreCase(PinDemuxComposite.PIN_NUM_PACKAGE)) {
                    return String.valueOf(value.getPinNum());
                }
                if (property.equalsIgnoreCase(registerColumnNames[2])) {
                    String curRegInModule = String.valueOf(value.getPinDemuxHead().getPinMuxModuleName()) + PinDemuxComposite.UNDER_LINE + value.getPinMuxRegName() + PinDemuxComposite.UNDER_LINE + value.getPinNum();
                    Map<String, List<FunctionParam>> registerFunction = GlobleInfo.getRegisterFunction();
                    List<FunctionParam> functions = registerFunction.get(curRegInModule);
                    if (functions != null) {
                        String[] functionNameS = new String[functions.size()];
                        int i = 0;
                        while (i < functions.size()) {
                            String functionName;
                            functionNameS[i] = functionName = functions.get(i).getFunction();
                            ++i;
                        }
                        PinDemuxComposite.this.functionCellEditor.setItems(functionNameS);
                        String[] items = PinDemuxComposite.this.functionCellEditor.getItems();
                        String function = value.getPinMuxFunction();
                        int i2 = 0;
                        while (i2 < items.length) {
                            if (function.equals(items[i2])) {
                                if (function.toUpperCase().startsWith("GPIO")) {
                                    value.setGpio(true);
                                } else {
                                    value.setGpio(false);
                                }
                                return i2;
                            }
                            ++i2;
                        }
                    }
                    return 0;
                }
                if (property.equalsIgnoreCase(registerColumnNames[3])) {
                    String driver = value.getPinMuxDriver();
                    return driver == null ? "" : driver;
                }
                if (property.equalsIgnoreCase(registerColumnNames[4])) {
                    String slewRate = value.getPinMuxSlewRate();
                    return slewRate == null ? "" : slewRate;
                }
                if (property.equalsIgnoreCase(registerColumnNames[5]) && ExcelDataHelper.isV120RegFomatVersion(ExcelDataHelper.getExcelData())) {
                    String pinMuxPupd = value.getPinMuxPupd();
                    return pinMuxPupd == null ? "" : pinMuxPupd;
                }
                return value;
            }

            public void modify(Object element, String property, Object value) {
                PinDemuxRegisterInfo item = null;
                if (!(element instanceof TableItem)) {
                    return;
                }
                item = (PinDemuxRegisterInfo)((TableItem)element).getData();
                String itemMuxModule = null;
                String itemRegName = null;
                if (item != null) {
                    itemMuxModule = item.getPinDemuxHead().getPinMuxModuleName();
                    itemRegName = item.getPinMuxRegName();
                }
                if (property.equalsIgnoreCase(registerColumnNames[2])) {
                    String pinMuxDriver;
                    int index = (Integer)value;
                    if (index == -1) {
                        index = 0;
                    }
                    String selectFunction = PinDemuxComposite.this.functionCellEditor.getItems()[index];
                    String oldValue = item.getPinMuxFunction();
                    PinDemuxRegisterInfo registerInfo = PinDemuxComposite.this.getRegsiterInfo(itemMuxModule, itemRegName, selectFunction);
                    if (registerInfo != null && ((pinMuxDriver = registerInfo.getPinMuxDriver()) == null || pinMuxDriver.isEmpty())) {
                        MessageDialog.openWarning((Shell)parent.getShell(), (String)Messages.Message_Error, (String)(String.valueOf(Messages.Message_NotSelectFction) + selectFunction));
                        return;
                    }
                    if (!oldValue.equalsIgnoreCase(selectFunction)) {
                        if (pinDemuxRegisterInfos != null) {
                            for (PinDemuxRegisterInfo pinDemuxRegisterInfo : pinDemuxRegisterInfos) {
                                String pinMuxFunction = pinDemuxRegisterInfo.getPinMuxFunction();
                                if (!selectFunction.equals(pinMuxFunction)) continue;
                                String regName = pinDemuxRegisterInfo.getPinMuxRegName();
                                MessageDialog.openWarning((Shell)parent.getShell(), (String)Messages.Message_Error, (String)NLS.bind((String)Messages.PinDemuxComposite_SelectFunctionValue, (Object[])new Object[]{selectFunction, regName}));
                                return;
                            }
                            if (PinDemuxComposite.this.gpioParams != null) {
                                int j = 0;
                                while (j < PinDemuxComposite.this.gpioParams.size()) {
                                    String gpioName;
                                    if (PinDemuxComposite.this.gpioParams.get(j) != null && (gpioName = ((GpioData)PinDemuxComposite.this.gpioParams.get(j)).getGpioName()) != null && gpioName.equals(selectFunction)) {
                                        String regName = null;
                                        if (pinDemuxRegisterInfos != null) {
                                            int i = 0;
                                            while (i < pinDemuxRegisterInfos.size()) {
                                                if (((PinDemuxRegisterInfo)pinDemuxRegisterInfos.get(i)).getPinMuxFunction().equals(selectFunction)) {
                                                    regName = ((PinDemuxRegisterInfo)pinDemuxRegisterInfos.get(i)).getPinMuxRegName();
                                                    break;
                                                }
                                                ++i;
                                            }
                                        }
                                        MessageDialog.openWarning((Shell)parent.getShell(), (String)Messages.Message_Error, (String)NLS.bind((String)Messages.PinDemuxComposite_SelectFunctionValue, (Object[])new Object[]{selectFunction, regName}));
                                        return;
                                    }
                                    ++j;
                                }
                            }
                            if (oldValue.toUpperCase().startsWith("GPIO")) {
                                int j = 0;
                                while (j < PinDemuxComposite.this.gpioParams.size()) {
                                    if (((GpioData)PinDemuxComposite.this.gpioParams.get(j)).getGpioName().equals(oldValue)) {
                                        PinDemuxComposite.this.gpioParams.remove(j);
                                    }
                                    ++j;
                                }
                            }
                            PinDemuxComposite.this.refreshGpio(item, selectFunction);
                        }
                        PinDemuxComposite.this.refreshItemInOriginal(item, itemMuxModule, itemRegName, selectFunction);
                        item.setPinMuxFunction(selectFunction);
                        PinDemuxComposite.this.registerTableViewer.refresh();
                    }
                }
            }
        });
        this.functionCellEditor = new ComboBoxCellEditor((Composite)table, new String[0], 0x1000008);
        CellEditor[] cellEditorArray = new CellEditor[6];
        cellEditorArray[2] = this.functionCellEditor;
        this.registerTableViewer.setCellEditors(cellEditorArray);
    }

    private PinDemuxRegisterInfo getRegsiterInfo(String itemMuxModule, String itemRegName, String selectFunction) {
        PinDemuxRegisterInfo regsiterInfo = null;
        if (this.originalDemuxInfo != null) {
            ArrayList<PinDemuxRegisterInfo> infos = this.originalDemuxInfo.getPinDemuxRegisterList();
            int j = 0;
            while (j < infos.size()) {
                String pinMuxRegName = infos.get(j).getPinMuxRegName();
                String pinMuxModuleName = infos.get(j).getPinDemuxHead().getPinMuxModuleName();
                String pinMuxFunction = infos.get(j).getPinMuxFunction();
                if (itemMuxModule.equalsIgnoreCase(pinMuxModuleName) && pinMuxFunction.equalsIgnoreCase(selectFunction) && itemRegName.equalsIgnoreCase(pinMuxRegName)) {
                    regsiterInfo = infos.get(j);
                    break;
                }
                ++j;
            }
        }
        return regsiterInfo;
    }

    private void refreshItemInOriginal(PinDemuxRegisterInfo item, String itemMuxModule, String itemRegName, String selectFunction) {
        PinDemuxRegisterInfo regsiterInfo = null;
        if (this.originalDemuxInfo != null) {
            ArrayList<PinDemuxRegisterInfo> infos = this.originalDemuxInfo.getPinDemuxRegisterList();
            int j = 0;
            while (j < infos.size()) {
                String pinMuxRegName = infos.get(j).getPinMuxRegName();
                String pinMuxModuleName = infos.get(j).getPinDemuxHead().getPinMuxModuleName();
                String pinMuxFunction = infos.get(j).getPinMuxFunction();
                if (itemMuxModule.equalsIgnoreCase(pinMuxModuleName) && pinMuxFunction.equalsIgnoreCase(selectFunction) && itemRegName.equalsIgnoreCase(pinMuxRegName)) {
                    regsiterInfo = infos.get(j);
                    break;
                }
                ++j;
            }
            if (regsiterInfo != null) {
                item.setPinMuxDriver(regsiterInfo.getPinMuxDriver());
                item.setPinMuxSlewRate(regsiterInfo.getPinMuxSlewRate());
                item.setPinMuxValue(regsiterInfo.getPinMuxValue());
                item.setPinMuxPupd(regsiterInfo.getPinMuxPupd());
                item.setRegBit(regsiterInfo.getRegBit());
                item.setRegStartBit(regsiterInfo.getRegStartBit());
                item.setRegReadOrWrite(regsiterInfo.getRegReadOrWrite());
            }
        }
    }

    private void refreshGpio(PinDemuxRegisterInfo item, String selectFunction) {
        if (selectFunction.toUpperCase().startsWith("GPIO")) {
            if (this.map != null) {
                item.setGpio(true);
                if (this.pinDemuxInfo.getGpioMap() != null) {
                    String gpioID = PinDemuxComposite.genGpioID(selectFunction, item.getPinDemuxHead().getPinMuxModuleName(), item.getPinMuxRegName());
                    GpioData gpioData = this.pinDemuxInfo.getGpioMap().get(gpioID);
                    if (gpioData != null) {
                        gpioData.setGpioID(gpioID);
                        this.gpioParams.add(gpioData);
                    } else {
                        gpioData = this.originalDemuxInfo.getGpioMap().get(gpioID);
                        if (gpioData != null) {
                            gpioData.setGpioID(gpioID);
                            this.gpioParams.add(gpioData);
                            this.pinDemuxInfo.getGpioMap().put(gpioID, gpioData);
                        }
                    }
                }
            }
        } else {
            item.setGpio(false);
        }
        if (this.gpioTableViewer != null) {
            this.gpioTableViewer.setInput(this.gpioParams);
        }
    }

    protected void handlePaintTableItem(Event event) {
        event.detail &= 0xFFFFFFDF;
        if ((event.detail & 2) == 0) {
            return;
        }
        Table table = (Table)event.widget;
        int clientWidth = table.getClientArea().width;
        GC gc = event.gc;
        Color oldForeground = gc.getForeground();
        Color oldBackground = gc.getBackground();
        Color forecolor = new Color(null, new RGB(255, 0, 0));
        gc.setForeground(forecolor);
        gc.drawRectangle(0, event.y, clientWidth, event.height - 2);
        forecolor.dispose();
        gc.setForeground(oldForeground);
        gc.setBackground(oldBackground);
        event.detail &= 0xFFFFFFFD;
    }

    private void CreateGPIO(Composite parent) {
        Composite controlGpio = new Composite(parent, 2048);
        TableColumnLayout tclGpio = new TableColumnLayout();
        controlGpio.setLayout((Layout)tclGpio);
        GridData layoutData3 = new GridData(4, 4, true, true, 1, 1);
        layoutData3.minimumHeight = 120;
        controlGpio.setLayoutData((Object)layoutData3);
        this.gpioTableViewer = new TableViewer(controlGpio, 66050);
        this.gpioTableViewer.setContentProvider((IContentProvider)new IStructuredContentProvider(){

            public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            }

            public void dispose() {
            }

            public Object[] getElements(Object inputElement) {
                if (inputElement instanceof Collection) {
                    Collection c = (Collection)inputElement;
                    return c.toArray(new Object[c.size()]);
                }
                return new Object[0];
            }
        });
        this.gpioTableViewer.setLabelProvider((IBaseLabelProvider)new ITableLabelProvider(){

            public void addListener(ILabelProviderListener listener) {
            }

            public void dispose() {
            }

            public boolean isLabelProperty(Object element, String property) {
                return false;
            }

            public void removeListener(ILabelProviderListener listener) {
            }

            public Image getColumnImage(Object element, int columnIndex) {
                return null;
            }

            public String getColumnText(Object element, int columnIndex) {
                if (element instanceof GpioData) {
                    GpioData gpio = (GpioData)element;
                    if (columnIndex == 0) {
                        return gpio.getGpioName();
                    }
                    if (columnIndex == 1) {
                        DriectionConfig config = gpio.getGpioDirection();
                        if (config.equals((Object)DriectionConfig.Input)) {
                            return Messages.PinDemuxDirectionInput;
                        }
                        if (config.equals((Object)DriectionConfig.Output)) {
                            return Messages.PinDemuxDirectionOutput;
                        }
                    } else if (columnIndex == 2) {
                        LevelConfig config = gpio.getGpioLevel();
                        if (config.equals((Object)LevelConfig.Low)) {
                            return Messages.PinDemuxLevelLow;
                        }
                        if (config.equals((Object)LevelConfig.High)) {
                            return Messages.PinDemuxLevelHigh;
                        }
                        if (config.equals((Object)LevelConfig.NA)) {
                            return Messages.PinDemuxLevelNa;
                        }
                    }
                }
                return "";
            }
        });
        Table gpioTable = this.gpioTableViewer.getTable();
        gpioTable.setHeaderVisible(true);
        gpioTable.setLinesVisible(true);
        gpioTable.addListener(42, new Listener(){

            public void handleEvent(Event event) {
                PinDemuxComposite.this.handlePaintTableItem(event);
            }
        });
        int minWeidth = 10;
        TableColumn column = new TableColumn(gpioTable, 0x1000000, 0);
        column.setResizable(false);
        column.setMoveable(true);
        column.setText(gpioColumnNames[0]);
        column.setAlignment(0x1000000);
        tclGpio.setColumnData((Widget)column, (ColumnLayoutData)new ColumnWeightData(1, 10, false));
        column = new TableColumn(gpioTable, 0x1000000, 1);
        column.setResizable(false);
        column.setMoveable(true);
        column.setText(gpioColumnNames[1]);
        column.setAlignment(0x1000000);
        tclGpio.setColumnData((Widget)column, (ColumnLayoutData)new ColumnWeightData(1, 10, false));
        column = new TableColumn(gpioTable, 0x1000000, 2);
        column.setResizable(false);
        column.setMoveable(true);
        column.setText(gpioColumnNames[2]);
        column.setAlignment(0x1000000);
        tclGpio.setColumnData((Widget)column, (ColumnLayoutData)new ColumnWeightData(1, 10, false));
        column = new TableColumn(gpioTable, 0x1000000, 3);
        column.setResizable(false);
        column.setMoveable(true);
        column.setAlignment(0x1000000);
        tclGpio.setColumnData((Widget)column, (ColumnLayoutData)new ColumnWeightData(1, 10, false));
        column = new TableColumn(gpioTable, 0x1000000, 4);
        column.setResizable(false);
        column.setMoveable(true);
        column.setAlignment(0x1000000);
        tclGpio.setColumnData((Widget)column, (ColumnLayoutData)new ColumnWeightData(1, 10, false));
        column = new TableColumn(gpioTable, 0x1000000, 5);
        column.setResizable(false);
        column.setMoveable(true);
        column.setAlignment(0x1000000);
        tclGpio.setColumnData((Widget)column, (ColumnLayoutData)new ColumnWeightData(1, 10, false));
        column = new TableColumn(gpioTable, 0x1000000, 6);
        column.setResizable(false);
        column.setMoveable(true);
        column.setAlignment(0x1000000);
        tclGpio.setColumnData((Widget)column, (ColumnLayoutData)new ColumnWeightData(1, 10, false));
        this.gpioTableViewer.setColumnProperties(gpioColumnNames);
        this.gpioTableViewer.setCellModifier(new ICellModifier(){

            public boolean canModify(Object element, String property) {
                return true;
            }

            public Object getValue(Object element, String property) {
                GpioData value = null;
                if (element instanceof GpioData) {
                    value = (GpioData)element;
                }
                if (property.equals(gpioColumnNames[0])) {
                    String name = value.getGpioName();
                    return name == null ? "" : name;
                }
                if (property.equals(gpioColumnNames[1])) {
                    DriectionConfig config = value.getGpioDirection();
                    if (config.equals((Object)DriectionConfig.Input)) {
                        return 0;
                    }
                    if (config.equals((Object)DriectionConfig.Output)) {
                        return 1;
                    }
                    return 0;
                }
                if (property.equals(gpioColumnNames[2])) {
                    DriectionConfig gpioDirection = value.getGpioDirection();
                    LevelConfig config = value.getGpioLevel();
                    this.updateLevelByDirection(gpioDirection);
                    if (gpioDirection == DriectionConfig.Output) {
                        if (config.equals((Object)LevelConfig.Low)) {
                            return 0;
                        }
                        if (config.equals((Object)LevelConfig.High)) {
                            return 1;
                        }
                    } else if (config.equals((Object)LevelConfig.NA)) {
                        return 0;
                    }
                    return 0;
                }
                return value;
            }

            public void modify(Object element, String property, Object value) {
                GpioData item = null;
                if (element instanceof TableItem) {
                    item = (GpioData)((TableItem)element).getData();
                }
                if (property.equals(gpioColumnNames[1])) {
                    DriectionConfig oldValue;
                    String valueOf;
                    Integer index = (Integer)value;
                    if (index == -1) {
                        index = 0;
                    }
                    if (!(valueOf = PinDemuxComposite.this.direction.getItems()[index]).equals((oldValue = item.getGpioDirection()).name())) {
                        if (valueOf.equals(Messages.PinDemuxDirectionInput)) {
                            item.setGpioDirection(DriectionConfig.Input);
                        } else if (valueOf.equals(Messages.PinDemuxDirectionOutput)) {
                            item.setGpioDirection(DriectionConfig.Output);
                        }
                    }
                    LevelConfig gpioLevel = item.getGpioLevel();
                    if (valueOf.equalsIgnoreCase(Messages.PinDemuxDirectionOutput)) {
                        PinDemuxComposite.this.level.setItems(new String[]{Messages.PinDemuxLevelLow, Messages.PinDemuxLevelHigh});
                        if (gpioLevel == LevelConfig.NA) {
                            item.setGpioLevel(LevelConfig.Low);
                        }
                    } else {
                        PinDemuxComposite.this.level.setItems(new String[]{Messages.PinDemuxLevelNa});
                        if (gpioLevel != LevelConfig.NA) {
                            item.setGpioLevel(LevelConfig.NA);
                        }
                    }
                } else if (property.equals(gpioColumnNames[2])) {
                    String valueOf;
                    Integer index = (Integer)value;
                    if (index == -1) {
                        index = 0;
                    }
                    if ((valueOf = PinDemuxComposite.this.level.getItems()[index]).equals(Messages.PinDemuxLevelNa)) {
                        item.setGpioLevel(LevelConfig.NA);
                    } else if (valueOf.equals(Messages.PinDemuxLevelLow)) {
                        item.setGpioLevel(LevelConfig.Low);
                    } else if (valueOf.equals(Messages.PinDemuxLevelHigh)) {
                        item.setGpioLevel(LevelConfig.High);
                    }
                }
                PinDemuxComposite.this.gpioTableViewer.refresh();
            }

            private void updateLevelByDirection(DriectionConfig gpioDirection) {
                if (gpioDirection == DriectionConfig.Output) {
                    PinDemuxComposite.this.level.setItems(new String[]{Messages.PinDemuxLevelLow, Messages.PinDemuxLevelHigh});
                } else {
                    PinDemuxComposite.this.level.setItems(new String[]{Messages.PinDemuxLevelNa});
                }
            }
        });
        this.direction = new ComboBoxCellEditor((Composite)gpioTable, new String[]{Messages.PinDemuxDirectionInput, Messages.PinDemuxDirectionOutput}, 0x1000008);
        this.level = new ComboBoxCellEditor((Composite)gpioTable, new String[]{Messages.PinDemuxLevelNa}, 0x1000008);
        CellEditor[] cellEditorArray = new CellEditor[4];
        cellEditorArray[1] = this.direction;
        cellEditorArray[2] = this.level;
        this.gpioTableViewer.setCellEditors(cellEditorArray);
    }

    private String[] listToArray(ArrayList<String> list) {
        String[] resStrings = new String[list.size()];
        int i = 0;
        while (i < list.size()) {
            String value;
            resStrings[i] = value = list.get(i);
            ++i;
        }
        return resStrings;
    }

    public Combo getComboStartup() {
        return this.comboStartup;
    }

    public TableViewer getRegisterTableViewer() {
        return this.registerTableViewer;
    }

    public TableViewer getGpioTableViewer() {
        return this.gpioTableViewer;
    }

    public ExcelData getExcelData() {
        return this.excelData;
    }

    public PinDemuxInfo getPinDemuxInfo() {
        return this.pinDemuxInfo;
    }

    public void setPinDemuxInfo(PinDemuxInfo pinDemuxInfo) {
        this.pinDemuxInfo = pinDemuxInfo;
    }

    public static ArrayList<PinDemuxRegisterInfo> getPinDemuxRegisterInfos() {
        return pinDemuxRegisterInfos;
    }

    public static void setPinDemuxRegisterInfos(ArrayList<PinDemuxRegisterInfo> pinDemuxRegisterInfos) {
        PinDemuxComposite.pinDemuxRegisterInfos = pinDemuxRegisterInfos;
    }

    public Map<String, GpioData> getMap() {
        return this.map;
    }

    public void setMap(Map<String, GpioData> map) {
        this.map = map;
    }

    public PinDemuxInfo getOriginalDemuxInfo() {
        return this.originalDemuxInfo;
    }

    public void setGpioParams(List<GpioData> gpioParams) {
        this.gpioParams = gpioParams;
    }

    public List<GpioData> getGpioParams() {
        return this.gpioParams;
    }

    public static String genGpioID(String function, String moduleName, String regName) {
        return String.valueOf(function) + "+" + moduleName + "+" + regName;
    }

    static /* synthetic */ Combo access$0(PinDemuxComposite pinDemuxComposite) {
        return pinDemuxComposite.comboStartup;
    }

    static /* synthetic */ Label access$1(PinDemuxComposite pinDemuxComposite) {
        return pinDemuxComposite.labCustomDemoName;
    }

    static /* synthetic */ String access$2(PinDemuxComposite pinDemuxComposite) {
        return pinDemuxComposite.DEMONAME;
    }

    static /* synthetic */ Object access$3(PinDemuxComposite pinDemuxComposite) {
        return pinDemuxComposite.REGBINDATA;
    }

    static /* synthetic */ String access$4(PinDemuxComposite pinDemuxComposite) {
        return pinDemuxComposite.DATANAME;
    }

    static /* synthetic */ void access$5(PinDemuxComposite pinDemuxComposite, int n) {
        pinDemuxComposite.lastSelIndexForStartup = n;
    }

    static /* synthetic */ ComboBoxCellEditor access$6(PinDemuxComposite pinDemuxComposite) {
        return pinDemuxComposite.functionCellEditor;
    }

    static /* synthetic */ PinDemuxRegisterInfo access$7(PinDemuxComposite pinDemuxComposite, String string, String string2, String string3) {
        return pinDemuxComposite.getRegsiterInfo(string, string2, string3);
    }

    static /* synthetic */ ArrayList access$8() {
        return pinDemuxRegisterInfos;
    }

    static /* synthetic */ List access$9(PinDemuxComposite pinDemuxComposite) {
        return pinDemuxComposite.gpioParams;
    }

    static /* synthetic */ void access$10(PinDemuxComposite pinDemuxComposite, PinDemuxRegisterInfo pinDemuxRegisterInfo, String string) {
        pinDemuxComposite.refreshGpio(pinDemuxRegisterInfo, string);
    }

    static /* synthetic */ void access$11(PinDemuxComposite pinDemuxComposite, PinDemuxRegisterInfo pinDemuxRegisterInfo, String string, String string2, String string3) {
        pinDemuxComposite.refreshItemInOriginal(pinDemuxRegisterInfo, string, string2, string3);
    }

    static /* synthetic */ TableViewer access$12(PinDemuxComposite pinDemuxComposite) {
        return pinDemuxComposite.registerTableViewer;
    }

    static /* synthetic */ ComboBoxCellEditor access$13(PinDemuxComposite pinDemuxComposite) {
        return pinDemuxComposite.direction;
    }

    static /* synthetic */ ComboBoxCellEditor access$14(PinDemuxComposite pinDemuxComposite) {
        return pinDemuxComposite.level;
    }

    static /* synthetic */ TableViewer access$15(PinDemuxComposite pinDemuxComposite) {
        return pinDemuxComposite.gpioTableViewer;
    }
}

