/*
 * Decompiled with CFR 0.152.
 */
package com.hisilicon.hiregbin.ui;

import com.hisilicon.hiregbin.Messages;
import com.hisilicon.hiregbin.model.BaseParam;
import com.hisilicon.hiregbin.model.BatchParameter;
import com.hisilicon.hiregbin.model.GlobleInfo;
import com.hisilicon.hiregbin.model.PinDemuxHead;
import com.hisilicon.hiregbin.model.Setting;
import com.hisilicon.hiregbin.model.StarupInfo;
import com.hisilicon.hiregbin.model.reg.BaseRegisterInfo;
import com.hisilicon.hiregbin.model.reg.DemoBaseParam;
import com.hisilicon.hiregbin.model.reg.DriectionConfig;
import com.hisilicon.hiregbin.model.reg.GpioData;
import com.hisilicon.hiregbin.model.reg.LevelConfig;
import com.hisilicon.hiregbin.model.reg.ParsedMainData;
import com.hisilicon.hiregbin.model.reg.PinDemuxInfo;
import com.hisilicon.hiregbin.model.reg.PinDemuxRegisterInfo;
import com.hisilicon.hiregbin.model.reg.PinDemuxType;
import com.hisilicon.hiregbin.model.reg.bin.RegBinAction;
import com.hisilicon.hiregbin.model.reg.bin.RegBinData;
import com.hisilicon.hiregbin.model.reg.cfg.CfgBinData;
import com.hisilicon.hiregbin.model.reg.excel.DdrType;
import com.hisilicon.hiregbin.model.reg.excel.ExcelData;
import com.hisilicon.hiregbin.model.reg.hi98cv200bin.BinData;
import com.hisilicon.hiregbin.model.reg.hi98cv200bin.MultiperTable;
import com.hisilicon.hiregbin.preferences.PanelPreferences;
import com.hisilicon.hiregbin.ui.AbstractBaseComposite;
import com.hisilicon.hiregbin.ui.BaseSettingComposite;
import com.hisilicon.hiregbin.ui.DemoTypeSelectDialog;
import com.hisilicon.hiregbin.ui.MultiperTableComposite;
import com.hisilicon.hiregbin.ui.PinDemuxComposite;
import com.hisilicon.hiregbin.utility.BytesArrayUtils;
import com.hisilicon.hiregbin.utility.BytesUtils;
import com.hisilicon.hiregbin.utility.ExcelDataHelper;
import com.hisilicon.hiregbin.utility.FileUtils;
import com.hisilicon.hiregbin.utility.HiToolUtils;
import com.hisilicon.hiregbin.utility.TextReader;
import com.hisilicon.hiregbin.views.RegbinView;
import java.io.File;
import java.io.IOException;
import java.nio.ByteOrder;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.dom4j.DocumentException;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.PlatformUI;

public class PanelComposite
extends AbstractBaseComposite {
    private static final String[] IMPORT_BIN_ERROR = new String[]{"Cannot find the data item: ", "Invalid value: ", "Cannot find the module item: ", "Cannot find the data item: ", "Invalid value: "};
    private static final int MINWIDTH = 980;
    public static final String CELL_KEY_DEMOCONFIG_DDRFREQ = "DDRFreq";
    public static final String CELL_KEY_DEMOCONFIG_CPUFREQ = "CPUFreq";
    private static final String[] CAPACITYTITLE_TITLE_LIST = new String[]{"1024Mch0_1024Mch1", "1024Mch0_512Mch1", "512Mch0_512Mch1", "512Mch0_256Mch1", "256Mch0_256Mch1"};
    private static final String[] CAPACITYTITLE_LIST = new String[]{"2048M", "1536M", "1024M", "768M", "512M"};
    private TabFolder tabFolder;
    private TabItem baseSettingItem;
    private TabItem pinDemuxItem;
    private Label labDemoVersion;
    private Label labCustomDemoName;
    private Text textCustomDemoName;
    protected Button btnDemoImport;
    protected Button btnImportRegBin;
    protected Button btnImportFastbootBin;
    protected Button btnImportCfgBin;
    protected Button btnImportConfig;
    protected String selectDemoName;
    private String customAddStr;
    private Composite baseComposite;
    private Composite pinComposite;
    private BaseSettingComposite baseSettingComposite;
    private PinDemuxComposite pinDemuxComposite;
    private ScrolledComposite baseScrolledComposite;
    private ScrolledComposite pinDemuxScrolledCom;
    private Composite tabComposite;

    public PanelComposite(Composite parent, Setting setting) {
        super(parent, setting);
        this.setting = setting;
    }

    @Override
    protected Control createControl(Composite parent) {
        parent.setBackground(GlobleInfo.white);
        ParsedMainData parsedMainData = ExcelDataHelper.getDemoParsedMainData();
        ScrolledComposite scrolledCom = new ScrolledComposite(parent, 2816);
        scrolledCom.setLayoutData((Object)new GridData(1808));
        scrolledCom.setExpandHorizontal(true);
        scrolledCom.setExpandVertical(true);
        scrolledCom.setMinWidth(980);
        scrolledCom.setMinHeight(768);
        scrolledCom.setLayout((Layout)new GridLayout(1, false));
        Composite composite = new Composite((Composite)scrolledCom, 0);
        composite.setLayout((Layout)new GridLayout(1, false));
        composite.setLayoutData((Object)new GridData(1808));
        scrolledCom.setContent((Control)composite);
        Composite compositeTempFile = new Composite(composite, 0);
        compositeTempFile.setLayout((Layout)new GridLayout(3, false));
        compositeTempFile.setLayoutData((Object)new GridData(4, 1, true, false));
        compositeTempFile.setBackground(GlobleInfo.white);
        Label labDemoType = new Label(compositeTempFile, 0);
        labDemoType.setText(Messages.PanelComposite_TempPath);
        GridData labDemoTypeGD = new GridData();
        labDemoTypeGD.horizontalIndent = 0;
        labDemoType.setLayoutData((Object)labDemoTypeGD);
        labDemoType.setBackground(GlobleInfo.white);
        Text imageText = new Text(compositeTempFile, 2048);
        GridData gridData = new GridData(4, 1, true, false);
        gridData.verticalIndent = 2;
        imageText.setLayoutData((Object)gridData);
        String tempFilePath = PanelPreferences.CONFIG.getTempFilePath();
        imageText.setText(tempFilePath);
        imageText.setToolTipText(tempFilePath);
        imageText.setEnabled(false);
        gridData = new GridData();
        gridData.widthHint = 130;
        Button loadBtn = new Button(compositeTempFile, 0);
        loadBtn.setText(Messages.PanelComposite_TempFile_Load);
        loadBtn.setLayoutData((Object)gridData);
        loadBtn.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                IViewPart view = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().findView(RegbinView.ID);
                if (view != null && view instanceof RegbinView) {
                    RegbinView regbinView = (RegbinView)view;
                    try {
                        while (!regbinView.selectTempFile(true)) {
                        }
                        if (!regbinView.isClose()) {
                            regbinView.deviceChanged();
                        }
                    }
                    catch (DocumentException e) {
                        e.printStackTrace();
                    }
                }
            }
        });
        PanelPreferences.CONFIG.setTempFilePath(tempFilePath);
        Composite compositeImport = new Composite(composite, 0);
        compositeImport.setLayoutData((Object)new GridData(4, 1, true, false));
        compositeImport.setBackground(GlobleInfo.white);
        compositeImport.setLayout((Layout)new GridLayout(4, false));
        this.btnDemoImport = new Button(compositeImport, 0);
        this.btnDemoImport.setText(Messages.PanelComposite_DemoSettingImport);
        gridData = new GridData(576);
        gridData.widthHint = 130;
        this.btnDemoImport.setLayoutData((Object)gridData);
        this.btnDemoImport.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                BaseParam baseParam = new BaseParam();
                Object paramObj = PanelComposite.this.getParam(baseParam, ".reg");
                if (!PanelComposite.this.tipNeedSaveData(paramObj) && PanelComposite.this.checkParseMainData(parsedMainData)) {
                    DemoTypeSelectDialog demoTypeSelectDialog = new DemoTypeSelectDialog(Display.getCurrent().getActiveShell(), parsedMainData, PanelComposite.this.customAddStr, PanelComposite.this.customDemoName, PanelComposite.this.selectDemoName);
                    int open = demoTypeSelectDialog.open();
                    if (open == 0) {
                        PanelComposite.setCurrentExcelData(ExcelDataHelper.getExcelData());
                        PanelComposite.this.customAddStr = demoTypeSelectDialog.getCustomAddStr();
                        PanelComposite.this.customDemoName = demoTypeSelectDialog.getCustomDemoName();
                        PanelComposite.this.selectDemoName = demoTypeSelectDialog.getSelectDemoName();
                        if (PanelComposite.this.selectDemoName != null) {
                            String tableName;
                            PanelComposite.this.customDemoName = tableName = PanelComposite.this.handleTableName(parsedMainData, PanelComposite.this.selectDemoName);
                            PanelComposite.this.labCustomDemoName.setText(PanelComposite.this.customDemoName);
                            PanelComposite.this.textCustomDemoName.setText("");
                            PanelComposite.this.customAddStr = "";
                            PanelComposite.this.customDemoName = PanelComposite.this.customAddStr != null && !PanelComposite.this.customAddStr.isEmpty() ? String.valueOf(tableName) + "_" + PanelComposite.this.customAddStr : tableName;
                            PanelComposite.this.baseSettingComposite.refreshDemoInfoToUI(PanelComposite.this.baseComposite, parsedMainData, PanelComposite.this.selectDemoName, PinDemuxType.Demo, true);
                            PanelComposite.this.pinDemuxComposite.refreshDemoInfoToUI(PanelComposite.this.selectDemoName, null, null, PinDemuxType.Demo, null);
                            PanelComposite.this.importRefreshBtnState();
                        }
                    } else {
                        return;
                    }
                }
            }
        });
        if (ExcelDataHelper.isV120RegFomatVersion(ExcelDataHelper.getExcelData()) && !RegbinView.isHi3716V550Series()) {
            this.btnImportConfig = new Button(compositeImport, 0);
            this.btnImportConfig.setText(Messages.PanelComposite_ConfigImport);
            gridData = new GridData(576);
            gridData.widthHint = 130;
            this.btnImportConfig.setLayoutData((Object)gridData);
            this.btnImportConfig.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    block15: {
                        BaseParam baseParam = new BaseParam();
                        Object paramObj = PanelComposite.this.getParam(baseParam, ".reg");
                        if (!PanelComposite.this.tipNeedSaveData(paramObj)) {
                            FileDialog fd = new FileDialog(PanelComposite.this.getShell());
                            fd.setFilterExtensions(new String[]{"*.config", "*.*"});
                            String filePath = fd.open();
                            if (filePath == null) {
                                return;
                            }
                            if (filePath.length() <= 0) {
                                MessageDialog.openInformation((Shell)PanelComposite.this.getShell(), (String)Messages.Message_Error, (String)Messages.PanelComposite_TempFile_Isvalid);
                                return;
                            }
                            if (new File(filePath) != null && !new File(filePath).exists()) {
                                MessageDialog.openError((Shell)PanelComposite.this.getShell(), (String)Messages.Message_HiRegBin, (String)Messages.ValidityCheck_Import_param_isNull);
                                return;
                            }
                            try {
                                TextReader textReader = new TextReader(filePath);
                                String configDemoName = textReader.getValue("ConfigName", "ConfigName");
                                if (configDemoName != null) {
                                    if (!ExcelDataHelper.isV135XlsFomatVersion(ExcelDataHelper.getExcelData())) {
                                        String[] names = configDemoName.split("_");
                                        String curDdrName = "";
                                        String[] stringArray = names;
                                        int n = names.length;
                                        int n2 = 0;
                                        while (n2 < n) {
                                            String name = stringArray[n2];
                                            if (name.toLowerCase().contains("ddr")) {
                                                curDdrName = name;
                                                break;
                                            }
                                            ++n2;
                                        }
                                        if (RegbinView.isHi3716MV430Series()) {
                                            Combo comboDdrType = PanelComposite.this.baseSettingComposite.getComboDdrType();
                                            if (comboDdrType.getSelectionIndex() == -1) {
                                                MessageDialog.openError((Shell)PanelComposite.this.getShell(), (String)Messages.Message_HiRegBin, (String)Messages.Message_HAVATO_IMPORT_DEMO);
                                                return;
                                            }
                                            if (comboDdrType.getItemCount() > 0 && !comboDdrType.getText().equals(curDdrName)) {
                                                MessageDialog.openError((Shell)PanelComposite.this.getShell(), (String)Messages.Message_HiRegBin, (String)Messages.Message_DDR_NOT_MATCH);
                                                return;
                                            }
                                        }
                                        String updateDdrNameAddFreq = PanelComposite.this.updateDdrNameAddFreq(configDemoName, parsedMainData.getDemoList(), curDdrName);
                                        configDemoName = configDemoName.replace(curDdrName, updateDdrNameAddFreq);
                                    }
                                    PanelComposite.this.refreshDemoInfoByConfig(parsedMainData, configDemoName);
                                    PanelComposite.this.refreshConfigurableParamByConfig(textReader);
                                    PanelComposite.this.refreshMacByConfig(textReader);
                                    PanelComposite.this.refreshPhyAddressByConfig(textReader);
                                    PanelComposite.this.refreshGpioGroupNumByConfig(textReader);
                                    PanelComposite.this.refreshGpioBitsByConfig(textReader);
                                    PanelComposite.this.refreshStartupByConfig(textReader);
                                    PanelComposite.this.refreshPinMuxByConfig(textReader);
                                    if (ExcelDataHelper.isV135XlsFomatVersion(ExcelDataHelper.getExcelData())) {
                                        PanelComposite.this.refreshDdrPhyByConfig(textReader);
                                    }
                                    break block15;
                                }
                                MessageDialog.openError((Shell)PanelComposite.this.getShell(), (String)Messages.Message_HiRegBin, (String)Messages.ValidityCheck_Import_param_isNull);
                                return;
                            }
                            catch (IOException e1) {
                                e1.printStackTrace();
                                MessageDialog.openError((Shell)PanelComposite.this.getShell(), (String)Messages.Message_HiRegBin, (String)Messages.ValidityCheck_Import_param_isNull);
                                return;
                            }
                            catch (NullPointerException e2) {
                                e2.printStackTrace();
                                MessageDialog.openError((Shell)PanelComposite.this.getShell(), (String)Messages.Message_HiRegBin, (String)Messages.ValidityCheck_Import_param_isNull);
                                return;
                            }
                        }
                    }
                }
            });
        }
        this.btnImportRegBin = new Button(compositeImport, 0);
        this.btnImportRegBin.setText(Messages.PanelComposite_Import_From_RegBin);
        gridData = new GridData(576);
        gridData.widthHint = 130;
        this.btnImportRegBin.setLayoutData((Object)gridData);
        this.btnImportRegBin.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (RegbinView.isNotLoadImportExcelDataSuccess()) {
                    MessageDialog.openInformation((Shell)PanelComposite.this.getShell(), (String)Messages.Message_Warning, (String)Messages.PanelComposite_Wait_Import_ExcelData_Load_Success);
                    return;
                }
                BaseParam baseParam = new BaseParam();
                Object paramObj = PanelComposite.this.getParam(baseParam, ".reg");
                if (!PanelComposite.this.tipNeedSaveData(paramObj)) {
                    PanelComposite.this.openRegBinFile();
                    PanelComposite.this.importRefreshBtnState();
                    PanelComposite.setCurrentExcelData(ExcelDataHelper.getExcelDataforImport());
                }
            }
        });
        if (ExcelDataHelper.isV120RegFomatVersion(ExcelDataHelper.getExcelData())) {
            PanelComposite.setBtnMakeRegBin(new Button(compositeImport, 0));
            PanelComposite.getBtnMakeRegBin().setText(Messages.AbstractBaseComposite_MakeRegBin);
            gridData.widthHint = 130;
            PanelComposite.getBtnMakeRegBin().setLayoutData((Object)gridData);
            PanelComposite.getBtnMakeRegBin().addListener(13, (Listener)new AbstractBaseComposite.MakeRegBinListener());
            if (RegbinView.isHi3716V550Series()) {
                Button btnMakeAllRegBin = new Button(compositeImport, 0);
                btnMakeAllRegBin.setText("Create All Reg");
                btnMakeAllRegBin.setLayoutData((Object)gridData);
                AbstractBaseComposite.MakeRegBinListener makeRegBinListener = new AbstractBaseComposite.MakeRegBinListener();
                makeRegBinListener.setBatch(true);
                btnMakeAllRegBin.addListener(13, (Listener)makeRegBinListener);
            }
        } else {
            this.btnImportCfgBin = new Button(compositeImport, 0);
            this.btnImportCfgBin.setText(Messages.PanelComposite_Import_From_CfgBin);
            gridData = new GridData(576);
            gridData.widthHint = 130;
            this.btnImportCfgBin.setLayoutData((Object)gridData);
            this.btnImportCfgBin.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    if (RegbinView.isNotLoadImportExcelDataSuccess()) {
                        MessageDialog.openInformation((Shell)PanelComposite.this.getShell(), (String)Messages.Message_Warning, (String)Messages.PanelComposite_Wait_Import_ExcelData_Load_Success);
                        return;
                    }
                    BaseParam baseParam = new BaseParam();
                    Object paramObj = PanelComposite.this.getParam(baseParam, ".reg");
                    if (!PanelComposite.this.tipNeedSaveData(paramObj)) {
                        PanelComposite.this.openCfgBinFile();
                        PanelComposite.this.importRefreshBtnState();
                        PanelComposite.setCurrentExcelData(ExcelDataHelper.getExcelDataforImport());
                    }
                }
            });
            this.btnImportFastbootBin = new Button(compositeImport, 0);
            this.btnImportFastbootBin.setText(Messages.PanelComposite_Import_From_Fastboot);
            gridData = new GridData(576);
            gridData.widthHint = 130;
            this.btnImportFastbootBin.setLayoutData((Object)gridData);
            this.btnImportFastbootBin.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    if (RegbinView.isNotLoadImportExcelDataSuccess()) {
                        MessageDialog.openInformation((Shell)PanelComposite.this.getShell(), (String)Messages.Message_Warning, (String)Messages.PanelComposite_Wait_Import_ExcelData_Load_Success);
                        return;
                    }
                    BaseParam baseParam = new BaseParam();
                    Object paramObj = PanelComposite.this.getParam(baseParam, ".reg");
                    if (!PanelComposite.this.tipNeedSaveData(paramObj)) {
                        PanelComposite.this.openRegBinFromFastboot();
                        PanelComposite.this.importRefreshBtnState();
                        PanelComposite.setCurrentExcelData(ExcelDataHelper.getExcelDataforImport());
                    }
                }
            });
        }
        Composite customNameComposite = new Composite(composite, 0);
        customNameComposite.setLayout((Layout)new GridLayout(3, false));
        customNameComposite.setLayoutData((Object)new GridData(4, 1, true, false));
        customNameComposite.setBackground(GlobleInfo.white);
        Label labCustomTableName = new Label(customNameComposite, 0);
        labCustomTableName.setText(Messages.PanelComposite_CustomRegTableName);
        GridData labCustomTableNameGD = new GridData(1, 1, false, false);
        labCustomTableName.setLayoutData((Object)labCustomTableNameGD);
        labCustomTableName.setBackground(GlobleInfo.white);
        this.labCustomDemoName = new Label(customNameComposite, 0);
        this.labCustomDemoName.setText("");
        GridData customDemoNameGD = new GridData(1, 1, false, false);
        customDemoNameGD.widthHint = 700;
        this.labCustomDemoName.setLayoutData((Object)customDemoNameGD);
        this.labCustomDemoName.setBackground(GlobleInfo.white);
        this.labCustomDemoName.setToolTipText(this.labCustomDemoName.getText());
        this.textCustomDemoName = new Text(customNameComposite, 2048);
        GridData textCustomDemoNameGD = new GridData(1, 1, false, false);
        textCustomDemoNameGD.widthHint = 300;
        this.textCustomDemoName.setTextLimit(32);
        this.textCustomDemoName.setText(Messages.PanelComposite_CustomName);
        this.textCustomDemoName.setForeground(GlobleInfo.gray);
        this.textCustomDemoName.setLayoutData((Object)textCustomDemoNameGD);
        this.textCustomDemoName.setVisible(false);
        this.textCustomDemoName.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                String text = PanelComposite.this.textCustomDemoName.getText();
                if (text == null) {
                    return;
                }
                if (text.equalsIgnoreCase(Messages.PanelComposite_CustomName)) {
                    PanelComposite.this.textCustomDemoName.setForeground(GlobleInfo.gray);
                } else {
                    PanelComposite.this.textCustomDemoName.setForeground(GlobleInfo.black);
                }
                PanelComposite.this.customAddStr = PanelComposite.this.textCustomDemoName.getText();
            }
        });
        this.textCustomDemoName.addFocusListener(new FocusListener(){

            public void focusLost(FocusEvent e) {
                String text = PanelComposite.this.textCustomDemoName.getText();
                if (text.isEmpty() || text.equalsIgnoreCase("")) {
                    PanelComposite.this.textCustomDemoName.setText(Messages.PanelComposite_CustomName);
                    PanelComposite.this.textCustomDemoName.setForeground(GlobleInfo.gray);
                    PanelComposite.this.textCustomDemoName.update();
                }
            }

            public void focusGained(FocusEvent e) {
                String text = PanelComposite.this.textCustomDemoName.getText();
                if (text.equalsIgnoreCase(Messages.PanelComposite_CustomName)) {
                    PanelComposite.this.textCustomDemoName.setText("");
                    PanelComposite.this.textCustomDemoName.update();
                }
            }
        });
        Label labVersion = new Label(customNameComposite, 0);
        labVersion.setText(Messages.PanelComposite_Tabel_Version);
        GridData labVersionGD = new GridData(1, 1, false, false);
        labVersion.setLayoutData((Object)labVersionGD);
        labVersion.setBackground(GlobleInfo.white);
        this.labDemoVersion = new Label(customNameComposite, 0);
        GridData labDemoVersionGD = new GridData(1, 1, false, false);
        this.labDemoVersion.setText("");
        this.labDemoVersion.setLayoutData((Object)labDemoVersionGD);
        this.labDemoVersion.setBackground(GlobleInfo.white);
        this.tabComposite = new Composite(composite, 0);
        GridData tabCompositeGD = new GridData(1808);
        this.tabComposite.setLayoutData((Object)tabCompositeGD);
        this.tabComposite.setLayout((Layout)new GridLayout(1, false));
        this.tabComposite.setBackground(GlobleInfo.white);
        this.tabFolder = new TabFolder(this.tabComposite, 0);
        GridData layoutData = new GridData(1808);
        this.tabFolder.setLayoutData((Object)layoutData);
        this.tabFolder.setLayout((Layout)new GridLayout(1, false));
        this.baseScrolledComposite = new ScrolledComposite((Composite)this.tabFolder, 2816);
        this.baseScrolledComposite.setLayoutData((Object)new GridData(4, 4, true, true));
        this.baseScrolledComposite.setBackground(GlobleInfo.white);
        this.baseScrolledComposite.setExpandHorizontal(true);
        this.baseScrolledComposite.setExpandVertical(true);
        this.baseScrolledComposite.setMinWidth(980);
        this.baseScrolledComposite.setMinHeight(380);
        this.baseScrolledComposite.setLayout((Layout)new GridLayout(1, true));
        this.baseSettingItem = new TabItem(this.tabFolder, 0);
        this.baseSettingItem.setText(Messages.PanelComposite_BaseSetting);
        this.baseSettingItem.setControl((Control)this.baseScrolledComposite);
        this.baseComposite = new Composite((Composite)this.baseScrolledComposite, 0);
        this.baseComposite.setLayout((Layout)new FillLayout());
        this.baseComposite.setBackground(GlobleInfo.white);
        this.baseScrolledComposite.setContent((Control)this.baseComposite);
        this.baseSettingComposite = new BaseSettingComposite(this.baseComposite, this.setting, this.selectDemoName, this);
        this.baseSettingComposite.setLayout((Layout)new FillLayout());
        this.baseSettingComposite.setBackground(GlobleInfo.white);
        this.pinDemuxItem = new TabItem(this.tabFolder, 0);
        this.pinDemuxItem.setText(Messages.PanelComposite_PinReuseSetting);
        this.pinDemuxScrolledCom = new ScrolledComposite((Composite)this.tabFolder, 768);
        this.pinDemuxScrolledCom.setLayoutData((Object)new GridData(4, 4, true, true));
        this.pinDemuxScrolledCom.setBackground(GlobleInfo.white);
        this.pinDemuxScrolledCom.setExpandHorizontal(true);
        this.pinDemuxScrolledCom.setExpandVertical(true);
        this.pinDemuxScrolledCom.setMinWidth(980);
        this.pinDemuxScrolledCom.setMinHeight(380);
        this.pinDemuxScrolledCom.setLayout((Layout)new GridLayout(1, false));
        this.pinDemuxItem.setControl((Control)this.pinDemuxScrolledCom);
        this.pinComposite = new Composite((Composite)this.pinDemuxScrolledCom, 0);
        this.pinComposite.setLayoutData((Object)new FillLayout());
        this.pinComposite.setLayout((Layout)new GridLayout(1, false));
        this.pinComposite.setBackground(GlobleInfo.white);
        this.pinDemuxScrolledCom.setContent((Control)this.pinComposite);
        this.pinDemuxComposite = new PinDemuxComposite(this.pinComposite, this.setting, this.labCustomDemoName);
        this.pinDemuxComposite.setLayout((Layout)new GridLayout(1, false));
        this.pinDemuxComposite.setLayoutData(new GridData(1808));
        ExcelData excelData = ExcelDataHelper.getExcelData();
        if (excelData != null && !RegbinView.isHi3716V550Series() && ExcelDataHelper.isV120RegFomatVersion(excelData) && ExcelDataHelper.getExcelData().getExcelMainData() != null && ExcelDataHelper.getExcelData().getExcelMainData().getMultiperTableList() != null) {
            this.setMultiperTableComposite(new MultiperTableComposite(composite, 0, ExcelDataHelper.getExcelData().getExcelMainData().getMultiperTableList(), this));
            this.multiperTableComposite.setLayoutData(new GridData(4, 4, true, true));
            this.multiperTableComposite.setBackground(GlobleInfo.white);
        }
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)composite, "com.hisilicon.hiregbin.hiregbin_context");
        return composite;
    }

    protected void importRefreshBtnState() {
        if (this.baseSettingComposite.getBtnNoCA() != null && !this.baseSettingComposite.isDisposed() && this.baseSettingComposite.getBtnNoCA().getSelection()) {
            PanelComposite.setBtnReplaceFastbootEnable(true);
            PanelComposite.setBtnMakeRegBinEnable(true);
            PanelComposite.setBtnMakeCfgBinEnable(false);
            PanelComposite.setBtnExportExcelEnable(true);
        }
        if (this.baseSettingComposite.getBtnCA() != null && !this.baseSettingComposite.isDisposed() && this.baseSettingComposite.getBtnCA().getSelection()) {
            PanelComposite.setBtnReplaceFastbootEnable(false);
            PanelComposite.setBtnMakeRegBinEnable(true);
            PanelComposite.setBtnMakeCfgBinEnable(true);
            PanelComposite.setBtnExportExcelEnable(true);
        }
    }

    private String handleTableNameHi3751V550(DemoBaseParam demoBaseParam, StringBuilder result, String demoName) {
        String ddrCapacity = demoBaseParam.getDdrCapacity();
        List<String> capacityTitleList = this.getCapacityTitleList(ddrCapacity);
        String ddrPCBLayers = demoBaseParam.getDdrPCBLayers();
        Map<String, String> dynamicParamMap = demoBaseParam.getDynamicParamMap();
        String cpuFreq = dynamicParamMap.get(CELL_KEY_DEMOCONFIG_CPUFREQ);
        String startup = demoBaseParam.getStartup();
        String ddrType = demoBaseParam.getDdrType();
        if (capacityTitleList.size() > 0) {
            result.append(demoName).append("_").append(ddrPCBLayers).append("_").append("cpu").append(cpuFreq).append("_").append(ddrType.replace("-", "_")).append("_").append(capacityTitleList.get(1)).append("_").append(capacityTitleList.get(0)).append("_").append(startup);
        }
        return result.toString();
    }

    private String handleTableName(ParsedMainData parsedMainData, String demoName) {
        StringBuilder result = new StringBuilder();
        if (parsedMainData == null) {
            return null;
        }
        ArrayList<DemoBaseParam> chipBaseParamList = parsedMainData.getDemoList();
        for (DemoBaseParam demoBaseParam : chipBaseParamList) {
            if (!demoName.equalsIgnoreCase(demoBaseParam.getDemoName())) continue;
            String chipName = demoBaseParam.getChipName();
            if (chipName.isEmpty()) {
                chipName = demoName.substring(0, 7);
            }
            if (RegbinView.isHi3716V550Series()) {
                return this.handleTableNameHi3751V550(demoBaseParam, result, demoName);
            }
            String ddrBuswidth = demoBaseParam.getDdrBuswidth();
            String ddrPCBLayers = demoBaseParam.getDdrPCBLayers();
            String demoType = demoBaseParam.getDemoType();
            String ddrCapacity = demoBaseParam.getDdrCapacity();
            String startup = demoBaseParam.getStartup();
            result.append(demoName).append("_");
            result.append(chipName).append("_");
            result.append(demoType).append("_");
            if (ExcelDataHelper.isV135XlsFomatVersion(ExcelDataHelper.getExcelData())) {
                String curDdrPhy = demoBaseParam.getDdrPhy();
                Map<String, String> map = demoBaseParam.getDynamicParamMap();
                for (Map.Entry<String, String> entity : map.entrySet()) {
                    String phyChannel;
                    String keyChannel;
                    String key = entity.getKey();
                    if (key.indexOf("_") == -1 || curDdrPhy.indexOf("_") == -1 || !(keyChannel = key.substring(key.indexOf("_") + "_".length())).equalsIgnoreCase(phyChannel = curDdrPhy.substring(curDdrPhy.indexOf("_") + "_".length()))) continue;
                    String curDdrCapacity = entity.getValue();
                    String curDdrCapacityInfo = String.valueOf(phyChannel) + curDdrCapacity;
                    result.append(curDdrCapacityInfo).append("_");
                    break;
                }
            } else {
                result.append(ddrCapacity).append("_");
            }
            result.append(ddrBuswidth).append("_");
            result.append(ddrPCBLayers);
            if (RegbinView.getCurrentChip().equalsIgnoreCase("Hi3716MV410") || RegbinView.getCurrentChip().equalsIgnoreCase("Hi3716MV420") || RegbinView.getCurrentChip().equalsIgnoreCase("Hi3716MV330")) {
                result.append("_");
                result.append(startup);
            }
            return result.toString();
        }
        return result.toString();
    }

    @Override
    protected BatchParameter initUi() {
        ParsedMainData parsedMainData = ExcelDataHelper.getDemoParsedMainData();
        String[] demoNames = this.initDemoName(parsedMainData);
        if (demoNames == null || demoNames.length == 0) {
            return null;
        }
        this.setCurrentDemo(demoNames[0]);
        Combo startup = this.pinDemuxComposite.getComboStartup();
        if (startup == null || startup.getItemCount() == 0) {
            return null;
        }
        Combo ddrCapacity = this.baseSettingComposite.getDDRCapacityCombo();
        if (ddrCapacity == null || ddrCapacity.getItemCount() == 0) {
            return null;
        }
        BatchParameter batchParameter = new BatchParameter();
        batchParameter.setDemoName(demoNames);
        batchParameter.setStarupItemCount(startup.getItemCount());
        batchParameter.setDdrCapacityItemCount(ddrCapacity.getItemCount());
        return batchParameter;
    }

    @Override
    protected void setCurrentDemo(String demoName) {
        ParsedMainData parsedMainData = ExcelDataHelper.getDemoParsedMainData();
        this.selectDemoName = this.handleTableName(parsedMainData, demoName);
        this.labCustomDemoName.setText(this.selectDemoName);
        this.baseSettingComposite.refreshDemoInfoToUI(this.baseComposite, parsedMainData, demoName, PinDemuxType.Demo, true);
        this.pinDemuxComposite.refreshDemoInfoToUI(demoName, null, null, PinDemuxType.Demo, null);
    }

    @Override
    protected void setParam(int ddrCapacityItemIndex, int starupItemIndex) {
        Combo ddrCapacity = this.baseSettingComposite.getDDRCapacityCombo();
        if (ddrCapacity == null) {
            return;
        }
        ddrCapacity.select(ddrCapacityItemIndex);
        this.updateCustomNameForDdrCapacity();
        Combo startup = this.pinDemuxComposite.getComboStartup();
        startup.select(starupItemIndex);
        String selectName = startup.getText();
        if (selectName != null) {
            this.pinDemuxComposite.updateLblCustomDemoName(this.labCustomDemoName, selectName);
        }
    }

    @Override
    protected Object getParam(BaseParam baseParam, String regOrCfg) {
        String tableVersion;
        String labCustomDemoNameValue = this.labCustomDemoName.getText().trim();
        labCustomDemoNameValue = labCustomDemoNameValue.substring(labCustomDemoNameValue.indexOf(":") + ":".length());
        String text = this.textCustomDemoName.getText();
        if (text != null && !text.isEmpty()) {
            this.customDemoName = !text.equalsIgnoreCase(Messages.PanelComposite_CustomName) ? String.valueOf(labCustomDemoNameValue) + this.textCustomDemoName.getText() : labCustomDemoNameValue;
        } else {
            if (labCustomDemoNameValue.endsWith("_")) {
                labCustomDemoNameValue = labCustomDemoNameValue.substring(0, labCustomDemoNameValue.lastIndexOf("_"));
            }
            this.customDemoName = labCustomDemoNameValue.trim();
        }
        if (!this.customDemoName.isEmpty()) {
            if (this.customDemoName.endsWith("_")) {
                this.customDemoName = this.customDemoName.substring(0, this.customDemoName.lastIndexOf("_"));
            }
            if (!this.customDemoName.endsWith(regOrCfg)) {
                this.customDemoName = this.customDemoName.concat(regOrCfg);
            } else if (this.customDemoName.substring(0, this.customDemoName.lastIndexOf(regOrCfg)).endsWith("_")) {
                this.customDemoName = this.customDemoName.substring(0, this.customDemoName.lastIndexOf("_")).concat(regOrCfg);
            }
        }
        if ((tableVersion = this.labDemoVersion.getText()).equals(Messages.PanelComposite_Cfg_NoVersion) && regOrCfg.equalsIgnoreCase(".reg")) {
            tableVersion = ExcelDataHelper.getExcelData().getExcelMainData().getXlsVersion();
        }
        if (this.pinDemuxComposite != null && !this.pinDemuxComposite.isDisposed() && this.pinDemuxComposite.getComboStartup() != null && !this.pinDemuxComposite.getComboStartup().isDisposed()) {
            String startup = this.pinDemuxComposite.getComboStartup().getText();
            baseParam.setSelectStartup(startup);
        }
        baseParam.setCustomDemoName(this.customDemoName);
        if (this.pinDemuxComposite != null) {
            baseParam.setPinDemuxInfo(this.getPinDemuxParam());
        }
        baseParam.setTableVersion(tableVersion);
        return this.baseSettingComposite.getParam(baseParam, regOrCfg);
    }

    @Override
    protected boolean checkInfo(Object objParam) {
        return true;
    }

    @Override
    protected boolean checkAllValidValue() {
        String customDemoName;
        if (!(this.textCustomDemoName == null || this.textCustomDemoName.isDisposed() || (customDemoName = this.textCustomDemoName.getText()) == null || customDemoName.equalsIgnoreCase(Messages.PanelComposite_CustomName) || customDemoName.isEmpty())) {
            Pattern pattern = Pattern.compile("[\u4e00-\u9fa5]");
            Matcher matcher = pattern.matcher(customDemoName);
            if (matcher.find()) {
                MessageDialog.openWarning((Shell)this.getShell(), (String)Messages.Message_Warning, (String)Messages.CustomDemoNameIsInvalid);
                return false;
            }
            if (!EnglishAndNumberPattern.matcher(customDemoName).matches()) {
                MessageDialog.openWarning((Shell)this.getShell(), (String)Messages.Message_Warning, (String)Messages.CustomDemoNameIsInvalid);
                return false;
            }
        }
        boolean bool = true;
        bool = this.baseSettingComposite.checkAllValidValue();
        if (!bool) {
            return false;
        }
        bool = this.pinDemuxComposite.checkAllValidValue();
        if (!bool) {
            return false;
        }
        return bool;
    }

    public String getSelectDemoName() {
        return this.selectDemoName;
    }

    public void setSelectDemoName(String selectDemoName) {
        this.selectDemoName = selectDemoName;
    }

    protected void openRegBinFromFastboot() {
        FileDialog fd = new FileDialog(this.getShell());
        fd.setFilterExtensions(new String[]{"*.bin", "*.*"});
        String filePath = fd.open();
        if (filePath == null) {
            return;
        }
        File file = new File(filePath);
        if (file != null && !file.exists()) {
            MessageDialog.openError((Shell)this.getShell(), (String)Messages.Message_Error, (String)Messages.MultiperTableComposite_import_reg_file_is_not_exist);
            return;
        }
        if (ExcelDataHelper.isV120RegFomatVersion(ExcelDataHelper.getExcelData())) {
            List<MultiperTable> multiperTableList;
            if (!this.getBinDataFromBoot(filePath)) {
                return;
            }
            this.lastInputBoot = filePath;
            if (this.multiperTableComposite != null && (multiperTableList = this.multiperTableComposite.getMultiperTableList()) != null && !multiperTableList.isEmpty()) {
                MultiperTable defaultMultiperTable = multiperTableList.get(0);
                BinData binData = null;
                binData = defaultMultiperTable.isSupport() ? defaultMultiperTable.getBinData() : multiperTableList.get(1).getBinData();
                if (binData != null) {
                    ExcelData excelData = ExcelDataHelper.getExcelDataforImport();
                    if (excelData == null) {
                        MessageDialog.openError((Shell)this.getShell(), (String)"Error", (String)"Please open an Excel data file first.");
                        return;
                    }
                    ParsedMainData pmd = ExcelDataHelper.toParsedMainDataNew(excelData);
                    if (!excelData.importBinData(excelData, binData, pmd, true)) {
                        BaseRegisterInfo reg = excelData.getErrorRegister();
                        if (reg == null) {
                            MessageDialog.openError((Shell)this.getShell(), (String)"Error", (String)Messages.ImportFileFormatError);
                            return;
                        }
                        if (reg.getRegReadOrWrite() == RegBinAction.NONE) {
                            this.baseSettingComposite.refreshDemoInfoToUI(this.baseComposite, pmd, ExcelDataHelper.extractDeviceName(binData.getHeadData().getBinName()), PinDemuxType.ImportBin, true);
                            this.pinDemuxComposite.refreshDemoInfoToUI(ExcelDataHelper.extractDeviceName(binData.getHeadData().getBinName()), binData, binData.getHeadData().getBinName(), PinDemuxType.ImportBin, null);
                            this.multiperTableComposite.redraw();
                        }
                        String errorStr = excelData.getErrorCode() == 1 ? String.valueOf(IMPORT_BIN_ERROR[0]) + reg.getRegName() : String.valueOf(IMPORT_BIN_ERROR[0]) + excelData.getErrorValue() + "(" + reg.getRegName() + ")";
                        MessageDialog.openWarning((Shell)this.getShell(), (String)"Error", (String)errorStr);
                    }
                    ExcelDataHelper.setParsedMainData(pmd);
                    this.baseSettingComposite.refreshDemoInfoToUI(this.baseComposite, pmd, ExcelDataHelper.extractDeviceName(binData.getHeadData().getBinName()), PinDemuxType.ImportBin, true);
                    this.pinDemuxComposite.refreshDemoInfoToUI(ExcelDataHelper.extractDeviceName(binData.getHeadData().getBinName()), binData, binData.getHeadData().getBinName(), PinDemuxType.ImportBin, null);
                    this.multiperTableComposite.setLastSelection((IStructuredSelection)this.multiperTableComposite.getViewer().getSelection());
                }
            }
        } else {
            File fastbootRegBin = this.readFastbootRegBin(filePath, 64, 8192);
            if (fastbootRegBin == null) {
                MessageDialog.openError((Shell)this.getShell(), (String)"Error", (String)("The input file '" + filePath + "' is invalid."));
                return;
            }
            RegBinData binData = new RegBinData();
            String fastbootRegBinPath = fastbootRegBin.getPath();
            if (!binData.fromFile(fastbootRegBinPath)) {
                if (fastbootRegBin.exists()) {
                    FileUtils.deleteFile(fastbootRegBin);
                }
                MessageDialog.openError((Shell)this.getShell(), (String)"Error", (String)("The input file '" + filePath + "' is invalid."));
                return;
            }
            ExcelData excelData = ExcelDataHelper.getExcelDataforImport();
            if (excelData == null) {
                MessageDialog.openError((Shell)this.getShell(), (String)"Error", (String)"Please open an Excel data file first.");
                return;
            }
            ParsedMainData pmd = ExcelDataHelper.toParsedMainDataNew(excelData);
            if (!excelData.importRegBin(excelData, pmd, binData, true)) {
                BaseRegisterInfo reg = excelData.getErrorRegister();
                if (reg == null) {
                    return;
                }
                if (reg.getRegReadOrWrite() == RegBinAction.NONE) {
                    this.baseSettingComposite.refreshDemoInfoToUI(this.baseComposite, pmd, ExcelDataHelper.extractDeviceName(binData.getmName()), PinDemuxType.ImportBin, true);
                    this.pinDemuxComposite.refreshDemoInfoToUI(ExcelDataHelper.extractDeviceName(binData.getmName()), binData, binData.getmName(), PinDemuxType.ImportBin, null);
                    if (fastbootRegBin.exists()) {
                        FileUtils.deleteFile(fastbootRegBin);
                    }
                }
                String errorStr = excelData.getErrorCode() == 1 ? String.valueOf(IMPORT_BIN_ERROR[0]) + reg.getRegName() : String.valueOf(IMPORT_BIN_ERROR[0]) + excelData.getErrorValue() + "(" + reg.getRegName() + ")";
                MessageDialog.openWarning((Shell)this.getShell(), (String)"Error", (String)errorStr);
            }
            ExcelDataHelper.setParsedMainData(pmd);
            this.baseSettingComposite.refreshDemoInfoToUI(this.baseComposite, pmd, ExcelDataHelper.extractDeviceName(binData.getmName()), PinDemuxType.ImportBin, true);
            this.pinDemuxComposite.refreshDemoInfoToUI(ExcelDataHelper.extractDeviceName(binData.getmName()), binData, binData.getmName(), PinDemuxType.ImportBin, null);
            if (fastbootRegBin.exists()) {
                FileUtils.deleteFile(fastbootRegBin);
            }
        }
    }

    private int getHi3798MV300TableStartAddr(byte[] inputBootBuffer) {
        if (inputBootBuffer == null) {
            return 0;
        }
        int multipleTableStartAddr = 12288;
        byte[] auxareaBytes = BytesUtils.genSubBytes(inputBootBuffer, 532, 4);
        int auxareaLen = BytesArrayUtils.getInt(auxareaBytes, 0, ByteOrder.LITTLE_ENDIAN);
        byte[] ascareaBytes = BytesUtils.genSubBytes(inputBootBuffer, 536, 4);
        int ascarealen = BytesArrayUtils.getInt(ascareaBytes, 0, ByteOrder.LITTLE_ENDIAN);
        byte[] areaBytes = BytesUtils.genSubBytes(inputBootBuffer, 1032, 4);
        int areaLen = BytesArrayUtils.getInt(areaBytes, 0, ByteOrder.LITTLE_ENDIAN);
        return multipleTableStartAddr + auxareaLen + ascarealen + areaLen;
    }

    private boolean getBinDataFromBoot(String filePath) {
        TableViewer itemViewer;
        byte[] securityFlagBytes;
        int securityValue;
        byte[] inputBootBuffer = FileUtils.readAllBytes(filePath);
        if (inputBootBuffer == null) {
            return false;
        }
        int multiformAddrFlag = 12256;
        int formLenFlag = 12264;
        int formAddrFlag = 12260;
        int defaultFormFlag = 1152;
        int securityFlag = 1036;
        int headAreaLength = 12288;
        int auxAreaFlag = 536;
        int bootAreaFlag = 1032;
        int securityMulitFlag = -2088414648;
        int securityFormLenFlag = 1040;
        int formAddr = 0;
        int hlsLen = 0;
        if (RegbinView.isHi3796CV300Series()) {
            multiformAddrFlag = 67632;
            formAddrFlag = 67636;
            formLenFlag = 67636;
            defaultFormFlag = 67776;
        } else if (RegbinView.isHi3798MV310Series()) {
            multiformAddrFlag = 1064;
            formLenFlag = 10752;
            defaultFormFlag = 1200;
        } else if (RegbinView.isHi3716MV430Series()) {
            byte[] keyRightsFlagBytes = BytesUtils.genSubBytes(inputBootBuffer, 528, 4);
            int keyRightsValue = BytesArrayUtils.getInt(keyRightsFlagBytes, 0, ByteOrder.LITTLE_ENDIAN);
            if (keyRightsValue != 1014535725) {
                hlsLen = 65536;
            }
            formLenFlag = 10752;
            defaultFormFlag = 1200 + hlsLen;
            multiformAddrFlag = 1064 + hlsLen;
        } else if (RegbinView.isHi3796MV200Series()) {
            multiformAddrFlag += 65536;
            formLenFlag += 65536;
            formAddrFlag += 65536;
            defaultFormFlag = 66736;
        }
        boolean securityMulit = false;
        if (RegbinView.isHi3798MV200Series() && (securityValue = BytesArrayUtils.getInt(securityFlagBytes = BytesUtils.genSubBytes(inputBootBuffer, securityFlag, 4), 0, ByteOrder.LITTLE_ENDIAN)) == securityMulitFlag) {
            formLenFlag = securityFormLenFlag;
            securityMulit = true;
        }
        if (inputBootBuffer.length <= 0 || inputBootBuffer.length < multiformAddrFlag) {
            MessageDialog.openError((Shell)this.getShell(), (String)Messages.Message_Error, (String)NLS.bind((String)Messages.ImportFileFormatError, (Object)filePath));
            return false;
        }
        byte[] multiFormFlagBytes = BytesUtils.genSubBytes(inputBootBuffer, multiformAddrFlag, 4);
        int multiFormFlag = BytesArrayUtils.getInt(multiFormFlagBytes, 0, ByteOrder.LITTLE_ENDIAN);
        boolean isSupportMutiForm = false;
        int multiFormFlagValue = 0;
        if (RegbinView.isHi3796CV300Series()) {
            multiFormFlagValue = 1014535905;
            if (multiFormFlag == multiFormFlagValue) {
                isSupportMutiForm = true;
            }
        } else if (RegbinView.isHi3798MV310Series() || RegbinView.isHi3716MV430Series()) {
            multiFormFlagValue = -2088414648;
            if (multiFormFlag == multiFormFlagValue) {
                isSupportMutiForm = true;
            }
        } else if (multiFormFlag != multiFormFlagValue) {
            isSupportMutiForm = true;
        }
        byte[] defaultFormData = null;
        int singleFormLen = 0;
        boolean writeSingleFormLen_96CV300 = false;
        if (RegbinView.isHi3798MV310Series() || RegbinView.isHi3716MV430Series()) {
            defaultFormData = BytesUtils.genSubBytes(inputBootBuffer, defaultFormFlag, formLenFlag);
        } else {
            int headData = 0;
            if (RegbinView.isHi3796CV300Series()) {
                headData = 16;
            }
            byte[] singleFormLenBytes = BytesUtils.genSubBytes(inputBootBuffer, formLenFlag, 4);
            singleFormLen = BytesArrayUtils.getInt(singleFormLenBytes, 0, ByteOrder.LITTLE_ENDIAN) - headData;
            File file = new File(filePath);
            long fileLen = file.length();
            if (singleFormLen <= 0 || (long)singleFormLen > fileLen) {
                MessageDialog.openError((Shell)this.getShell(), (String)Messages.Message_Error, (String)NLS.bind((String)Messages.GetBootFormLength_Failed, (Object)file.getName()));
                return false;
            }
            byte[] formAddrBytes = BytesUtils.genSubBytes(inputBootBuffer, formAddrFlag, 4);
            if (securityMulit) {
                byte[] auxAreaLenBytes = BytesUtils.genSubBytes(inputBootBuffer, auxAreaFlag, 4);
                int auxAreaLength = BytesArrayUtils.getInt(auxAreaLenBytes, 0, ByteOrder.LITTLE_ENDIAN);
                byte[] bootAreaLenBytes = BytesUtils.genSubBytes(inputBootBuffer, bootAreaFlag, 4);
                int bootAreaLength = BytesArrayUtils.getInt(bootAreaLenBytes, 0, ByteOrder.LITTLE_ENDIAN);
                formAddr = headAreaLength + auxAreaLength + bootAreaLength;
            } else {
                formAddr = BytesArrayUtils.getInt(formAddrBytes, 0, ByteOrder.LITTLE_ENDIAN);
            }
            if (formAddr <= 0 || (long)formAddr > fileLen && !RegbinView.isHi3796CV300Series()) {
                MessageDialog.openError((Shell)this.getShell(), (String)Messages.Message_Error, (String)NLS.bind((String)Messages.GetBootFormStartAddr_Failed, (Object)file.getName()));
                return false;
            }
            defaultFormData = BytesUtils.genSubBytes(inputBootBuffer, defaultFormFlag, singleFormLen);
        }
        ArrayList<MultiperTable> multiperTableList = ExcelDataHelper.getExcelData().getExcelMainData().getMultiperTableList();
        if (multiperTableList == null || multiperTableList.isEmpty()) {
            MessageDialog.openError((Shell)this.getShell(), (String)Messages.Message_Error, (String)Messages.PanelComposite_Not_Found_Multiper_In_MainTemp);
            return false;
        }
        BinData defaultBinData = new BinData();
        boolean result = true;
        try {
            int pointer = 0;
            result = defaultBinData.fromFile(defaultFormData, pointer);
        }
        catch (Exception e) {
            result = false;
        }
        if (!result) {
            MessageDialog.openError((Shell)this.getShell(), (String)Messages.Message_Error, (String)Messages.ImportDateFileFormatError);
            return false;
        }
        MultiperTable defaultMultiperTable = multiperTableList.get(0);
        defaultMultiperTable.setBinData(defaultBinData);
        defaultMultiperTable.setTableName(defaultBinData.getHeadData().getBinName());
        defaultMultiperTable.setTableFile(null);
        if (isSupportMutiForm) {
            defaultMultiperTable.setSupport(false);
        } else {
            defaultMultiperTable.setSupport(true);
        }
        if (isSupportMutiForm) {
            byte[] mTableLengthBytes;
            if (RegbinView.isHi3798MV310Series()) {
                formAddr = this.getHi3798MV300TableStartAddr(inputBootBuffer);
                mTableLengthBytes = BytesUtils.genSubBytes(inputBootBuffer, 1068, 4);
                singleFormLen = BytesArrayUtils.getInt(mTableLengthBytes, 0, ByteOrder.LITTLE_ENDIAN);
            } else if (RegbinView.isHi3716MV430Series()) {
                formAddr = this.getHi3716MV430TableStartAddr(inputBootBuffer);
                byte[] formLenByte = BytesUtils.genSubBytes(inputBootBuffer, 1068 + hlsLen, 4);
                singleFormLen = BytesArrayUtils.getInt(formLenByte, 0, ByteOrder.LITTLE_ENDIAN);
            } else if (RegbinView.isHi3796CV300Series()) {
                formAddr = this.getHi3796CV300TableStartAddr(inputBootBuffer);
                mTableLengthBytes = BytesUtils.genSubBytes(inputBootBuffer, 67636, 4);
                singleFormLen = BytesArrayUtils.getInt(mTableLengthBytes, 0, ByteOrder.LITTLE_ENDIAN) - 16;
            }
            int multiperFormStart = 0;
            int i = 0;
            while (i < 6) {
                multiperFormStart = RegbinView.isHi3796CV300Series() && i > 0 ? formAddr + i * singleFormLen + 16 * i : formAddr + i * singleFormLen;
                byte[] curMultiperFormData = BytesUtils.genSubBytes(inputBootBuffer, multiperFormStart, singleFormLen);
                MultiperTable multiperTable = multiperTableList.get(1 + i);
                if (isSupportMutiForm) {
                    multiperTable.setSupport(true);
                } else {
                    multiperTable.setSupport(false);
                }
                boolean isEmpty = true;
                int j = 0;
                while (j < curMultiperFormData.length) {
                    if (curMultiperFormData[0] != 0) {
                        isEmpty = false;
                    }
                    ++j;
                }
                if (isEmpty) {
                    multiperTable.setBinData(null);
                    multiperTable.setTableName("");
                    multiperTable.setTableFile(null);
                } else {
                    BinData binData = new BinData();
                    int pointer = 0;
                    result = binData.fromFile(curMultiperFormData, pointer);
                    if (!result) {
                        MessageDialog.openError((Shell)this.getShell(), (String)Messages.Message_Error, (String)Messages.ImportDateFileFormatError);
                        return false;
                    }
                    multiperTable.setBinData(binData);
                    multiperTable.setTableName(binData.getHeadData().getBinName());
                    multiperTable.setTableFile(null);
                }
                ++i;
            }
        }
        if (this.multiperTableComposite != null) {
            this.multiperTableComposite.setMultiperTableList(multiperTableList);
            itemViewer = this.multiperTableComposite.getItemViewer();
            itemViewer.setInput(multiperTableList);
            this.multiperTableComposite.updateBackground(itemViewer, multiperTableList);
            if (isSupportMutiForm) {
                itemViewer.getTable().select(1);
            } else {
                itemViewer.getTable().select(0);
            }
        } else {
            MessageDialog.openError((Shell)this.getShell(), (String)Messages.Message_Error, (String)Messages.MultiperTableComposite_Not_Exist);
            return false;
        }
        itemViewer.refresh();
        this.multiperTableComposite.getItemViewer().setInput(multiperTableList);
        this.multiperTableComposite.getItemViewer().refresh();
        return true;
    }

    protected void openRegBinFile() {
        Object binData;
        FileDialog fd = new FileDialog(this.getShell());
        fd.setFilterExtensions(new String[]{"*.reg", "*.*"});
        String filePath = fd.open();
        if (filePath == null) {
            return;
        }
        File file = new File(filePath);
        if (file != null && !file.exists()) {
            MessageDialog.openError((Shell)this.getShell(), (String)Messages.Message_HiRegBin, (String)Messages.ValidityCheck_Import_param_isNull);
            return;
        }
        if (RegbinView.isHi3716MV430Series()) {
            Combo comboDdrType = this.baseSettingComposite.getComboDdrType();
            if (comboDdrType.getSelectionIndex() == -1) {
                MessageDialog.openError((Shell)this.getShell(), (String)Messages.Message_HiRegBin, (String)Messages.Message_HAVATO_IMPORT_DEMO);
                return;
            }
            String[] names = filePath.split("_");
            String curDdrName = "";
            String[] stringArray = names;
            int n = names.length;
            int n2 = 0;
            while (n2 < n) {
                String name = stringArray[n2];
                if (name.toLowerCase().contains("ddr")) {
                    curDdrName = name;
                    break;
                }
                ++n2;
            }
            if (comboDdrType.getItemCount() > 0 && !comboDdrType.getText().equals(curDdrName)) {
                MessageDialog.openError((Shell)this.getShell(), (String)Messages.Message_HiRegBin, (String)Messages.Message_DDR_NOT_MATCH);
                return;
            }
        }
        if (ExcelDataHelper.isV120RegFomatVersion(ExcelDataHelper.getExcelData())) {
            binData = new BinData();
            boolean result = true;
            try {
                byte[] binDataBytes = FileUtils.readAllBytes(filePath);
                int pointer = 0;
                result = ((BinData)binData).fromFile(binDataBytes, pointer);
            }
            catch (Exception e2) {
                result = false;
            }
            if (!result) {
                MessageDialog.openError((Shell)this.getShell(), (String)Messages.Message_Error, (String)Messages.ImportDateFileFormatError);
                return;
            }
            ExcelData excelData = ExcelDataHelper.getExcelDataforImport();
            if (excelData == null) {
                MessageDialog.openError((Shell)this.getShell(), (String)"Error", (String)"Please open an Excel data file first.");
                return;
            }
            ParsedMainData pmd = ExcelDataHelper.toParsedMainDataNew(excelData);
            if (!excelData.importBinData(excelData, (BinData)binData, pmd, true)) {
                return;
            }
            boolean refreshDdr = true;
            if (RegbinView.isHi3716MV430Series()) {
                refreshDdr = false;
            }
            ExcelDataHelper.setParsedMainData(pmd);
            this.baseSettingComposite.refreshDemoInfoToUI(this.baseComposite, pmd, ExcelDataHelper.extractDeviceName(((BinData)binData).getHeadData().getBinName()), PinDemuxType.ImportBin, refreshDdr);
            this.pinDemuxComposite.refreshDemoInfoToUI(ExcelDataHelper.extractDeviceName(((BinData)binData).getHeadData().getBinName()), binData, ((BinData)binData).getHeadData().getBinName(), PinDemuxType.ImportBin, null);
        } else {
            binData = new RegBinData();
            if (!((RegBinData)binData).fromFile(filePath)) {
                MessageDialog.openError((Shell)this.getShell(), (String)"Error", (String)("The input file '" + filePath + "' is invalid."));
                return;
            }
            ExcelData excelData = ExcelDataHelper.getExcelDataforImport();
            if (excelData == null) {
                MessageDialog.openError((Shell)this.getShell(), (String)"Error", (String)"Please open an Excel data file first.");
                return;
            }
            ParsedMainData pmd = ExcelDataHelper.toParsedMainDataNew(excelData);
            if (!excelData.importRegBin(excelData, pmd, (RegBinData)binData, true)) {
                return;
            }
            ExcelDataHelper.setParsedMainData(pmd);
            this.baseSettingComposite.refreshDemoInfoToUI(this.baseComposite, pmd, ExcelDataHelper.extractDeviceName(((RegBinData)binData).getmName()), PinDemuxType.ImportBin, true);
            this.pinDemuxComposite.refreshDemoInfoToUI(ExcelDataHelper.extractDeviceName(((RegBinData)binData).getmName()), binData, ((RegBinData)binData).getmName(), PinDemuxType.ImportBin, null);
        }
        byte[] binDataBytes = FileUtils.readAllBytes(filePath);
        if ((RegbinView.isHi3796MV200Series() || RegbinView.isHi3716MV430Series()) && binDataBytes.length > 10752) {
            MessageDialog.openInformation((Shell)this.getShell(), (String)Messages.Message_HiRegBin, (String)NLS.bind((String)Messages.PanelComposite_Import_From_RegBin_Overlength, (Object)10752, (Object)binDataBytes.length));
        }
        if (RegbinView.isHi3796CV300Series() && binDataBytes.length > 10480) {
            MessageDialog.openInformation((Shell)this.getShell(), (String)Messages.Message_HiRegBin, (String)NLS.bind((String)Messages.PanelComposite_Import_From_RegBin_Overlength, (Object)10480, (Object)binDataBytes.length));
        }
    }

    protected void openCfgBinFile() {
        FileDialog fd = new FileDialog(this.getShell());
        fd.setFilterExtensions(new String[]{"*.cfg", "*.*"});
        String filePath = fd.open();
        if (filePath == null) {
            return;
        }
        CfgBinData binData = new CfgBinData();
        if (!binData.fromFile(filePath)) {
            MessageDialog.openError((Shell)this.getShell(), (String)"Error", (String)("The input file '" + filePath + "' is invalid."));
            return;
        }
        ExcelData excelData = ExcelDataHelper.getExcelDataforImport();
        if (excelData == null) {
            MessageDialog.openError((Shell)this.getShell(), (String)"Error", (String)"Please open an Excel data file first.");
            return;
        }
        ParsedMainData pmd = ExcelDataHelper.toParsedMainDataNew(excelData);
        if (!excelData.importCfgBin(excelData, binData, pmd, true)) {
            return;
        }
        ExcelDataHelper.setParsedMainData(pmd);
        this.baseSettingComposite.refreshDemoInfoToUI(this.baseComposite, pmd, ExcelDataHelper.extractDeviceName(binData.getmName()), PinDemuxType.ImportBin, true);
        this.pinDemuxComposite.refreshDemoInfoToUI(ExcelDataHelper.extractDeviceName(binData.getmName()), binData, binData.getmName(), PinDemuxType.ImportBin, null);
    }

    @Override
    protected PinDemuxInfo getPinDemuxParam() {
        return this.pinDemuxComposite.getPinDemuxParam();
    }

    private void refreshConfigurableParamByConfig(TextReader textReader) {
        ArrayList<Combo> comboDdrParamList = this.baseSettingComposite.getComboDdrParamList();
        for (Combo combo : comboDdrParamList) {
            String comboKey = (String)combo.getData();
            String[] items = combo.getItems();
            String value = textReader.getValue("DdrParamters", comboKey);
            int i = 0;
            while (i < items.length) {
                String comboValue = items[i];
                if (comboValue.equals(value)) {
                    combo.select(i);
                }
                ++i;
            }
        }
        this.updateCustomNameForDdrCapacity();
        this.updateCustomNameForDdrType();
        this.labCustomDemoName.update();
    }

    private void refreshMacByConfig(TextReader textReader) {
        ArrayList<Combo> comboMacList = this.baseSettingComposite.getComboMacList();
        for (Combo combo : comboMacList) {
            String comboKey = (String)combo.getData();
            String[] items = combo.getItems();
            String value = textReader.getValue("MacName", comboKey);
            int i = 0;
            while (i < items.length) {
                String comboValue = items[i];
                if (comboValue.equals(value)) {
                    combo.select(i);
                }
                ++i;
            }
        }
    }

    private void refreshPhyAddressByConfig(TextReader textReader) {
        ArrayList<Text> textPhyAddressList = this.baseSettingComposite.getTextPhyAddressList();
        int i = 0;
        while (i < textPhyAddressList.size()) {
            Combo macCombo;
            Text text = textPhyAddressList.get(i);
            String macKey = (String)text.getData();
            String value = textReader.getValue("PhyAddress", macKey);
            if (value != null && !value.isEmpty()) {
                if (value.equalsIgnoreCase("ff") || value.equalsIgnoreCase("0xff")) {
                    value = "NA";
                }
                text.setText(value);
            }
            if ((macCombo = this.baseSettingComposite.getComboMacList().get(i)) != null) {
                String macComboValue = macCombo.getText();
                if (macComboValue != null && macComboValue.equalsIgnoreCase("NA")) {
                    text.setEnabled(false);
                } else {
                    text.setEnabled(true);
                }
            }
            ++i;
        }
    }

    private void refreshGpioGroupNumByConfig(TextReader textReader) {
        ArrayList<Combo> comboGpioGroupNumList = this.baseSettingComposite.getComboGpioGroupNumList();
        int j = 0;
        while (j < comboGpioGroupNumList.size()) {
            Combo combo = comboGpioGroupNumList.get(j);
            String comboKey = (String)combo.getData();
            String[] items = combo.getItems();
            String value = textReader.getValue("GpioGroupNum", comboKey);
            int i = 0;
            while (i < items.length) {
                String comboValue = items[i];
                if (comboValue.equals(value)) {
                    combo.select(i);
                }
                ++i;
            }
            Combo macCombo = this.baseSettingComposite.getComboMacList().get(j);
            if (macCombo != null) {
                String macComboValue = macCombo.getText();
                if (macComboValue != null && (macComboValue.equalsIgnoreCase("NA") || macComboValue.equalsIgnoreCase("FE_PHY"))) {
                    combo.setEnabled(false);
                } else {
                    combo.setEnabled(true);
                }
            }
            ++j;
        }
    }

    private void refreshGpioBitsByConfig(TextReader textReader) {
        ArrayList<Combo> comboGpioBitsNumList = this.baseSettingComposite.getComboGpioBitsNumList();
        int j = 0;
        while (j < comboGpioBitsNumList.size()) {
            Combo combo = comboGpioBitsNumList.get(j);
            String comboKey = (String)combo.getData();
            String[] items = combo.getItems();
            String value = textReader.getValue("GpioBits", comboKey);
            int i = 0;
            while (i < items.length) {
                String comboValue = items[i];
                if (comboValue.equals(value)) {
                    combo.select(i);
                }
                ++i;
            }
            Combo macCombo = this.baseSettingComposite.getComboMacList().get(j);
            if (macCombo != null) {
                String macComboValue = macCombo.getText();
                if (macComboValue != null && (macComboValue.equalsIgnoreCase("NA") || macComboValue.equalsIgnoreCase("FE_PHY"))) {
                    combo.setEnabled(false);
                } else {
                    combo.setEnabled(true);
                }
            }
            ++j;
        }
    }

    private void refreshStartupByConfig(TextReader textReader) {
        Combo comboStartup = this.pinDemuxComposite.getComboStartup();
        String[] items = comboStartup.getItems();
        String value = textReader.getValue("Startup", "Startup");
        int i = 0;
        while (i < items.length) {
            String comboValue = items[i];
            if (comboValue.equals(value)) {
                comboStartup.select(i);
            }
            ++i;
        }
    }

    private void refreshDdrPhyByConfig(TextReader textReader) {
        Combo comboDdrPhy = this.baseSettingComposite.getComboDdrPhy();
        if (comboDdrPhy == null) {
            return;
        }
        String comboKey = (String)comboDdrPhy.getData();
        String[] items = comboDdrPhy.getItems();
        String value = textReader.getValue("DdrPhy", comboKey);
        int i = 0;
        while (i < items.length) {
            String comboValue = items[i];
            if (comboValue.equals(value)) {
                comboDdrPhy.select(i);
            }
            ++i;
        }
    }

    private void refreshPinMuxByConfig(TextReader textReader) {
        ExcelData excelData = this.pinDemuxComposite.getExcelData();
        if (excelData != null) {
            Combo comboStartup = this.pinDemuxComposite.getComboStartup();
            ParsedMainData parsedMainData = ExcelDataHelper.getParsedMainData();
            if (parsedMainData != null) {
                ArrayList<String> startupList = parsedMainData.getStartupList();
                String[] startups = comboStartup.getItems();
                this.pinDemuxComposite.setPinDemuxInfo(new PinDemuxInfo());
                PinDemuxInfo pinDemuxInfo = this.pinDemuxComposite.getPinDemuxInfo();
                Map<String, ArrayList<PinDemuxRegisterInfo>> pinDemuxForFlashMap = pinDemuxInfo.getPinDemuxForFlashMap();
                StarupInfo starupInfo = new StarupInfo();
                starupInfo.setStartupItem(startups);
                for (String customStartup : startupList) {
                    String genGpioID;
                    String value;
                    String pinMuxFunction;
                    String pinMuxRegName;
                    PinDemuxHead pinDemuxHead;
                    ArrayList<PinDemuxRegisterInfo> registerList;
                    starupInfo.setStarup(customStartup);
                    PinDemuxInfo processPinDemuxInfo = excelData.getPinDemuxInfoByStartup(this.selectDemoName, starupInfo, false, true, null);
                    Map<String, ArrayList<PinDemuxRegisterInfo>> originalPinDemuxForFlashMap = processPinDemuxInfo.getPinDemuxForFlashMap();
                    int startupIndex = 0;
                    while (startupIndex < startups.length) {
                        registerList = new ArrayList<PinDemuxRegisterInfo>();
                        String startup = startups[startupIndex];
                        if (originalPinDemuxForFlashMap.containsKey(startup)) {
                            ArrayList startupPinDemuxRegList = (ArrayList)originalPinDemuxForFlashMap.get(startup);
                            for (PinDemuxRegisterInfo pinDemuxRegisterInfo : startupPinDemuxRegList) {
                                PinDemuxHead pinDemuxHead2 = pinDemuxRegisterInfo.getPinDemuxHead();
                                pinDemuxRegisterInfo.setPinDemuxHead(pinDemuxHead2);
                                String pinMuxRegName2 = pinDemuxRegisterInfo.getPinMuxRegName();
                                String pinMuxFunction2 = pinDemuxRegisterInfo.getPinMuxFunction();
                                String value2 = textReader.getValue(startup, pinMuxRegName2);
                                if (!pinMuxFunction2.equalsIgnoreCase(value2)) continue;
                                registerList.add(pinDemuxRegisterInfo);
                                if (!pinMuxFunction2.toUpperCase().startsWith("GPIO")) continue;
                                String genGpioID2 = PinDemuxComposite.genGpioID(pinMuxFunction2, pinDemuxRegisterInfo.getPinDemuxHead().getPinMuxModuleName(), pinMuxRegName2);
                                this.updateGpioByConfig(textReader, genGpioID2, pinMuxFunction2);
                            }
                        }
                        pinDemuxForFlashMap.put(startup, registerList);
                        ++startupIndex;
                    }
                    if (originalPinDemuxForFlashMap.containsKey("pin_mux_drv_aon")) {
                        ArrayList pinDemuxRegList = (ArrayList)originalPinDemuxForFlashMap.get("pin_mux_drv_aon");
                        registerList = new ArrayList();
                        for (PinDemuxRegisterInfo pinDemuxRegisterInfo : pinDemuxRegList) {
                            pinDemuxHead = pinDemuxRegisterInfo.getPinDemuxHead();
                            pinDemuxRegisterInfo.setPinDemuxHead(pinDemuxHead);
                            pinMuxRegName = pinDemuxRegisterInfo.getPinMuxRegName();
                            pinMuxFunction = pinDemuxRegisterInfo.getPinMuxFunction();
                            value = textReader.getValue("pin_mux_drv_aon", pinMuxRegName);
                            if (pinMuxFunction.equalsIgnoreCase(value)) {
                                registerList.add(pinDemuxRegisterInfo);
                                if (pinMuxFunction.toUpperCase().startsWith("GPIO") || pinMuxFunction.toUpperCase().startsWith("AON")) {
                                    genGpioID = PinDemuxComposite.genGpioID(pinMuxFunction, pinDemuxRegisterInfo.getPinDemuxHead().getPinMuxModuleName(), pinMuxRegName);
                                    this.updateGpioByConfig(textReader, genGpioID, pinMuxFunction);
                                }
                            }
                            pinDemuxForFlashMap.put("pin_mux_drv_aon", registerList);
                        }
                    }
                    if (originalPinDemuxForFlashMap.containsKey("pin_mux_drv")) {
                        ArrayList pinDemuxRegList = (ArrayList)originalPinDemuxForFlashMap.get("pin_mux_drv");
                        registerList = new ArrayList();
                        for (PinDemuxRegisterInfo pinDemuxRegisterInfo : pinDemuxRegList) {
                            pinDemuxHead = pinDemuxRegisterInfo.getPinDemuxHead();
                            pinDemuxRegisterInfo.setPinDemuxHead(pinDemuxHead);
                            pinMuxRegName = pinDemuxRegisterInfo.getPinMuxRegName();
                            pinMuxFunction = pinDemuxRegisterInfo.getPinMuxFunction();
                            value = textReader.getValue("pin_mux_drv", pinMuxRegName);
                            if (pinMuxFunction.equalsIgnoreCase(value)) {
                                registerList.add(pinDemuxRegisterInfo);
                                if (pinMuxFunction.toUpperCase().startsWith("GPIO")) {
                                    genGpioID = PinDemuxComposite.genGpioID(pinMuxFunction, pinDemuxRegisterInfo.getPinDemuxHead().getPinMuxModuleName(), pinMuxRegName);
                                    this.updateGpioByConfig(textReader, genGpioID, pinMuxFunction);
                                }
                            }
                            pinDemuxForFlashMap.put("pin_mux_drv", registerList);
                        }
                    }
                    if (!originalPinDemuxForFlashMap.containsKey("fp_pin_mux_drv")) continue;
                    ArrayList fpPinDemuxRegList = (ArrayList)originalPinDemuxForFlashMap.get("fp_pin_mux_drv");
                    registerList = new ArrayList();
                    for (PinDemuxRegisterInfo pinDemuxRegisterInfo : fpPinDemuxRegList) {
                        pinDemuxHead = pinDemuxRegisterInfo.getPinDemuxHead();
                        pinDemuxRegisterInfo.setPinDemuxHead(pinDemuxHead);
                        pinMuxRegName = pinDemuxRegisterInfo.getPinMuxRegName();
                        pinMuxFunction = pinDemuxRegisterInfo.getPinMuxFunction();
                        value = textReader.getValue("fp_pin_mux_drv", pinMuxRegName);
                        if (pinMuxFunction.equalsIgnoreCase(value)) {
                            registerList.add(pinDemuxRegisterInfo);
                            if (pinMuxFunction.toUpperCase().startsWith("GPIO")) {
                                genGpioID = PinDemuxComposite.genGpioID(pinMuxFunction, pinDemuxRegisterInfo.getPinDemuxHead().getPinMuxModuleName(), pinMuxRegName);
                                this.updateGpioByConfig(textReader, genGpioID, pinMuxFunction);
                            }
                        }
                        pinDemuxForFlashMap.put("fp_pin_mux_drv", registerList);
                    }
                }
                Map<String, GpioData> gpioMap = pinDemuxInfo.getGpioMap();
                if (gpioMap.size() == 0) {
                    Map<String, GpioData> map = this.pinDemuxComposite.getMap();
                    for (Map.Entry<String, GpioData> entity : map.entrySet()) {
                        String key = entity.getKey();
                        GpioData value = entity.getValue();
                        pinDemuxInfo.setGpioMap(key, value);
                    }
                }
                excelData.copyPinDemuxReg(comboStartup.getText(), pinDemuxInfo, false, comboStartup.getItems());
                ArrayList<PinDemuxRegisterInfo> pinDemuxRegisterList = pinDemuxInfo.getPinDemuxRegisterList();
                pinDemuxInfo.setPinDemuxRegisterList(pinDemuxRegisterList);
                PinDemuxComposite.setPinDemuxRegisterInfos(pinDemuxInfo.getPinDemuxRegisterList());
                this.pinDemuxComposite.getRegisterTableViewer().setInput(PinDemuxComposite.getPinDemuxRegisterInfos());
                this.pinDemuxComposite.getRegisterTableViewer().refresh();
                ArrayList<String> selectGPIO = new ArrayList<String>();
                ArrayList<PinDemuxRegisterInfo> pinDemuxRegisterInfos = PinDemuxComposite.getPinDemuxRegisterInfos();
                int i = 0;
                while (i < pinDemuxRegisterInfos.size()) {
                    PinDemuxRegisterInfo pinDemuxRegisterInfo = pinDemuxRegisterInfos.get(i);
                    if (pinDemuxRegisterInfo != null && pinDemuxRegisterInfo.isGpio()) {
                        String gpioID = PinDemuxComposite.genGpioID(pinDemuxRegisterInfo.getPinMuxFunction(), pinDemuxRegisterInfo.getPinDemuxHead().getPinMuxModuleName(), pinDemuxRegisterInfo.getPinMuxRegName());
                        selectGPIO.add(gpioID);
                    }
                    ++i;
                }
                ArrayList<GpioData> gpioParams = new ArrayList<GpioData>();
                int j = 0;
                while (j < selectGPIO.size()) {
                    gpioParams.add(this.pinDemuxComposite.getMap().get(selectGPIO.get(j)));
                    ++j;
                }
                this.pinDemuxComposite.setGpioParams(gpioParams);
                this.pinDemuxComposite.getGpioTableViewer().setInput(this.pinDemuxComposite.getGpioParams());
                this.pinDemuxComposite.getGpioTableViewer().refresh();
                GlobleInfo.setNeedSave(false);
            }
        }
    }

    private void updateGpioByConfig(TextReader textReader, String genGpioID, String pinMuxFunction) {
        block6: {
            Map<String, GpioData> map;
            String gpioLevelConfig;
            block7: {
                Map<String, GpioData> map2;
                gpioLevelConfig = textReader.getValue("GPIO", genGpioID);
                if (gpioLevelConfig == null) {
                    gpioLevelConfig = "NA";
                }
                if (!gpioLevelConfig.equalsIgnoreCase("NA")) break block7;
                if (this.pinDemuxComposite == null || this.pinDemuxComposite.getMap() == null || (map2 = this.pinDemuxComposite.getMap()) == null) break block6;
                for (Map.Entry<String, GpioData> entity : map2.entrySet()) {
                    GpioData gpioData;
                    String key = entity.getKey();
                    if (!key.equalsIgnoreCase(genGpioID) || (gpioData = entity.getValue()) == null) continue;
                    gpioData.setGpioDirection(DriectionConfig.Input);
                    gpioData.setGpioLevel(LevelConfig.NA);
                    break block6;
                }
                break block6;
            }
            if (this.pinDemuxComposite != null && this.pinDemuxComposite.getMap() != null && (map = this.pinDemuxComposite.getMap()) != null) {
                for (Map.Entry<String, GpioData> entity : map.entrySet()) {
                    String key = entity.getKey();
                    if (!key.equalsIgnoreCase(genGpioID)) continue;
                    GpioData gpioData = entity.getValue();
                    gpioData.setGpioDirection(DriectionConfig.Output);
                    if (gpioLevelConfig.equalsIgnoreCase(LevelConfig.High.name())) {
                        gpioData.setGpioLevel(LevelConfig.High);
                    } else {
                        gpioData.setGpioLevel(LevelConfig.Low);
                    }
                    break;
                }
            }
        }
    }

    private String updateDdrNameAddFreq(String regBinName, ArrayList<DemoBaseParam> demoList, String ddrTypeName) {
        String importDemoName = regBinName.substring(0, regBinName.indexOf("_"));
        for (DemoBaseParam demoBaseParam : demoList) {
            String demoName = demoBaseParam.getDemoName();
            if (!demoName.equalsIgnoreCase(importDemoName)) continue;
            String ddrType = demoBaseParam.getDdrType();
            if (!HiToolUtils.equalsIgnoreCaseDDR(ddrTypeName)) continue;
            ddrTypeName = ddrType;
        }
        return ddrTypeName;
    }

    private void refreshDemoInfoByConfig(ParsedMainData parsedMainData, String configDemoName) {
        if (configDemoName != null && parsedMainData != null) {
            ArrayList<DemoBaseParam> chipBaseParamList = parsedMainData.getDemoList();
            int demoSize = chipBaseParamList.size();
            boolean isMatch = false;
            int i = 0;
            while (i < demoSize) {
                String curDemoName = chipBaseParamList.get(i).getDemoName();
                if (configDemoName.startsWith(curDemoName)) {
                    isMatch = true;
                    break;
                }
                ++i;
            }
            if (!isMatch) {
                MessageDialog.openInformation((Shell)this.getShell(), (String)Messages.Message_HiRegBin, (String)NLS.bind((String)Messages.PanelComposite_CurDemoNameNotMatchCustomer, (Object)configDemoName));
                return;
            }
            PanelComposite.setCurrentExcelData(ExcelDataHelper.getExcelData());
            configDemoName = this.updateDddForCapital(configDemoName);
            if (configDemoName.indexOf("mbyte") != -1) {
                configDemoName = configDemoName.replace("mbyte", "MB");
            }
            if (configDemoName.indexOf("gbyte") != -1) {
                configDemoName = configDemoName.replace("gbyte", "GB");
            }
            this.selectDemoName = configDemoName.substring(0, configDemoName.indexOf("_"));
            this.customDemoName = configDemoName;
            if (this.selectDemoName != null) {
                if (this.customDemoName.indexOf("layers") != -1) {
                    this.labCustomDemoName.setText(this.customDemoName.substring(0, this.customDemoName.indexOf("layers") + "layers".length()));
                    if (this.customDemoName.indexOf(".") != -1) {
                        this.customAddStr = this.customDemoName.substring(this.customDemoName.indexOf("layers") + "layers".length(), this.customDemoName.lastIndexOf("."));
                    }
                    this.textCustomDemoName.setText(this.customAddStr);
                } else {
                    String tableName;
                    this.customDemoName = tableName = this.handleTableName(parsedMainData, this.selectDemoName);
                    this.labCustomDemoName.setText(this.customDemoName);
                    this.customDemoName = this.customAddStr != null && !this.customAddStr.isEmpty() ? String.valueOf(tableName) + "_" + this.customAddStr : tableName;
                }
            }
            if (this.selectDemoName != null) {
                boolean refreshDdr = true;
                if (RegbinView.isHi3716MV430Series()) {
                    refreshDdr = false;
                }
                this.baseSettingComposite.refreshDemoInfoToUI(this.baseComposite, parsedMainData, this.selectDemoName, PinDemuxType.Demo, refreshDdr);
                this.pinDemuxComposite.refreshDemoInfoToUI(this.selectDemoName, null, null, PinDemuxType.Demo, null);
                this.importRefreshBtnState();
            }
        }
    }

    private String updateDddForCapital(String configDemoName) {
        DdrType.DDRTYPE[] values;
        DdrType.DDRTYPE[] dDRTYPEArray = values = DdrType.DDRTYPE.values();
        int n = values.length;
        int n2 = 0;
        while (n2 < n) {
            DdrType.DDRTYPE ddrType = dDRTYPEArray[n2];
            String lowerCaseName = ddrType.name().toLowerCase();
            if (configDemoName.indexOf(lowerCaseName) != -1) {
                return configDemoName.replace(lowerCaseName, ddrType.name());
            }
            ++n2;
        }
        return configDemoName;
    }

    public void updateCustomNameForDdrType() {
        Combo comboDdrType = this.baseSettingComposite.getComboDdrType();
        if (comboDdrType != null && !comboDdrType.isDisposed()) {
            String labCustomDemoNameValue = this.labCustomDemoName.getText();
            String lowerStr = labCustomDemoNameValue.toLowerCase();
            String[] items = comboDdrType.getItems();
            if (items.length <= 0) {
                return;
            }
            int selectionIndex = comboDdrType.getSelectionIndex();
            String selectDdrType = items[selectionIndex];
            String[] stringArray = items;
            int n = items.length;
            int n2 = 0;
            while (n2 < n) {
                String comboDdrTypeValue = stringArray[n2];
                if (comboDdrTypeValue.equals(selectDdrType)) {
                    if (lowerStr.contains(comboDdrTypeValue.toLowerCase())) {
                        labCustomDemoNameValue = labCustomDemoNameValue.replace(comboDdrTypeValue, selectDdrType);
                        break;
                    }
                    if (lowerStr.contains("ddrx")) {
                        labCustomDemoNameValue = labCustomDemoNameValue.replace("ddrx", selectDdrType);
                        break;
                    }
                }
                ++n2;
            }
            this.labCustomDemoName.setText(labCustomDemoNameValue);
            this.labCustomDemoName.update();
            this.setCustomDemoName(labCustomDemoNameValue);
        }
    }

    private List<String> getCapacityTitleList(String ddrCapacity) {
        ArrayList<String> capacityTitleList = new ArrayList<String>();
        if (ddrCapacity.equalsIgnoreCase("2GB")) {
            capacityTitleList.add(CAPACITYTITLE_TITLE_LIST[0]);
            capacityTitleList.add(CAPACITYTITLE_LIST[0]);
        } else if (ddrCapacity.equalsIgnoreCase("1.5GB")) {
            capacityTitleList.add(CAPACITYTITLE_TITLE_LIST[1]);
            capacityTitleList.add(CAPACITYTITLE_LIST[1]);
        } else if (ddrCapacity.equalsIgnoreCase("1GB")) {
            capacityTitleList.add(CAPACITYTITLE_TITLE_LIST[2]);
            capacityTitleList.add(CAPACITYTITLE_LIST[2]);
        } else if (ddrCapacity.equalsIgnoreCase("768M")) {
            capacityTitleList.add(CAPACITYTITLE_TITLE_LIST[3]);
            capacityTitleList.add(CAPACITYTITLE_LIST[3]);
        } else if (ddrCapacity.equalsIgnoreCase("512M")) {
            capacityTitleList.add(CAPACITYTITLE_TITLE_LIST[4]);
            capacityTitleList.add(CAPACITYTITLE_LIST[4]);
        }
        return capacityTitleList;
    }

    private String handleTitleDdrCapacity(String labCustomDemoNameValue, String lowerStr, String selectDdrCapacity, String[] items) {
        List<String> capacityTitleList = this.getCapacityTitleList(selectDdrCapacity);
        String[] stringArray = items;
        int n = items.length;
        int n2 = 0;
        while (n2 < n) {
            String capacity = stringArray[n2];
            List<String> oldCapacityTitleList = this.getCapacityTitleList(capacity);
            if (lowerStr.contains(oldCapacityTitleList.get(0).toLowerCase())) {
                labCustomDemoNameValue = labCustomDemoNameValue.replace(oldCapacityTitleList.get(0), capacityTitleList.get(0)).replace(oldCapacityTitleList.get(1), capacityTitleList.get(1));
                break;
            }
            ++n2;
        }
        return labCustomDemoNameValue;
    }

    public void updataPinDemuxComposite(String volDvdd) {
        this.pinDemuxComposite.refreshDemoInfoToUI(this.selectDemoName, null, null, PinDemuxType.Demo, volDvdd);
    }

    public void updateCustomNameForDdrCapacity() {
        String labCustomDemoNameValue = this.labCustomDemoName.getText();
        String lowerStr = labCustomDemoNameValue.toLowerCase();
        ArrayList<Combo> comboDdrParamList = this.baseSettingComposite.getComboDdrParamList();
        int comboIndex = 0;
        while (comboIndex < comboDdrParamList.size()) {
            Combo comboDdrPhy;
            Combo combo = comboDdrParamList.get(comboIndex);
            String comboName = (String)combo.getData();
            if (comboName.equals(ExcelDataHelper.getDdrcapcity())) {
                String[] items = combo.getItems();
                if (items.length <= 0) {
                    return;
                }
                int selectionIndex = combo.getSelectionIndex();
                String selectDdrCapacity = items[selectionIndex];
                if (RegbinView.isHi3716V550Series()) {
                    labCustomDemoNameValue = this.handleTitleDdrCapacity(labCustomDemoNameValue, lowerStr, selectDdrCapacity, items);
                } else {
                    String[] stringArray = items;
                    int n = items.length;
                    int n2 = 0;
                    while (n2 < n) {
                        String ddrCapacity = stringArray[n2];
                        if (lowerStr.contains(ddrCapacity.toLowerCase())) {
                            if (labCustomDemoNameValue.contains(ddrCapacity)) {
                                labCustomDemoNameValue = labCustomDemoNameValue.replace(ddrCapacity, selectDdrCapacity);
                                break;
                            }
                            labCustomDemoNameValue = labCustomDemoNameValue.toLowerCase().replace(ddrCapacity.toLowerCase(), selectDdrCapacity.toLowerCase());
                            break;
                        }
                        ++n2;
                    }
                }
                this.labCustomDemoName.setText(labCustomDemoNameValue);
                this.labCustomDemoName.update();
            } else if (comboName.startsWith(ExcelDataHelper.getDdrcapcity()) && (comboDdrPhy = this.baseSettingComposite.getComboDdrPhy()) != null && !comboDdrPhy.isDisposed()) {
                String comboNameChannel;
                String selectDdrPhy = comboDdrPhy.getItem(comboDdrPhy.getSelectionIndex());
                String selectDdrPhyChannel = selectDdrPhy.substring(selectDdrPhy.indexOf("_") + "_".length());
                if (selectDdrPhyChannel.equalsIgnoreCase(comboNameChannel = comboName.substring(comboName.indexOf("_") + "_".length()))) {
                    String[] items = combo.getItems();
                    if (items.length <= 0) {
                        return;
                    }
                    combo.setEnabled(true);
                    int selectionIndex = combo.getSelectionIndex();
                    String selectDdrCapacity = items[selectionIndex];
                    String curDdrCapacityInfo = String.valueOf(selectDdrPhy.substring(selectDdrPhy.indexOf("_") + "_".length())) + selectDdrCapacity;
                    int ddrIndex = lowerStr.indexOf("ddr");
                    if (ddrIndex != -1) {
                        String secondPart = lowerStr.substring(ddrIndex + "ddr".length() + 1);
                        String thirdPart = secondPart.substring(secondPart.indexOf("_") + "_".length());
                        String oldDdrCapacityInfo = thirdPart.substring(0, thirdPart.indexOf("_"));
                        labCustomDemoNameValue = labCustomDemoNameValue.contains(oldDdrCapacityInfo) ? labCustomDemoNameValue.replace(oldDdrCapacityInfo, curDdrCapacityInfo) : labCustomDemoNameValue.toLowerCase().replace(oldDdrCapacityInfo.toLowerCase(), curDdrCapacityInfo.toLowerCase());
                        this.labCustomDemoName.setText(labCustomDemoNameValue);
                        this.labCustomDemoName.update();
                    }
                } else {
                    combo.setEnabled(false);
                }
            }
            ++comboIndex;
        }
    }

    public Label getLabDemoVersion() {
        return this.labDemoVersion;
    }

    public void setLabDemoVersion(Label labDemoVersion) {
        this.labDemoVersion = labDemoVersion;
    }

    public Label getLabCustomDemoName() {
        return this.labCustomDemoName;
    }

    public void setLabCustomDemoName(Label labCustomDemoName) {
        this.labCustomDemoName = labCustomDemoName;
    }

    public Text getTextCustomDemoName() {
        return this.textCustomDemoName;
    }

    public void setTextCustomDemoName(Text textCustomDemoName) {
        this.textCustomDemoName = textCustomDemoName;
    }

    public String getCustomAddStr() {
        return this.customAddStr;
    }

    public void setCustomAddStr(String customAddStr) {
        this.customAddStr = customAddStr;
    }

    public Composite getBaseComposite() {
        return this.baseComposite;
    }

    public BaseSettingComposite getBaseSettingComposite() {
        return this.baseSettingComposite;
    }

    public PinDemuxComposite getPinDemuxComposite() {
        return this.pinDemuxComposite;
    }

    public ScrolledComposite getBaseScrolledComposite() {
        return this.baseScrolledComposite;
    }

    public TabFolder getTabFolder() {
        return this.tabFolder;
    }

    public TabItem getBaseSettingItem() {
        return this.baseSettingItem;
    }

    public TabItem getPinDemuxItem() {
        return this.pinDemuxItem;
    }

    static /* synthetic */ String access$0(PanelComposite panelComposite) {
        return panelComposite.customAddStr;
    }

    static /* synthetic */ void access$1(PanelComposite panelComposite, String string) {
        panelComposite.customAddStr = string;
    }

    static /* synthetic */ String access$2(PanelComposite panelComposite, ParsedMainData parsedMainData, String string) {
        return panelComposite.handleTableName(parsedMainData, string);
    }

    static /* synthetic */ Label access$3(PanelComposite panelComposite) {
        return panelComposite.labCustomDemoName;
    }

    static /* synthetic */ Text access$4(PanelComposite panelComposite) {
        return panelComposite.textCustomDemoName;
    }

    static /* synthetic */ BaseSettingComposite access$5(PanelComposite panelComposite) {
        return panelComposite.baseSettingComposite;
    }

    static /* synthetic */ Composite access$6(PanelComposite panelComposite) {
        return panelComposite.baseComposite;
    }

    static /* synthetic */ PinDemuxComposite access$7(PanelComposite panelComposite) {
        return panelComposite.pinDemuxComposite;
    }

    static /* synthetic */ String access$8(PanelComposite panelComposite, String string, ArrayList arrayList, String string2) {
        return panelComposite.updateDdrNameAddFreq(string, arrayList, string2);
    }

    static /* synthetic */ void access$9(PanelComposite panelComposite, ParsedMainData parsedMainData, String string) {
        panelComposite.refreshDemoInfoByConfig(parsedMainData, string);
    }

    static /* synthetic */ void access$10(PanelComposite panelComposite, TextReader textReader) {
        panelComposite.refreshConfigurableParamByConfig(textReader);
    }

    static /* synthetic */ void access$11(PanelComposite panelComposite, TextReader textReader) {
        panelComposite.refreshMacByConfig(textReader);
    }

    static /* synthetic */ void access$12(PanelComposite panelComposite, TextReader textReader) {
        panelComposite.refreshPhyAddressByConfig(textReader);
    }

    static /* synthetic */ void access$13(PanelComposite panelComposite, TextReader textReader) {
        panelComposite.refreshGpioGroupNumByConfig(textReader);
    }

    static /* synthetic */ void access$14(PanelComposite panelComposite, TextReader textReader) {
        panelComposite.refreshGpioBitsByConfig(textReader);
    }

    static /* synthetic */ void access$15(PanelComposite panelComposite, TextReader textReader) {
        panelComposite.refreshStartupByConfig(textReader);
    }

    static /* synthetic */ void access$16(PanelComposite panelComposite, TextReader textReader) {
        panelComposite.refreshPinMuxByConfig(textReader);
    }

    static /* synthetic */ void access$17(PanelComposite panelComposite, TextReader textReader) {
        panelComposite.refreshDdrPhyByConfig(textReader);
    }
}

