/*
 * Decompiled with CFR 0.152.
 */
package com.hisilicon.hiregbin.ui;

import com.hisilicon.hiregbin.Messages;
import com.hisilicon.hiregbin.model.BaseParam;
import com.hisilicon.hiregbin.model.GlobleInfo;
import com.hisilicon.hiregbin.model.Setting;
import com.hisilicon.hiregbin.model.reg.BaseRegisterInfo;
import com.hisilicon.hiregbin.model.reg.CAConfig;
import com.hisilicon.hiregbin.model.reg.DemoBaseParam;
import com.hisilicon.hiregbin.model.reg.GpioData;
import com.hisilicon.hiregbin.model.reg.NetworkConfig;
import com.hisilicon.hiregbin.model.reg.ParsedMainData;
import com.hisilicon.hiregbin.model.reg.PinDemuxType;
import com.hisilicon.hiregbin.model.reg.excel.ExcelData;
import com.hisilicon.hiregbin.model.reg.excel.ExcelMainData;
import com.hisilicon.hiregbin.model.reg.excel.MainPackage;
import com.hisilicon.hiregbin.processor.PrepareSetting;
import com.hisilicon.hiregbin.ui.AbstractBaseComposite;
import com.hisilicon.hiregbin.ui.DemoTypeSelectDialog;
import com.hisilicon.hiregbin.ui.PanelComposite;
import com.hisilicon.hiregbin.ui.RegisterInfoDialog;
import com.hisilicon.hiregbin.utility.ExcelDataHelper;
import com.hisilicon.hiregbin.views.RegbinView;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class BaseSettingComposite
extends AbstractBaseComposite {
    private static final int GPIO_BIT_MIN_VALUE = 0;
    private static final int GPIO_GROUP_MIN_VALUE = 0;
    private static final int GPIO_BIT_MAX_VALUE = 255;
    private static final int GPIO_GROUP_MAX_VALUE = 255;
    public static final String MAC_DEFAULT_NA = "NA";
    public static final String MAC_FE_PHY = "FE_PHY";
    public static final String MAC_DEFAULT_DEFAULT = "Default";
    public static final String MAC_DEFAULT_NA_HEXVALUE = "ff";
    public static final String MAC_DEFAULT_NA_VALUE = "255";
    private static final String CPU_FREQ = "CPUFreq";
    private static final String DDR_FREQ = "DDRFreq";
    private static final String PCBLayer = "PCBLayer";
    private static final String DDRLayers = "DDRLayers";
    private static final String PackageType = "PackageType";
    private Button btnCA;
    private Button btnNoCA;
    private Text textDdrType;
    private Combo comboDdrType;
    private Combo comboDdrPhy;
    private Text textDdrBuswidth;
    private Text textPCBLayers;
    private Button btnCARegisterInfo;
    private Button btnDdrRegisterInfo;
    private Button btnOtherRegisterInfo;
    private Button btnNetRegsiterInfo;
    private ArrayList<Label> lblMacList;
    private ArrayList<Label> lblMacPhyAddrList;
    private ArrayList<Label> lblHexList;
    private ArrayList<Label> lblMacGpioGroupList;
    private ArrayList<Label> lblMacBinDemuxList;
    private ArrayList<Label> lblMacGpioBitList;
    private ArrayList<Combo> comboMacList;
    private ArrayList<Combo> comboGpioGroupNumList;
    private ArrayList<Combo> comboGpioBitsNumList;
    private ArrayList<Combo> comboDdrParamList;
    private ArrayList<Text> textPhyAddressList;
    private Group netConfigGroup;
    private boolean regBtnExit;
    private String selectDemoName;
    private PanelComposite panelComposite;
    private final String[] voldvddArray = new String[]{"3V3_IO", "1V8_IO"};
    private String volDvdd;
    private String[] gpioBitArray = new String[]{"0", "1", "2", "3", "4", "5", "6", "7", "Default"};

    public BaseSettingComposite(Composite parent, Setting setting, String selectDemoName, PanelComposite panelComposite) {
        super(parent, setting);
        this.lblMacList = new ArrayList();
        this.lblMacPhyAddrList = new ArrayList();
        this.lblHexList = new ArrayList();
        this.lblMacGpioGroupList = new ArrayList();
        this.lblMacBinDemuxList = new ArrayList();
        this.lblMacGpioBitList = new ArrayList();
        this.comboMacList = new ArrayList();
        this.textPhyAddressList = new ArrayList();
        this.comboGpioGroupNumList = new ArrayList();
        this.comboGpioBitsNumList = new ArrayList();
        this.comboDdrParamList = new ArrayList();
        this.selectDemoName = selectDemoName;
        this.panelComposite = panelComposite;
        this.createContents();
    }

    protected void createContents() {
        if (!ExcelDataHelper.isV120RegFomatVersion(ExcelDataHelper.getExcelData())) {
            this.createCAGroup();
        }
        this.createFrequencyGroup();
        this.createOtherGroup();
        this.createMacGroup();
    }

    private void createFrequencyGroup() {
        try {
            LinkedHashMap<String, ArrayList<BaseRegisterInfo>> comboParamRegInfoMap;
            ParsedMainData parsedMainData = ExcelDataHelper.getParsedMainData();
            if (parsedMainData != null && (comboParamRegInfoMap = parsedMainData.getComboParamRegInfoMap()) != null) {
                Group frequencyGroup = new Group((Composite)this, 0);
                frequencyGroup.setLayoutData((Object)new GridData(4, 1, true, false));
                frequencyGroup.setLayout((Layout)new GridLayout(8, false));
                frequencyGroup.setBackground(GlobleInfo.white);
                frequencyGroup.setText(Messages.BaseSettingComposite_Frequency_Setting);
                if (ExcelDataHelper.isV135XlsFomatVersion(ExcelDataHelper.getExcelData())) {
                    Label labDdrPhy = new Label((Composite)frequencyGroup, 0);
                    labDdrPhy.setText(Messages.BaseSettingComposite_DDR_Phy);
                    BaseSettingComposite.fillHorizontalLabel((Control)labDdrPhy, 30);
                    this.comboDdrPhy = new Combo((Composite)frequencyGroup, 8);
                    this.comboDdrPhy.setBackground(GlobleInfo.white);
                    this.comboDdrPhy.setData((Object)this.comboDdrPhy);
                    BaseSettingComposite.fillHorizontalCombo((Control)this.comboDdrPhy);
                    AbstractBaseComposite.changeControlListener((Control)this.comboDdrPhy);
                    this.comboDdrPhy.addSelectionListener(new SelectionListener(){

                        public void widgetSelected(SelectionEvent e) {
                            BaseSettingComposite.this.panelComposite.updateCustomNameForDdrCapacity();
                        }

                        public void widgetDefaultSelected(SelectionEvent e) {
                        }
                    });
                }
                for (Map.Entry<String, ArrayList<BaseRegisterInfo>> next : comboParamRegInfoMap.entrySet()) {
                    String paramName = next.getKey();
                    Label label = new Label((Composite)frequencyGroup, 0);
                    label.setText(paramName);
                    BaseSettingComposite.fillHorizontalLabel((Control)label, 20);
                    Combo combo = new Combo((Composite)frequencyGroup, 8);
                    BaseSettingComposite.fillHorizontalCombo((Control)combo);
                    combo.setData((Object)paramName);
                    if (paramName.equalsIgnoreCase(DDRLayers)) {
                        label.setVisible(false);
                        combo.setVisible(false);
                    }
                    if (paramName.equalsIgnoreCase(CPU_FREQ)) {
                        combo.setEnabled(false);
                    }
                    if (paramName.equalsIgnoreCase(DDR_FREQ)) {
                        if (RegbinView.isHi3796CV300Series()) {
                            combo.setEnabled(true);
                        } else {
                            combo.setEnabled(false);
                        }
                    }
                    if (paramName.equalsIgnoreCase(PCBLayer)) {
                        label.setVisible(false);
                        combo.setVisible(false);
                    }
                    if (paramName.equalsIgnoreCase(PackageType)) {
                        combo.setEnabled(false);
                    }
                    AbstractBaseComposite.changeControlListener((Control)combo);
                    combo.addSelectionListener(new SelectionListener(){

                        public void widgetSelected(SelectionEvent e) {
                            if (paramName.toUpperCase().startsWith("VOL_DVDD3318")) {
                                if (BaseSettingComposite.this.isRefreshPinDemuxComsite()) {
                                    BaseSettingComposite.this.volDvdd = combo.getItem(combo.getSelectionIndex());
                                    BaseSettingComposite.this.panelComposite.updataPinDemuxComposite(BaseSettingComposite.this.volDvdd);
                                } else {
                                    combo.select(combo.indexOf(BaseSettingComposite.this.volDvdd));
                                }
                            }
                            BaseSettingComposite.this.panelComposite.updateCustomNameForDdrCapacity();
                        }

                        public void widgetDefaultSelected(SelectionEvent e) {
                        }
                    });
                    this.comboDdrParamList.add(combo);
                }
                Composite detailsComposite = new Composite((Composite)frequencyGroup, 0);
                detailsComposite.setBackground(GlobleInfo.white);
                GridLayout layoutComposite = new GridLayout();
                layoutComposite.numColumns = 1;
                layoutComposite.marginTop = 0;
                detailsComposite.setLayout((Layout)layoutComposite);
                detailsComposite.setLayoutData((Object)new GridData(131072, 0x1000000, true, false, 8, 1));
                this.btnDdrRegisterInfo = new Button(detailsComposite, 0x1000000);
                GridData gridData = new GridData(640);
                gridData.widthHint = 70;
                this.btnDdrRegisterInfo.setLayoutData((Object)gridData);
                this.btnDdrRegisterInfo.setText(Messages.BaseSettingComposite_Register_Details);
                this.btnDdrRegisterInfo.setEnabled(false);
                this.btnDdrRegisterInfo.addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent e) {
                        String[] tableNames = null;
                        if (ExcelDataHelper.isV120RegFomatVersion(ExcelDataHelper.getExcelData())) {
                            String selectCombo;
                            if (ExcelDataHelper.isV135XlsFomatVersion(ExcelDataHelper.getExcelData())) {
                                if (BaseSettingComposite.this.comboDdrPhy != null && !BaseSettingComposite.this.comboDdrPhy.isDisposed()) {
                                    selectCombo = BaseSettingComposite.this.comboDdrPhy.getText();
                                    if (selectCombo.indexOf("Channel") != -1) {
                                        selectCombo = selectCombo.substring(selectCombo.indexOf("Channel") + "Channel".length());
                                    }
                                    tableNames = new String[]{"mddrc" + selectCombo, "peri_cfg"};
                                }
                            } else if (BaseSettingComposite.this.comboDdrType != null && !BaseSettingComposite.this.comboDdrType.isDisposed()) {
                                selectCombo = BaseSettingComposite.this.comboDdrType.getText();
                                if (selectCombo.toLowerCase().contains("x")) {
                                    selectCombo = selectCombo.replace("x", "");
                                }
                                tableNames = new String[]{"sys_clk", "mddrc_" + selectCombo, "clk_ssmod", "peri_cfg"};
                            }
                        } else {
                            tableNames = new String[]{"mddrc", "clk_ssmod"};
                        }
                        RegisterInfoDialog registerInfoDialog = new RegisterInfoDialog(Display.getDefault().getActiveShell(), tableNames, BaseSettingComposite.getCurrentExcelData(), BaseSettingComposite.this.comboDdrParamList, BaseSettingComposite.this.panelComposite.getLabCustomDemoName(), (BaseParam)BaseSettingComposite.this.getParam(new BaseParam(), "reg"));
                        registerInfoDialog.open();
                    }
                });
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            MessageDialog.openError((Shell)this.getShell(), (String)Messages.Message_Error, (String)Messages.PanelComposite_Load_TempFile_Error);
            return;
        }
    }

    private void createOtherGroup() {
        Group ddrGroup = new Group((Composite)this, 64);
        ddrGroup.setLayoutData((Object)new GridData(4, 1, true, false));
        ddrGroup.setLayout((Layout)new GridLayout(7, false));
        ddrGroup.setBackground(GlobleInfo.white);
        ddrGroup.setText(Messages.BaseSettingComposite_Other_Information);
        Label labDdrType = new Label((Composite)ddrGroup, 0);
        labDdrType.setText(Messages.BaseSettingComposite_DDR_Type);
        BaseSettingComposite.fillHorizontalLabel((Control)labDdrType, 30);
        if (ExcelDataHelper.isV120RegFomatVersion(ExcelDataHelper.getExcelData())) {
            this.comboDdrType = new Combo((Composite)ddrGroup, 8);
            this.comboDdrType.setBackground(GlobleInfo.white);
            this.comboDdrType.setData((Object)this.comboDdrType);
            if (RegbinView.isHi3716MV430Series() || RegbinView.isHi3796CV300Series()) {
                this.comboDdrType.setEnabled(true);
            } else {
                this.comboDdrType.setEnabled(false);
            }
            this.comboDdrType.addSelectionListener(new SelectionListener(){

                public void widgetSelected(SelectionEvent e) {
                    ParsedMainData parsedMainData = ExcelDataHelper.getParsedMainData();
                    String ddrCapacity = BaseSettingComposite.this.updateDDRTypeForUI(parsedMainData, BaseSettingComposite.this.selectDemoName, PinDemuxType.ImportBin, BaseSettingComposite.this.comboDdrType.getText());
                    String tableName = DemoTypeSelectDialog.handleTableName(parsedMainData, BaseSettingComposite.this.selectDemoName, false, BaseSettingComposite.this.comboDdrType.getText(), ddrCapacity);
                    BaseSettingComposite.this.updateDdrFreqForUI(parsedMainData, BaseSettingComposite.this.selectDemoName, BaseSettingComposite.this.comboDdrType.getText(), BaseSettingComposite.this.selectDemoName);
                    BaseSettingComposite.this.panelComposite.getLabCustomDemoName().setText(tableName);
                    BaseSettingComposite.this.panelComposite.update();
                    BaseSettingComposite.this.panelComposite.layout();
                }

                public void widgetDefaultSelected(SelectionEvent e) {
                }
            });
            BaseSettingComposite.fillHorizontalCombo((Control)this.comboDdrType);
            this.comboDdrType.addSelectionListener(new SelectionListener(){

                public void widgetSelected(SelectionEvent e) {
                    BaseSettingComposite.this.panelComposite.updateCustomNameForDdrType();
                }

                public void widgetDefaultSelected(SelectionEvent e) {
                }
            });
            AbstractBaseComposite.changeControlListener((Control)this.comboDdrType);
        } else {
            this.textDdrType = new Text((Composite)ddrGroup, 2056);
            this.textDdrType.setTextLimit(8);
            BaseSettingComposite.fillHorizontalText((Control)this.textDdrType, 80);
            BaseSettingComposite.addLosesfocus((Control)this.textDdrType);
        }
        Label labDdrBuswidth = new Label((Composite)ddrGroup, 0);
        labDdrBuswidth.setText(Messages.BaseSettingComposite_DDR_Buswidth);
        BaseSettingComposite.fillHorizontalLabel((Control)labDdrBuswidth, 30);
        this.textDdrBuswidth = new Text((Composite)ddrGroup, 2056);
        this.textDdrBuswidth.setTextLimit(8);
        BaseSettingComposite.fillHorizontalText((Control)this.textDdrBuswidth, 80);
        BaseSettingComposite.addLosesfocus((Control)this.textDdrBuswidth);
        Label labPCBLayers = new Label((Composite)ddrGroup, 0);
        labPCBLayers.setText(Messages.BaseSettingComposite_DDR_PCBLayers);
        BaseSettingComposite.fillHorizontalLabel((Control)labPCBLayers, 30);
        this.textPCBLayers = new Text((Composite)ddrGroup, 2056);
        this.textPCBLayers.setTextLimit(8);
        BaseSettingComposite.fillHorizontalText((Control)this.textPCBLayers, 80);
        BaseSettingComposite.addLosesfocus((Control)this.textPCBLayers);
        Composite detailsComposite = new Composite((Composite)ddrGroup, 0);
        detailsComposite.setBackground(GlobleInfo.white);
        GridLayout layoutComposite = new GridLayout();
        layoutComposite.numColumns = 1;
        layoutComposite.marginTop = 0;
        detailsComposite.setLayout((Layout)layoutComposite);
        detailsComposite.setLayoutData((Object)new GridData(131072, 0x1000000, true, false, 8, 2));
        this.btnOtherRegisterInfo = new Button(detailsComposite, 0x1000000);
        GridData gridData = new GridData(640);
        gridData.widthHint = 70;
        this.btnOtherRegisterInfo.setLayoutData((Object)gridData);
        this.btnOtherRegisterInfo.setText(Messages.BaseSettingComposite_Register_Details);
        this.btnOtherRegisterInfo.setEnabled(false);
        this.btnOtherRegisterInfo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                String[] tableNames = null;
                String selectDdrType = BaseSettingComposite.this.comboDdrType.getText().toLowerCase();
                if (ExcelDataHelper.isV120RegFomatVersion(ExcelDataHelper.getExcelData())) {
                    String workbookDdrWake = "ddr_wakeup";
                    String ddrphyTableName = "ddrphy";
                    String ddrPoweron = "ddr_poweron";
                    if (RegbinView.isHi3796CV300Series()) {
                        if (selectDdrType.contains("_2rank")) {
                            selectDdrType = selectDdrType.replace("_2rank", "");
                        }
                        if (selectDdrType.contains("lpddr4x")) {
                            selectDdrType = selectDdrType.replace("lpddr4x", "lp4x");
                        }
                        if (BaseSettingComposite.this.selectDemoName.toLowerCase().contains("dma")) {
                            ddrphyTableName = String.valueOf(BaseSettingComposite.this.selectDemoName) + "_" + "ddrphy" + "_" + selectDdrType;
                            workbookDdrWake = workbookDdrWake.replace("ddr", "LPDDR4");
                            ddrPoweron = "mddrc_poweron_LPDDR4";
                        } else {
                            ddrphyTableName = String.valueOf(BaseSettingComposite.this.selectDemoName) + "_" + "ddrphy";
                            workbookDdrWake = workbookDdrWake.replace("ddr", "DDR4");
                            ddrPoweron = "mddrc_poweron_DDR4";
                        }
                    }
                    tableNames = new String[]{ddrphyTableName, ddrPoweron, workbookDdrWake};
                } else {
                    tableNames = new String[]{"ddrphy", "ddr_poweron", "ddr_wakeup"};
                }
                RegisterInfoDialog registerInfoDialog = new RegisterInfoDialog(Display.getDefault().getActiveShell(), tableNames, BaseSettingComposite.getCurrentExcelData(), BaseSettingComposite.this.comboDdrParamList, BaseSettingComposite.this.panelComposite.getLabCustomDemoName(), (BaseParam)BaseSettingComposite.this.getParam(new BaseParam(), "reg"));
                registerInfoDialog.open();
            }
        });
    }

    private String updateDDRTypeForUI(ParsedMainData parsedMainData, String importDemoName, PinDemuxType importType, String selectDdrType) {
        ArrayList<DemoBaseParam> demoList = parsedMainData.getDemoList();
        LinkedHashMap<String, ArrayList<BaseRegisterInfo>> comboParamRegInfoMap = parsedMainData.getComboParamRegInfoMap();
        Iterator<Map.Entry<String, ArrayList<BaseRegisterInfo>>> iterator = comboParamRegInfoMap.entrySet().iterator();
        for (DemoBaseParam demoBaseParam : demoList) {
            String getDemoName = demoBaseParam.getDemoName();
            if (!importDemoName.trim().equalsIgnoreCase(getDemoName)) continue;
            Map<String, String> dynamicParamMap = demoBaseParam.getDynamicParamMap();
            Iterator<Map.Entry<String, String>> dynamicParamMapIt = dynamicParamMap.entrySet().iterator();
            block1: while (dynamicParamMapIt.hasNext()) {
                int comboIndex = 0;
                while (comboIndex < this.comboDdrParamList.size()) {
                    Combo combo = this.comboDdrParamList.get(comboIndex);
                    String comboName = (String)combo.getData();
                    if (selectDdrType == null) continue block1;
                    if (comboName.equals(ExcelDataHelper.getDdrcapcity())) {
                        String[] stringArray = this.comboDdrType.getItems();
                        int n = stringArray.length;
                        int n2 = 0;
                        while (n2 < n) {
                            String ddrType = stringArray[n2];
                            if (selectDdrType.equals(ddrType)) {
                                return this.getDDRCapacityItems(iterator, selectDdrType, importDemoName, parsedMainData, combo);
                            }
                            ++n2;
                        }
                    }
                    ++comboIndex;
                }
            }
            break block0;
        }
        return null;
    }

    private void updateDdrFreqForUI(ParsedMainData parsedMainData, String selectDemoName, String selectDdrType, String demoName) {
        ArrayList<DemoBaseParam> chipBaseParamList = parsedMainData.getDemoList();
        for (DemoBaseParam demoBaseParam : chipBaseParamList) {
            if (!demoName.equalsIgnoreCase(demoBaseParam.getDemoName()) || selectDdrType == null || !RegbinView.isHi3796CV300Series()) continue;
            Map<String, String> dynamicParamMap = demoBaseParam.getDynamicParamMap();
            for (Map.Entry<String, String> entry : dynamicParamMap.entrySet()) {
                String paramName = entry.getKey();
                int comboIndex = 0;
                while (comboIndex < this.comboDdrParamList.size()) {
                    Combo combo = this.comboDdrParamList.get(comboIndex);
                    String comboName = (String)combo.getData();
                    String currentDdrNum = "";
                    String[] strs = selectDdrType.split("-");
                    if (strs.length >= 2) {
                        int ddrNumIndex = 1;
                        currentDdrNum = strs[ddrNumIndex].substring(0, 4);
                    }
                    if (comboName.equals(paramName)) {
                        String[] items = combo.getItems();
                        int itemsIndex = 0;
                        while (itemsIndex < items.length) {
                            if (items[itemsIndex].contains(currentDdrNum)) {
                                combo.select(itemsIndex);
                            }
                            ++itemsIndex;
                        }
                    }
                    ++comboIndex;
                }
            }
        }
    }

    /*
     * Unable to fully structure code
     */
    private String getDDRCapacityItems(Iterator<Map.Entry<String, ArrayList<BaseRegisterInfo>>> iterator, String selectDdrType, String importDemoName, ParsedMainData parsedMainData, Combo combo) {
        if (selectDdrType != null && !selectDdrType.isEmpty()) ** GOTO lbl15
        return null;
lbl-1000:
        // 1 sources

        {
            entry = iterator.next();
            paramName = entry.getKey();
            paramRegList = entry.getValue();
            if (!ExcelDataHelper.getDdrcapcity().equals(paramName)) continue;
            functionArray = ParsedMainData.getFunctionFromList(paramRegList, selectDdrType);
            lastOptions = this.updateOptionsByPackage(parsedMainData, importDemoName, paramName, functionArray);
            if (lastOptions != null && lastOptions.length != 0) {
                combo.setItems(lastOptions);
            } else {
                combo.setItems(functionArray);
            }
            combo.select(0);
            return combo.getText();
lbl15:
            // 2 sources

            ** while (iterator.hasNext())
        }
lbl16:
        // 1 sources

        return null;
    }

    private void createMacGroup() {
        this.netConfigGroup = new Group((Composite)this, 64);
        this.netConfigGroup.setLayoutData((Object)new GridData(4, 1, false, false));
        this.netConfigGroup.setLayout((Layout)new GridLayout(10, false));
        this.netConfigGroup.setBackground(GlobleInfo.white);
        this.netConfigGroup.setText(Messages.BaseSettingComposite_Network_Setting);
        ParsedMainData parsedMainData = ExcelDataHelper.getParsedMainData();
        if (parsedMainData != null) {
            ArrayList<NetworkConfig> netWorkConfigList = parsedMainData.getNetWorkConfigList();
            int netWorkConfigSize = netWorkConfigList.size();
            int netWorkConfigIndex = 0;
            while (netWorkConfigIndex < netWorkConfigSize) {
                NetworkConfig networkConfig = netWorkConfigList.get(netWorkConfigIndex);
                String netMacName = networkConfig.getNetMacName();
                Label labNetMac = new Label((Composite)this.netConfigGroup, 0);
                AbstractBaseComposite.fillHorizontalLabel((Control)labNetMac, 30);
                String labName = netMacName;
                if (netMacName.contains("MAC")) {
                    labName = netMacName.replace("MAC", "ETH");
                }
                labNetMac.setText(labName);
                this.lblMacList.add(labNetMac);
                GridData gridData = new GridData();
                gridData.widthHint = 70;
                Combo comboNetMac = new Combo((Composite)this.netConfigGroup, 8);
                comboNetMac.setBackground(GlobleInfo.white);
                comboNetMac.setData((Object)netMacName);
                comboNetMac.setLayoutData((Object)gridData);
                comboNetMac.addSelectionListener(new SelectionListener(){

                    public void widgetSelected(SelectionEvent e) {
                        String selectValue = comboNetMac.getText();
                        String curMacName = (String)comboNetMac.getData();
                        int comboIndex = 0;
                        try {
                            comboIndex = Integer.parseInt(curMacName.substring(curMacName.indexOf("MAC") + "MAC".length()));
                        }
                        catch (Exception e2) {
                            comboIndex = 0;
                        }
                        String[] items = comboNetMac.getItems();
                        if (selectValue.equalsIgnoreCase(BaseSettingComposite.MAC_DEFAULT_NA)) {
                            BaseSettingComposite.this.checkCurrentDemoState(false, comboIndex, parsedMainData.getDemoList(), PinDemuxType.ImportBin);
                        } else {
                            BaseSettingComposite.this.checkCurrentDemoState(true, comboIndex, parsedMainData.getDemoList(), PinDemuxType.ImportBin);
                        }
                        if (selectValue.equalsIgnoreCase(BaseSettingComposite.MAC_FE_PHY)) {
                            Combo bitCombo;
                            Combo groupCombo = (Combo)BaseSettingComposite.this.comboGpioGroupNumList.get(comboIndex);
                            if (groupCombo != null) {
                                groupCombo.setEnabled(false);
                            }
                            if ((bitCombo = (Combo)BaseSettingComposite.this.comboGpioBitsNumList.get(comboIndex)) != null) {
                                bitCombo.setEnabled(false);
                            }
                        }
                        int itemsIndex = 0;
                        while (itemsIndex < items.length) {
                            if (items[itemsIndex].equals(selectValue)) {
                                comboNetMac.select(itemsIndex);
                            }
                            ++itemsIndex;
                        }
                    }

                    public void widgetDefaultSelected(SelectionEvent e) {
                    }
                });
                AbstractBaseComposite.fillHorizontalCombo((Control)comboNetMac);
                this.comboMacList.add(comboNetMac);
                AbstractBaseComposite.changeControlListener((Control)comboNetMac);
                Label labMacPhyAddress = new Label((Composite)this.netConfigGroup, 0);
                labMacPhyAddress.setText(Messages.BaseSettingComposite_Phy_Address);
                AbstractBaseComposite.fillHorizontalLabel((Control)labMacPhyAddress, 30);
                this.lblMacPhyAddrList.add(labMacPhyAddress);
                Text textMacPhyAddress = new Text((Composite)this.netConfigGroup, 2048);
                textMacPhyAddress.setTextLimit(8);
                AbstractBaseComposite.fillHorizontalText((Control)textMacPhyAddress, 80);
                AbstractBaseComposite.addLosesfocus((Control)textMacPhyAddress);
                AbstractBaseComposite.changeControlListener((Control)textMacPhyAddress);
                textMacPhyAddress.setData((Object)netMacName);
                this.textPhyAddressList.add(textMacPhyAddress);
                Label labHex = new Label((Composite)this.netConfigGroup, 0);
                labHex.setText("(HEX)");
                AbstractBaseComposite.fillHorizontalLabel((Control)labHex, 0);
                this.lblHexList.add(labHex);
                Label labMacBinDemux = new Label((Composite)this.netConfigGroup, 0);
                labMacBinDemux.setText(Messages.BaseSettingComposite_Pin_Reuse);
                AbstractBaseComposite.fillHorizontalLabel((Control)labMacBinDemux, 30);
                this.lblMacBinDemuxList.add(labMacBinDemux);
                Label labMacGpioGroup = new Label((Composite)this.netConfigGroup, 0);
                labMacGpioGroup.setText(Messages.BaseSettingComposite_GPIO_Group_Number);
                AbstractBaseComposite.fillHorizontalLabel((Control)labMacGpioGroup, 30);
                this.lblMacGpioGroupList.add(labMacGpioGroup);
                Combo comboMacGpio = new Combo((Composite)this.netConfigGroup, 8);
                comboMacGpio.setBackground(GlobleInfo.white);
                AbstractBaseComposite.fillHorizontalCombo((Control)comboMacGpio);
                this.comboGpioGroupNumList.add(comboMacGpio);
                comboMacGpio.setData((Object)netMacName);
                AbstractBaseComposite.changeControlListener((Control)comboMacGpio);
                Label labMacGpioBit = new Label((Composite)this.netConfigGroup, 0);
                labMacGpioBit.setText(Messages.BaseSettingComposite_GPIO_Bit_Number);
                AbstractBaseComposite.fillHorizontalLabel((Control)labMacGpioBit, 15);
                this.lblMacGpioBitList.add(labMacGpioBit);
                Combo comboMacGpioBit = new Combo((Composite)this.netConfigGroup, 8);
                comboMacGpioBit.setBackground(GlobleInfo.white);
                AbstractBaseComposite.fillHorizontalCombo((Control)comboMacGpioBit);
                this.comboGpioBitsNumList.add(comboMacGpioBit);
                comboMacGpioBit.setData((Object)netMacName);
                AbstractBaseComposite.changeControlListener((Control)comboMacGpioBit);
                ++netWorkConfigIndex;
            }
            if (!this.regBtnExit) {
                Composite detailsComposite = new Composite((Composite)this.netConfigGroup, 0);
                detailsComposite.setBackground(GlobleInfo.white);
                GridLayout layoutComposite = new GridLayout();
                layoutComposite.numColumns = 1;
                layoutComposite.marginTop = 0;
                detailsComposite.setLayout((Layout)layoutComposite);
                detailsComposite.setLayoutData((Object)new GridData(131072, 0x1000000, true, false, 10, 1));
                this.btnNetRegsiterInfo = new Button(detailsComposite, 0x1000000);
                GridData MacGridData = new GridData(640);
                MacGridData.widthHint = 70;
                this.btnNetRegsiterInfo.setLayoutData((Object)MacGridData);
                this.btnNetRegsiterInfo.setText(Messages.BaseSettingComposite_Register_Details);
                this.btnNetRegsiterInfo.setEnabled(false);
                this.regBtnExit = true;
                this.btnNetRegsiterInfo.addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent e) {
                        String[] tableNames = new String[]{"eth_phy_cfg"};
                        RegisterInfoDialog registerInfoDialog = new RegisterInfoDialog(Display.getDefault().getActiveShell(), tableNames, BaseSettingComposite.getCurrentExcelData(), BaseSettingComposite.this.comboDdrParamList, BaseSettingComposite.this.panelComposite.getLabCustomDemoName(), (BaseParam)BaseSettingComposite.this.getParam(new BaseParam(), "reg"));
                        registerInfoDialog.open();
                    }
                });
            }
            if (netWorkConfigSize > 0) {
                this.netConfigGroup.setVisible(true);
            } else {
                this.netConfigGroup.setVisible(false);
            }
        }
    }

    private void createCAGroup() {
        Group caGroup = new Group((Composite)this, 64);
        caGroup.setLayoutData((Object)new GridData(4, 1, true, false));
        caGroup.setLayout((Layout)new GridLayout(3, false));
        caGroup.setBackground(GlobleInfo.white);
        caGroup.setText(Messages.BaseSettingComposite_Security_Setting);
        this.btnCA = new Button((Composite)caGroup, 16);
        this.btnCA.setText(Messages.BaseSettingComposite_CA);
        this.btnCA.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                if (BaseSettingComposite.this.btnCA.getSelection()) {
                    BaseSettingComposite.setBtnMakeRegBinEnable(true);
                    BaseSettingComposite.setBtnMakeCfgBinEnable(true);
                    BaseSettingComposite.setBtnReplaceFastbootEnable(false);
                    BaseSettingComposite.this.updateLblCustomDemoName(BaseSettingComposite.this.panelComposite.getLabCustomDemoName(), CAConfig.CA.name());
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        BaseSettingComposite.fillHorizontalLabel((Control)this.btnCA, 30);
        AbstractBaseComposite.changeControlListener((Control)this.btnCA);
        this.btnNoCA = new Button((Composite)caGroup, 16);
        this.btnNoCA.setText(Messages.BaseSettingComposite_noCA);
        this.btnNoCA.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                if (BaseSettingComposite.this.btnNoCA.getSelection()) {
                    BaseSettingComposite.setBtnMakeRegBinEnable(true);
                    BaseSettingComposite.setBtnMakeCfgBinEnable(false);
                    BaseSettingComposite.setBtnReplaceFastbootEnable(true);
                    BaseSettingComposite.this.updateLblCustomDemoName(BaseSettingComposite.this.panelComposite.getLabCustomDemoName(), CAConfig.noCA.name());
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        BaseSettingComposite.fillHorizontalLabel((Control)this.btnNoCA, 30);
        AbstractBaseComposite.changeControlListener((Control)this.btnNoCA);
        this.btnCARegisterInfo = new Button((Composite)caGroup, 0);
        this.btnCARegisterInfo.setText(Messages.BaseSettingComposite_Register_Details);
        GridData gridData = new GridData(640);
        gridData.widthHint = 70;
        this.btnCARegisterInfo.setLayoutData((Object)gridData);
        this.btnCARegisterInfo.setEnabled(false);
        this.btnCARegisterInfo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                String[] tableNames = new String[2];
                if (BaseSettingComposite.this.btnNoCA.getSelection()) {
                    tableNames[0] = ExcelDataHelper.isV120RegFomatVersion(ExcelDataHelper.getExcelData()) ? "noCA" : "sysctrl_noCA";
                }
                if (BaseSettingComposite.this.btnCA.getSelection()) {
                    tableNames[0] = ExcelDataHelper.isV120RegFomatVersion(ExcelDataHelper.getExcelData()) ? "CA" : "sysctrl_CA";
                }
                RegisterInfoDialog registerInfoDialog = new RegisterInfoDialog(Display.getDefault().getActiveShell(), tableNames, BaseSettingComposite.getCurrentExcelData(), BaseSettingComposite.this.comboDdrParamList, BaseSettingComposite.this.panelComposite.getLabCustomDemoName(), (BaseParam)BaseSettingComposite.this.getParam(new BaseParam(), "reg"));
                registerInfoDialog.open();
            }
        });
    }

    public Combo getDDRCapacityCombo() {
        int comboIndex = 0;
        while (comboIndex < this.comboDdrParamList.size()) {
            Combo combo = this.comboDdrParamList.get(comboIndex);
            String comboName = (String)combo.getData();
            if (comboName.equals(ExcelDataHelper.getDdrcapcity())) {
                return this.comboDdrParamList.get(comboIndex);
            }
            ++comboIndex;
        }
        return null;
    }

    public void updateLblCustomDemoName(Label labCustomDemoName, String ca) {
        String labCustomDemoNameValue = labCustomDemoName.getText();
        String lowerStr = labCustomDemoNameValue.toLowerCase();
        int comboIndex = 0;
        while (comboIndex < this.comboDdrParamList.size()) {
            Combo combo = this.comboDdrParamList.get(comboIndex);
            String comboName = (String)combo.getData();
            if (comboName.equals(ExcelDataHelper.getDdrcapcity())) {
                String[] items = combo.getItems();
                if (items.length <= 0) {
                    return;
                }
                int selectionIndex = combo.getSelectionIndex();
                String selectDdrCapacity = items[selectionIndex];
                String[] stringArray = items;
                int n = items.length;
                int n2 = 0;
                while (n2 < n) {
                    String ddrCapacity = stringArray[n2];
                    if (lowerStr.equalsIgnoreCase(ddrCapacity)) {
                        labCustomDemoNameValue = labCustomDemoNameValue.replace(ddrCapacity, selectDdrCapacity);
                        break;
                    }
                    ++n2;
                }
            }
            ++comboIndex;
        }
        labCustomDemoName.setText(labCustomDemoNameValue);
        labCustomDemoName.update();
    }

    protected void refreshDemoInfoToUI(Composite parent, ParsedMainData parsedMainData, String importDemoName, PinDemuxType importType, boolean refreshDdr) {
        if (parsedMainData == null) {
            return;
        }
        this.selectDemoName = importDemoName;
        this.updateCustomNameForUI(parsedMainData);
        this.updateComboParamForUI(parsedMainData, importDemoName, refreshDdr);
        this.updateNetworkForUI(parsedMainData, importDemoName);
        this.updateDemoBaseParamForUI(parsedMainData, importDemoName, importType, refreshDdr);
        this.updateBtnRegisterInfo();
        this.panelComposite.updateCustomNameForDdrCapacity();
        this.panelComposite.updateCustomNameForDdrType();
        this.update();
        this.layout();
        GlobleInfo.setNeedSave(false);
    }

    private void updateBtnRegisterInfo() {
        if (this.btnCARegisterInfo != null && !this.btnCARegisterInfo.isDisposed() && !this.btnCARegisterInfo.isEnabled()) {
            this.btnCARegisterInfo.setEnabled(true);
        }
        if (!this.btnDdrRegisterInfo.isEnabled()) {
            this.btnDdrRegisterInfo.setEnabled(true);
        }
        if (!this.btnOtherRegisterInfo.isEnabled()) {
            this.btnOtherRegisterInfo.setEnabled(true);
        }
        if (this.btnNetRegsiterInfo != null && !this.btnNetRegsiterInfo.isDisposed() && !this.btnNetRegsiterInfo.isEnabled()) {
            this.btnNetRegsiterInfo.setEnabled(true);
        }
    }

    private void updateComboParamForUI(ParsedMainData parsedMainData, String importDemoName, boolean refreshDdr) {
        LinkedHashMap<String, ArrayList<BaseRegisterInfo>> comboParamRegInfoMap = parsedMainData.getComboParamRegInfoMap();
        Iterator<Map.Entry<String, ArrayList<BaseRegisterInfo>>> iterator = comboParamRegInfoMap.entrySet().iterator();
        ArrayList<DemoBaseParam> demoList = parsedMainData.getDemoList();
        String ddrType = null;
        String volType = null;
        for (DemoBaseParam demoBaseParam : demoList) {
            if (!importDemoName.equals(demoBaseParam.getDemoName())) continue;
            ddrType = demoBaseParam.getDdrType();
            volType = demoBaseParam.getVolDvdd();
            break;
        }
        block1: while (iterator.hasNext()) {
            Map.Entry<String, ArrayList<BaseRegisterInfo>> entry = iterator.next();
            String paramName = entry.getKey();
            ArrayList<BaseRegisterInfo> paramRegList = entry.getValue();
            for (Combo combo : this.comboDdrParamList) {
                String comboKey = (String)combo.getData();
                if (!refreshDdr && paramName.equalsIgnoreCase("DDRCapacity")) continue block1;
                if (!comboKey.equals(paramName)) continue;
                String[] functionArray = ParsedMainData.getFunctionFromList(paramRegList, ddrType);
                String[] lastOptions = this.updateOptionsByPackage(parsedMainData, importDemoName, paramName, functionArray);
                if (paramName.toUpperCase().startsWith("VOL_DVDD3318")) {
                    combo.setItems(this.voldvddArray);
                    combo.select(combo.indexOf(volType));
                    this.volDvdd = combo.getItem(combo.indexOf(volType));
                    continue block1;
                }
                if (lastOptions != null && lastOptions.length != 0) {
                    combo.setItems(lastOptions);
                    continue;
                }
                combo.setItems(functionArray);
            }
        }
    }

    private String[] updateOptionsByPackage(ParsedMainData parsedMainData, String importDemoName, String paramName, String[] functionArray) {
        ExcelData excelData = ExcelDataHelper.getExcelData();
        ExcelMainData excelMainData = excelData.getExcelMainData();
        ArrayList<MainPackage> mainPackageList = excelMainData.getMainPackageList();
        if (mainPackageList == null || mainPackageList.isEmpty()) {
            return null;
        }
        for (MainPackage mainPackage : mainPackageList) {
            String packageParamName = mainPackage.getPackageName();
            if (!paramName.equalsIgnoreCase(packageParamName)) continue;
            ArrayList<DemoBaseParam> demoList = parsedMainData.getDemoList();
            for (DemoBaseParam demoBaseParam : demoList) {
                List<String> bga15x15List;
                String[] bga15x15Array;
                String selectPackage;
                String demoName = demoBaseParam.getDemoName();
                if (!importDemoName.equalsIgnoreCase(demoName) || (selectPackage = demoBaseParam.getPackageStr()) == null) continue;
                if (selectPackage.equalsIgnoreCase("BGA21x21")) {
                    List<String> bga21x21List = mainPackage.getBga21x21();
                    String[] bga21x21Array = bga21x21List.toArray(new String[bga21x21List.size()]);
                    if (!this.containArray(bga21x21Array, functionArray)) continue;
                    return bga21x21Array;
                }
                if (!selectPackage.equalsIgnoreCase("BGA15x15") || !this.containArray(bga15x15Array = (bga15x15List = mainPackage.getBga15x15()).toArray(new String[bga15x15List.size()]), functionArray)) continue;
                return bga15x15Array;
            }
        }
        return null;
    }

    private boolean containArray(String[] children, String[] parent) {
        boolean flag = false;
        int k = 0;
        if (children.length < parent.length) {
            int i = 0;
            while (i < children.length) {
                int j = 0;
                while (j < parent.length) {
                    if (children[i].equalsIgnoreCase(parent[j])) {
                        ++k;
                    }
                    ++j;
                }
                ++i;
            }
        }
        if (k == children.length) {
            flag = true;
        }
        return flag;
    }

    private void updateCustomNameForUI(ParsedMainData parsedMainData) {
        String customDemoName;
        String xlsVersion = parsedMainData.getXlsVersion();
        Label labCustomDemoName = this.panelComposite.getLabCustomDemoName();
        Text textCustomDemoName = this.panelComposite.getTextCustomDemoName();
        this.panelComposite.getLabDemoVersion().setText(xlsVersion);
        this.panelComposite.getLabDemoVersion().getParent().layout();
        if (!this.panelComposite.getTextCustomDemoName().isVisible() && !RegbinView.isHi3716V550Series()) {
            this.panelComposite.getTextCustomDemoName().setVisible(true);
        }
        if ((customDemoName = parsedMainData.getCustomDemoName()) != null && !customDemoName.isEmpty()) {
            String toLabNameString = "";
            String toTextNameString = "";
            String lowerCustomDemoName = customDemoName.toLowerCase();
            if (RegbinView.isHi3716MV310Series()) {
                toLabNameString = customDemoName.substring(0, customDemoName.indexOf("layers") + "layers".length());
                if (customDemoName.indexOf(".") != -1) {
                    toTextNameString = customDemoName.substring(customDemoName.indexOf("layers") + "layers".length(), customDemoName.lastIndexOf("."));
                }
            } else if (!(lowerCustomDemoName.contains("nand") || lowerCustomDemoName.contains("spi") || lowerCustomDemoName.contains("emmc") || lowerCustomDemoName.contains("sd"))) {
                if (customDemoName.indexOf("layers") != -1) {
                    toLabNameString = customDemoName.substring(0, customDemoName.indexOf("layers") + "layers".length());
                    if (customDemoName.indexOf(".") != -1) {
                        toTextNameString = customDemoName.substring(customDemoName.indexOf("layers") + "layers".length(), customDemoName.lastIndexOf("."));
                    }
                }
            } else if ((lowerCustomDemoName.contains("nand") || lowerCustomDemoName.contains("spi") || lowerCustomDemoName.contains("emmc")) && lowerCustomDemoName.contains(".")) {
                if (customDemoName.indexOf("nand") != -1) {
                    toLabNameString = customDemoName.substring(0, customDemoName.lastIndexOf("nand") + "nand".length());
                    toTextNameString = customDemoName.substring(customDemoName.lastIndexOf("nand") + "nand".length(), customDemoName.lastIndexOf("."));
                } else if (customDemoName.indexOf("spi") != -1) {
                    toLabNameString = customDemoName.substring(0, customDemoName.lastIndexOf("spi") + "spi".length());
                    toTextNameString = customDemoName.substring(customDemoName.lastIndexOf("spi") + "spi".length(), customDemoName.lastIndexOf("."));
                } else if (customDemoName.indexOf("emmc-phy") != -1) {
                    toLabNameString = customDemoName.substring(0, customDemoName.lastIndexOf("emmc-phy") + "emmc-phy".length());
                    toTextNameString = customDemoName.substring(customDemoName.lastIndexOf("emmc-phy") + "emmc-phy".length(), customDemoName.lastIndexOf("."));
                } else if (customDemoName.indexOf("emmc") != -1) {
                    toLabNameString = customDemoName.substring(0, customDemoName.lastIndexOf("emmc") + "emmc".length());
                    toTextNameString = customDemoName.substring(customDemoName.lastIndexOf("emmc") + "emmc".length(), customDemoName.lastIndexOf("."));
                } else {
                    toLabNameString = customDemoName.substring(0, customDemoName.lastIndexOf("."));
                    toTextNameString = "";
                }
            } else {
                toLabNameString = customDemoName;
            }
            if (RegbinView.isHi3716V550Series()) {
                toLabNameString = toLabNameString.replace("-", "_");
                labCustomDemoName.setText(toLabNameString);
            } else {
                labCustomDemoName.setText(toLabNameString);
            }
            if (toTextNameString.equalsIgnoreCase("_")) {
                toTextNameString = "";
            }
            textCustomDemoName.setText(toTextNameString);
            labCustomDemoName.update();
            textCustomDemoName.update();
        }
    }

    private void updateNetworkForUI(ParsedMainData parsedMainData, String importDemoName) {
        if (this.netConfigGroup != null) {
            this.netConfigGroup.dispose();
        }
        this.lblMacList.clear();
        this.lblMacPhyAddrList.clear();
        this.lblHexList.clear();
        this.lblMacGpioGroupList.clear();
        this.lblMacBinDemuxList.clear();
        this.lblMacGpioBitList.clear();
        this.comboMacList.clear();
        this.textPhyAddressList.clear();
        this.comboGpioGroupNumList.clear();
        this.comboGpioBitsNumList.clear();
        this.regBtnExit = false;
        this.createMacGroup();
        ArrayList<NetworkConfig> netWorkConfigList = parsedMainData.getNetWorkConfigList();
        String[] gpioGroupArray = this.getGpioGroupArray(parsedMainData);
        int macIndex = 0;
        while (macIndex < netWorkConfigList.size()) {
            NetworkConfig networkConfig = netWorkConfigList.get(macIndex);
            String netMacName = networkConfig.getNetMacName();
            String netMacValue = networkConfig.getNetMacValue();
            int netPhyAddress = networkConfig.getNetPhyAddress();
            ArrayList<String> netMacValueList = networkConfig.getNetMacValueList();
            int netGpioGroupNumber = networkConfig.getNetGpioGroupNumber();
            int netGpioBitNumber = networkConfig.getNetGpioBitNumber();
            String labName = netMacName;
            if (netMacName.contains("MAC")) {
                labName = netMacName.replace("MAC", "ETH");
            }
            this.lblMacList.get(macIndex).setText(labName);
            String[] netMacValueArray = this.listToArray(netMacValueList);
            Combo comboMac = this.comboMacList.get(macIndex);
            GridData gridData = new GridData();
            gridData.widthHint = 70;
            comboMac.setLayoutData((Object)gridData);
            Text textPthAddress = this.textPhyAddressList.get(macIndex);
            Combo comboGpioGroupNum = this.comboGpioGroupNumList.get(macIndex);
            Combo comboGpioBitsNum = this.comboGpioBitsNumList.get(macIndex);
            if (netMacValueArray == null || netMacValueArray.length == 0) {
                comboMac.setEnabled(false);
                textPthAddress.setEditable(false);
                comboGpioGroupNum.setEnabled(false);
                comboGpioBitsNum.setEnabled(false);
            } else {
                String gpioGroup;
                int i;
                String[] lastOptions = this.updateOptionsByPackage(parsedMainData, importDemoName, netMacName, netMacValueArray);
                if (lastOptions != null && lastOptions.length != 0) {
                    netMacValueArray = lastOptions;
                }
                comboMac.setItems(netMacValueArray);
                if (netMacValue != null) {
                    int selectIndex = 0;
                    i = 0;
                    while (i < netMacValueArray.length) {
                        if (netMacValue.equalsIgnoreCase(netMacValueArray[i])) {
                            selectIndex = i;
                        }
                        ++i;
                    }
                    comboMac.select(selectIndex);
                    if (netMacValue.equalsIgnoreCase(MAC_DEFAULT_NA)) {
                        textPthAddress.setEnabled(false);
                        comboGpioGroupNum.setEnabled(false);
                        comboGpioBitsNum.setEnabled(false);
                    } else if (netMacValue.equalsIgnoreCase(MAC_FE_PHY)) {
                        comboGpioGroupNum.setEnabled(false);
                        comboGpioBitsNum.setEnabled(false);
                    }
                } else if (comboMac.getItemCount() > 0) {
                    comboMac.select(0);
                }
                if (netPhyAddress == 255) {
                    textPthAddress.setText(MAC_DEFAULT_NA);
                } else {
                    textPthAddress.setText(Integer.toHexString(netPhyAddress));
                }
                comboGpioGroupNum.setItems(gpioGroupArray);
                comboGpioGroupNum.select(comboGpioGroupNum.getItemCount() - 1);
                if (netGpioGroupNumber != -1 && netGpioGroupNumber != 255) {
                    String[] items = comboGpioGroupNum.getItems();
                    i = 0;
                    while (i < items.length) {
                        gpioGroup = items[i];
                        if (gpioGroup.equalsIgnoreCase(String.valueOf(netGpioGroupNumber))) {
                            comboGpioGroupNum.select(i);
                        }
                        ++i;
                    }
                }
                comboGpioBitsNum.setItems(this.gpioBitArray);
                comboGpioBitsNum.select(comboGpioBitsNum.getItemCount() - 1);
                if (netGpioBitNumber != -1 && netGpioBitNumber != 255) {
                    String[] items = comboGpioBitsNum.getItems();
                    i = 0;
                    while (i < items.length) {
                        gpioGroup = items[i];
                        if (gpioGroup.equalsIgnoreCase(String.valueOf(netGpioBitNumber))) {
                            comboGpioBitsNum.select(i);
                        }
                        ++i;
                    }
                }
            }
            ++macIndex;
        }
    }

    private void updateDemoBaseParamForUI(ParsedMainData parsedMainData, String importDemoName, PinDemuxType importType, boolean refreshDdr) {
        ArrayList<DemoBaseParam> demoList = parsedMainData.getDemoList();
        for (DemoBaseParam demoBaseParam : demoList) {
            ArrayList<String> ddrTypeList;
            String getDemoName = demoBaseParam.getDemoName();
            if (!importDemoName.trim().equalsIgnoreCase(getDemoName)) continue;
            String demoType = demoBaseParam.getDemoType();
            String ddrBuswidth = demoBaseParam.getDdrBuswidth();
            String ddrPCBLayers = demoBaseParam.getDdrPCBLayers();
            CAConfig caStr = demoBaseParam.getCa();
            Map<String, String> dynamicParamMap = demoBaseParam.getDynamicParamMap();
            this.setUIDdrMessage(demoType, ddrBuswidth, ddrPCBLayers, caStr);
            for (Map.Entry<String, String> entry : dynamicParamMap.entrySet()) {
                int itemsIndex;
                String[] items;
                String comboName;
                Combo combo;
                String paramName = entry.getKey();
                String selectValue = entry.getValue();
                int comboIndex = 0;
                while (comboIndex < this.comboDdrParamList.size()) {
                    combo = this.comboDdrParamList.get(comboIndex);
                    comboName = (String)combo.getData();
                    if (comboName.equals(paramName)) {
                        items = combo.getItems();
                        itemsIndex = 0;
                        while (itemsIndex < items.length) {
                            if (items[itemsIndex].equals(selectValue)) {
                                combo.select(itemsIndex);
                                break;
                            }
                            combo.select(1);
                            ++itemsIndex;
                        }
                    }
                    ++comboIndex;
                }
                if (importType != PinDemuxType.Demo) continue;
                comboIndex = 0;
                while (comboIndex < this.comboMacList.size()) {
                    combo = this.comboMacList.get(comboIndex);
                    comboName = (String)combo.getData();
                    if (comboName.equals(paramName)) {
                        items = combo.getItems();
                        if (selectValue.equalsIgnoreCase(MAC_DEFAULT_NA)) {
                            this.checkCurrentDemoState(false, comboIndex, demoList, importType);
                        } else {
                            this.checkCurrentDemoState(true, comboIndex, demoList, importType);
                        }
                        if (selectValue.equalsIgnoreCase(MAC_FE_PHY)) {
                            Combo bitCombo;
                            Combo groupCombo = this.comboGpioGroupNumList.get(comboIndex);
                            if (groupCombo != null) {
                                groupCombo.setEnabled(false);
                            }
                            if ((bitCombo = this.comboGpioBitsNumList.get(comboIndex)) != null) {
                                bitCombo.setEnabled(false);
                            }
                        }
                        itemsIndex = 0;
                        while (itemsIndex < items.length) {
                            if (items[itemsIndex].equals(selectValue)) {
                                combo.select(itemsIndex);
                            }
                            ++itemsIndex;
                        }
                    }
                    ++comboIndex;
                }
            }
            if (refreshDdr && this.comboDdrType != null && !this.comboDdrType.isDisposed() && (ddrTypeList = parsedMainData.getDdrTypeList()) != null) {
                ArrayList<String> tempDdrTypeList = new ArrayList<String>();
                for (String ddrType : ddrTypeList) {
                    tempDdrTypeList.add(ddrType);
                }
                Iterator it = tempDdrTypeList.iterator();
                while (it.hasNext()) {
                    String curDdrType = (String)it.next();
                    if (importDemoName.contains("tsa") && curDdrType.contains("LPDDR")) {
                        it.remove();
                    }
                    if (!importDemoName.contains("dma") || !curDdrType.equalsIgnoreCase("DDR4-3200")) continue;
                    it.remove();
                }
                this.comboDdrType.setItems(this.listToArray(tempDdrTypeList));
                String ddrType = demoBaseParam.getDdrType();
                if (ddrType.contains(",")) {
                    String[] ddrTypes = ddrType.split(",");
                    ddrType = ddrTypes[0];
                }
                String[] items = this.comboDdrType.getItems();
                int i = 0;
                while (i < items.length) {
                    String string = items[i];
                    if (string.equalsIgnoreCase(ddrType)) {
                        this.comboDdrType.select(i);
                        break;
                    }
                    ++i;
                }
            }
            this.refreshDdrType(parsedMainData, importType, demoBaseParam);
        }
    }

    private void setUIDdrMessage(String demoType, String ddrBuswidth, String ddrPCBLayers, CAConfig caStr) {
        if (this.textDdrType != null && !this.textDdrType.isDisposed()) {
            this.textDdrType.setText(demoType);
        }
        if (ddrBuswidth != null) {
            this.textDdrBuswidth.setText(ddrBuswidth);
        }
        if (ddrPCBLayers != null) {
            if (ddrPCBLayers.endsWith(".")) {
                ddrPCBLayers = ddrPCBLayers.substring(0, ddrPCBLayers.indexOf("."));
            }
            this.textPCBLayers.setText(ddrPCBLayers);
        }
        if (caStr != null) {
            if (caStr == CAConfig.noCA) {
                if (this.btnCA != null && !this.btnCA.isDisposed()) {
                    this.btnCA.setSelection(false);
                }
                if (this.btnNoCA != null && !this.btnNoCA.isDisposed()) {
                    this.btnNoCA.setSelection(true);
                }
            } else if (caStr == CAConfig.CA) {
                if (this.btnCA != null && !this.btnCA.isDisposed()) {
                    this.btnCA.setSelection(true);
                }
                if (this.btnNoCA != null && !this.btnNoCA.isDisposed()) {
                    this.btnNoCA.setSelection(false);
                }
            }
        }
        if (this.btnCA != null && !this.btnCA.isDisposed() && this.btnCA.getSelection()) {
            BaseSettingComposite.setBtnMakeRegBinEnable(false);
            BaseSettingComposite.setBtnMakeCfgBinEnable(true);
        }
        if (this.btnNoCA != null && !this.btnNoCA.isDisposed() && this.btnNoCA.getSelection()) {
            BaseSettingComposite.setBtnMakeRegBinEnable(true);
            BaseSettingComposite.setBtnMakeCfgBinEnable(false);
        }
    }

    private void refreshDdrType(ParsedMainData parsedMainData, PinDemuxType importType, DemoBaseParam demoBaseParam) {
        block6: {
            String customDemoName;
            Label labCustomDemoName;
            ArrayList<String> ddrPhyList;
            block7: {
                ArrayList<String> ddrPhyList2;
                if (importType != PinDemuxType.Demo) break block7;
                if (this.comboDdrPhy == null || this.comboDdrPhy.isDisposed() || (ddrPhyList2 = parsedMainData.getDdrPhyList()) == null) break block6;
                this.comboDdrPhy.setItems(this.listToArray(ddrPhyList2));
                String ddrPhy = demoBaseParam.getDdrPhy();
                String[] items = this.comboDdrPhy.getItems();
                int i = 0;
                while (i < items.length) {
                    String string = items[i];
                    if (string.equalsIgnoreCase(ddrPhy)) {
                        this.comboDdrPhy.select(i);
                    }
                    ++i;
                }
                break block6;
            }
            if (this.comboDdrPhy != null && !this.comboDdrPhy.isDisposed() && (ddrPhyList = parsedMainData.getDdrPhyList()) != null && (labCustomDemoName = this.panelComposite.getLabCustomDemoName()) != null && (customDemoName = labCustomDemoName.getText()).indexOf("layers") != -1) {
                String[] names;
                String subCustomDemoName = customDemoName.substring(0, customDemoName.indexOf("layers"));
                String[] stringArray = names = subCustomDemoName.split("_");
                int n = names.length;
                int n2 = 0;
                while (n2 < n) {
                    String name = stringArray[n2];
                    if (name.toLowerCase().contains("dch")) {
                        this.updatePhyCapacityByImport(name, "dch");
                        break;
                    }
                    if (name.toLowerCase().contains("sch")) {
                        this.updatePhyCapacityByImport(name, "sch");
                        break;
                    }
                    ++n2;
                }
            }
        }
    }

    private void updatePhyCapacityByImport(String name, String phyName) {
        String phyInfo = name;
        String ddrCapacity = phyInfo.substring(phyInfo.indexOf(phyName) + phyName.length());
        int comboIndex = 0;
        while (comboIndex < this.comboDdrParamList.size()) {
            Combo combo = this.comboDdrParamList.get(comboIndex);
            String comboName = (String)combo.getData();
            if (comboName.endsWith(phyName)) {
                String[] items = combo.getItems();
                int itemsIndex = 0;
                while (itemsIndex < items.length) {
                    if (items[itemsIndex].equals(ddrCapacity)) {
                        combo.select(itemsIndex);
                    }
                    ++itemsIndex;
                }
            }
            ++comboIndex;
        }
    }

    private String[] getGpioGroupArray(ParsedMainData parsedMainData) {
        ArrayList<GpioData> gpioList = parsedMainData.getGpioList();
        ArrayList<String> gpioGroupList = new ArrayList<String>();
        if (gpioList != null) {
            int i = 0;
            while (i < gpioList.size()) {
                String gpioNum = gpioList.get(i).getGpioItemNum();
                gpioGroupList.add(gpioNum);
                ++i;
            }
        }
        gpioGroupList.add(MAC_DEFAULT_DEFAULT);
        String[] gpioGroupArray = this.listToArray(gpioGroupList);
        return gpioGroupArray;
    }

    private void checkCurrentDemoState(boolean currentDemoMacState, int index, ArrayList<DemoBaseParam> demoList, PinDemuxType importType) {
        String itemValue;
        String[] items;
        ParsedMainData parsedMainData = ExcelDataHelper.getDemoParsedMainData();
        ArrayList<NetworkConfig> netWorkConfigList = parsedMainData.getNetWorkConfigList();
        NetworkConfig networkConfig = netWorkConfigList.get(index);
        Text textPhyAddress = this.textPhyAddressList.get(index);
        if (textPhyAddress != null) {
            if (!currentDemoMacState) {
                textPhyAddress.setText(MAC_DEFAULT_NA);
            } else {
                int netPhyAddress = networkConfig.getNetPhyAddress();
                if (importType == PinDemuxType.Demo) {
                    for (DemoBaseParam demoBaseParam : demoList) {
                        ArrayList<String> phyAddrList;
                        String getDemoName = demoBaseParam.getDemoName();
                        if (!this.selectDemoName.trim().equalsIgnoreCase(getDemoName) || (phyAddrList = demoBaseParam.getPhyAddrList()) == null) continue;
                        try {
                            String curMacAndDemoPhyAddr;
                            if (demoBaseParam.getPhyAddrList().size() != netWorkConfigList.size() || (curMacAndDemoPhyAddr = demoBaseParam.getPhyAddrList().get(index)).equalsIgnoreCase(MAC_DEFAULT_NA)) continue;
                            netPhyAddress = Integer.parseInt(curMacAndDemoPhyAddr);
                        }
                        catch (Exception e) {
                            MessageDialog.openError((Shell)this.getShell(), (String)Messages.Message_HiRegBin, (String)Messages.BaseSettingComposite_GetTempPhyAddr_Failed);
                        }
                    }
                    if (netPhyAddress == 255) {
                        textPhyAddress.setText(MAC_DEFAULT_NA);
                    } else {
                        textPhyAddress.setText(Integer.toHexString(netPhyAddress));
                    }
                }
            }
            textPhyAddress.setEnabled(currentDemoMacState);
        }
        if (this.comboGpioGroupNumList.get(index) != null) {
            if (!currentDemoMacState) {
                this.comboGpioGroupNumList.get(index).select(this.comboGpioGroupNumList.get(index).getItemCount() - 1);
            } else if (importType == PinDemuxType.Demo) {
                int netGpioGroupNumber = networkConfig.getNetGpioGroupNumber();
                Combo comboGpioGroup = this.comboGpioGroupNumList.get(index);
                items = comboGpioGroup.getItems();
                int itemsIndex = 0;
                while (itemsIndex < items.length) {
                    itemValue = items[itemsIndex];
                    if (itemValue.equalsIgnoreCase(MAC_DEFAULT_DEFAULT)) {
                        itemValue = MAC_DEFAULT_NA_VALUE;
                    }
                    if (itemValue.equalsIgnoreCase(String.valueOf(netGpioGroupNumber))) {
                        comboGpioGroup.select(itemsIndex);
                    }
                    ++itemsIndex;
                }
            }
            this.comboGpioGroupNumList.get(index).setEnabled(currentDemoMacState);
        }
        if (this.comboGpioBitsNumList.get(index) != null) {
            if (!currentDemoMacState) {
                this.comboGpioBitsNumList.get(index).select(this.comboGpioBitsNumList.get(index).getItemCount() - 1);
            } else if (importType == PinDemuxType.Demo) {
                int netGpioBitNumber = networkConfig.getNetGpioBitNumber();
                Combo comboGpioBits = this.comboGpioBitsNumList.get(index);
                items = comboGpioBits.getItems();
                int itemsIndex = 0;
                while (itemsIndex < items.length) {
                    itemValue = items[itemsIndex];
                    if (itemValue.equalsIgnoreCase(MAC_DEFAULT_DEFAULT)) {
                        itemValue = MAC_DEFAULT_NA_VALUE;
                    }
                    if (itemValue.equalsIgnoreCase(String.valueOf(netGpioBitNumber))) {
                        comboGpioBits.select(itemsIndex);
                    }
                    ++itemsIndex;
                }
            }
            this.comboGpioBitsNumList.get(index).setEnabled(currentDemoMacState);
        }
    }

    @Override
    protected Object getParam(BaseParam baseParam, String regOrCfg) {
        int selectionIndex;
        String macName;
        int comboIndex = 0;
        while (comboIndex < this.comboDdrParamList.size()) {
            Combo combo = this.comboDdrParamList.get(comboIndex);
            String paramName = (String)combo.getData();
            String selectParamValue = combo.getText();
            baseParam.putSelectDdrParamValueMap(paramName, selectParamValue);
            ++comboIndex;
        }
        int macIndex = 0;
        while (macIndex < this.comboMacList.size()) {
            macName = "MAC" + macIndex;
            Combo combo = this.comboMacList.get(macIndex);
            String selectMac = combo.getText();
            baseParam.putSelectMacValueMap(macName, selectMac);
            ++macIndex;
        }
        macIndex = 0;
        while (macIndex < this.textPhyAddressList.size()) {
            macName = "MAC" + macIndex;
            Text textPhyAddr = this.textPhyAddressList.get(macIndex);
            String phyAddrValue = textPhyAddr.getText();
            if (phyAddrValue.equalsIgnoreCase(MAC_DEFAULT_NA)) {
                phyAddrValue = MAC_DEFAULT_NA_HEXVALUE;
            }
            baseParam.putSelectPhyAddrValueMap(macName, phyAddrValue);
            ++macIndex;
        }
        macIndex = 0;
        while (macIndex < this.comboGpioGroupNumList.size()) {
            macName = "MAC" + macIndex;
            Combo comboGpioGroupNum = this.comboGpioGroupNumList.get(macIndex);
            String gpioGroupValue = comboGpioGroupNum.getText();
            if (gpioGroupValue.equalsIgnoreCase(MAC_DEFAULT_DEFAULT)) {
                gpioGroupValue = MAC_DEFAULT_NA_VALUE;
            }
            baseParam.putSelectGpioGroupNumValueMap(macName, gpioGroupValue);
            ++macIndex;
        }
        macIndex = 0;
        while (macIndex < this.comboGpioBitsNumList.size()) {
            macName = "MAC" + macIndex;
            Combo comboGpioBitsNum = this.comboGpioBitsNumList.get(macIndex);
            String GpioBitsNumValue = comboGpioBitsNum.getText();
            if (GpioBitsNumValue.equalsIgnoreCase(MAC_DEFAULT_DEFAULT)) {
                GpioBitsNumValue = MAC_DEFAULT_NA_VALUE;
            }
            baseParam.putSelectGpioBitsValueMap(macName, GpioBitsNumValue);
            ++macIndex;
        }
        if (this.comboDdrType != null && !this.comboDdrType.isDisposed()) {
            selectionIndex = this.comboDdrType.getSelectionIndex();
            String selectDdrType = null;
            if (selectionIndex != -1) {
                try {
                    selectDdrType = this.comboDdrType.getItem(selectionIndex);
                }
                catch (Exception e) {
                    baseParam.setSelectDdrType(selectDdrType);
                }
            }
            baseParam.setSelectDdrType(selectDdrType);
        } else if (this.textDdrType != null && !this.textDdrType.isDisposed()) {
            baseParam.setSelectDdrType(this.textDdrType.getText());
        }
        if (this.comboDdrPhy != null && !this.comboDdrPhy.isDisposed()) {
            selectionIndex = this.comboDdrPhy.getSelectionIndex();
            String selectDdrPhy = null;
            if (selectionIndex != -1) {
                try {
                    selectDdrPhy = this.comboDdrPhy.getItem(selectionIndex);
                }
                catch (Exception e) {
                    baseParam.setSelectDdrPhy(selectDdrPhy);
                }
            }
            baseParam.setSelectDdrPhy(selectDdrPhy);
        }
        CAConfig selectCA = null;
        if (this.btnCA != null && !this.btnCA.isDisposed() && this.btnCA.getSelection()) {
            selectCA = CAConfig.CA;
        }
        if (this.btnNoCA != null && !this.btnNoCA.isDisposed() && this.btnNoCA.getSelection()) {
            selectCA = CAConfig.noCA;
        }
        baseParam.setSelectCA(selectCA);
        baseParam.setSelectDemoName(this.selectDemoName);
        this.getSetting().setParamObj(baseParam);
        return baseParam;
    }

    private String[] listToArray(List<String> list) {
        String[] resStrings = new String[list.size()];
        int i = 0;
        while (i < list.size()) {
            String value;
            resStrings[i] = value = list.get(i);
            ++i;
        }
        return resStrings;
    }

    @Override
    public PrepareSetting getSetting() {
        return (PrepareSetting)super.getSetting();
    }

    public Button getBtnCA() {
        return this.btnCA;
    }

    public Button getBtnNoCA() {
        return this.btnNoCA;
    }

    public Button getBtnDdrRegisterInfo() {
        return this.btnDdrRegisterInfo;
    }

    @Override
    protected boolean checkAllValidValue() {
        for (Text phyAddressText : this.textPhyAddressList) {
            if (phyAddressText.isDisposed()) continue;
            String phyAddressTextValue = phyAddressText.getText();
            if (phyAddressTextValue == null || phyAddressTextValue.equals("")) {
                MessageDialog.openInformation((Shell)this.getShell(), (String)Messages.Message_Warning, (String)NLS.bind((String)Messages.ValidityCheck_Address, (Object)Messages.BaseSettingComposite_Phy_Address));
                return false;
            }
            if (phyAddressTextValue.equalsIgnoreCase(MAC_DEFAULT_NA)) {
                phyAddressTextValue = MAC_DEFAULT_NA_HEXVALUE;
            }
            if (BaseSettingComposite.isValidHexString(phyAddressTextValue)) continue;
            MessageDialog.openInformation((Shell)this.getShell(), (String)Messages.Message_Warning, (String)NLS.bind((String)Messages.ValidityCheck_Must_Hex_Number, (Object)Messages.BaseSettingComposite_Phy_Address));
            return false;
        }
        for (Combo gpioGroupText : this.comboGpioGroupNumList) {
            if (!gpioGroupText.getEnabled()) continue;
            if (gpioGroupText.getText() == null || gpioGroupText.getText().equals("")) {
                MessageDialog.openInformation((Shell)this.getShell(), (String)Messages.Message_Warning, (String)NLS.bind((String)Messages.ValidityCheck_Address, (Object)Messages.BaseSettingComposite_GPIO_Group_Number));
                return false;
            }
            if (this.checkComboValue(gpioGroupText, 0, 255)) continue;
            MessageDialog.openWarning((Shell)Display.getCurrent().getActiveShell(), (String)Messages.Message_Warning, (String)(String.valueOf(Messages.BaseSettingComposite_GPIO_Group_Number) + Messages.ValidityCheck_EnterIntNumbers_Range + String.valueOf(0) + " " + Messages.ValidityCheck_EnterIntNumbers_To + " " + String.valueOf(255) + "!"));
            return false;
        }
        for (Combo gpioBitsText : this.comboGpioBitsNumList) {
            if (!gpioBitsText.getEnabled()) continue;
            if (gpioBitsText.getText() == null || gpioBitsText.getText().equals("")) {
                MessageDialog.openInformation((Shell)this.getShell(), (String)Messages.Message_Warning, (String)NLS.bind((String)Messages.ValidityCheck_Address, (Object)Messages.BaseSettingComposite_GPIO_Bit_Number));
                return false;
            }
            if (this.checkComboValue(gpioBitsText, 0, 255)) continue;
            MessageDialog.openWarning((Shell)Display.getCurrent().getActiveShell(), (String)Messages.Message_Warning, (String)(String.valueOf(Messages.BaseSettingComposite_GPIO_Bit_Number) + Messages.ValidityCheck_EnterIntNumbers_Range + String.valueOf(0) + " " + Messages.ValidityCheck_EnterIntNumbers_To + " " + String.valueOf(255) + "!"));
            return false;
        }
        return true;
    }

    @Override
    protected Control createControl(Composite parent) {
        return null;
    }

    public ArrayList<Combo> getComboDdrParamList() {
        return this.comboDdrParamList;
    }

    public ArrayList<Combo> getComboMacList() {
        return this.comboMacList;
    }

    public ArrayList<Combo> getComboGpioGroupNumList() {
        return this.comboGpioGroupNumList;
    }

    public ArrayList<Combo> getComboGpioBitsNumList() {
        return this.comboGpioBitsNumList;
    }

    public ArrayList<Text> getTextPhyAddressList() {
        return this.textPhyAddressList;
    }

    public Combo getComboDdrPhy() {
        return this.comboDdrPhy;
    }

    public Combo getComboDdrType() {
        return this.comboDdrType;
    }

    static /* synthetic */ PanelComposite access$1(BaseSettingComposite baseSettingComposite) {
        return baseSettingComposite.panelComposite;
    }

    static /* synthetic */ void access$2(BaseSettingComposite baseSettingComposite, String string) {
        baseSettingComposite.volDvdd = string;
    }

    static /* synthetic */ String access$3(BaseSettingComposite baseSettingComposite) {
        return baseSettingComposite.volDvdd;
    }

    static /* synthetic */ Combo access$4(BaseSettingComposite baseSettingComposite) {
        return baseSettingComposite.comboDdrPhy;
    }

    static /* synthetic */ Combo access$5(BaseSettingComposite baseSettingComposite) {
        return baseSettingComposite.comboDdrType;
    }

    static /* synthetic */ ArrayList access$6(BaseSettingComposite baseSettingComposite) {
        return baseSettingComposite.comboDdrParamList;
    }

    static /* synthetic */ String access$7(BaseSettingComposite baseSettingComposite) {
        return baseSettingComposite.selectDemoName;
    }

    static /* synthetic */ String access$8(BaseSettingComposite baseSettingComposite, ParsedMainData parsedMainData, String string, PinDemuxType pinDemuxType, String string2) {
        return baseSettingComposite.updateDDRTypeForUI(parsedMainData, string, pinDemuxType, string2);
    }

    static /* synthetic */ void access$9(BaseSettingComposite baseSettingComposite, ParsedMainData parsedMainData, String string, String string2, String string3) {
        baseSettingComposite.updateDdrFreqForUI(parsedMainData, string, string2, string3);
    }

    static /* synthetic */ void access$10(BaseSettingComposite baseSettingComposite, boolean bl, int n, ArrayList arrayList, PinDemuxType pinDemuxType) {
        baseSettingComposite.checkCurrentDemoState(bl, n, arrayList, pinDemuxType);
    }

    static /* synthetic */ ArrayList access$11(BaseSettingComposite baseSettingComposite) {
        return baseSettingComposite.comboGpioGroupNumList;
    }

    static /* synthetic */ ArrayList access$12(BaseSettingComposite baseSettingComposite) {
        return baseSettingComposite.comboGpioBitsNumList;
    }

    static /* synthetic */ Button access$13(BaseSettingComposite baseSettingComposite) {
        return baseSettingComposite.btnCA;
    }

    static /* synthetic */ Button access$14(BaseSettingComposite baseSettingComposite) {
        return baseSettingComposite.btnNoCA;
    }
}

