/*
 * Decompiled with CFR 0.152.
 */
package com.hisilicon.hiregbin.ui;

import com.hisilicon.hiregbin.Messages;
import com.hisilicon.hiregbin.model.BaseParam;
import com.hisilicon.hiregbin.model.BatchParameter;
import com.hisilicon.hiregbin.model.GlobleInfo;
import com.hisilicon.hiregbin.model.Setting;
import com.hisilicon.hiregbin.model.reg.DemoBaseParam;
import com.hisilicon.hiregbin.model.reg.ParsedMainData;
import com.hisilicon.hiregbin.model.reg.PinDemuxInfo;
import com.hisilicon.hiregbin.model.reg.excel.ExcelData;
import com.hisilicon.hiregbin.model.reg.hi98cv200bin.BinData;
import com.hisilicon.hiregbin.model.reg.hi98cv200bin.MultiperTable;
import com.hisilicon.hiregbin.preferences.PanelPreferences;
import com.hisilicon.hiregbin.processor.PrepareSetting;
import com.hisilicon.hiregbin.ui.MultiperTableComposite;
import com.hisilicon.hiregbin.ui.PanelComposite;
import com.hisilicon.hiregbin.ui.ReplaceRegDialog;
import com.hisilicon.hiregbin.utility.BitUtils;
import com.hisilicon.hiregbin.utility.BytesArrayUtils;
import com.hisilicon.hiregbin.utility.BytesUtils;
import com.hisilicon.hiregbin.utility.ExcelDataHelper;
import com.hisilicon.hiregbin.utility.FileUtils;
import com.hisilicon.hiregbin.utility.HiToolUtils;
import com.hisilicon.hiregbin.views.RegbinView;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.lang.reflect.InvocationTargetException;
import java.nio.ByteOrder;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public abstract class AbstractBaseComposite
extends Composite {
    protected static final int TEXT_LIMIT_4 = 4;
    protected static final int TEXT_LIMIT_8 = 8;
    public static final int HORIZONTAL_0 = 0;
    public static final int HORIZONTAL_1 = 1;
    public static final int HORIZONTAL_2 = 2;
    public static final int HORIZONTAL_15 = 15;
    public static final int HORIZONTAL_20 = 20;
    public static final int HORIZONTAL_30 = 30;
    public static final int DEMO_NAME_NUM = 30;
    public static final int WIDTH_HINT_70 = 70;
    public static final int WIDTH_HINT_80 = 80;
    public static final String UNDER_LINE = "_";
    public static final int CHIP_NAME_SIZE = 7;
    public static final int TEXT_LIMIT_32 = 32;
    protected static final int FASTBOOT_REGBIN_START = 64;
    protected static final int FASTBOOT_REGBIN_LEN = 8192;
    public static final int HLS_FLAG = 528;
    public static final int KEY_RIGHTS = 1014535725;
    public static final int MULTI_FORM_FLAG_98MV310 = 1064;
    public static final int MULTI_FORM_FLAG_96CV300 = 67632;
    public static final int FORM_LEN = 1068;
    public static final int FORM_NUMBER = 1072;
    public static final int MULTI_FORM_FLAG = 12256;
    public static final int FORM_ADDR_FLAG = 12260;
    public static final int FORM_LEN_FLAG_98MV310 = 10752;
    public static final int FORM_LEN_FLAG_96CV300 = 67636;
    public static final int SINGLE_FORM_LEN_96CV300 = 10240;
    public static final int HEAD_DATA_96CV300 = 16;
    public static final int FORM_LEN_FLAG = 12264;
    public static final int DEFAULT_FORM_LEN_FLAG_98MV310 = 1200;
    public static final int DEFAULT_FORM_LEN_FLAG_96CV300 = 67776;
    public static final int DEFAULT_FORM_LEN_FLAG = 1152;
    public static final int MULTIPER_MAX_COUNT = 6;
    public static final int MULTI_FORM_FLAG_VALUE = -2088414648;
    public static final int HSL = 65536;
    public static final int DEFAULT_FORM_LEN_FLAG_Hi3796MV200 = 66736;
    public static final int SECURITY_FLAG = 1036;
    public static final int HEAD_AREA_LENGTH = 12288;
    public static final int AUX_AREA_LENGTH = 536;
    public static final int AUX_AREA_LENGTH_3716mv430 = 532;
    public static final int RESERVED_AREA_LENGTH = 536;
    public static final int BOOT_AREA_LENGTH = 1032;
    public static final int SECURITY_MULIT_FLAG = -2088414648;
    public static final int SECURITY_FORM_LEN_FLAG = 1040;
    protected static final Pattern hexDataPatternWithPerfix = Pattern.compile("0x[0-9a-fA-F]{1,8}");
    protected static final Pattern hexDataPattern = Pattern.compile("[0-9a-fA-F]{1,8}");
    protected static final Pattern EnglishAndNumberPattern = Pattern.compile("[0-9a-zA-Z_-]{1,32}");
    protected static final Pattern ChinesePattern = Pattern.compile("[\u4e00-\u9fa5]");
    private static Button btnMakeRegBin;
    private static Button btnMakeCfgBin;
    private static Button btnReplaceFastboot;
    private static Button btnExportExcel;
    private static ExcelData currentExcelData;
    protected Setting setting;
    protected String customDemoName;
    private String exportErrString = "";
    protected String lastInputBoot;
    private String lastOutputBoot;
    protected MultiperTableComposite multiperTableComposite;

    public AbstractBaseComposite(Composite parent, Setting setting) {
        super(parent, 0);
        this.setting = setting;
        this._setLayout((Layout)new GridLayout());
        this.createContents(this);
    }

    private void createContents(Composite parent) {
        Control control = this.createControl(parent);
        if (control != null) {
            control.setBackground(GlobleInfo.white);
            control.setLayoutData((Object)new GridData(1808));
        }
        if (RegbinView.isHi3716V550Series()) {
            return;
        }
        if (this instanceof PanelComposite) {
            PanelComposite panelComposite = (PanelComposite)this;
            Composite buttonArea = new Composite(parent, 0);
            buttonArea.setLayoutData((Object)new GridData(4, 1, true, false));
            buttonArea.setBackground(GlobleInfo.white);
            GridData gridData = new GridData(576);
            if (ExcelDataHelper.isV120RegFomatVersion(ExcelDataHelper.getExcelData())) {
                Button btnImportFastbootBin = new Button(buttonArea, 0);
                btnImportFastbootBin.setText(Messages.PanelComposite_Import_From_Fastboot);
                gridData = new GridData(576);
                gridData.widthHint = 130;
                btnImportFastbootBin.setLayoutData((Object)gridData);
                btnImportFastbootBin.addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent e) {
                        if (RegbinView.isNotLoadImportExcelDataSuccess()) {
                            MessageDialog.openInformation((Shell)AbstractBaseComposite.this.getShell(), (String)Messages.Message_Warning, (String)Messages.PanelComposite_Wait_Import_ExcelData_Load_Success);
                            return;
                        }
                        BaseParam baseParam = new BaseParam();
                        Object paramObj = AbstractBaseComposite.this.getParam(baseParam, ".reg");
                        if (!AbstractBaseComposite.this.tipNeedSaveData(paramObj)) {
                            panelComposite.openRegBinFromFastboot();
                            panelComposite.importRefreshBtnState();
                            AbstractBaseComposite.setCurrentExcelData(ExcelDataHelper.getExcelDataforImport());
                        }
                    }
                });
                Button btnMakeFastboot = new Button(buttonArea, 0);
                btnMakeFastboot.setText(Messages.AbstractBaseComposite_ReplaceFastboot);
                btnMakeFastboot.addListener(13, (Listener)new ReplaceFastbootRegBinListener());
                btnMakeFastboot.setLayoutData((Object)gridData);
                GridLayout gridLayout = new GridLayout(3, false);
                buttonArea.setLayoutData((Object)new GridData(576));
                buttonArea.setLayout((Layout)gridLayout);
            } else {
                GridLayout gridLayout = new GridLayout(4, false);
                buttonArea.setLayoutData((Object)new GridData(576));
                buttonArea.setLayout((Layout)gridLayout);
                AbstractBaseComposite.setBtnMakeRegBin(new Button(buttonArea, 0));
                btnMakeRegBin.setText(Messages.AbstractBaseComposite_MakeRegBin);
                gridData.widthHint = 130;
                btnMakeRegBin.setLayoutData((Object)gridData);
                btnMakeRegBin.setEnabled(false);
                btnMakeRegBin.addListener(13, (Listener)new MakeRegBinListener());
                btnMakeCfgBin = new Button(buttonArea, 0);
                btnMakeCfgBin.setText(Messages.AbstractBaseComposite_MakeCfgBin);
                gridData = new GridData(576);
                gridData.widthHint = 130;
                btnMakeCfgBin.setLayoutData((Object)gridData);
                btnMakeCfgBin.setEnabled(false);
                btnMakeCfgBin.addListener(13, (Listener)new MakeCfgBinListener());
                btnReplaceFastboot = new Button(buttonArea, 0);
                btnReplaceFastboot.setText(Messages.AbstractBaseComposite_ReplaceFastboot);
                gridData = new GridData(576);
                gridData.widthHint = 130;
                btnReplaceFastboot.setLayoutData((Object)gridData);
                btnReplaceFastboot.setEnabled(false);
                btnReplaceFastboot.addListener(13, (Listener)new ReplaceFastbootRegBinListener());
                btnExportExcel = new Button(buttonArea, 0);
                btnExportExcel.setText(Messages.AbstractBaseComposite_ExportExcel);
                gridData = new GridData(576);
                gridData.widthHint = 130;
                btnExportExcel.setEnabled(false);
                btnExportExcel.setLayoutData((Object)gridData);
                btnExportExcel.addListener(13, (Listener)new ExportExcelListener());
            }
        }
    }

    protected static void changeControlListener(Control control) {
        control.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                GlobleInfo.setNeedSave(true);
            }
        });
        control.addListener(24, new Listener(){

            public void handleEvent(Event event) {
                GlobleInfo.setNeedSave(true);
            }
        });
    }

    public Setting getSetting() {
        return this.setting;
    }

    protected void setParam(int ddrCapacityItemIndex, int starupItemIndex) {
    }

    protected Object getParam(BaseParam baseParam, String regOrCfg) {
        return null;
    }

    protected PinDemuxInfo getPinDemuxParam() {
        return null;
    }

    protected abstract Control createControl(Composite var1);

    public void _setLayout(Layout layout) {
        super.setLayout(layout);
    }

    public void setLayout(Layout layout) {
    }

    public static void addLosesfocus(Control contorl) {
        contorl.addFocusListener(new FocusListener(){

            public void focusLost(FocusEvent e) {
                AbstractBaseComposite.setCurrentParam((Control)e.getSource());
            }

            public void focusGained(FocusEvent e) {
            }
        });
    }

    private static void setCurrentParam(Control control) {
        if (control instanceof Text) {
            Text text = (Text)control;
            text.setText(((Text)control).getText());
        }
        if (control instanceof Combo) {
            Combo combo = (Combo)control;
            combo.select(combo.getSelectionIndex());
        }
        if (control instanceof Button) {
            Button button = (Button)control;
            button.setSelection(button.getSelection());
        }
    }

    protected static GridData fillHorizontalCombo(Control control) {
        GridData layoutData = null;
        if (HiToolUtils.isLinux()) {
            layoutData = new GridData(1, 1, false, false);
            layoutData.widthHint = 115;
        } else {
            layoutData = new GridData(1, 1, false, false);
        }
        layoutData.minimumWidth = 75;
        control.setLayoutData((Object)layoutData);
        return layoutData;
    }

    protected static GridData fillHorizontalText(Control control, int widthHint) {
        GridData layoutData = new GridData(1, 1, false, false);
        layoutData.widthHint = widthHint;
        control.setLayoutData((Object)layoutData);
        return layoutData;
    }

    protected static GridData fillHorizontalLabel(Control control, int horizontalIndent) {
        control.setBackground(GlobleInfo.white);
        GridData layoutData = new GridData();
        layoutData.horizontalIndent = horizontalIndent;
        control.setLayoutData((Object)layoutData);
        return layoutData;
    }

    protected boolean checkExitBeforeSave(String savePath) {
        File saveFile = new File(savePath);
        int open = 1;
        while (saveFile != null && saveFile.exists() && open == 1) {
            MessageDialog dialog = new MessageDialog(this.getShell(), Messages.Message_HiRegBin, null, NLS.bind((String)Messages.Composite_msg_file_exists_already_whether_to_overwrite_it, (Object)saveFile.getAbsolutePath()), 6, new String[]{IDialogConstants.YES_LABEL, IDialogConstants.NO_LABEL}, 0);
            open = dialog.open();
            if (open != 1) continue;
            return false;
        }
        return open != 2;
    }

    protected File replaceFastbootRegBin(File fastbootFile, File regbinFile, int replaceStart, int replaceLen) {
        RandomAccessFile inFile = null;
        RandomAccessFile outFile = null;
        File tmpFile = null;
        try {
            try {
                inFile = new RandomAccessFile(regbinFile, "r");
                String regBinFileName = "";
                String fastbootPath = fastbootFile.getAbsolutePath();
                regBinFileName = fastbootPath.endsWith(".bin") ? String.valueOf(fastbootPath.substring(0, fastbootPath.indexOf(".bin"))) + ".new.bin" : String.valueOf(fastbootFile.getAbsolutePath()) + "new.bin";
                tmpFile = new File(regBinFileName);
                int regBinFileLen = (int)regbinFile.length();
                byte[] regBinFileData = new byte[regBinFileLen];
                inFile.seek(0L);
                inFile.read(regBinFileData);
                if (tmpFile.exists()) {
                    FileUtils.deleteFile(tmpFile);
                }
                FileUtils.copy(fastbootFile, tmpFile);
                outFile = new RandomAccessFile(tmpFile, "rw");
                outFile.seek(replaceStart);
                outFile.write(BitUtils.genBytesWithZero(replaceLen));
                outFile.seek(replaceStart);
                outFile.write(regBinFileData, 0, regBinFileLen);
            }
            catch (Exception e) {
                e.printStackTrace();
                if (inFile != null) {
                    try {
                        inFile.close();
                    }
                    catch (IOException e2) {
                        e2.printStackTrace();
                    }
                }
                if (outFile != null) {
                    try {
                        outFile.close();
                    }
                    catch (IOException e3) {
                        e3.printStackTrace();
                    }
                }
                return null;
            }
        }
        finally {
            if (inFile != null) {
                try {
                    inFile.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            if (outFile != null) {
                try {
                    outFile.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        return tmpFile;
    }

    protected boolean checkInfo(Object objParam) {
        return false;
    }

    protected File readFastbootRegBin(String filePath, int readStart, int readLen) {
        RandomAccessFile inFile = null;
        RandomAccessFile outFile = null;
        File tmpFile = null;
        try {
            try {
                File file = new File(filePath);
                inFile = new RandomAccessFile(file, "r");
                String hiToolPath = HiToolUtils.getInstallPath();
                tmpFile = new File(String.valueOf(hiToolPath) + File.separator + file.getName() + ".tmp");
                byte[] regBinFileData = new byte[readLen];
                inFile.seek(readStart);
                int readLength = inFile.read(regBinFileData);
                if (tmpFile.exists()) {
                    FileUtils.deleteFile(tmpFile);
                }
                outFile = new RandomAccessFile(tmpFile, "rw");
                outFile.seek(0L);
                outFile.write(regBinFileData, 0, readLength);
            }
            catch (Exception e) {
                e.printStackTrace();
                if (inFile != null) {
                    try {
                        inFile.close();
                    }
                    catch (IOException e2) {
                        e2.printStackTrace();
                    }
                }
                if (outFile != null) {
                    try {
                        outFile.close();
                    }
                    catch (IOException e3) {
                        e3.printStackTrace();
                    }
                }
                return null;
            }
        }
        finally {
            if (inFile != null) {
                try {
                    inFile.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            if (outFile != null) {
                try {
                    outFile.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        return tmpFile;
    }

    protected boolean isRefreshPinDemuxComsite() {
        return MessageDialog.openQuestion((Shell)this.getShell(), (String)Messages.Message_Information, (String)Messages.PinDemuxComposite_Refresh);
    }

    protected boolean tipNeedSaveData(Object paramObj) {
        if (GlobleInfo.isNeedSave()) {
            BaseParam baseParam;
            String tipString = "Reg.bin";
            if (paramObj == null) {
                GlobleInfo.setNeedSave(false);
                return false;
            }
            if (paramObj instanceof BaseParam && ((baseParam = (BaseParam)paramObj).getSelectDdrType() == null || baseParam.getSelectDemoName() == null)) {
                GlobleInfo.setNeedSave(false);
                return false;
            }
            boolean openConfirm = MessageDialog.openQuestion((Shell)this.getShell(), (String)Messages.Message_Information, (String)(String.valueOf(Messages.AbstractBaseComposite_TipNeedSave) + tipString));
            if (openConfirm) {
                Event e = new Event();
                btnMakeRegBin.notifyListeners(13, e);
                GlobleInfo.setNeedSave(false);
                return true;
            }
            GlobleInfo.setNeedSave(false);
            return false;
        }
        return false;
    }

    protected boolean checkParseMainData(ParsedMainData parsedMainData) {
        ArrayList<DemoBaseParam> chipBaseParamList = parsedMainData.getDemoList();
        int demoSize = chipBaseParamList.size();
        if (demoSize > 30) {
            MessageDialog.openError((Shell)this.getShell(), (String)Messages.Message_Error, (String)Messages.PanelComposite_DemoNameNumber_Error);
            return false;
        }
        return true;
    }

    protected boolean checkHexTextValue(Text text, int min, int max) {
        String textStr = text.getText();
        if (!textStr.isEmpty()) {
            int hexValue = 0;
            if (textStr.startsWith("0x")) {
                textStr = textStr.substring(2);
                hexValue = Integer.parseInt(textStr, 16);
                if (textStr.length() >= String.valueOf(Integer.MAX_VALUE).length()) {
                    return false;
                }
                if (hexValue < min || hexValue > max) {
                    return false;
                }
            } else {
                if (text.getText().length() >= String.valueOf(Integer.MAX_VALUE).length()) {
                    return false;
                }
                Integer value = Integer.valueOf(textStr, 16);
                if (value < min || value > max) {
                    return false;
                }
            }
        }
        return true;
    }

    protected boolean checkStringTextLen(Text text, int minLen, int maxLen) {
        String textStr = text.getText();
        return textStr.isEmpty() || text.getText().length() <= maxLen;
    }

    protected boolean checkTextValue(Text text, int min, int max) {
        String textStr = text.getText();
        if (textStr.equalsIgnoreCase("NA") || textStr.equalsIgnoreCase("Default")) {
            textStr = "255";
        }
        if (!textStr.isEmpty()) {
            if (text.getText().length() >= String.valueOf(Integer.MAX_VALUE).length()) {
                return false;
            }
            Integer value = Integer.valueOf(textStr);
            if (value < min || value > max) {
                return false;
            }
        }
        return true;
    }

    protected boolean checkComboValue(Combo combo, int min, int max) {
        String textStr = combo.getText();
        if (textStr.equalsIgnoreCase("NA") || textStr.equalsIgnoreCase("Default")) {
            textStr = "255";
        }
        if (!textStr.isEmpty()) {
            if (combo.getText().length() >= String.valueOf(Integer.MAX_VALUE).length()) {
                return false;
            }
            Integer value = Integer.valueOf(textStr);
            if (value < min || value > max) {
                return false;
            }
        }
        return true;
    }

    protected boolean checkAllValidValue() {
        return true;
    }

    public static boolean isValidHexString(String hexString, boolean withPrefix) {
        if (withPrefix) {
            return hexDataPatternWithPerfix.matcher(hexString).matches();
        }
        return hexDataPattern.matcher(hexString).matches();
    }

    public static boolean isValidHexString(String str) {
        return AbstractBaseComposite.isValidHexString(str, false) || AbstractBaseComposite.isValidHexString(str, true);
    }

    public void setCustomDemoName(String customDemoName) {
        this.customDemoName = customDemoName;
    }

    public static ExcelData getCurrentExcelData() {
        return currentExcelData;
    }

    public static void setCurrentExcelData(ExcelData currentExcelData) {
        AbstractBaseComposite.currentExcelData = currentExcelData;
    }

    public static Button getBtnMakeRegBin() {
        return btnMakeRegBin;
    }

    public static void setBtnMakeRegBin(Button btnMakeRegBin) {
        AbstractBaseComposite.btnMakeRegBin = btnMakeRegBin;
    }

    public static void setBtnMakeRegBinEnable(boolean bool) {
        if (btnMakeRegBin != null && !btnMakeRegBin.isDisposed()) {
            btnMakeRegBin.setEnabled(bool);
        }
    }

    public static void setBtnMakeCfgBinEnable(boolean bool) {
        if (btnMakeCfgBin != null && !btnMakeCfgBin.isDisposed()) {
            btnMakeCfgBin.setEnabled(bool);
        }
    }

    public static void setBtnReplaceFastbootEnable(boolean bool) {
        if (btnReplaceFastboot != null && !btnReplaceFastboot.isDisposed()) {
            btnReplaceFastboot.setEnabled(bool);
        }
    }

    public static void setBtnExportExcelEnable(boolean bool) {
        if (btnExportExcel != null && !btnExportExcel.isDisposed()) {
            btnExportExcel.setEnabled(bool);
        }
    }

    protected String[] initDemoName(ParsedMainData parsedMainData) {
        if (parsedMainData == null) {
            return null;
        }
        ArrayList<DemoBaseParam> chipBaseParamList = parsedMainData.getDemoList();
        int demoSize = chipBaseParamList.size();
        String[] demoNames = new String[demoSize];
        int i = 0;
        while (i < demoSize) {
            demoNames[i] = chipBaseParamList.get(i).getDemoName();
            ++i;
        }
        return demoNames;
    }

    protected void setCurrentDemo(String demoName) {
    }

    public void setMultiperTableComposite(MultiperTableComposite multiperTableComposite) {
        this.multiperTableComposite = multiperTableComposite;
    }

    protected BatchParameter initUi() {
        return null;
    }

    protected int getHi3716MV430TableStartAddr(byte[] inputBootBuffer) {
        int formLenFlag = 0;
        int hlsLen = 0;
        byte[] keyRightsFlagBytes = BytesUtils.genSubBytes(inputBootBuffer, 528, 4);
        int keyRightsValue = BytesArrayUtils.getInt(keyRightsFlagBytes, 0, ByteOrder.LITTLE_ENDIAN);
        if (keyRightsValue != 1014535725) {
            hlsLen = 65536;
        }
        formLenFlag += hlsLen;
        formLenFlag += 12288;
        byte[] auxAreaLenBytes = BytesUtils.genSubBytes(inputBootBuffer, 532 + hlsLen, 4);
        int auxAreaLenValue = BytesArrayUtils.getInt(auxAreaLenBytes, 0, ByteOrder.LITTLE_ENDIAN);
        formLenFlag += auxAreaLenValue;
        byte[] reservedAreaLenBytes = BytesUtils.genSubBytes(inputBootBuffer, 536 + hlsLen, 4);
        int reservedAreaLenValue = BytesArrayUtils.getInt(reservedAreaLenBytes, 0, ByteOrder.LITTLE_ENDIAN);
        formLenFlag += reservedAreaLenValue;
        byte[] hashAreaLenBytes = BytesUtils.genSubBytes(inputBootBuffer, 1032 + hlsLen, 4);
        int hashAreaLenValue = BytesArrayUtils.getInt(hashAreaLenBytes, 0, ByteOrder.LITTLE_ENDIAN);
        return formLenFlag += hashAreaLenValue;
    }

    protected int getHi3796CV300TableStartAddr(byte[] inputBootBuffer) {
        int HEAD_DATA = 16;
        int mTableStart = 0;
        int hlsLen = 65536;
        mTableStart = 1024 + hlsLen;
        mTableStart += 12288;
        int bootLengthFlag = 67608;
        byte[] bootLengthByte = BytesUtils.genSubBytes(inputBootBuffer, bootLengthFlag, 4);
        int bootLength = BytesArrayUtils.getInt(bootLengthByte, 0, ByteOrder.LITTLE_ENDIAN);
        mTableStart += bootLength;
        return mTableStart += 16;
    }

    static /* synthetic */ ExcelData access$0() {
        return currentExcelData;
    }

    static /* synthetic */ String access$1(AbstractBaseComposite abstractBaseComposite) {
        return abstractBaseComposite.lastOutputBoot;
    }

    static /* synthetic */ void access$2(AbstractBaseComposite abstractBaseComposite, String string) {
        abstractBaseComposite.lastOutputBoot = string;
    }

    static /* synthetic */ void access$3(AbstractBaseComposite abstractBaseComposite, String string) {
        abstractBaseComposite.exportErrString = string;
    }

    static /* synthetic */ String access$4(AbstractBaseComposite abstractBaseComposite) {
        return abstractBaseComposite.exportErrString;
    }

    static /* synthetic */ void access$5(Control control) {
        AbstractBaseComposite.setCurrentParam(control);
    }

    private final class ExportExcelListener
    implements Listener {
        private ExportExcelListener() {
        }

        public void handleEvent(Event event) {
            Setting setting = AbstractBaseComposite.this.getSetting();
            this.saveInFileSystem(setting);
        }

        public void saveInFileSystem(final Setting setting) {
            if (!this.prepareWork()) {
                return;
            }
            FileDialog dialog = new FileDialog(AbstractBaseComposite.this.getShell(), 8192);
            dialog.setFilterExtensions(new String[]{"*.xlsx", "*.*"});
            dialog.setFilterNames(new String[]{"*.xlsx"});
            if (!AbstractBaseComposite.this.customDemoName.endsWith(".xlsx")) {
                AbstractBaseComposite.this.customDemoName = AbstractBaseComposite.this.customDemoName.concat(".xlsx");
            }
            dialog.setFileName(AbstractBaseComposite.this.customDemoName);
            final String savePath = dialog.open();
            if (savePath != null) {
                boolean checkExitBeforeSaveResult = AbstractBaseComposite.this.checkExitBeforeSave(savePath);
                if (checkExitBeforeSaveResult) {
                    ProgressMonitorDialog progress = new ProgressMonitorDialog(null);
                    try {
                        progress.run(true, false, new IRunnableWithProgress(){

                            public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                                monitor.beginTask(NLS.bind((String)Messages.PanelComposite_Export_TempFile, (Object)new File(savePath).getName()), -1);
                                monitor.setTaskName(NLS.bind((String)Messages.PanelComposite_Export_TempFile, (Object)new File(savePath).getName()));
                                IStatus create = Status.CANCEL_STATUS;
                                PrepareSetting prepareSetting = (PrepareSetting)setting;
                                try {
                                    create = prepareSetting.exportExcel(savePath, currentExcelData);
                                }
                                catch (IOException e) {
                                    e.printStackTrace();
                                    AbstractBaseComposite.this.exportErrString = e.getMessage();
                                }
                                if (create == null || create.isOK()) {
                                    Display.getDefault().syncExec(new Runnable(){

                                        @Override
                                        public void run() {
                                            MessageDialog.openInformation((Shell)AbstractBaseComposite.this.getShell(), (String)Messages.Message_HiRegBin, (String)Messages.Message_Export_Success);
                                        }
                                    });
                                } else {
                                    Display.getDefault().syncExec(new Runnable(){

                                        @Override
                                        public void run() {
                                            MessageDialog.openError((Shell)AbstractBaseComposite.this.getShell(), (String)Messages.Message_HiRegBin, (String)AbstractBaseComposite.this.exportErrString);
                                        }
                                    });
                                }
                                monitor.done();
                            }
                        });
                    }
                    catch (InvocationTargetException e) {
                        e.printStackTrace();
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                } else {
                    return;
                }
            }
        }

        private boolean prepareWork() {
            boolean bool = true;
            if (AbstractBaseComposite.this instanceof PanelComposite && !(bool = AbstractBaseComposite.this.checkAllValidValue())) {
                return false;
            }
            BaseParam baseParam = new BaseParam();
            Object paramObj = AbstractBaseComposite.this.getParam(baseParam, ".xlsx");
            if (paramObj == null) {
                MessageDialog.openError((Shell)AbstractBaseComposite.this.getShell(), (String)Messages.Message_HiRegBin, (String)Messages.AbstractBaseComposite_GetDemoInfo);
                return false;
            }
            return true;
        }
    }

    private final class MakeCfgBinListener
    implements Listener {
        private MakeCfgBinListener() {
        }

        public void handleEvent(Event event) {
            Setting setting = AbstractBaseComposite.this.getSetting();
            this.saveInFileSystem(setting);
        }

        public void saveInFileSystem(Setting setting) {
            if (!this.prepareWork()) {
                return;
            }
            FileDialog dialog = new FileDialog(AbstractBaseComposite.this.getShell(), 8192);
            dialog.setFilterExtensions(new String[]{"*.cfg", "*.*"});
            dialog.setFilterNames(new String[]{"*.cfg"});
            if (!(AbstractBaseComposite.this.customDemoName.contains("_spi") || AbstractBaseComposite.this.customDemoName.contains("_nand") || AbstractBaseComposite.this.customDemoName.contains("_emmc"))) {
                BaseParam baseParam = new BaseParam();
                AbstractBaseComposite.this.getParam(baseParam, ".cfg");
                String selectStartup = baseParam.getSelectStartup();
                if (selectStartup != null && AbstractBaseComposite.this.customDemoName.contains("layers")) {
                    AbstractBaseComposite.this.customDemoName = AbstractBaseComposite.this.customDemoName.replaceFirst("layers", "layers_" + selectStartup);
                }
            }
            if (!AbstractBaseComposite.this.customDemoName.endsWith(".cfg")) {
                AbstractBaseComposite.this.customDemoName = AbstractBaseComposite.this.customDemoName.concat(".cfg");
            }
            dialog.setFileName(AbstractBaseComposite.this.customDemoName);
            String savePath = dialog.open();
            if (savePath != null) {
                boolean checkExitBeforeSaveResult = AbstractBaseComposite.this.checkExitBeforeSave(savePath);
                if (checkExitBeforeSaveResult) {
                    IStatus create = Status.CANCEL_STATUS;
                    PrepareSetting prepareSetting = (PrepareSetting)setting;
                    String errString = "";
                    try {
                        create = prepareSetting.makeCfgBin(savePath, currentExcelData);
                    }
                    catch (IOException e) {
                        errString = e.getMessage();
                        e.printStackTrace();
                    }
                    if (create == null || create.isOK()) {
                        MessageDialog.openInformation((Shell)AbstractBaseComposite.this.getShell(), (String)Messages.Message_HiRegBin, (String)Messages.Message_Create_Success);
                    } else {
                        MessageDialog.openError((Shell)AbstractBaseComposite.this.getShell(), (String)Messages.Message_HiRegBin, (String)errString);
                    }
                } else {
                    return;
                }
            }
        }

        private boolean prepareWork() {
            boolean bool = true;
            if (AbstractBaseComposite.this instanceof PanelComposite && !(bool = AbstractBaseComposite.this.checkAllValidValue())) {
                return false;
            }
            BaseParam baseParam = new BaseParam();
            Object paramObj = AbstractBaseComposite.this.getParam(baseParam, ".cfg");
            if (paramObj == null) {
                MessageDialog.openError((Shell)AbstractBaseComposite.this.getShell(), (String)Messages.Message_HiRegBin, (String)Messages.AbstractBaseComposite_GetDemoInfo);
                return false;
            }
            return true;
        }
    }

    final class MakeRegBinListener
    implements Listener {
        private boolean batch;

        MakeRegBinListener() {
        }

        public boolean isBatch() {
            return this.batch;
        }

        public void setBatch(boolean batch) {
            this.batch = batch;
        }

        public void handleEvent(Event event) {
            Setting setting = AbstractBaseComposite.this.getSetting();
            if (this.batch) {
                BatchParameter batchParameter = AbstractBaseComposite.this.initUi();
                if (batchParameter != null) {
                    int i = 0;
                    while (i < batchParameter.getDemoName().length) {
                        if (i != 0) {
                            AbstractBaseComposite.this.setCurrentDemo(batchParameter.getDemoName()[i]);
                        }
                        int ddrCapacityItemIndex = 0;
                        while (ddrCapacityItemIndex < batchParameter.getDdrCapacityItemCount()) {
                            int starupItemIndex = 0;
                            while (starupItemIndex < batchParameter.getStarupItemCount()) {
                                this.saveInFileSystem(setting, ddrCapacityItemIndex, starupItemIndex);
                                ++starupItemIndex;
                            }
                            ++ddrCapacityItemIndex;
                        }
                        ++i;
                    }
                }
            } else {
                this.saveInFileSystem(setting, 0, 0);
            }
        }

        public void saveInFileSystem(Setting setting, int ddrCapacityItemIndex, int starupItemIndex) {
            if (!this.prepareWork(ddrCapacityItemIndex, starupItemIndex)) {
                return;
            }
            if (!AbstractBaseComposite.this.customDemoName.endsWith(".reg")) {
                AbstractBaseComposite.this.customDemoName = AbstractBaseComposite.this.customDemoName.concat(".reg");
            }
            StringBuffer customName = new StringBuffer();
            if (!(RegbinView.getCurrentChip().equalsIgnoreCase("Hi3716MV410") || RegbinView.getCurrentChip().equalsIgnoreCase("Hi3716MV420") || RegbinView.isHi3716V550Series())) {
                if (AbstractBaseComposite.this.customDemoName.contains("_spi")) {
                    customName.append(AbstractBaseComposite.this.customDemoName.substring(0, AbstractBaseComposite.this.customDemoName.indexOf("_spi")));
                    customName.append(AbstractBaseComposite.this.customDemoName.substring(AbstractBaseComposite.this.customDemoName.indexOf("_spi") + "_spi".length()));
                } else if (AbstractBaseComposite.this.customDemoName.contains("_nand")) {
                    customName.append(AbstractBaseComposite.this.customDemoName.substring(0, AbstractBaseComposite.this.customDemoName.indexOf("_nand")));
                    customName.append(AbstractBaseComposite.this.customDemoName.substring(AbstractBaseComposite.this.customDemoName.indexOf("_nand") + "_nand".length()));
                } else if (AbstractBaseComposite.this.customDemoName.contains("_emmc")) {
                    customName.append(AbstractBaseComposite.this.customDemoName.substring(0, AbstractBaseComposite.this.customDemoName.indexOf("_emmc")));
                    customName.append(AbstractBaseComposite.this.customDemoName.substring(AbstractBaseComposite.this.customDemoName.indexOf("_emmc") + "_emmc".length()));
                } else if (AbstractBaseComposite.this.customDemoName.contains("_sd")) {
                    customName.append(AbstractBaseComposite.this.customDemoName.substring(0, AbstractBaseComposite.this.customDemoName.indexOf("_sd")));
                    customName.append(AbstractBaseComposite.this.customDemoName.substring(AbstractBaseComposite.this.customDemoName.indexOf("_sd") + "_sd".length()));
                } else {
                    customName.append(AbstractBaseComposite.this.customDemoName);
                }
            } else {
                customName = customName.append(AbstractBaseComposite.this.customDemoName);
            }
            String savePath = null;
            if (this.batch) {
                savePath = String.valueOf(new File(PanelPreferences.CONFIG.getTempFilePath()).getParent()) + "\\" + customName.toString();
            } else {
                FileDialog dialog = new FileDialog(AbstractBaseComposite.this.getShell(), 8192);
                dialog.setFilterExtensions(new String[]{"*.reg", "*.*"});
                dialog.setFileName(customName.toString());
                savePath = dialog.open();
            }
            if (savePath != null) {
                GlobleInfo.setNeedSave(false);
                ExcelData excelData = ExcelDataHelper.getExcelData();
                File file = new File(savePath);
                String fileName = file.getName();
                System.out.println(file.length());
                String configFileName = String.valueOf(fileName.substring(0, fileName.lastIndexOf("."))) + ".config";
                boolean checkExitBeforeSaveResult = AbstractBaseComposite.this.checkExitBeforeSave(savePath);
                if (checkExitBeforeSaveResult) {
                    IStatus create = Status.CANCEL_STATUS;
                    PrepareSetting prepareSetting = (PrepareSetting)setting;
                    try {
                        create = ExcelDataHelper.isV120RegFomatVersion(ExcelDataHelper.getExcelData()) ? prepareSetting.make98cv200Bin(savePath, currentExcelData, customName.toString()) : prepareSetting.makeRegBin(savePath, currentExcelData, customName.toString());
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                    if (create == null || create.isOK()) {
                        if (ExcelDataHelper.isV120RegFomatVersion(excelData)) {
                            MessageDialog.openInformation((Shell)AbstractBaseComposite.this.getShell(), (String)Messages.Message_HiRegBin, (String)NLS.bind((String)Messages.Message_Create_Success_With_RegAndConfig, (Object)fileName, (Object)configFileName));
                        } else {
                            MessageDialog.openInformation((Shell)AbstractBaseComposite.this.getShell(), (String)Messages.Message_HiRegBin, (String)Messages.Message_Create_Success);
                        }
                    } else {
                        BinData binData = prepareSetting.save98MV200BinDataByCurExcelData(savePath, excelData, configFileName);
                        byte[] binDataArray = binData.binDataArray();
                        System.out.println("binDataArray\u957f\u5ea6:" + binDataArray.length);
                        if (RegbinView.isHi3796MV200Series() || RegbinView.isHi3716MV430Series()) {
                            if (binDataArray.length > 10752) {
                                MessageDialog.openInformation((Shell)AbstractBaseComposite.this.getShell(), (String)Messages.Message_HiRegBin, (String)NLS.bind((String)Messages.Message_Create_TooLong_With_RegAndConfig, (Object)10752, (Object)binDataArray.length));
                                return;
                            }
                        } else if (RegbinView.isHi3796CV300Series()) {
                            if (binDataArray.length > 10480) {
                                MessageDialog.openInformation((Shell)AbstractBaseComposite.this.getShell(), (String)Messages.Message_HiRegBin, (String)NLS.bind((String)Messages.Message_Create_TooLong_With_RegAndConfig, (Object)10480, (Object)binDataArray.length));
                                return;
                            }
                            MessageDialog.openError((Shell)AbstractBaseComposite.this.getShell(), (String)Messages.Message_HiRegBin, (String)create.getMessage());
                        }
                    }
                } else {
                    return;
                }
            }
        }

        private boolean prepareWork(int ddrCapacityItemIndex, int starupItemIndex) {
            Object paramObj;
            boolean bool = true;
            if (AbstractBaseComposite.this instanceof PanelComposite && !(bool = AbstractBaseComposite.this.checkAllValidValue())) {
                return false;
            }
            BaseParam baseParam = new BaseParam();
            if (this.batch) {
                AbstractBaseComposite.this.setParam(ddrCapacityItemIndex, starupItemIndex);
            }
            if ((paramObj = AbstractBaseComposite.this.getParam(baseParam, ".reg")) == null) {
                MessageDialog.openError((Shell)AbstractBaseComposite.this.getShell(), (String)Messages.Message_HiRegBin, (String)Messages.AbstractBaseComposite_GetDemoInfo);
                return false;
            }
            return true;
        }
    }

    private final class ReplaceFastbootRegBinListener
    implements Listener {
        private ReplaceFastbootRegBinListener() {
        }

        public void handleEvent(Event event) {
            Setting setting = AbstractBaseComposite.this.getSetting();
            if (ExcelDataHelper.isV120RegFomatVersion(ExcelDataHelper.getExcelData())) {
                List<MultiperTable> multiperTableList;
                if (AbstractBaseComposite.this.multiperTableComposite != null && (multiperTableList = AbstractBaseComposite.this.multiperTableComposite.getMultiperTableList()) != null && multiperTableList.size() > 0) {
                    boolean isNotImport = true;
                    for (MultiperTable multiperTable : multiperTableList) {
                        BinData binData;
                        if (multiperTable == null || (binData = multiperTable.getBinData()) == null) continue;
                        isNotImport = false;
                    }
                    if (isNotImport) {
                        MessageDialog.openWarning((Shell)AbstractBaseComposite.this.getShell(), (String)Messages.Message_Warning, (String)Messages.AbstractBaseComposite_is_not_import_fastboot);
                        return;
                    }
                }
                if (AbstractBaseComposite.this.multiperTableComposite != null) {
                    BaseParam baseParam = new BaseParam();
                    TableViewer viewer = AbstractBaseComposite.this.multiperTableComposite.getViewer();
                    if (viewer != null) {
                        IStructuredSelection selection = (IStructuredSelection)viewer.getSelection();
                        MultiperTable multiperTable = (MultiperTable)selection.getFirstElement();
                        Object paramObj = AbstractBaseComposite.this.getParam(baseParam, ".reg");
                        AbstractBaseComposite.this.multiperTableComposite.tipNeedSaveData(paramObj, multiperTable);
                    }
                }
                this.replaceFastbootRegFor98cv200();
            } else {
                this.saveInFileSystem(setting);
            }
        }

        public void replaceFastbootRegFor98cv200() {
            ReplaceRegDialog replaceRegDialog = new ReplaceRegDialog(Display.getCurrent().getActiveShell(), AbstractBaseComposite.this.lastInputBoot, AbstractBaseComposite.this.lastOutputBoot);
            int open = replaceRegDialog.open();
            if (open == 0) {
                String inputBoot = replaceRegDialog.getInputBoot();
                String outputBoot = replaceRegDialog.getOutputBoot();
                try {
                    byte[] securityFlagBytes;
                    int securityValue;
                    boolean invaidInputBootBuffer;
                    boolean checkInputBootFile;
                    File inputBootFile = new File(inputBoot);
                    boolean bl = checkInputBootFile = inputBootFile != null && !inputBootFile.exists();
                    if (checkInputBootFile) {
                        MessageDialog.openError((Shell)AbstractBaseComposite.this.getShell(), (String)Messages.Message_Error, (String)(String.valueOf(Messages.MultiperTableComposite_import_reg_file_is_not_exist) + "\n" + inputBootFile.getAbsolutePath()));
                        return;
                    }
                    boolean checkExitBeforeSaveResult = AbstractBaseComposite.this.checkExitBeforeSave(outputBoot);
                    if (!checkExitBeforeSaveResult) {
                        return;
                    }
                    byte[] inputBootBuffer = FileUtils.readAllBytes(inputBoot);
                    boolean bl2 = invaidInputBootBuffer = inputBootBuffer == null || inputBootBuffer.length <= 0 || inputBootBuffer.length < 12268;
                    if (invaidInputBootBuffer) {
                        MessageDialog.openError((Shell)AbstractBaseComposite.this.getShell(), (String)Messages.Message_HiRegBin, (String)Messages.AbstractBaseComposite_read_File_failed);
                        return;
                    }
                    int multiformAddrFlag = 12256;
                    int formLenFlag = 12264;
                    int formAddrFlag = 12260;
                    int securityFlag = 1036;
                    int securityMulitFlag = -2088414648;
                    int securityFormLenFlag = 1040;
                    int auxAreaFlag = 536;
                    int bootAreaFlag = 1032;
                    int headAreaLength = 12288;
                    int formAddr = 0;
                    int singleFormLen = 0;
                    int hlsLen = 0;
                    if (RegbinView.isHi3798MV310Series()) {
                        multiformAddrFlag = 1064;
                        formLenFlag = 10752;
                        singleFormLen = 1200;
                    } else if (RegbinView.isHi3796MV200Series()) {
                        multiformAddrFlag += 65536;
                        formLenFlag += 65536;
                        formAddrFlag += 65536;
                    } else if (RegbinView.isHi3716MV430Series()) {
                        multiformAddrFlag = 1064;
                        singleFormLen = 1200;
                        byte[] keyRightsFlagBytes = BytesUtils.genSubBytes(inputBootBuffer, 528, 4);
                        int keyRightsValue = BytesArrayUtils.getInt(keyRightsFlagBytes, 0, ByteOrder.LITTLE_ENDIAN);
                        if (keyRightsValue != 1014535725) {
                            hlsLen = 65536;
                        }
                        singleFormLen += hlsLen;
                        multiformAddrFlag += hlsLen;
                    } else if (RegbinView.isHi3796CV300Series()) {
                        multiformAddrFlag = 67632;
                        formAddrFlag = 67636;
                        formLenFlag = 67636;
                    }
                    boolean securityMulit = false;
                    if (RegbinView.isHi3798MV200Series() && (securityValue = BytesArrayUtils.getInt(securityFlagBytes = BytesUtils.genSubBytes(inputBootBuffer, securityFlag, 4), 0, ByteOrder.LITTLE_ENDIAN)) == securityMulitFlag) {
                        formLenFlag = securityFormLenFlag;
                        securityMulit = true;
                    }
                    boolean isSupportMutiForm = false;
                    byte[] multiFormFlagBytes = BytesUtils.genSubBytes(inputBootBuffer, multiformAddrFlag, 4);
                    int multiFormFlag = BytesArrayUtils.getInt(multiFormFlagBytes, 0, ByteOrder.LITTLE_ENDIAN);
                    int multiFormFlagValue = 0;
                    if (RegbinView.isHi3798MV310Series() || RegbinView.isHi3716MV430Series()) {
                        multiFormFlagValue = -2088414648;
                        if (multiFormFlag == multiFormFlagValue) {
                            isSupportMutiForm = true;
                        }
                    } else if (RegbinView.isHi3796CV300Series()) {
                        multiFormFlagValue = 1014535905;
                        if (multiFormFlag == multiFormFlagValue) {
                            isSupportMutiForm = true;
                        }
                    } else if (multiFormFlag != multiFormFlagValue) {
                        isSupportMutiForm = true;
                    }
                    if (isSupportMutiForm) {
                        if (RegbinView.isHi3798MV310Series()) {
                            formAddr = this.getHi3798MV300TableStartAddr(inputBootBuffer);
                            byte[] mTableLengthBytes = BytesUtils.genSubBytes(inputBootBuffer, 1068, 4);
                            singleFormLen = BytesArrayUtils.getInt(mTableLengthBytes, 0, ByteOrder.LITTLE_ENDIAN);
                        } else if (RegbinView.isHi3716MV430Series()) {
                            formAddr = AbstractBaseComposite.this.getHi3716MV430TableStartAddr(inputBootBuffer);
                            byte[] formLenByte = BytesUtils.genSubBytes(inputBootBuffer, 1068 + hlsLen, 4);
                            singleFormLen = BytesArrayUtils.getInt(formLenByte, 0, ByteOrder.LITTLE_ENDIAN);
                        } else if (RegbinView.isHi3796CV300Series()) {
                            formAddr = AbstractBaseComposite.this.getHi3796CV300TableStartAddr(inputBootBuffer);
                            singleFormLen = 10240;
                        } else {
                            boolean singleFormLenInviad;
                            byte[] singleFormLenBytes = BytesUtils.genSubBytes(inputBootBuffer, formLenFlag, 4);
                            singleFormLen = BytesArrayUtils.getInt(singleFormLenBytes, 0, ByteOrder.LITTLE_ENDIAN);
                            boolean bl3 = singleFormLenInviad = singleFormLen <= 0 || (long)singleFormLen > inputBootFile.length();
                            if (singleFormLenInviad) {
                                MessageDialog.openError((Shell)AbstractBaseComposite.this.getShell(), (String)Messages.Message_Error, (String)NLS.bind((String)Messages.GetBootFormLength_Failed, (Object)inputBootFile.getName()));
                                return;
                            }
                        }
                    }
                    if (!(RegbinView.isHi3798MV310Series() || RegbinView.isHi3716MV430Series() || RegbinView.isHi3796CV300Series())) {
                        boolean invaid;
                        byte[] formAddrBytes = BytesUtils.genSubBytes(inputBootBuffer, formAddrFlag, 4);
                        if (securityMulit) {
                            byte[] auxAreaLenBytes = BytesUtils.genSubBytes(inputBootBuffer, auxAreaFlag, 4);
                            int auxAreaLength = BytesArrayUtils.getInt(auxAreaLenBytes, 0, ByteOrder.LITTLE_ENDIAN);
                            byte[] bootAreaLenBytes = BytesUtils.genSubBytes(inputBootBuffer, bootAreaFlag, 4);
                            int bootAreaLength = BytesArrayUtils.getInt(bootAreaLenBytes, 0, ByteOrder.LITTLE_ENDIAN);
                            formAddr = headAreaLength + auxAreaLength + bootAreaLength;
                        } else {
                            formAddr = BytesArrayUtils.getInt(formAddrBytes, 0, ByteOrder.LITTLE_ENDIAN);
                        }
                        boolean bl4 = invaid = formAddr <= 0 || (long)formAddr > inputBootFile.length();
                        if (invaid) {
                            MessageDialog.openError((Shell)AbstractBaseComposite.this.getShell(), (String)Messages.Message_Error, (String)NLS.bind((String)Messages.GetBootFormStartAddr_Failed, (Object)inputBootFile.getName()));
                            return;
                        }
                    }
                    boolean result = true;
                    if (AbstractBaseComposite.this.multiperTableComposite != null) {
                        boolean checkMultiperTableList;
                        List<MultiperTable> multiperTableList = AbstractBaseComposite.this.multiperTableComposite.getMultiperTableList();
                        boolean bl5 = checkMultiperTableList = multiperTableList != null && multiperTableList.size() > 0;
                        if (checkMultiperTableList) {
                            File outputBootFile = new File(outputBoot);
                            FileUtils.copy(inputBootFile, outputBootFile);
                            if (isSupportMutiForm) {
                                if (RegbinView.isHi3798MV310Series()) {
                                    formAddr = this.getHi3798MV300TableStartAddr(inputBootBuffer);
                                    byte[] mTableLengthBytes = BytesUtils.genSubBytes(inputBootBuffer, 1068, 4);
                                    singleFormLen = BytesArrayUtils.getInt(mTableLengthBytes, 0, ByteOrder.LITTLE_ENDIAN);
                                }
                                int i = 0;
                                while (i < multiperTableList.size()) {
                                    MultiperTable multiperTable = multiperTableList.get(i);
                                    String tableId = multiperTable.getTableId();
                                    if (tableId.equals("Single")) {
                                        result = this.replaceDefaultReg(outputBootFile, inputBootFile, singleFormLen, multiperTable);
                                        if (!result) {
                                            MessageDialog.openError((Shell)AbstractBaseComposite.this.getShell(), (String)Messages.Message_HiRegBin, (String)NLS.bind((String)Messages.AbstractBaseComposite_replace_failed, (Object)multiperTable.getTableName()));
                                            return;
                                        }
                                    } else {
                                        int curMutiperTableIndex = 0;
                                        if (i > 0) {
                                            curMutiperTableIndex = i - 1;
                                        }
                                        int headData = 0;
                                        if (RegbinView.isHi3796CV300Series()) {
                                            headData = 16;
                                        }
                                        if (!(result = this.replaceMutiperReg(outputBootFile, inputBootFile, singleFormLen - headData, formAddr, multiperTable, tableId, curMutiperTableIndex))) {
                                            MessageDialog.openError((Shell)AbstractBaseComposite.this.getShell(), (String)Messages.Message_HiRegBin, (String)NLS.bind((String)Messages.AbstractBaseComposite_replace_failed, (Object)multiperTable.getTableName()));
                                            return;
                                        }
                                    }
                                    ++i;
                                }
                            } else {
                                MultiperTable multiperTable = multiperTableList.get(0);
                                String tableId = multiperTable.getTableId();
                                if (tableId.equals("Single") && !(result = this.replaceDefaultReg(outputBootFile, inputBootFile, singleFormLen, multiperTable))) {
                                    MessageDialog.openError((Shell)AbstractBaseComposite.this.getShell(), (String)Messages.Message_HiRegBin, (String)NLS.bind((String)Messages.AbstractBaseComposite_replace_failed, (Object)multiperTable.getTableName()));
                                    return;
                                }
                            }
                        } else {
                            result = false;
                        }
                    } else {
                        result = false;
                    }
                    AbstractBaseComposite.this.lastInputBoot = inputBoot;
                    AbstractBaseComposite.this.lastOutputBoot = outputBoot;
                    MessageDialog.openInformation((Shell)AbstractBaseComposite.this.getShell(), (String)Messages.Message_HiRegBin, (String)(String.valueOf(Messages.Message_ReplaceFastboot_Success) + "[" + outputBoot + "]"));
                }
                catch (Exception e) {
                    MessageDialog.openError((Shell)AbstractBaseComposite.this.getShell(), (String)Messages.Message_HiRegBin, (String)e.getMessage());
                }
            }
        }

        private int getHi3798MV300TableStartAddr(byte[] inputBootBuffer) {
            if (inputBootBuffer == null) {
                return 0;
            }
            int multipleTableStartAddr = 12288;
            byte[] auxareaBytes = BytesUtils.genSubBytes(inputBootBuffer, 532, 4);
            int auxareaLen = BytesArrayUtils.getInt(auxareaBytes, 0, ByteOrder.LITTLE_ENDIAN);
            byte[] ascareaBytes = BytesUtils.genSubBytes(inputBootBuffer, 536, 4);
            int ascarealen = BytesArrayUtils.getInt(ascareaBytes, 0, ByteOrder.LITTLE_ENDIAN);
            byte[] areaBytes = BytesUtils.genSubBytes(inputBootBuffer, 1032, 4);
            int areaLen = BytesArrayUtils.getInt(areaBytes, 0, ByteOrder.LITTLE_ENDIAN);
            return multipleTableStartAddr + auxareaLen + ascarealen + areaLen;
        }

        private boolean replaceMutiperReg(File outputBootFile, File inputBootFile, int singleFormLen, int formAddr, MultiperTable multiperTable, String tableId, int regIndex) {
            boolean result = true;
            int HEAD_DATA = 16;
            int replaceStart = 0;
            replaceStart = RegbinView.isHi3796CV300Series() && regIndex > 0 ? formAddr + regIndex * singleFormLen + 16 * regIndex : formAddr + regIndex * singleFormLen;
            BinData binData = multiperTable.getBinData();
            String tempRegFilePath = String.valueOf(outputBootFile.getPath()) + "." + regIndex;
            if (binData != null) {
                result = this.replaceBinData(outputBootFile, inputBootFile, replaceStart, binData, tempRegFilePath);
                if (!result) {
                    MessageDialog.openError((Shell)AbstractBaseComposite.this.getShell(), (String)Messages.Message_HiRegBin, (String)NLS.bind((String)Messages.AbstractBaseComposite_replace_failed, (Object)tableId));
                    return result;
                }
            } else {
                result = this.replaceDefaultEmptyData(outputBootFile, inputBootFile, singleFormLen, replaceStart, tempRegFilePath);
                if (!result) {
                    MessageDialog.openError((Shell)AbstractBaseComposite.this.getShell(), (String)Messages.Message_HiRegBin, (String)Messages.AbstractBaseComposite_replace_failed);
                    return result;
                }
            }
            return result;
        }

        private boolean replaceDefaultReg(File outputBootFile, File inputBootFile, int singleFormLen, MultiperTable multiperTable) {
            boolean result = true;
            int defaultFormFlag = 1152;
            if (RegbinView.isHi3796MV200Series()) {
                defaultFormFlag = 66736;
            } else if (RegbinView.isHi3798MV310Series()) {
                defaultFormFlag = 1200;
            } else if (RegbinView.isHi3716MV430Series()) {
                defaultFormFlag = singleFormLen;
            } else if (RegbinView.isHi3796CV300Series()) {
                defaultFormFlag = 67776;
                singleFormLen -= 16;
            }
            BinData defaultBinData = multiperTable.getBinData();
            String tempRegFilePath = String.valueOf(outputBootFile.getPath()) + "." + "Single";
            if (defaultBinData != null) {
                result = this.replaceBinData(outputBootFile, inputBootFile, defaultFormFlag, defaultBinData, tempRegFilePath);
                if (!result) {
                    MessageDialog.openError((Shell)AbstractBaseComposite.this.getShell(), (String)Messages.Message_HiRegBin, (String)NLS.bind((String)Messages.AbstractBaseComposite_replace_failed, (Object)"Single"));
                    return result;
                }
            } else {
                result = this.replaceDefaultEmptyData(outputBootFile, inputBootFile, singleFormLen, defaultFormFlag, tempRegFilePath);
                if (!result) {
                    MessageDialog.openError((Shell)AbstractBaseComposite.this.getShell(), (String)Messages.Message_HiRegBin, (String)Messages.AbstractBaseComposite_replace_failed);
                    return result;
                }
            }
            return result;
        }

        private boolean replaceDefaultEmptyData(File outputBootFile, File inputBootFile, int singleFormLen, int replaceStart, String tempRegFilePath) {
            boolean result;
            byte[] genBytesWithZero = BytesUtils.genBytesWithZero(singleFormLen);
            File inputRegFile = new File(tempRegFilePath);
            if (!inputRegFile.exists()) {
                FileUtils.createFile(inputRegFile);
            }
            if (result = FileUtils.writeAllBytes(genBytesWithZero, tempRegFilePath)) {
                result = this.copyRegFileToOutputBoot(outputBootFile, replaceStart, tempRegFilePath);
            }
            FileUtils.deleteFile(inputRegFile);
            return result;
        }

        private boolean replaceBinData(File outputBootFile, File inputBootFile, int replaceStart, BinData binData, String tempRegFilePath) {
            boolean result = binData.toFile(tempRegFilePath);
            if (result) {
                result = this.copyRegFileToOutputBoot(outputBootFile, replaceStart, tempRegFilePath);
            }
            return result;
        }

        private boolean copyRegFileToOutputBoot(File outputBootFile, int replaceStart, String tempRegFilePath) {
            File inputRegFile = new File(tempRegFilePath);
            int replaceLen = (int)inputRegFile.length();
            RandomAccessFile inFile = null;
            RandomAccessFile outFile = null;
            try {
                try {
                    inFile = new RandomAccessFile(inputRegFile, "r");
                    int regBinFileLen = (int)inputRegFile.length();
                    byte[] regBinFileData = new byte[regBinFileLen];
                    inFile.seek(0L);
                    inFile.read(regBinFileData);
                    outFile = new RandomAccessFile(outputBootFile, "rw");
                    outFile.seek(replaceStart);
                    outFile.write(BitUtils.genBytesWithZero(replaceLen));
                    outFile.seek(replaceStart);
                    outFile.write(regBinFileData, 0, regBinFileLen);
                }
                catch (Exception e) {
                    e.printStackTrace();
                    if (inFile != null) {
                        try {
                            inFile.close();
                        }
                        catch (IOException e2) {
                            e2.printStackTrace();
                        }
                    }
                    if (outFile != null) {
                        try {
                            outFile.close();
                        }
                        catch (IOException e3) {
                            e3.printStackTrace();
                        }
                    }
                    return false;
                }
            }
            finally {
                if (inFile != null) {
                    try {
                        inFile.close();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
                if (outFile != null) {
                    try {
                        outFile.close();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
            }
            FileUtils.deleteFile(inputRegFile);
            return true;
        }

        public void saveInFileSystem(Setting setting) {
            if (!this.prepareWork()) {
                return;
            }
            FileDialog fd = new FileDialog(AbstractBaseComposite.this.getShell());
            fd.setFilterExtensions(new String[]{"*.bin", "*.*"});
            fd.setFilterNames(new String[]{"*.bin", "*.*"});
            String filePath = fd.open();
            if (filePath == null) {
                return;
            }
            GlobleInfo.setNeedSave(false);
            File fastbootFile = new File(filePath);
            if (fastbootFile == null || !fastbootFile.exists()) {
                MessageDialog.openError((Shell)AbstractBaseComposite.this.getShell(), (String)"Error", (String)("The input file '" + filePath + "' is invalid."));
                return;
            }
            File regBinFile = null;
            String hiToolPath = HiToolUtils.getInstallPath();
            regBinFile = new File(String.valueOf(hiToolPath) + File.separator + fastbootFile.getName() + ".tempRegbin");
            IStatus create = Status.CANCEL_STATUS;
            PrepareSetting prepareSetting = (PrepareSetting)setting;
            if (!AbstractBaseComposite.this.customDemoName.endsWith(".reg")) {
                AbstractBaseComposite.this.customDemoName = AbstractBaseComposite.this.customDemoName.concat(".reg");
            }
            StringBuffer customName = new StringBuffer();
            if (!RegbinView.getCurrentChip().equalsIgnoreCase("Hi3716MV410") && !RegbinView.getCurrentChip().equalsIgnoreCase("Hi3716MV420")) {
                if (AbstractBaseComposite.this.customDemoName.contains("_spi")) {
                    customName.append(AbstractBaseComposite.this.customDemoName.substring(0, AbstractBaseComposite.this.customDemoName.indexOf("_spi")));
                    customName.append(AbstractBaseComposite.this.customDemoName.substring(AbstractBaseComposite.this.customDemoName.indexOf("_spi") + "_spi".length()));
                } else if (AbstractBaseComposite.this.customDemoName.contains("_nand")) {
                    customName.append(AbstractBaseComposite.this.customDemoName.substring(0, AbstractBaseComposite.this.customDemoName.indexOf("_nand")));
                    customName.append(AbstractBaseComposite.this.customDemoName.substring(AbstractBaseComposite.this.customDemoName.indexOf("_nand") + "_nand".length()));
                } else if (AbstractBaseComposite.this.customDemoName.contains("_emmc")) {
                    customName.append(AbstractBaseComposite.this.customDemoName.substring(0, AbstractBaseComposite.this.customDemoName.indexOf("_emmc")));
                    customName.append(AbstractBaseComposite.this.customDemoName.substring(AbstractBaseComposite.this.customDemoName.indexOf("_emmc") + "_emmc".length()));
                } else {
                    customName.append(AbstractBaseComposite.this.customDemoName);
                }
            } else {
                customName = customName.append(AbstractBaseComposite.this.customDemoName);
            }
            try {
                create = prepareSetting.makeRegBin(regBinFile.getPath(), currentExcelData, customName.toString());
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            File newFastbootRegBin = AbstractBaseComposite.this.replaceFastbootRegBin(fastbootFile, regBinFile, 64, 8192);
            if (regBinFile.exists()) {
                FileUtils.deleteFile(regBinFile);
            }
            String newFastbootRegBinName = newFastbootRegBin.getName();
            if (create == null || create.isOK()) {
                MessageDialog.openInformation((Shell)AbstractBaseComposite.this.getShell(), (String)Messages.Message_HiRegBin, (String)(String.valueOf(Messages.Message_ReplaceFastboot_Success) + "[" + newFastbootRegBinName + "]"));
            } else {
                MessageDialog.openError((Shell)AbstractBaseComposite.this.getShell(), (String)Messages.Message_HiRegBin, (String)create.getMessage());
            }
        }

        private boolean prepareWork() {
            boolean bool = true;
            if (AbstractBaseComposite.this instanceof PanelComposite && !(bool = AbstractBaseComposite.this.checkAllValidValue())) {
                return false;
            }
            BaseParam baseParam = new BaseParam();
            Object paramObj = AbstractBaseComposite.this.getParam(baseParam, ".reg");
            if (paramObj == null) {
                MessageDialog.openError((Shell)AbstractBaseComposite.this.getShell(), (String)Messages.Message_HiRegBin, (String)Messages.AbstractBaseComposite_GetDemoInfo);
                return false;
            }
            return true;
        }
    }
}

