/*
 * Decompiled with CFR 0.152.
 */
package com.hisilicon.hiregbin.model.reg.hi98cv200bin;

import com.hisilicon.hiregbin.model.reg.hi98cv200bin.BinItem;
import com.hisilicon.hiregbin.utility.BytesArrayUtils;
import com.hisilicon.hiregbin.utility.BytesUtils;
import java.nio.ByteOrder;
import java.util.ArrayList;

public class BinTable {
    private static final int TABLE_ADDRESS_SIZE = 3;
    private static final int REG_LENGTH = 2;
    private static final int REG_FIX_LENGTH = 3;
    private int tableAddress;
    private int tableRegTotalLength;
    private ArrayList<BinItem> tableBinItemList = new ArrayList();

    public int calculateTableAddress(int regAbsoluteAddr) {
        return BytesArrayUtils.get3HightBytesFromInt(regAbsoluteAddr);
    }

    public void addBinItemToList(BinItem binItem) {
        this.tableBinItemList.add(binItem);
    }

    public int fromBytes(byte[] buffer, int offset) throws IndexOutOfBoundsException {
        int pointer = offset;
        this.tableAddress = BytesArrayUtils.getIntFor3bytes(buffer, pointer, ByteOrder.BIG_ENDIAN, true);
        int tableItemLen = BytesArrayUtils.getShort(buffer, pointer += 3, ByteOrder.BIG_ENDIAN) & 0xFFFF;
        int startPointer = 0;
        byte[] curTableData = BytesUtils.genSubBytes(buffer, pointer += 2, tableItemLen);
        int curTableItemLen = tableItemLen;
        while (curTableItemLen > 0) {
            BinItem binItem = new BinItem();
            int curItemLen = binItem.fromBytes(curTableData, startPointer);
            startPointer += curItemLen;
            curTableItemLen -= curItemLen;
            binItem.setmTableRef(this);
            this.tableBinItemList.add(binItem);
        }
        return (pointer += tableItemLen) - offset;
    }

    public int toBytes(byte[] buffer, int offset) throws IndexOutOfBoundsException {
        int pointer = offset;
        BytesArrayUtils.setIntFor3bytes(buffer, pointer, this.tableAddress & 0xFFFFFF00, ByteOrder.BIG_ENDIAN, true);
        int regLenStartOffset = pointer += 3;
        pointer += 2;
        int i = 0;
        while (i < this.tableBinItemList.size()) {
            BinItem binItem = this.tableBinItemList.get(i);
            int writeSize = binItem.toBytes(buffer, pointer);
            pointer += writeSize;
            ++i;
        }
        int totalRegLen = pointer - offset - 3 - 2;
        BytesArrayUtils.setShort(buffer, regLenStartOffset, (short)(totalRegLen & 0xFFFF), ByteOrder.BIG_ENDIAN);
        return pointer - offset;
    }

    public int getBytesSize() {
        int size = 0;
        size += 3;
        size += 2;
        for (BinItem binItem : this.tableBinItemList) {
            size += 3;
            size += binItem.getIntValueBitCount(binItem.getValue());
            size += binItem.getIntValueBitCount(binItem.getDelay());
        }
        return size;
    }

    public int getTableAddress() {
        return this.tableAddress;
    }

    public void setTableAddress(int tableAddress) {
        this.tableAddress = tableAddress;
    }

    public int getTableRegTotalLength() {
        return this.tableRegTotalLength;
    }

    public void setTableRegTotalLength(int tableRegTotalLength) {
        this.tableRegTotalLength = tableRegTotalLength;
    }

    public ArrayList<BinItem> getTableBinItemList() {
        return this.tableBinItemList;
    }

    public void setTableBinItemList(ArrayList<BinItem> tableBinItemList) {
        this.tableBinItemList = tableBinItemList;
    }
}

