/*
 * Decompiled with CFR 0.152.
 */
package com.hisilicon.hiregbin.model.reg.hi98cv200bin;

import com.hisilicon.hiregbin.model.reg.hi98cv200bin.BinModuleType;

public class BinModuleHead {
    protected int RESERVE = 0;
    private BinModuleType moduleType;
    private int normalBoot;
    private int standbyWakeup;
    private int normalChip;
    private int caChip;

    public BinModuleHead(BinModuleType moduleType, int normalBoot, int standbyWakeup, int normalChip, int caChip) {
        this.moduleType = moduleType;
        this.normalBoot = normalBoot;
        this.standbyWakeup = standbyWakeup;
        this.normalChip = normalChip;
        this.caChip = caChip;
    }

    public BinModuleHead() {
    }

    public byte setReserveModuleHeadToBytes() {
        return (byte)this.RESERVE;
    }

    public byte setModuleHeadToBytes() {
        byte byteModuleType = (byte)((this.moduleType.ordinal() & 0xF) << 4);
        byte byteNormalBoot = (byte)((this.normalBoot & 1) << 3);
        byte byteStandbyWakeup = (byte)((this.standbyWakeup & 1) << 2);
        byte byteNormalChip = (byte)((this.normalChip & 1) << 1);
        byte byteCaChip = (byte)((this.caChip & 1) << 0);
        return (byte)(byteModuleType | byteNormalBoot | byteStandbyWakeup | byteNormalChip | byteCaChip);
    }

    public BinModuleHead getModuleHeadFromBytes(byte data) {
        BinModuleType moduleType = BinModuleType.values()[(data & 0xF0) >> 4];
        int normalboot = (data & 8) >> 3;
        int standbyWakeup = (data & 4) >> 2;
        int normalChip = (data & 2) >> 1;
        int caChip = data & 1;
        BinModuleHead binModuleHead = new BinModuleHead(moduleType, normalboot, standbyWakeup, normalChip, caChip);
        return binModuleHead;
    }

    public BinModuleType getModuleType() {
        return this.moduleType;
    }

    public void setModuleType(BinModuleType moduleType) {
        this.moduleType = moduleType;
    }

    public int getNormalBoot() {
        return this.normalBoot;
    }

    public void setNormalBoot(int normalBoot) {
        this.normalBoot = normalBoot;
    }

    public int getStandbyWakeup() {
        return this.standbyWakeup;
    }

    public void setStandbyWakeup(int standbyWakeup) {
        this.standbyWakeup = standbyWakeup;
    }

    public int getNormalChip() {
        return this.normalChip;
    }

    public void setNormalChip(int normalChip) {
        this.normalChip = normalChip;
    }

    public int getCaChip() {
        return this.caChip;
    }

    public void setCaChip(int caChip) {
        this.caChip = caChip;
    }
}

