/*
 * Decompiled with CFR 0.152.
 */
package com.hisilicon.hiregbin.model.reg.hi98cv200bin;

import com.hisilicon.hiregbin.model.reg.hi98cv200bin.BinItem;
import com.hisilicon.hiregbin.model.reg.hi98cv200bin.BinModuleHead;
import com.hisilicon.hiregbin.model.reg.hi98cv200bin.BinTable;
import com.hisilicon.hiregbin.utility.BytesArrayUtils;
import com.hisilicon.hiregbin.utility.BytesUtils;
import java.nio.ByteOrder;
import java.util.ArrayList;

public class BinModule {
    protected static final int HEADER_SIZE = 4;
    protected static final int LENGTH_OFFSET = 2;
    protected static final int BASEADDR_OFFSET = 3;
    protected int mBaseAddr;
    protected ArrayList<BinTable> binTableList;
    private BinModuleHead binModuleHead;

    public BinModule(BinModuleHead binModuleHead) {
        this.binModuleHead = binModuleHead;
        this.binTableList = new ArrayList();
    }

    public BinModule() {
        this.binTableList = new ArrayList();
    }

    public void addTableToModule(BinTable binTable) {
        this.binTableList.add(binTable);
    }

    public BinTable getTableFromModule(int index) {
        return this.binTableList.get(index);
    }

    public BinModuleHead getBinModuleHead() {
        return this.binModuleHead;
    }

    public void setBinModuleHead(BinModuleHead binModuleHead) {
        this.binModuleHead = binModuleHead;
    }

    public int getBaseAddr() {
        return this.mBaseAddr;
    }

    public void setBaseAddr(int mBaseAddr) {
        this.mBaseAddr = mBaseAddr;
    }

    public int getTableCount() {
        return this.binTableList.size();
    }

    public ArrayList<BinItem> seekForItems(int address, int startBit) {
        return null;
    }

    public int getBytesSize() {
        int size = 4;
        int i = 0;
        while (i < this.binTableList.size()) {
            BinTable binTable = this.binTableList.get(i);
            size += binTable.getBytesSize();
            ++i;
        }
        if (size % 4 != 0) {
            size += 4 - size % 4;
        }
        return size;
    }

    public int fromBytes(byte[] buffer, int offset) throws IndexOutOfBoundsException {
        int pointer = offset;
        this.binModuleHead = new BinModuleHead();
        this.binModuleHead = this.binModuleHead.getModuleHeadFromBytes(buffer[++pointer]);
        int moduleRegLen = BytesArrayUtils.getShort(buffer, ++pointer, ByteOrder.BIG_ENDIAN) & 0xFFFF;
        int startPointer = 0;
        byte[] curModuleData = BytesUtils.genSubBytes(buffer, pointer += 2, moduleRegLen);
        int curModuleRegLen = moduleRegLen;
        while (curModuleRegLen > 0) {
            BinTable binTable = new BinTable();
            int curTableLen = binTable.fromBytes(curModuleData, startPointer);
            startPointer += curTableLen;
            curModuleRegLen -= curTableLen;
            ArrayList<BinItem> tableBinItemList = binTable.getTableBinItemList();
            for (BinItem binItem : tableBinItemList) {
                if (binItem == null) continue;
                binItem.setmModuleRef(this);
            }
            if (binTable.getTableBinItemList().size() <= 0) continue;
            this.binTableList.add(binTable);
        }
        return (pointer += moduleRegLen) - offset;
    }

    public int toBytes(byte[] buffer, int offset) throws IndexOutOfBoundsException {
        int pointer = offset;
        buffer[pointer] = this.binModuleHead.setReserveModuleHeadToBytes();
        buffer[++pointer] = this.binModuleHead.setModuleHeadToBytes();
        ++pointer;
        int startPointer = pointer += 2;
        int i = 0;
        while (i < this.binTableList.size()) {
            BinTable binTable = this.binTableList.get(i);
            int writeSize = binTable.toBytes(buffer, pointer);
            pointer += writeSize;
            ++i;
        }
        short length = (short)(pointer - startPointer);
        BytesArrayUtils.setShort(buffer, (short)(offset + 2 & 0xFFFF), length, ByteOrder.BIG_ENDIAN);
        return pointer - offset;
    }

    public boolean isExistBinTableList(BinTable binTable) {
        return this.binTableList != null && this.binTableList.contains(binTable);
    }

    public BinTable getExistBinTable(int curTableAddr) {
        int i = 0;
        while (i < this.binTableList.size()) {
            BinTable binTable = this.binTableList.get(i);
            int tableAddress = binTable.getTableAddress();
            if (curTableAddr == tableAddress) {
                return binTable;
            }
            ++i;
        }
        return null;
    }

    public ArrayList<BinTable> getBinTableList() {
        return this.binTableList;
    }

    public void setBinTableList(ArrayList<BinTable> binTableList) {
        this.binTableList = binTableList;
    }
}

