/*
 * Decompiled with CFR 0.152.
 */
package com.hisilicon.hiregbin.model.reg.hi98cv200bin;

import com.hisilicon.hiregbin.utility.BytesArrayUtils;
import java.io.UnsupportedEncodingException;
import java.text.SimpleDateFormat;
import java.util.Date;

public class BinHeadData {
    protected static final String TIME_FORMAT = "yyyy/MM/dd HH:mm:ss";
    protected static final int REG_FORMAT_VERSION_NUMBER_LEN = 4;
    protected static final int XML_VERSION_NUMBER_LEN = 6;
    protected static final int FIRST_MODULE_OFFSET_LEN = 2;
    protected static final int DATA_TIME_LEN = 20;
    protected static final int NAME_OFFSET_SIZE = 4;
    protected String regFormatVersion;
    protected String xlsVersion;
    protected int firstBinModuleOffset;
    protected String binMakeTime;
    protected String binName;

    public int getHeadBytesSize() {
        int size = 0;
        size += 4;
        size += 6;
        size += 2;
        size += 20;
        try {
            int nameSize = this.binName.getBytes(System.getProperty("file.encoding")).length;
            size = nameSize % 4 == 0 ? (size += nameSize) : (size += nameSize + (4 - nameSize % 4));
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        return size;
    }

    public int setHeadDataToFile(byte[] binData, int pointer) {
        Date timeNow = new Date();
        SimpleDateFormat df = new SimpleDateFormat(TIME_FORMAT);
        this.binMakeTime = df.format(timeNow);
        BytesArrayUtils.setString(binData, pointer, 4, this.regFormatVersion);
        BytesArrayUtils.setString(binData, pointer += 4, 6, this.xlsVersion);
        binData[pointer += 6] = (byte)(this.firstBinModuleOffset & 0xFFFF);
        BytesArrayUtils.setString(binData, pointer += 2, this.binMakeTime.length(), this.binMakeTime);
        BytesArrayUtils.setString(binData, pointer += 20, this.binName.length(), this.binName);
        try {
            int nameSize = this.binName.getBytes(System.getProperty("file.encoding")).length;
            pointer = nameSize % 4 == 0 ? (pointer += nameSize) : (pointer += nameSize + (4 - nameSize % 4));
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        return pointer;
    }

    public int getHeadDataFromFile(byte[] binData, int pointer) {
        this.regFormatVersion = BytesArrayUtils.getString(binData, pointer, 4);
        this.xlsVersion = BytesArrayUtils.getString(binData, pointer += 4, 6);
        this.firstBinModuleOffset = binData[pointer += 6];
        this.binMakeTime = BytesArrayUtils.getString(binData, pointer += 2, 20);
        int binNameLen = this.firstBinModuleOffset - (pointer += 20);
        this.binName = BytesArrayUtils.getString(binData, pointer, binNameLen);
        try {
            int nameSize = this.binName.getBytes(System.getProperty("file.encoding")).length;
            pointer = nameSize % 4 == 0 ? (pointer += nameSize) : (pointer += nameSize + (4 - nameSize % 4));
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        return pointer;
    }

    public String getRegFormatVersion() {
        return this.regFormatVersion;
    }

    public void setRegFormatVersion(String regFormatVersion) {
        this.regFormatVersion = regFormatVersion;
    }

    public String getXlsVersion() {
        return this.xlsVersion;
    }

    public void setXlsVersion(String xlsVersion) {
        this.xlsVersion = xlsVersion;
    }

    public int getFirstBinModuleOffset() {
        return this.firstBinModuleOffset;
    }

    public void setFirstBinModuleOffset(int firstBinModuleOffset) {
        this.firstBinModuleOffset = firstBinModuleOffset;
    }

    public String getBinMakeTime() {
        return this.binMakeTime;
    }

    public void setBinMakeTime(String binMakeTime) {
        this.binMakeTime = binMakeTime;
    }

    public String getBinName() {
        return this.binName;
    }

    public void setBinName(String binName) {
        this.binName = binName;
    }
}

