/*
 * Decompiled with CFR 0.152.
 */
package com.hisilicon.hiregbin.model.reg.excel;

import com.hisilicon.hiregbin.Messages;
import com.hisilicon.hiregbin.model.FunctionParam;
import com.hisilicon.hiregbin.model.GlobleInfo;
import com.hisilicon.hiregbin.model.PinDemuxHead;
import com.hisilicon.hiregbin.model.PinDemuxInterfaceInfo;
import com.hisilicon.hiregbin.model.StarupInfo;
import com.hisilicon.hiregbin.model.reg.BaseRegisterInfo;
import com.hisilicon.hiregbin.model.reg.CAConfig;
import com.hisilicon.hiregbin.model.reg.DemoBaseParam;
import com.hisilicon.hiregbin.model.reg.DriectionConfig;
import com.hisilicon.hiregbin.model.reg.GpioData;
import com.hisilicon.hiregbin.model.reg.Layers;
import com.hisilicon.hiregbin.model.reg.LevelConfig;
import com.hisilicon.hiregbin.model.reg.NetworkConfig;
import com.hisilicon.hiregbin.model.reg.ParsedMainData;
import com.hisilicon.hiregbin.model.reg.PinDemuxInfo;
import com.hisilicon.hiregbin.model.reg.PinDemuxRegisterInfo;
import com.hisilicon.hiregbin.model.reg.bin.RegBinAction;
import com.hisilicon.hiregbin.model.reg.bin.RegBinData;
import com.hisilicon.hiregbin.model.reg.bin.RegBinItem;
import com.hisilicon.hiregbin.model.reg.cfg.CfgBinCommand;
import com.hisilicon.hiregbin.model.reg.cfg.CfgBinData;
import com.hisilicon.hiregbin.model.reg.cfg.CfgBinItem;
import com.hisilicon.hiregbin.model.reg.cfg.CfgBinModule;
import com.hisilicon.hiregbin.model.reg.cfg.CfgBinType;
import com.hisilicon.hiregbin.model.reg.excel.ExcelMainData;
import com.hisilicon.hiregbin.model.reg.excel.ExcelWorkbookInfo;
import com.hisilicon.hiregbin.model.reg.excel.MainModelParam;
import com.hisilicon.hiregbin.model.reg.excel.MainNetconfig;
import com.hisilicon.hiregbin.model.reg.excel.MainRegInfo;
import com.hisilicon.hiregbin.model.reg.hi98cv200bin.BinData;
import com.hisilicon.hiregbin.model.reg.hi98cv200bin.BinHeadData;
import com.hisilicon.hiregbin.model.reg.hi98cv200bin.BinItem;
import com.hisilicon.hiregbin.model.reg.hi98cv200bin.BinModule;
import com.hisilicon.hiregbin.model.reg.hi98cv200bin.BinModuleHead;
import com.hisilicon.hiregbin.model.reg.hi98cv200bin.BinModuleType;
import com.hisilicon.hiregbin.model.reg.hi98cv200bin.SameFunctionSumValue;
import com.hisilicon.hiregbin.processor.PrepareSetting;
import com.hisilicon.hiregbin.ui.PinDemuxComposite;
import com.hisilicon.hiregbin.utility.BitUtils;
import com.hisilicon.hiregbin.utility.ExcelDataHelper;
import com.hisilicon.hiregbin.utility.HiToolUtils;
import com.hisilicon.hiregbin.views.RegbinView;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;

public class ExcelData {
    private static String EXCELTABLENAME = "pin_mux_drv_";
    private static String EXCELTABLEPUBLIC = "fp_pin_mux_drv";
    private static String LAYER2 = "2layers";
    private static String LAYER4 = "4layers";
    private static String LAYER6 = "6layers";
    private static String LAYER8 = "8layers";
    public static final int ERROR_REGBIN_NOITEMMATCHED = 1;
    public static final int ERROR_REGBIN_VALUEINVALID = 2;
    public static final int ERROR_CFGBIN_NOMODULEMATCHED = 3;
    public static final int ERROR_CFGBIN_NOITEMMATCHED = 4;
    public static final int ERROR_CFGBIN_VALUEINVALID = 5;
    private ExcelMainData excelMainData;
    private ArrayList<ExcelWorkbookInfo> excelWorkbookInfoList = new ArrayList();
    private ArrayList<GpioData> gpioParsedDataList = new ArrayList();
    private ExcelWorkbookInfo errorWorkBook;
    private BaseRegisterInfo errorRegister;
    private int errorCode;
    private int errorValue;

    public ExcelMainData getExcelMainData() {
        return this.excelMainData;
    }

    public void setExcelMainData(ExcelMainData excelMainData) {
        this.excelMainData = excelMainData;
    }

    public ArrayList<ExcelWorkbookInfo> getExcelWorkbookInfoList() {
        return this.excelWorkbookInfoList;
    }

    public void setExcelWorkbookInfoList(ArrayList<ExcelWorkbookInfo> excelWorkbookInfoList) {
        this.excelWorkbookInfoList = excelWorkbookInfoList;
    }

    public ExcelWorkbookInfo getExcelWorkbookInfoGIPOByName() {
        if (this.excelWorkbookInfoList != null && this.excelWorkbookInfoList.size() > 0) {
            int i = 0;
            while (i < this.excelWorkbookInfoList.size()) {
                if (this.excelWorkbookInfoList.get(i).getWorkbookName().equalsIgnoreCase(EXCELTABLEPUBLIC)) {
                    return this.excelWorkbookInfoList.get(i);
                }
                ++i;
            }
        }
        return null;
    }

    public ExcelWorkbookInfo getPinMuxDrvExcelWorkbookInfo() {
        if (this.excelWorkbookInfoList != null && this.excelWorkbookInfoList.size() > 0) {
            int i = 0;
            while (i < this.excelWorkbookInfoList.size()) {
                if (this.excelWorkbookInfoList.get(i).getWorkbookName().equalsIgnoreCase("pin_mux_drv")) {
                    return this.excelWorkbookInfoList.get(i);
                }
                ++i;
            }
        }
        return null;
    }

    public ExcelWorkbookInfo getPinMuxDrvExcelWorkbookInfoByName(String name) {
        if (this.excelWorkbookInfoList != null && this.excelWorkbookInfoList.size() > 0) {
            int i = 0;
            while (i < this.excelWorkbookInfoList.size()) {
                if (name.toLowerCase().contains("spi")) {
                    name = "spi";
                }
                if (this.excelWorkbookInfoList.get(i).getWorkbookName().equalsIgnoreCase(String.valueOf(EXCELTABLENAME) + name)) {
                    return this.excelWorkbookInfoList.get(i);
                }
                ++i;
            }
        }
        return null;
    }

    public ExcelWorkbookInfo getExcelWorkbookInfoByName(String name) {
        if (this.excelWorkbookInfoList != null && this.excelWorkbookInfoList.size() > 0) {
            int i = 0;
            while (i < this.excelWorkbookInfoList.size()) {
                if (this.excelWorkbookInfoList.get(i).getWorkbookName().equalsIgnoreCase(name)) {
                    return this.excelWorkbookInfoList.get(i);
                }
                ++i;
            }
        }
        Display.getDefault().syncExec(new Runnable(){

            @Override
            public void run() {
                MessageDialog.openWarning((Shell)Display.getCurrent().getActiveShell(), (String)Messages.Message_Warning, (String)NLS.bind((String)Messages.Message_Not_Found_WORKBOOK, (Object)name));
            }
        });
        return null;
    }

    public ExcelWorkbookInfo getExcelWorkbookInfoByModuleName(String moduleName) {
        if (this.excelWorkbookInfoList != null && this.excelWorkbookInfoList.size() > 0) {
            int i = 0;
            while (i < this.excelWorkbookInfoList.size()) {
                ExcelWorkbookInfo excelWorkbookInfo = this.excelWorkbookInfoList.get(i);
                if (excelWorkbookInfo.getModuleName().equalsIgnoreCase(moduleName)) {
                    return this.excelWorkbookInfoList.get(i);
                }
                ++i;
            }
        }
        return null;
    }

    public String getDdrPCBLayers(String demoName) {
        String name = null;
        ArrayList<DemoBaseParam> demoList = this.excelMainData.getDemoList();
        int i = 0;
        while (i < demoList.size()) {
            if (demoList.get(i).getDemoName().equalsIgnoreCase(demoName)) {
                name = demoList.get(i).getDdrPCBLayers();
            }
            ++i;
        }
        return name;
    }

    public String getComboStartup(String demoName) {
        String startup = null;
        ArrayList<DemoBaseParam> demoList = this.excelMainData.getDemoList();
        int i = 0;
        while (i < demoList.size()) {
            if (demoList.get(i).getDemoName().equalsIgnoreCase(demoName)) {
                startup = demoList.get(i).getStartup();
            }
            ++i;
        }
        return startup;
    }

    public void getPublicPinDemuxInfo(PinDemuxInfo pinDemuxInfo, String demoType) {
        List<FunctionParam> funcitonParamList = new ArrayList<FunctionParam>();
        FunctionParam funcitonParam = null;
        PinDemuxRegisterInfo regsiterInfo = null;
        ArrayList<PinDemuxRegisterInfo> pinDemuxRegsiters = pinDemuxInfo.getPinDemuxRegisterList();
        GpioData gpio = null;
        ExcelWorkbookInfo info = this.getExcelWorkbookInfoGIPOByName();
        if (info != null) {
            PinDemuxHead pinDemuxHead = new PinDemuxHead();
            pinDemuxHead.setPinMuxModuleName(info.getModuleName());
            pinDemuxHead.setPinMuxBaseAddress(info.getBaseAddress());
            pinDemuxHead.setExeForNormalBoot(info.isExeForNormalBoot());
            pinDemuxHead.setExeForStandyWakeup(info.isExeForStandyWakeup());
            pinDemuxHead.setPinMuxItem(info.getItem());
            pinDemuxHead.setPinMuxPriority(info.getPriority());
            pinDemuxHead.setPinNormalChip(info.isNormalChip());
            pinDemuxHead.setPinCaChip(info.isCaChip());
            pinDemuxHead.setPinModuleType(info.getModuleType());
            int i = 0;
            while (i < info.getBaseRegisterInfoList().size()) {
                BaseRegisterInfo baseRegsiterInfo = info.getBaseRegisterInfoList().get(i);
                regsiterInfo = new PinDemuxRegisterInfo();
                String regName = baseRegsiterInfo.getRegName();
                regsiterInfo.setPinMuxRegName(regName);
                int offsetAddress = baseRegsiterInfo.getRegOffsetAddress();
                regsiterInfo.setPinMuxOffsetAddress(offsetAddress);
                Map<String, String> selectFunValue = baseRegsiterInfo.getDemoSelectFunValue();
                String selectfunction = selectFunValue.get(demoType);
                String function = baseRegsiterInfo.getRegFunction();
                if (selectfunction.equals(function)) {
                    pinDemuxRegsiters.add(regsiterInfo);
                }
                if (function != null && (function.toUpperCase().startsWith("GPIO") || function.toUpperCase().startsWith("AON_GPIO"))) {
                    gpio = new GpioData();
                    gpio.setGpioName(function);
                    gpio.setGpioLevel(LevelConfig.NA);
                    gpio.setGpioDirection(DriectionConfig.Input);
                    String gpioGroupStr = this.handleGpioGroupStr(function);
                    ArrayList<GpioData> gpioList = this.getExcelMainData().getGpioList();
                    for (GpioData gpioData : gpioList) {
                        String gpioName = gpioData.getGpioName();
                        int gpioGroupAddress = gpioData.getGpioGroupAddress();
                        if (!gpioName.startsWith(gpioGroupStr)) continue;
                        gpio.setGpioGroupAddress(gpioGroupAddress);
                        break;
                    }
                    gpio.setPinDemuxHead(pinDemuxHead);
                    String gpioID = PinDemuxComposite.genGpioID(function, pinDemuxHead.getPinMuxModuleName(), regName);
                    gpio.setGpioID(gpioID);
                    pinDemuxInfo.setGpioMap(gpioID, gpio);
                    regsiterInfo.setGpio(true);
                }
                regsiterInfo.setPinMuxFunction(function);
                String driver = baseRegsiterInfo.getLayerDriver();
                String slewRete = baseRegsiterInfo.getLayerSlewRate();
                int value = baseRegsiterInfo.getLayerValue();
                String pupd = baseRegsiterInfo.getLayerPupd();
                funcitonParam = this.setFuncParamAndRegInfo(regsiterInfo, pinDemuxHead, baseRegsiterInfo, regName, function, driver, slewRete, value, pupd);
                funcitonParamList = this.setCurRegFunction(info, funcitonParamList, funcitonParam, i, regName);
                this.setRegInfo(regsiterInfo, pinDemuxHead, baseRegsiterInfo);
                ++i;
            }
        }
        pinDemuxInfo.setPinDemuxRegisterList(pinDemuxRegsiters);
    }

    private FunctionParam setFuncParamAndRegInfo(PinDemuxRegisterInfo regsiterInfo, PinDemuxHead pinDemuxHead, BaseRegisterInfo baseRegsiterInfo, String regName, String function, String driver, String slewRete, int value, String pupd) {
        FunctionParam funcitonParam = new FunctionParam();
        funcitonParam.setFunction(function);
        funcitonParam.setRegisterName(regName);
        funcitonParam.setCurRegInModuleID(pinDemuxHead.getPinMuxModuleName(), regName, baseRegsiterInfo.getRegPinNum());
        regsiterInfo.setPinMuxDriver(driver);
        regsiterInfo.setPinMuxSlewRate(slewRete);
        regsiterInfo.setPinMuxValue(value);
        regsiterInfo.setPinMuxPupd(pupd);
        return funcitonParam;
    }

    private String handleGpioGroupStr(String function) {
        int indexOf = function.indexOf("_AON");
        if (indexOf != -1) {
            return function.substring(0, indexOf);
        }
        indexOf = function.indexOf("_");
        String gpioGroupStr = "";
        gpioGroupStr = indexOf != -1 ? function.substring(0, indexOf) : function.substring(0, 5);
        return gpioGroupStr;
    }

    public PinDemuxInfo getPinDemuxInfoByStartup(String demoType, StarupInfo starupInfo, boolean filterFunction, boolean isOriginal, String volDvdd) {
        ExcelWorkbookInfo aonBookInfo;
        ExcelWorkbookInfo fpPinMuxDrvInfo;
        PinDemuxInfo pinDemuxInfo = new PinDemuxInfo();
        PinDemuxInterfaceInfo pinDemuxInterfaceInfo = new PinDemuxInterfaceInfo();
        pinDemuxInterfaceInfo.setPinDemuxInfo(pinDemuxInfo);
        pinDemuxInterfaceInfo.setDemoType(demoType);
        String[] startupItem = starupInfo.getStartupItem();
        int startupIndex = 0;
        while (startupIndex < startupItem.length) {
            String startup = startupItem[startupIndex];
            ExcelWorkbookInfo info = this.getPinMuxDrvExcelWorkbookInfoByName(startup);
            pinDemuxInterfaceInfo.setStartup(startup);
            if (info != null) {
                this.convertWorkbookToPinDemuxInfo(pinDemuxInterfaceInfo, info, filterFunction, false, volDvdd);
            }
            ++startupIndex;
        }
        ExcelWorkbookInfo pinMuxDrvInfo = this.getPinMuxDrvExcelWorkbookInfo();
        if (pinMuxDrvInfo != null) {
            pinDemuxInterfaceInfo.setStartup("pin_mux_drv");
            this.convertWorkbookToPinDemuxInfo(pinDemuxInterfaceInfo, pinMuxDrvInfo, filterFunction, false, volDvdd);
        }
        if ((fpPinMuxDrvInfo = this.getExcelWorkbookInfoGIPOByName()) != null) {
            pinDemuxInterfaceInfo.setStartup("fp_pin_mux_drv");
            this.convertWorkbookToPinDemuxInfo(pinDemuxInterfaceInfo, fpPinMuxDrvInfo, filterFunction, true, volDvdd);
        }
        if ((aonBookInfo = this.getPinMuxDrvExcelWorkbookInfoByName("aon")) != null) {
            pinDemuxInterfaceInfo.setStartup("pin_mux_drv_aon");
            this.convertWorkbookToPinDemuxInfo(pinDemuxInterfaceInfo, aonBookInfo, filterFunction, false, volDvdd);
        }
        String selectStartup = starupInfo.getStarup();
        this.copyPinDemuxReg(selectStartup, pinDemuxInfo, isOriginal, startupItem);
        return pinDemuxInfo;
    }

    public void copyPinDemuxReg(String selectStartup, PinDemuxInfo pinDemuxInfo, boolean isOriginal, String[] startupItems) {
        ArrayList<PinDemuxRegisterInfo> pinDemuxRegisterList = pinDemuxInfo.getPinDemuxRegisterList();
        pinDemuxRegisterList.clear();
        Map<String, ArrayList<PinDemuxRegisterInfo>> pinDemuxForFlashMap = pinDemuxInfo.getPinDemuxForFlashMap();
        if (isOriginal) {
            if (startupItems != null) {
                String[] stringArray = startupItems;
                int n = startupItems.length;
                int n2 = 0;
                while (n2 < n) {
                    String startup = stringArray[n2];
                    if (pinDemuxForFlashMap.containsKey(startup)) {
                        ArrayList<PinDemuxRegisterInfo> startupList = pinDemuxForFlashMap.get(startup);
                        for (PinDemuxRegisterInfo pinDemuxRegisterInfo : startupList) {
                            pinDemuxRegisterList.add(pinDemuxRegisterInfo);
                        }
                    }
                    ++n2;
                }
            }
        } else if (pinDemuxForFlashMap.containsKey(selectStartup)) {
            ArrayList<PinDemuxRegisterInfo> startupList = pinDemuxForFlashMap.get(selectStartup);
            for (PinDemuxRegisterInfo pinDemuxRegisterInfo : startupList) {
                pinDemuxRegisterList.add(pinDemuxRegisterInfo);
            }
        }
        if (pinDemuxForFlashMap.containsKey("pin_mux_drv")) {
            ArrayList<PinDemuxRegisterInfo> pinMuxDrvList;
            if (pinDemuxForFlashMap.containsKey("pin_mux_drv")) {
                pinMuxDrvList = pinDemuxForFlashMap.get("pin_mux_drv");
                for (PinDemuxRegisterInfo pinDemuxRegisterInfo : pinMuxDrvList) {
                    pinDemuxRegisterList.add(pinDemuxRegisterInfo);
                }
            }
            if (pinDemuxForFlashMap.containsKey("pin_mux_drv_aon")) {
                pinMuxDrvList = pinDemuxForFlashMap.get("pin_mux_drv_aon");
                for (PinDemuxRegisterInfo pinDemuxRegisterInfo : pinMuxDrvList) {
                    pinDemuxRegisterList.add(pinDemuxRegisterInfo);
                }
            }
        }
        if (pinDemuxForFlashMap.containsKey("fp_pin_mux_drv") && pinDemuxForFlashMap.containsKey("fp_pin_mux_drv")) {
            ArrayList<PinDemuxRegisterInfo> fpPinMuxDrvList = pinDemuxForFlashMap.get("fp_pin_mux_drv");
            for (PinDemuxRegisterInfo pinDemuxRegisterInfo : fpPinMuxDrvList) {
                pinDemuxRegisterList.add(pinDemuxRegisterInfo);
            }
        }
    }

    private String getVolDvddType(String demoType) {
        ParsedMainData parsedMainData = ExcelDataHelper.getDemoParsedMainData();
        for (DemoBaseParam demoBaseParam : parsedMainData.getDemoList()) {
            if (!demoType.equals(demoBaseParam.getDemoName())) continue;
            return demoBaseParam.getVolDvdd();
        }
        return null;
    }

    private void convertWorkbookToPinDemuxInfo(PinDemuxInterfaceInfo pinDemuxInterfaceInfo, ExcelWorkbookInfo info, boolean filterFunction, boolean isFpPinMuxDrv, String volDvdd) {
        String demoType = pinDemuxInterfaceInfo.getDemoType();
        List<FunctionParam> funcitonParamList = new ArrayList<FunctionParam>();
        ArrayList<PinDemuxRegisterInfo> pinDemuxRegsiters = new ArrayList<PinDemuxRegisterInfo>();
        String ddrPCBLayers = this.getDdrPCBLayers(demoType);
        PinDemuxRegisterInfo regsiterInfo = null;
        Object gpio = null;
        PinDemuxHead pinDemuxHead = new PinDemuxHead();
        pinDemuxHead.setPinMuxModuleName(info.getModuleName());
        pinDemuxHead.setPinMuxBaseAddress(info.getBaseAddress());
        pinDemuxHead.setExeForNormalBoot(info.isExeForNormalBoot());
        pinDemuxHead.setExeForStandyWakeup(info.isExeForStandyWakeup());
        pinDemuxHead.setPinMuxItem(info.getItem());
        pinDemuxHead.setPinMuxPriority(info.getPriority());
        pinDemuxHead.setPinNormalChip(info.isNormalChip());
        pinDemuxHead.setPinCaChip(info.isCaChip());
        pinDemuxHead.setPinModuleType(info.getModuleType());
        PinDemuxInfo pinDemuxInfo = pinDemuxInterfaceInfo.getPinDemuxInfo();
        String startup = pinDemuxInterfaceInfo.getStartup();
        int i = 0;
        while (i < info.getBaseRegisterInfoList().size()) {
            block18: {
                String function;
                String regName;
                BaseRegisterInfo baseRegsiterInfo;
                block17: {
                    baseRegsiterInfo = info.getBaseRegisterInfoList().get(i);
                    regsiterInfo = new PinDemuxRegisterInfo();
                    regName = baseRegsiterInfo.getRegName();
                    regsiterInfo.setPinMuxRegName(regName);
                    int offsetAddress = baseRegsiterInfo.getRegOffsetAddress();
                    regsiterInfo.setPinMuxOffsetAddress(offsetAddress);
                    function = baseRegsiterInfo.getRegFunction();
                    if (!startup.equals("pin_mux_drv")) break block17;
                    if (volDvdd == null) {
                        volDvdd = this.getVolDvddType(demoType);
                    }
                    if (volDvdd != null && (volDvdd.equals("3V3_IO") && function.endsWith("1V8") || volDvdd.equals("1V8_IO") && function.endsWith("3V3"))) break block18;
                }
                if (function != null) {
                    this.setPinDemuxInfoData(pinDemuxInfo, regsiterInfo, pinDemuxHead, regName, function);
                }
                regsiterInfo.setPinMuxFunction(function);
                String driver = "";
                String slewRete = "";
                String pupd = "";
                int value = 0;
                if (!isFpPinMuxDrv) {
                    Layers layers = null;
                    if (LAYER2.equalsIgnoreCase(ddrPCBLayers)) {
                        layers = baseRegsiterInfo.getRegLayers2();
                    } else if (LAYER4.equalsIgnoreCase(ddrPCBLayers) || LAYER6.equalsIgnoreCase(ddrPCBLayers) || LAYER8.equalsIgnoreCase(ddrPCBLayers)) {
                        layers = baseRegsiterInfo.getRegLayers4and6and8();
                    }
                    if (layers != null) {
                        driver = layers.getDriver();
                        slewRete = layers.getSlewRate();
                        pupd = layers.getPupd();
                        value = layers.getValue();
                    }
                } else {
                    driver = baseRegsiterInfo.getLayerDriver();
                    slewRete = baseRegsiterInfo.getLayerSlewRate();
                    value = baseRegsiterInfo.getLayerValue();
                    pupd = baseRegsiterInfo.getLayerPupd();
                }
                FunctionParam funcitonParam = this.setFuncParamAndRegInfo(regsiterInfo, pinDemuxHead, baseRegsiterInfo, regName, function, driver, slewRete, value, pupd);
                funcitonParamList = this.setCurRegFunction(info, funcitonParamList, funcitonParam, i, regName);
                this.setRegInfo(regsiterInfo, pinDemuxHead, baseRegsiterInfo);
                if (filterFunction) {
                    Map<String, String> selectFunValue = baseRegsiterInfo.getDemoSelectFunValue();
                    if (selectFunValue == null) {
                        pinDemuxRegsiters.add(regsiterInfo);
                    } else {
                        String selectfunction = selectFunValue.get(demoType);
                        if (selectfunction != null && selectfunction.equals(function)) {
                            pinDemuxRegsiters.add(regsiterInfo);
                        }
                    }
                } else {
                    pinDemuxRegsiters.add(regsiterInfo);
                }
            }
            ++i;
        }
        pinDemuxInfo.getPinDemuxForFlashMap().put(startup, pinDemuxRegsiters);
    }

    private void setPinDemuxInfoData(PinDemuxInfo pinDemuxInfo, PinDemuxRegisterInfo regsiterInfo, PinDemuxHead pinDemuxHead, String regName, String function) {
        if (function.toUpperCase().startsWith("GPIO") || function.toUpperCase().startsWith("AON_GPIO")) {
            GpioData gpio = new GpioData();
            gpio.setGpioName(function);
            gpio.setGpioLevel(LevelConfig.NA);
            gpio.setGpioDirection(DriectionConfig.Input);
            String gpioGroupStr = this.handleGpioGroupStr(function);
            ArrayList<GpioData> gpioList = this.getExcelMainData().getGpioList();
            for (GpioData gpioData : gpioList) {
                String gpioName = gpioData.getGpioName();
                int gpioGroupAddress = gpioData.getGpioGroupAddress();
                if (!gpioName.startsWith(gpioGroupStr)) continue;
                gpio.setGpioGroupAddress(gpioGroupAddress);
                break;
            }
            gpio.setPinDemuxHead(pinDemuxHead);
            String gpioID = PinDemuxComposite.genGpioID(function, pinDemuxHead.getPinMuxModuleName(), regName);
            gpio.setGpioID(gpioID);
            pinDemuxInfo.setGpioMap(gpioID, gpio);
            System.out.println(gpioID);
            regsiterInfo.setGpio(true);
        }
    }

    private void setRegInfo(PinDemuxRegisterInfo regsiterInfo, PinDemuxHead pinDemuxHead, BaseRegisterInfo baseRegsiterInfo) {
        regsiterInfo.setPinMuxRegisterAttribute(baseRegsiterInfo.getRegAttribute());
        regsiterInfo.setPinNum(baseRegsiterInfo.getRegPinNum());
        regsiterInfo.setRegDelay(baseRegsiterInfo.getRegDelay());
        regsiterInfo.setRegReadOrWrite(baseRegsiterInfo.getRegReadOrWrite());
        regsiterInfo.setRegBit(baseRegsiterInfo.getRegBit());
        regsiterInfo.setRegStartBit(baseRegsiterInfo.getRegStartBit());
        regsiterInfo.setPinDemuxHead(pinDemuxHead);
    }

    private List<FunctionParam> setCurRegFunction(ExcelWorkbookInfo info, List<FunctionParam> funcitonParamList, FunctionParam funcitonParam, int i, String regName) {
        if (funcitonParamList.size() == 0) {
            funcitonParamList.add(funcitonParam);
        } else {
            int j = 0;
            while (j < funcitonParamList.size()) {
                String functionRegName = funcitonParamList.get(j).getRegisterName();
                String curRegInModule = funcitonParamList.get(j).getCurRegInModuleID();
                if (functionRegName.equals(regName)) {
                    if (!funcitonParamList.contains(funcitonParam)) {
                        funcitonParamList.add(funcitonParam);
                    }
                    if (i != info.getBaseRegisterInfoList().size() - 1) break;
                    GlobleInfo.setRegisterFunction(curRegInModule, funcitonParamList);
                    break;
                }
                GlobleInfo.setRegisterFunction(curRegInModule, funcitonParamList);
                funcitonParamList = new ArrayList<FunctionParam>();
                funcitonParamList.add(funcitonParam);
                if (i == info.getBaseRegisterInfoList().size() - 1) {
                    String curRegInModuleID = funcitonParam.getCurRegInModuleID();
                    GlobleInfo.setRegisterFunction(curRegInModuleID, funcitonParamList);
                }
                ++j;
            }
        }
        return funcitonParamList;
    }

    public PinDemuxInfo getPinDemuxInfo(String demoType, String name) {
        List<FunctionParam> funcitonParamList = new ArrayList<FunctionParam>();
        PinDemuxInfo pinDemuxInfo = new PinDemuxInfo();
        PinDemuxRegisterInfo regsiterInfo = null;
        ArrayList<PinDemuxRegisterInfo> pinDemuxRegsiters = new ArrayList<PinDemuxRegisterInfo>();
        GpioData gpio = null;
        String ddrPCBLayers = this.getDdrPCBLayers(demoType);
        ExcelWorkbookInfo info = this.getPinMuxDrvExcelWorkbookInfoByName(name);
        if (info != null) {
            PinDemuxHead pinDemuxHead = new PinDemuxHead();
            pinDemuxHead.setPinMuxModuleName(info.getModuleName());
            pinDemuxHead.setPinMuxBaseAddress(info.getBaseAddress());
            pinDemuxHead.setExeForNormalBoot(info.isExeForNormalBoot());
            pinDemuxHead.setExeForStandyWakeup(info.isExeForStandyWakeup());
            pinDemuxHead.setPinMuxItem(info.getItem());
            pinDemuxHead.setPinMuxPriority(info.getPriority());
            pinDemuxHead.setPinNormalChip(info.isNormalChip());
            pinDemuxHead.setPinCaChip(info.isCaChip());
            pinDemuxHead.setPinModuleType(info.getModuleType());
            int i = 0;
            while (i < info.getBaseRegisterInfoList().size()) {
                BaseRegisterInfo baseRegsiterInfo = info.getBaseRegisterInfoList().get(i);
                regsiterInfo = new PinDemuxRegisterInfo();
                String regName = baseRegsiterInfo.getRegName();
                regsiterInfo.setPinMuxRegName(regName);
                int offsetAddress = baseRegsiterInfo.getRegOffsetAddress();
                regsiterInfo.setPinMuxOffsetAddress(offsetAddress);
                Map<String, String> selectFunValue = baseRegsiterInfo.getDemoSelectFunValue();
                String selectfunction = selectFunValue.get(demoType);
                String function = baseRegsiterInfo.getRegFunction();
                if (selectfunction.equals(function)) {
                    pinDemuxRegsiters.add(regsiterInfo);
                }
                if (function != null && (function.toUpperCase().startsWith("GPIO") || function.toUpperCase().startsWith("AON_GPIO"))) {
                    gpio = new GpioData();
                    gpio.setGpioName(function);
                    gpio.setGpioLevel(LevelConfig.NA);
                    gpio.setGpioDirection(DriectionConfig.Input);
                    String gpioGroupStr = this.handleGpioGroupStr(function);
                    ArrayList<GpioData> gpioList = this.getExcelMainData().getGpioList();
                    for (GpioData gpioData : gpioList) {
                        String gpioName = gpioData.getGpioName();
                        int gpioGroupAddress = gpioData.getGpioGroupAddress();
                        if (!gpioName.startsWith(gpioGroupStr)) continue;
                        gpio.setGpioGroupAddress(gpioGroupAddress);
                        break;
                    }
                    gpio.setPinDemuxHead(pinDemuxHead);
                    String gpioID = PinDemuxComposite.genGpioID(function, pinDemuxHead.getPinMuxModuleName(), regName);
                    gpio.setGpioID(gpioID);
                    pinDemuxInfo.setGpioMap(gpioID, gpio);
                    regsiterInfo.setGpio(true);
                }
                regsiterInfo.setPinMuxFunction(function);
                Layers layers = null;
                if (LAYER2.equalsIgnoreCase(ddrPCBLayers)) {
                    layers = baseRegsiterInfo.getRegLayers2();
                } else if (LAYER4.equalsIgnoreCase(ddrPCBLayers) || LAYER6.equalsIgnoreCase(ddrPCBLayers) || LAYER8.equalsIgnoreCase(ddrPCBLayers)) {
                    layers = baseRegsiterInfo.getRegLayers4and6and8();
                }
                if (layers != null) {
                    String driver = layers.getDriver();
                    String slewRete = layers.getSlewRate();
                    int value = layers.getValue();
                    String pupd = layers.getPupd();
                    FunctionParam funcitonParam = this.setFuncParamAndRegInfo(regsiterInfo, pinDemuxHead, baseRegsiterInfo, regName, function, driver, slewRete, value, pupd);
                    funcitonParamList = this.setCurRegFunction(info, funcitonParamList, funcitonParam, i, regName);
                }
                this.setRegInfo(regsiterInfo, pinDemuxHead, baseRegsiterInfo);
                ++i;
            }
            pinDemuxInfo.setPinDemuxRegisterList(pinDemuxRegsiters);
            this.getPublicPinDemuxInfo(pinDemuxInfo, demoType);
        }
        return pinDemuxInfo;
    }

    public PinDemuxInfo getOriginalpinDemuxInfo(String demoType, String name) {
        List<FunctionParam> funcitonParamList = new ArrayList<FunctionParam>();
        PinDemuxInfo originalpinDemuxInfo = new PinDemuxInfo();
        PinDemuxRegisterInfo regsiterInfo = null;
        ArrayList<PinDemuxRegisterInfo> originalpinDemuxRegsiters = new ArrayList<PinDemuxRegisterInfo>();
        GpioData gpio = null;
        String ddrPCBLayers = this.getDdrPCBLayers(demoType);
        ExcelWorkbookInfo info = this.getPinMuxDrvExcelWorkbookInfoByName(name);
        if (info != null) {
            PinDemuxHead pinDemuxHead = new PinDemuxHead();
            pinDemuxHead.setPinMuxModuleName(info.getModuleName());
            pinDemuxHead.setPinMuxBaseAddress(info.getBaseAddress());
            pinDemuxHead.setExeForNormalBoot(info.isExeForNormalBoot());
            pinDemuxHead.setExeForStandyWakeup(info.isExeForStandyWakeup());
            pinDemuxHead.setPinMuxItem(info.getItem());
            pinDemuxHead.setPinMuxPriority(info.getPriority());
            pinDemuxHead.setPinNormalChip(info.isNormalChip());
            pinDemuxHead.setPinCaChip(info.isCaChip());
            pinDemuxHead.setPinModuleType(info.getModuleType());
            int i = 0;
            while (i < info.getBaseRegisterInfoList().size()) {
                BaseRegisterInfo baseRegsiterInfo = info.getBaseRegisterInfoList().get(i);
                String regName = baseRegsiterInfo.getRegName();
                regsiterInfo = new PinDemuxRegisterInfo();
                regsiterInfo.setPinMuxRegName(regName);
                int offsetAddress = baseRegsiterInfo.getRegOffsetAddress();
                regsiterInfo.setPinMuxOffsetAddress(offsetAddress);
                String function = baseRegsiterInfo.getRegFunction();
                if (function != null && (function.toUpperCase().startsWith("GPIO") || function.toUpperCase().startsWith("AON_GPIO"))) {
                    gpio = new GpioData();
                    gpio.setGpioName(function);
                    gpio.setGpioLevel(LevelConfig.NA);
                    gpio.setGpioDirection(DriectionConfig.Input);
                    String gpioGroupStr = this.handleGpioGroupStr(function);
                    ArrayList<GpioData> gpioList = this.getExcelMainData().getGpioList();
                    for (GpioData gpioData : gpioList) {
                        String gpioName = gpioData.getGpioName();
                        int gpioGroupAddress = gpioData.getGpioGroupAddress();
                        if (!gpioName.startsWith(gpioGroupStr)) continue;
                        gpio.setGpioGroupAddress(gpioGroupAddress);
                        break;
                    }
                    gpio.setPinDemuxHead(pinDemuxHead);
                    String gpioID = PinDemuxComposite.genGpioID(function, pinDemuxHead.getPinMuxModuleName(), regName);
                    gpio.setGpioID(gpioID);
                    originalpinDemuxInfo.setGpioMap(gpioID, gpio);
                    regsiterInfo.setGpio(true);
                }
                regsiterInfo.setPinMuxFunction(function);
                Layers layers = null;
                if (LAYER2.equalsIgnoreCase(ddrPCBLayers)) {
                    layers = baseRegsiterInfo.getRegLayers2();
                } else if (LAYER4.equalsIgnoreCase(ddrPCBLayers) || LAYER6.equalsIgnoreCase(ddrPCBLayers) || LAYER8.equalsIgnoreCase(ddrPCBLayers)) {
                    layers = baseRegsiterInfo.getRegLayers4and6and8();
                }
                if (layers != null) {
                    String driver = layers.getDriver();
                    String slewRete = layers.getSlewRate();
                    String pupd = layers.getPupd();
                    int value = layers.getValue();
                    FunctionParam funcitonParam = this.setFuncParamAndRegInfo(regsiterInfo, pinDemuxHead, baseRegsiterInfo, regName, function, driver, slewRete, value, pupd);
                    funcitonParamList = this.setCurRegFunction(info, funcitonParamList, funcitonParam, i, regName);
                }
                this.setRegInfo(regsiterInfo, pinDemuxHead, baseRegsiterInfo);
                originalpinDemuxRegsiters.add(regsiterInfo);
                ++i;
            }
        }
        originalpinDemuxInfo.setPinDemuxRegisterList(originalpinDemuxRegsiters);
        this.getPublicOriginalPinDemuxInfo(originalpinDemuxInfo, demoType);
        return originalpinDemuxInfo;
    }

    private void getPublicOriginalPinDemuxInfo(PinDemuxInfo originalpinDemuxInfo, String demoType) {
        List<FunctionParam> funcitonParamList = new ArrayList<FunctionParam>();
        FunctionParam funcitonParam = null;
        PinDemuxRegisterInfo regsiterInfo = null;
        ArrayList<PinDemuxRegisterInfo> originalpinDemuxRegsiters = originalpinDemuxInfo.getPinDemuxRegisterList();
        GpioData gpio = null;
        ExcelWorkbookInfo info = this.getExcelWorkbookInfoGIPOByName();
        if (info != null) {
            PinDemuxHead pinDemuxHead = new PinDemuxHead();
            pinDemuxHead.setPinMuxModuleName(info.getModuleName());
            pinDemuxHead.setPinMuxBaseAddress(info.getBaseAddress());
            pinDemuxHead.setExeForNormalBoot(info.isExeForNormalBoot());
            pinDemuxHead.setExeForStandyWakeup(info.isExeForStandyWakeup());
            pinDemuxHead.setPinMuxItem(info.getItem());
            pinDemuxHead.setPinMuxPriority(info.getPriority());
            pinDemuxHead.setPinNormalChip(info.isNormalChip());
            pinDemuxHead.setPinCaChip(info.isCaChip());
            pinDemuxHead.setPinModuleType(info.getModuleType());
            int i = 0;
            while (i < info.getBaseRegisterInfoList().size()) {
                BaseRegisterInfo baseRegsiterInfo = info.getBaseRegisterInfoList().get(i);
                String regName = baseRegsiterInfo.getRegName();
                regsiterInfo = new PinDemuxRegisterInfo();
                regsiterInfo.setPinMuxRegName(regName);
                int offsetAddress = baseRegsiterInfo.getRegOffsetAddress();
                regsiterInfo.setPinMuxOffsetAddress(offsetAddress);
                String function = baseRegsiterInfo.getRegFunction();
                if (function != null && (function.toUpperCase().startsWith("GPIO") || function.toUpperCase().startsWith("AON_GPIO"))) {
                    gpio = new GpioData();
                    gpio.setGpioName(function);
                    gpio.setGpioLevel(LevelConfig.NA);
                    gpio.setGpioDirection(DriectionConfig.Input);
                    String gpioGroupStr = this.handleGpioGroupStr(function);
                    ArrayList<GpioData> gpioList = this.getExcelMainData().getGpioList();
                    for (GpioData gpioData : gpioList) {
                        String gpioName = gpioData.getGpioName();
                        int gpioGroupAddress = gpioData.getGpioGroupAddress();
                        if (!gpioName.startsWith(gpioGroupStr)) continue;
                        gpio.setGpioGroupAddress(gpioGroupAddress);
                        break;
                    }
                    gpio.setPinDemuxHead(pinDemuxHead);
                    String gpioID = PinDemuxComposite.genGpioID(function, pinDemuxHead.getPinMuxModuleName(), regName);
                    gpio.setGpioID(gpioID);
                    originalpinDemuxInfo.setGpioMap(gpioID, gpio);
                    regsiterInfo.setGpio(true);
                }
                regsiterInfo.setPinMuxFunction(function);
                String driver = baseRegsiterInfo.getLayerDriver();
                String slewRete = baseRegsiterInfo.getLayerSlewRate();
                int value = baseRegsiterInfo.getLayerValue();
                String pupd = baseRegsiterInfo.getLayerPupd();
                funcitonParam = this.setFuncParamAndRegInfo(regsiterInfo, pinDemuxHead, baseRegsiterInfo, regName, function, driver, slewRete, value, pupd);
                funcitonParamList = this.setCurRegFunction(info, funcitonParamList, funcitonParam, i, regName);
                this.setRegInfo(regsiterInfo, pinDemuxHead, baseRegsiterInfo);
                originalpinDemuxRegsiters.add(regsiterInfo);
                ++i;
            }
        }
        originalpinDemuxInfo.setPinDemuxRegisterList(originalpinDemuxRegsiters);
    }

    public ExcelWorkbookInfo getErrorWorkbook() {
        return this.errorWorkBook;
    }

    public BaseRegisterInfo getErrorRegister() {
        return this.errorRegister;
    }

    public int getErrorCode() {
        return this.errorCode;
    }

    public int getErrorValue() {
        return this.errorValue;
    }

    public boolean importRegBin(ExcelData excelData, ParsedMainData pmData, RegBinData binData, boolean forceExitOnError) {
        boolean error;
        this.errorWorkBook = null;
        this.errorRegister = null;
        ArrayList<RegBinItem> getmListItems = binData.getmListItems();
        for (RegBinItem regBinItem : getmListItems) {
            regBinItem.setHasExport(false);
        }
        if (!this.refreshBaseForRegBinImport(binData, excelData, pmData)) {
            return false;
        }
        String customName = pmData.getCustomDemoName();
        String customSelectDemoName = ExcelDataHelper.extractDeviceName(customName).trim();
        String startupString = this.getStartupStr(customName);
        int i = 0;
        while (i < excelData.getExcelWorkbookInfoList().size()) {
            block13: {
                boolean isIgnoreWorkBookName;
                boolean hi3716mv410Series;
                String workbookName;
                boolean isIgnore;
                ExcelWorkbookInfo bookInfo = excelData.getExcelWorkbookInfoList().get(i);
                boolean bl = isIgnore = bookInfo.getWorkbookName().equalsIgnoreCase("others") || bookInfo.getWorkbookName().equalsIgnoreCase("sysctrl_CA");
                if (isIgnore || !this.filterDemoNameWookbook(workbookName = bookInfo.getWorkbookName(), customSelectDemoName) || (hi3716mv410Series = RegbinView.isHi3716MV410Series()) && (isIgnoreWorkBookName = this.checkWorkBookName(startupString, workbookName))) break block13;
                String lastRegName = "";
                int j = 0;
                while (j < bookInfo.getBaseRegisterInfoList().size()) {
                    block15: {
                        boolean regFunc;
                        RegBinItem item;
                        int searchAddr;
                        BaseRegisterInfo regInfo;
                        block16: {
                            int attributes;
                            RegBinItem regBinItem;
                            block14: {
                                regInfo = bookInfo.getBaseRegisterInfoList().get(j);
                                searchAddr = bookInfo.getBaseAddress() + regInfo.getRegOffsetAddress();
                                String regFunction = regInfo.getRegFunction();
                                item = null;
                                boolean bl2 = regFunc = regFunction != null && !regFunction.isEmpty();
                                if (!regFunc) break block14;
                                if (regInfo.getRegName().equalsIgnoreCase(lastRegName)) break block15;
                                regBinItem = new RegBinItem();
                                this.handleAttributeValue(bookInfo.isExeForNormalBoot(), bookInfo.isExeForStandyWakeup(), regInfo.getRegBit(), regInfo.getRegStartBit(), regInfo.getRegReadOrWrite(), regBinItem);
                                attributes = regBinItem.getAttributes();
                                item = binData.seekForItem(searchAddr, regInfo.getRegReadOrWrite(), attributes);
                                lastRegName = regInfo.getRegName();
                                break block16;
                            }
                            regBinItem = new RegBinItem();
                            this.handleAttributeValue(bookInfo.isExeForNormalBoot(), bookInfo.isExeForStandyWakeup(), regInfo.getRegBit(), regInfo.getRegStartBit(), regInfo.getRegReadOrWrite(), regBinItem);
                            attributes = regBinItem.getAttributes();
                            item = binData.seekForItem(searchAddr, regInfo.getRegReadOrWrite(), attributes);
                            lastRegName = regInfo.getRegName();
                        }
                        if (item == null) {
                            boolean bl3 = regFunc = regInfo.getRegFunction() != null && !regInfo.getRegFunction().isEmpty();
                            if (!regFunc && forceExitOnError) {
                                this.errorWorkBook = bookInfo;
                                this.errorRegister = regInfo;
                                this.errorCode = 1;
                                this.errorValue = 0;
                            }
                        } else {
                            RegBinAction action = this.getRegBinAction(item, bookInfo);
                            int value = item.getValue();
                            if (!pmData.isValueValid(searchAddr, value)) {
                                if (forceExitOnError) {
                                    this.errorWorkBook = bookInfo;
                                    this.errorRegister = regInfo;
                                    this.errorCode = 2;
                                    this.errorValue = value;
                                }
                            } else {
                                boolean bl4 = regFunc = regInfo.getRegFunction() != null && !regInfo.getRegFunction().isEmpty();
                                if (regFunc) {
                                    System.out.println(regInfo.getRegName());
                                } else {
                                    regInfo.setRegValue(value);
                                }
                                regInfo.setRegReadOrWrite(action);
                                regInfo.setRegDelay(item.getDelay());
                                regInfo.setRegStartBit(item.getStartBit(action));
                                regInfo.setRegBit(item.getBits(action));
                                bookInfo.getBaseRegisterInfoList().set(j, regInfo);
                            }
                        }
                    }
                    ++j;
                }
                excelData.getExcelWorkbookInfoList().set(i, bookInfo);
            }
            ++i;
        }
        excelData.setExcelWorkbookInfoList(excelData.getExcelWorkbookInfoList());
        ExcelDataHelper.setExcelDataforImport(excelData);
        boolean bl = error = this.errorWorkBook != null && this.errorRegister != null;
        if (error) {
            return false;
        }
        this.errorWorkBook = null;
        this.errorRegister = null;
        this.errorCode = 0;
        this.errorValue = 0;
        return true;
    }

    private RegBinAction getRegBinAction(RegBinItem item, ExcelWorkbookInfo bookInfo) {
        RegBinAction action = null;
        if (item.isActionEnabled(RegBinAction.READ)) {
            action = RegBinAction.READ;
        } else if (item.isActionEnabled(RegBinAction.WRITE)) {
            action = RegBinAction.WRITE;
        }
        if (action != null) {
            bookInfo.setExeForNormalBoot(item.isExecutionRequiredForNormalBoot(action));
            bookInfo.setExeForStandyWakeup(item.isExecutionRequiredForStandbyWakeup(action));
        }
        return action;
    }

    public boolean importBinData(ExcelData excelData, BinData binData, ParsedMainData pmData, boolean forceExitOnError) {
        this.errorWorkBook = null;
        this.errorRegister = null;
        if (!this.refreshBaseForBinDataImport(binData, excelData, pmData)) {
            return false;
        }
        binData.initBinDataExport(binData);
        String customName = pmData.getCustomDemoName();
        String customSelectDemoName = ExcelDataHelper.extractDeviceName(customName).trim();
        int i = 0;
        while (i < excelData.getExcelWorkbookInfoList().size()) {
            ExcelWorkbookInfo bookInfo = excelData.getExcelWorkbookInfoList().get(i);
            if (!bookInfo.getWorkbookName().equalsIgnoreCase("others") && this.filterDemoNameWookbook(bookInfo.getWorkbookName(), customSelectDemoName)) {
                int j = 0;
                while (j < bookInfo.getBaseRegisterInfoList().size()) {
                    BaseRegisterInfo regInfo = bookInfo.getBaseRegisterInfoList().get(j);
                    BinModuleType moduleType = bookInfo.getModuleType();
                    String regFunction = regInfo.getRegFunction();
                    BinItem item = null;
                    item = binData.seekForItem(bookInfo.getBaseAddress(), regInfo.getRegOffsetAddress(), regInfo.getRegStartBit(), regInfo.getRegBit(), regInfo.getRegValue(), regInfo.getRegReadOrWrite().ordinal(), bookInfo.getModuleType());
                    if (item == null) {
                        if (regFunction == null || regFunction.isEmpty()) {
                            this.errorWorkBook = bookInfo;
                            this.errorRegister = regInfo;
                            this.errorCode = 4;
                            this.errorValue = 0;
                        }
                    } else {
                        BinModuleHead binModuleHead;
                        BinModule module = item.getmModuleRef();
                        if (module != null && (binModuleHead = module.getBinModuleHead()) != null) {
                            int normalBoot = binModuleHead.getNormalBoot();
                            int normalChip = binModuleHead.getNormalChip();
                            int standbyWakeup = binModuleHead.getStandbyWakeup();
                            int caChip = binModuleHead.getCaChip();
                            int baseAddr = module.getBaseAddr();
                            bookInfo.setExeForStandyWakeup(PrepareSetting.convertIntToBoot(standbyWakeup));
                            bookInfo.setExeForNormalBoot(PrepareSetting.convertIntToBoot(normalBoot));
                            bookInfo.setNormalChip(PrepareSetting.convertIntToBoot(normalChip));
                            bookInfo.setCaChip(PrepareSetting.convertIntToBoot(caChip));
                            bookInfo.setModuleType(moduleType);
                            bookInfo.setBaseAddress(baseAddr);
                            RegBinAction writeOrRead = item.getWriteOrRead();
                            int startBit = item.getStartBit();
                            int bits = item.getBits();
                            regInfo.setRegReadOrWrite(writeOrRead);
                            regInfo.setRegStartBit(startBit);
                            regInfo.setRegBit(bits);
                            int value = item.getValue();
                            if (!pmData.isValueValid(regInfo.getRegAbsoluteAddress(), value)) {
                                if (forceExitOnError) {
                                    this.errorWorkBook = bookInfo;
                                    this.errorRegister = regInfo;
                                    this.errorCode = 5;
                                    this.errorValue = value;
                                }
                            } else {
                                if (regInfo.getRegFunction() != null && !regInfo.getRegFunction().isEmpty()) {
                                    System.out.println(regInfo.getRegName());
                                } else {
                                    regInfo.setRegValue(value);
                                }
                                regInfo.setRegDelay(item.getDelay());
                                bookInfo.getBaseRegisterInfoList().set(j, regInfo);
                            }
                        }
                    }
                    ++j;
                }
                excelData.getExcelWorkbookInfoList().set(i, bookInfo);
            }
            ++i;
        }
        excelData.setExcelWorkbookInfoList(excelData.getExcelWorkbookInfoList());
        ExcelDataHelper.setExcelDataforImport(excelData);
        this.errorWorkBook = null;
        this.errorRegister = null;
        this.errorCode = 0;
        this.errorValue = 0;
        return true;
    }

    private void handleAttributeValue(boolean exeForNormalBoot, boolean exeForStandyWakeup, int regBit, int regStartBit, RegBinAction regReadOrWrite, RegBinItem regBinItem) {
        regBinItem.setBits(regReadOrWrite, regBit);
        regBinItem.setStartBit(regReadOrWrite, regStartBit);
        regBinItem.setExecutionRequiredForNormalBoot(regReadOrWrite, exeForNormalBoot);
        regBinItem.setExecutionRequiredForStandbyWakeup(regReadOrWrite, exeForStandyWakeup);
        regBinItem.setActionEnabled(regReadOrWrite, true);
        regBinItem.setAttribute(regBinItem.getAttributes());
    }

    private boolean filterDemoNameWookbook(String workbookName, String selectDemoName) {
        boolean result = true;
        if (workbookName.toLowerCase().contains("ddrphy")) {
            String[] workbookNameList = workbookName.split("_");
            if (workbookNameList.length > 0) {
                if (!workbookNameList[0].equalsIgnoreCase(selectDemoName)) {
                    result = false;
                }
            } else if (!workbookName.toLowerCase().contains(selectDemoName.toLowerCase())) {
                result = false;
            }
        }
        return result;
    }

    private boolean checkDemoName(ParsedMainData parsedMainData, String importCustomDemoName) {
        String importDemoName = ExcelDataHelper.extractDeviceName(importCustomDemoName);
        boolean exitsDemo = false;
        if (importDemoName != null && !importDemoName.isEmpty()) {
            ArrayList<DemoBaseParam> demoList = parsedMainData.getDemoList();
            for (DemoBaseParam demoBaseParam : demoList) {
                String demoName = demoBaseParam.getDemoName();
                if (!demoName.equalsIgnoreCase(importDemoName)) continue;
                exitsDemo = true;
                break;
            }
        }
        return exitsDemo;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected boolean refreshBaseForRegBinImport(RegBinData binData, ExcelData excelData, ParsedMainData pmData) {
        try {
            String[] names;
            int regAbsoluteAddress;
            String subVersion = binData.getmSubVersion();
            pmData.setXlsVersion(subVersion);
            String regBinName = binData.getmName().trim();
            if (!this.checkDemoName(pmData, regBinName)) {
                String errorName = regBinName;
                if (regBinName.isEmpty()) {
                    errorName = "null";
                }
                MessageDialog.openWarning((Shell)Display.getDefault().getActiveShell(), (String)Messages.Message_Warning, (String)NLS.bind((String)Messages.ImportDemoNameIsInvalid, (Object)ExcelDataHelper.extractDeviceName(errorName)));
                return false;
            }
            pmData.setCustomDemoName(regBinName);
            String deviceName = ExcelDataHelper.extractDeviceName(regBinName).trim();
            ArrayList<DemoBaseParam> demoList = pmData.getDemoList();
            LinkedHashMap<String, ArrayList<BaseRegisterInfo>> comboParamRegInfoMap = pmData.getComboParamRegInfoMap();
            for (Map.Entry<String, ArrayList<BaseRegisterInfo>> entry : comboParamRegInfoMap.entrySet()) {
                String paramName = entry.getKey();
                ArrayList<BaseRegisterInfo> paramRegList = entry.getValue();
                block7: for (BaseRegisterInfo baseRegisterInfo : paramRegList) {
                    int itemValue;
                    int regStartBit;
                    RegBinAction regReadOrWrite;
                    int regValue = baseRegisterInfo.getRegValue();
                    regAbsoluteAddress = baseRegisterInfo.getRegAbsoluteAddress();
                    RegBinItem item = binData.seekForItemForBase(regAbsoluteAddress, regReadOrWrite = baseRegisterInfo.getRegReadOrWrite(), regStartBit = baseRegisterInfo.getRegStartBit());
                    if (item == null || regValue != (itemValue = item.getValue())) continue;
                    String functionValue = baseRegisterInfo.getRegFunction();
                    for (DemoBaseParam demoBaseParam : demoList) {
                        Map<String, String> dynamicParamMap;
                        String demoName = demoBaseParam.getDemoName();
                        if (!deviceName.equalsIgnoreCase(demoName) || !(dynamicParamMap = demoBaseParam.getDynamicParamMap()).containsKey(paramName)) continue;
                        dynamicParamMap.remove(paramName);
                        dynamicParamMap.put(paramName, functionValue);
                        continue block7;
                    }
                }
            }
            String demoType = "";
            String ddrCapacity = "";
            String ddrBuswidth = "";
            String ddrPCBLayers = "";
            String[] regStartBit = names = regBinName.split("_");
            int regReadOrWrite = names.length;
            regAbsoluteAddress = 0;
            while (regAbsoluteAddress < regReadOrWrite) {
                String name = regStartBit[regAbsoluteAddress];
                if (name.toLowerCase().contains("ddr")) {
                    demoType = name;
                } else if (name.toLowerCase().contains("bit")) {
                    ddrBuswidth = name;
                } else if (name.toLowerCase().contains("layers")) {
                    ddrPCBLayers = name.substring(0, name.indexOf("layers") + "layers".length());
                } else if (name.toLowerCase().contains("byte")) {
                    ddrCapacity = name;
                }
                ++regAbsoluteAddress;
            }
            for (DemoBaseParam demoBaseParam : demoList) {
                if (!demoBaseParam.getDemoName().equalsIgnoreCase(deviceName)) continue;
                demoBaseParam.setDdrBuswidth(ddrBuswidth);
                demoBaseParam.setDdrCapacity(ddrCapacity);
                demoBaseParam.setDemoType(demoType);
                demoBaseParam.setDdrPCBLayers(ddrPCBLayers);
                demoBaseParam.setCa(CAConfig.noCA);
            }
            ExcelWorkbookInfo clkSSModWorkbookInfo = excelData.getExcelWorkbookInfoByName("eth_phy_cfg");
            if (clkSSModWorkbookInfo == null) return true;
            int baseAddress = clkSSModWorkbookInfo.getBaseAddress();
            ArrayList<NetworkConfig> netWorkConfigList = pmData.getNetWorkConfigList();
            ArrayList<MainNetconfig> mainNetconfigList = excelData.getExcelMainData().getMainNetconfigList();
            int excelMacIndex = 0;
            while (excelMacIndex < mainNetconfigList.size()) {
                MainNetconfig mainNetconfig = mainNetconfigList.get(excelMacIndex);
                String netMacName = mainNetconfig.getNetconfigName();
                MainRegInfo netPhyAddr = mainNetconfig.getNetPhyAddr();
                MainRegInfo netResetPin = mainNetconfig.getNetResetPin();
                String netPhyAddressReg = netPhyAddr.getRegName();
                String netResetPinReg = netResetPin.getRegName();
                ArrayList<BaseRegisterInfo> baseRegisterInfoList = clkSSModWorkbookInfo.getBaseRegisterInfoList();
                NetworkConfig networkConfig = netWorkConfigList.get(excelMacIndex);
                int index = 0;
                while (index < baseRegisterInfoList.size()) {
                    int value;
                    RegBinItem regBinItem;
                    BaseRegisterInfo baseRegisterInfo = baseRegisterInfoList.get(index);
                    int regOffsetAddress = baseRegisterInfo.getRegOffsetAddress();
                    int regAbsoluteAddress2 = baseAddress + regOffsetAddress;
                    int regStartBit2 = baseRegisterInfo.getRegStartBit();
                    RegBinAction regReadOrWrite2 = baseRegisterInfo.getRegReadOrWrite();
                    String regName = baseRegisterInfo.getRegName();
                    if (regName.equalsIgnoreCase(netPhyAddressReg)) {
                        regBinItem = binData.seekForItemForBase(regAbsoluteAddress2, regReadOrWrite2, regStartBit2);
                        if (regBinItem == null) {
                            return false;
                        }
                        try {
                            value = regBinItem.getValue();
                            if (networkConfig.getNetMacName().equalsIgnoreCase(netMacName)) {
                                networkConfig.setNetPhyAddress(value);
                            }
                        }
                        catch (Exception e) {
                            this.errorWorkBook = clkSSModWorkbookInfo;
                            this.errorRegister = baseRegisterInfo;
                            this.errorCode = 1;
                            this.errorValue = 0;
                        }
                    }
                    if (netResetPinReg.contains(regName)) {
                        regBinItem = binData.seekForItemForBase(regAbsoluteAddress2, regReadOrWrite2, regStartBit2);
                        if (regBinItem == null) {
                            return false;
                        }
                        try {
                            value = regBinItem.getValue();
                            if (regName.endsWith("_BIT")) {
                                int gpioBit = ExcelDataHelper.getGpioBit(value);
                                networkConfig.setNetGpioBitNumber(gpioBit);
                            } else {
                                int gpioGroup = ExcelDataHelper.getGpioGroup(value);
                                networkConfig.setNetGpioGroupNumber(gpioGroup);
                            }
                        }
                        catch (Exception e) {
                            this.errorWorkBook = clkSSModWorkbookInfo;
                            this.errorRegister = baseRegisterInfo;
                            this.errorCode = 1;
                            this.errorValue = 0;
                        }
                    }
                    ++index;
                }
                ++excelMacIndex;
            }
            return true;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    protected boolean refreshBaseForBinDataImport(BinData binData, ExcelData excelData, ParsedMainData pmData) {
        ArrayList<DemoBaseParam> demoList;
        String deviceName;
        String regBinName;
        block12: {
            block11: {
                BinHeadData headData = binData.getHeadData();
                String xlsVersion = headData.getXlsVersion();
                regBinName = headData.getBinName().trim();
                pmData.setXlsVersion(xlsVersion);
                if (this.checkDemoName(pmData, regBinName)) break block11;
                String errorName = regBinName;
                if (regBinName.isEmpty()) {
                    errorName = "null";
                }
                MessageDialog.openWarning((Shell)Display.getDefault().getActiveShell(), (String)Messages.Message_Warning, (String)NLS.bind((String)Messages.ImportDemoNameIsInvalid, (Object)ExcelDataHelper.extractDeviceName(errorName)));
                return false;
            }
            try {
                if (!ExcelDataHelper.isV135XlsFomatVersion(excelData)) {
                    String[] names = regBinName.split("_");
                    int i = 0;
                    while (i < names.length) {
                        if (names[i].toLowerCase().contains("ddr")) {
                            String ddrTypeName = "";
                            ddrTypeName = RegbinView.isHi3716V550Series() ? String.valueOf(names[i]) + "_" + names[i + 1] : names[i];
                            String demoTypeName = "";
                            demoTypeName = this.updateDdrNameAddFreq(regBinName, pmData.getDemoList(), demoTypeName, names);
                            demoTypeName = demoTypeName.toUpperCase();
                            regBinName = regBinName.replace(ddrTypeName, demoTypeName);
                            break;
                        }
                        ++i;
                    }
                }
                if (regBinName.indexOf("mbyte") != -1) {
                    regBinName = regBinName.replace("mbyte", "MB");
                }
                if (regBinName.indexOf("gbyte") != -1) {
                    regBinName = regBinName.replace("gbyte", "GB");
                }
                pmData.setCustomDemoName(regBinName);
                deviceName = ExcelDataHelper.extractDeviceName(regBinName).trim();
                demoList = pmData.getDemoList();
                LinkedHashMap<String, ArrayList<BaseRegisterInfo>> comboParamRegInfoMap = pmData.getComboParamRegInfoMap();
                Iterator<Map.Entry<String, ArrayList<BaseRegisterInfo>>> iterator = comboParamRegInfoMap.entrySet().iterator();
                long ddrCapacitysumValue = this.sumValueForDDRCapacity(binData, deviceName, demoList, iterator);
                if (this.parsDemoTypeName(excelData, regBinName, deviceName, demoList, ddrCapacitysumValue)) break block12;
                return false;
            }
            catch (Exception e) {
                e.printStackTrace();
                return false;
            }
        }
        this.parsBinName(excelData, regBinName, deviceName, demoList);
        ExcelWorkbookInfo clkSSModWorkbookInfo = excelData.getExcelWorkbookInfoByName("eth_phy_cfg");
        if (clkSSModWorkbookInfo != null) {
            int baseAddress = clkSSModWorkbookInfo.getBaseAddress();
            ArrayList<NetworkConfig> netWorkConfigList = pmData.getNetWorkConfigList();
            this.refreshMacModelValue(binData, excelData, deviceName, demoList, clkSSModWorkbookInfo, baseAddress, netWorkConfigList);
            this.refreshNetPhyAddAndGpio(binData, excelData, clkSSModWorkbookInfo, baseAddress, netWorkConfigList);
        }
        return true;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean refreshNetPhyAddAndGpio(BinData binData, ExcelData excelData, ExcelWorkbookInfo clkSSModWorkbookInfo, int baseAddress, ArrayList<NetworkConfig> netWorkConfigList) {
        ArrayList<MainNetconfig> mainNetconfigList = excelData.getExcelMainData().getMainNetconfigList();
        int excelMacIndex = 0;
        while (excelMacIndex < mainNetconfigList.size()) {
            MainNetconfig mainNetconfig = mainNetconfigList.get(excelMacIndex);
            String netMacName = mainNetconfig.getNetconfigName();
            MainRegInfo netPhyAddr = mainNetconfig.getNetPhyAddr();
            MainRegInfo netResetPin = mainNetconfig.getNetResetPin();
            String netPhyAddressReg = netPhyAddr.getRegName();
            String netResetPinReg = netResetPin.getRegName();
            ArrayList<BaseRegisterInfo> baseRegisterInfoList = clkSSModWorkbookInfo.getBaseRegisterInfoList();
            NetworkConfig networkConfig = netWorkConfigList.get(excelMacIndex);
            int index = 0;
            while (index < baseRegisterInfoList.size()) {
                block10: {
                    BaseRegisterInfo baseRegisterInfo = baseRegisterInfoList.get(index);
                    int regOffsetAddress = baseRegisterInfo.getRegOffsetAddress();
                    int regAbsoluteAddress = baseAddress + regOffsetAddress;
                    int regStartBit = baseRegisterInfo.getRegStartBit();
                    RegBinAction regReadOrWrite = baseRegisterInfo.getRegReadOrWrite();
                    int regBit = baseRegisterInfo.getRegBit();
                    String regName = baseRegisterInfo.getRegName();
                    try {
                        int value;
                        BinItem regBinItem;
                        if (regName.equalsIgnoreCase(netPhyAddressReg)) {
                            regBinItem = binData.seekForItemWithoutValue(regAbsoluteAddress, regOffsetAddress, regStartBit, regBit, regReadOrWrite.ordinal(), clkSSModWorkbookInfo.getModuleType());
                            if (regBinItem == null) {
                                return false;
                            }
                            value = regBinItem.getValue();
                            if (networkConfig.getNetMacName().equalsIgnoreCase(netMacName)) {
                                networkConfig.setNetPhyAddress(value);
                            }
                        }
                        if (!netResetPinReg.contains(regName)) break block10;
                        regBinItem = binData.seekForItemWithoutValue(regAbsoluteAddress, regOffsetAddress, regStartBit, regBit, regReadOrWrite.ordinal(), clkSSModWorkbookInfo.getModuleType());
                        if (regBinItem == null) {
                            return false;
                        }
                        value = regBinItem.getValue();
                        if (regName.endsWith("_BIT")) {
                            int gpioBit = ExcelDataHelper.getGpioBit(value);
                            networkConfig.setNetGpioBitNumber(gpioBit);
                        } else {
                            int gpioGroup = ExcelDataHelper.getGpioGroup(value);
                            networkConfig.setNetGpioGroupNumber(gpioGroup);
                        }
                    }
                    catch (Exception e) {
                        this.errorWorkBook = clkSSModWorkbookInfo;
                        this.errorRegister = baseRegisterInfo;
                        this.errorCode = 1;
                        this.errorValue = 0;
                    }
                }
                ++index;
            }
            ++excelMacIndex;
        }
        return true;
    }

    private boolean refreshMacModelValue(BinData binData, ExcelData excelData, String deviceName, ArrayList<DemoBaseParam> demoList, ExcelWorkbookInfo clkSSModWorkbookInfo, int baseAddress, ArrayList<NetworkConfig> netWorkConfigList) {
        long ddrMacsumValue = 0L;
        ArrayList<MainModelParam> mainMacModelParamList = excelData.getExcelMainData().getMainModelParamList();
        if (mainMacModelParamList != null) {
            int macModelIndex = 0;
            while (macModelIndex < mainMacModelParamList.size()) {
                ddrMacsumValue = 0L;
                MainModelParam mainModelParam = mainMacModelParamList.get(macModelIndex);
                NetworkConfig networkConfig = netWorkConfigList.get(macModelIndex);
                ArrayList<MainRegInfo> modelRegList = mainModelParam.getModelRegList();
                for (MainRegInfo mainRegInfo : modelRegList) {
                    String macRegName = mainRegInfo.getRegName();
                    ArrayList<BaseRegisterInfo> baseRegisterInfoList = clkSSModWorkbookInfo.getBaseRegisterInfoList();
                    int index = 0;
                    while (index < baseRegisterInfoList.size()) {
                        BinItem regBinItem;
                        BaseRegisterInfo baseRegisterInfo = baseRegisterInfoList.get(index);
                        int regOffsetAddress = baseRegisterInfo.getRegOffsetAddress();
                        int regAbsoluteAddress = baseAddress + regOffsetAddress;
                        int regStartBit = baseRegisterInfo.getRegStartBit();
                        int regValue = baseRegisterInfo.getRegValue();
                        RegBinAction regReadOrWrite = baseRegisterInfo.getRegReadOrWrite();
                        int regBit = baseRegisterInfo.getRegBit();
                        String regName = baseRegisterInfo.getRegName();
                        if (regName.equalsIgnoreCase(macRegName) && (regBinItem = binData.seekForItemForBase(regAbsoluteAddress, regOffsetAddress, regStartBit, regBit, regValue, regReadOrWrite.ordinal(), clkSSModWorkbookInfo.getModuleType())) != null) {
                            try {
                                String regFunction = baseRegisterInfo.getRegFunction();
                                networkConfig.setNetMacValue(regFunction);
                                ddrMacsumValue += (long)baseRegisterInfo.getRegValue();
                            }
                            catch (Exception e) {
                                this.errorWorkBook = clkSSModWorkbookInfo;
                                this.errorRegister = baseRegisterInfo;
                                this.errorCode = 1;
                                this.errorValue = 0;
                            }
                        }
                        ++index;
                    }
                }
                if (RegbinView.isHi3798MV200Series() || RegbinView.isHi3796MV200Series()) {
                    ArrayList<SameFunctionSumValue> sumValueBySameFunction = clkSSModWorkbookInfo.getSumValueBySameFunction();
                    if (sumValueBySameFunction == null) {
                        return false;
                    }
                    for (SameFunctionSumValue sameFunctionSumValue : sumValueBySameFunction) {
                        long sumValue;
                        String regPage = sameFunctionSumValue.getRegPage();
                        if (!regPage.equalsIgnoreCase("eth_phy_cfg") || ddrMacsumValue != (sumValue = sameFunctionSumValue.getSumValue())) continue;
                        String functionValue = sameFunctionSumValue.getFunctionName();
                        for (DemoBaseParam demoBaseParam : demoList) {
                            String demoName = demoBaseParam.getDemoName();
                            if (!deviceName.equalsIgnoreCase(demoName)) continue;
                            networkConfig.setNetMacValue(functionValue);
                        }
                    }
                }
                ++macModelIndex;
            }
        }
        return true;
    }

    private void parsBinName(ExcelData excelData, String regBinName, String deviceName, ArrayList<DemoBaseParam> demoList) {
        String[] names;
        String demoType = "";
        String ddrCapacity = "";
        String ddrBuswidth = "";
        String ddrPCBLayers = "";
        String[] stringArray = names = regBinName.split("_");
        int n = names.length;
        int n2 = 0;
        while (n2 < n) {
            String name = stringArray[n2];
            if (name.toLowerCase().contains("ddr")) {
                demoType = name;
            } else if (name.toLowerCase().contains("bit")) {
                ddrBuswidth = name;
            } else if (name.toLowerCase().contains("layers")) {
                ddrPCBLayers = name.substring(0, name.indexOf("layers") + "layers".length());
            } else if (name.toLowerCase().contains("byte")) {
                ddrCapacity = ExcelDataHelper.isV135XlsFomatVersion(excelData) ? (name.contains("dch") ? name.substring(name.indexOf("dch") + "dch".length()) : (name.contains("sch") ? name.substring(name.indexOf("sch") + "sch".length()) : name)) : name;
            }
            ++n2;
        }
        for (DemoBaseParam demoBaseParam : demoList) {
            if (!demoBaseParam.getDemoName().equalsIgnoreCase(deviceName)) continue;
            demoBaseParam.setDdrBuswidth(ddrBuswidth);
            demoBaseParam.setDdrCapacity(ddrCapacity);
            demoBaseParam.setDemoType(demoType);
            demoBaseParam.setDdrPCBLayers(ddrPCBLayers);
            demoBaseParam.setCa(CAConfig.noCA);
        }
    }

    private boolean parsDemoTypeName(ExcelData excelData, String regBinName, String deviceName, ArrayList<DemoBaseParam> demoList, long ddrCapacitysumValue) {
        if (!ExcelDataHelper.isV135XlsFomatVersion(excelData)) {
            String mddrStr;
            ExcelWorkbookInfo curMddrWorkbookInfo;
            String[] names;
            String demoTypeName = "";
            String[] stringArray = names = regBinName.split("_");
            int n = names.length;
            int n2 = 0;
            while (n2 < n) {
                String name = stringArray[n2];
                if (name.toLowerCase().contains("ddr")) {
                    demoTypeName = name;
                    break;
                }
                ++n2;
            }
            if (RegbinView.isHi3796CV300Series()) {
                boolean demoTypeNeedAdd2Rank = false;
                if (regBinName.contains("_2Rank")) {
                    demoTypeNeedAdd2Rank = true;
                }
                if (demoTypeNeedAdd2Rank) {
                    demoTypeName = String.valueOf(demoTypeName) + "_2Rank";
                }
                if (demoTypeName.toUpperCase().contains("X")) {
                    demoTypeName = demoTypeName.replace("X", "");
                }
            }
            if ((curMddrWorkbookInfo = excelData.getExcelWorkbookInfoByName(mddrStr = "mddrc_" + demoTypeName)) != null) {
                ArrayList<SameFunctionSumValue> sumValueBySameFunction = curMddrWorkbookInfo.getSumValueBySameFunction();
                if (sumValueBySameFunction == null) {
                    return false;
                }
                block1: for (SameFunctionSumValue sameFunctionSumValue : sumValueBySameFunction) {
                    long sumValue;
                    String regPage = sameFunctionSumValue.getRegPage();
                    if (!mddrStr.equalsIgnoreCase(regPage) || ddrCapacitysumValue != (sumValue = sameFunctionSumValue.getSumValue())) continue;
                    String functionValue = sameFunctionSumValue.getFunctionName();
                    for (DemoBaseParam demoBaseParam : demoList) {
                        Map<String, String> dynamicParamMap;
                        String demoName = demoBaseParam.getDemoName();
                        if (!deviceName.equalsIgnoreCase(demoName) || !(dynamicParamMap = demoBaseParam.getDynamicParamMap()).containsKey(ExcelDataHelper.getDdrcapcity())) continue;
                        dynamicParamMap.remove(ExcelDataHelper.getDdrcapcity());
                        dynamicParamMap.put(ExcelDataHelper.getDdrcapcity(), functionValue);
                        continue block1;
                    }
                }
            }
        }
        return true;
    }

    private long sumValueForDDRCapacity(BinData binData, String deviceName, ArrayList<DemoBaseParam> demoList, Iterator<Map.Entry<String, ArrayList<BaseRegisterInfo>>> iterator) {
        long ddrCapacitysumValue = 0L;
        while (iterator.hasNext()) {
            Map.Entry<String, ArrayList<BaseRegisterInfo>> entry = iterator.next();
            String paramName = entry.getKey();
            ArrayList<BaseRegisterInfo> paramRegList = entry.getValue();
            if (paramName.equalsIgnoreCase(ExcelDataHelper.getDdrcapcity())) {
                for (BaseRegisterInfo baseRegisterInfo : paramRegList) {
                    int itemValue;
                    int regValue = baseRegisterInfo.getRegValue();
                    BinItem item = binData.seekForItemForBase(baseRegisterInfo.getRegAbsoluteAddress(), baseRegisterInfo.getRegOffsetAddress(), baseRegisterInfo.getRegStartBit(), baseRegisterInfo.getRegBit(), baseRegisterInfo.getRegValue(), baseRegisterInfo.getRegReadOrWrite().ordinal(), BinModuleType.NORMAL);
                    if (item == null || regValue != (itemValue = item.getValue())) continue;
                    ddrCapacitysumValue += (long)itemValue;
                }
                continue;
            }
            BinModuleType binModuleType = BinModuleType.NORMAL;
            block2: for (BaseRegisterInfo baseRegisterInfo : paramRegList) {
                int itemValue;
                String bookName = baseRegisterInfo.getWorkbookName();
                int i = 0;
                while (i < this.excelWorkbookInfoList.size()) {
                    ExcelWorkbookInfo workBookInfo = this.excelWorkbookInfoList.get(i);
                    if (workBookInfo.getWorkbookName().equalsIgnoreCase(bookName)) {
                        binModuleType = workBookInfo.getModuleType();
                        System.out.println();
                        break;
                    }
                    ++i;
                }
                int regValue = baseRegisterInfo.getRegValue();
                int regOffsetAddress = baseRegisterInfo.getRegOffsetAddress();
                int regAbsoluteAddress = baseRegisterInfo.getRegAbsoluteAddress();
                int regStartBit = baseRegisterInfo.getRegStartBit();
                RegBinAction regReadOrWrite = baseRegisterInfo.getRegReadOrWrite();
                int regBit = baseRegisterInfo.getRegBit();
                BinItem item = binData.seekForItemForBase(regAbsoluteAddress, regOffsetAddress, regStartBit, regBit, regValue, regReadOrWrite.ordinal(), binModuleType);
                if (item == null || regValue != (itemValue = item.getValue())) continue;
                String functionValue = baseRegisterInfo.getRegFunction();
                for (DemoBaseParam demoBaseParam : demoList) {
                    Map<String, String> dynamicParamMap;
                    String demoName = demoBaseParam.getDemoName();
                    if (!deviceName.equalsIgnoreCase(demoName) || !(dynamicParamMap = demoBaseParam.getDynamicParamMap()).containsKey(paramName)) continue;
                    dynamicParamMap.remove(paramName);
                    dynamicParamMap.put(paramName, functionValue);
                    continue block2;
                }
            }
        }
        return ddrCapacitysumValue;
    }

    private String updateDdrNameAddFreq(String regBinName, ArrayList<DemoBaseParam> demoList, String demoTypeName, String[] names) {
        String[] stringArray = names;
        int n = names.length;
        int n2 = 0;
        while (n2 < n) {
            String name = stringArray[n2];
            if (name.toLowerCase().contains("ddr")) {
                demoTypeName = name;
                break;
            }
            ++n2;
        }
        String importDemoName = regBinName.substring(0, regBinName.indexOf("_"));
        for (DemoBaseParam demoBaseParam : demoList) {
            String ddrType;
            String demoName = demoBaseParam.getDemoName();
            if (!demoName.equalsIgnoreCase(importDemoName) || !(ddrType = demoBaseParam.getDdrType()).equalsIgnoreCase(demoTypeName) || !HiToolUtils.equalsIgnoreCaseDDR(demoTypeName)) continue;
            demoTypeName = ddrType;
        }
        return demoTypeName;
    }

    public boolean importCfgBin(ExcelData excelData, CfgBinData binData, ParsedMainData pmData, boolean forceExitOnError) {
        boolean error;
        this.errorWorkBook = null;
        this.errorRegister = null;
        if (!this.refreshBaseForCfgBinImport(binData, excelData, pmData)) {
            return false;
        }
        int index = 0;
        while (index < binData.getModuleCount()) {
            CfgBinModule module = binData.getModule(index);
            ArrayList<CfgBinItem> getmListItems = module.getmListItems();
            for (CfgBinItem cfgBinItem : getmListItems) {
                cfgBinItem.setHasExport(false);
            }
            ++index;
        }
        String customName = pmData.getCustomDemoName();
        String customSelectDemoName = ExcelDataHelper.extractDeviceName(customName).trim();
        String startupString = this.getStartupStr(customName);
        int i = 0;
        while (i < excelData.getExcelWorkbookInfoList().size()) {
            block17: {
                boolean isIgnoreWorkBookName;
                String workbookName;
                boolean isIgnore;
                ExcelWorkbookInfo bookInfo = excelData.getExcelWorkbookInfoList().get(i);
                boolean bl = isIgnore = bookInfo.getWorkbookName().equalsIgnoreCase("sysctrl_noCA") || bookInfo.getWorkbookName().equalsIgnoreCase("others");
                if (isIgnore || !this.filterDemoNameWookbook(workbookName = bookInfo.getWorkbookName(), customSelectDemoName) || (isIgnoreWorkBookName = this.checkWorkBookName(startupString, workbookName))) break block17;
                String lastRegName = "";
                int j = 0;
                while (j < bookInfo.getBaseRegisterInfoList().size()) {
                    block19: {
                        CfgBinItem item;
                        String regFunction;
                        BaseRegisterInfo regInfo;
                        block20: {
                            block18: {
                                regInfo = bookInfo.getBaseRegisterInfoList().get(j);
                                regFunction = regInfo.getRegFunction();
                                item = null;
                                if (regFunction == null || regFunction.isEmpty()) break block18;
                                if (regInfo.getRegName().equalsIgnoreCase(lastRegName)) break block19;
                                item = binData.seekForItem(bookInfo.getBaseAddress(), regInfo.getRegOffsetAddress(), regInfo.getRegStartBit());
                                lastRegName = regInfo.getRegName();
                                break block20;
                            }
                            item = binData.seekForItem(bookInfo.getBaseAddress(), regInfo.getRegOffsetAddress(), regInfo.getRegStartBit());
                            lastRegName = regInfo.getRegName();
                        }
                        if (item == null) {
                            boolean regFunc;
                            boolean bl2 = regFunc = regFunction != null && !regFunction.isEmpty();
                            if (!regFunc) {
                                this.errorWorkBook = bookInfo;
                                this.errorRegister = regInfo;
                                this.errorCode = 4;
                                this.errorValue = 0;
                            }
                        } else {
                            CfgBinModule module = item.getModuleRef();
                            if (module != null) {
                                boolean isWrite;
                                this.setStandyWakeupAndNormalBoot(bookInfo, module);
                                bookInfo.setBaseAddress(module.getBaseAddr());
                                boolean bl3 = isWrite = item.getCmd() == CfgBinCommand.REG || item.getCmd() == CfgBinCommand.REG_MSK;
                                if (isWrite) {
                                    regInfo.setRegReadOrWrite(RegBinAction.WRITE);
                                } else {
                                    regInfo.setRegReadOrWrite(RegBinAction.READ);
                                }
                                int startBit = BitUtils.getStartBit(item.getValueMask());
                                int bits = BitUtils.getEndBit(item.getValueMask()) - startBit;
                                regInfo.setRegStartBit(startBit);
                                regInfo.setRegBit(bits);
                                int value = item.getValue();
                                if (!pmData.isValueValid(regInfo.getRegAbsoluteAddress(), value)) {
                                    if (forceExitOnError) {
                                        this.errorWorkBook = bookInfo;
                                        this.errorRegister = regInfo;
                                        this.errorCode = 5;
                                        this.errorValue = value;
                                    }
                                } else {
                                    boolean regFunc;
                                    boolean bl4 = regFunc = regInfo.getRegFunction() != null && !regInfo.getRegFunction().isEmpty();
                                    if (regFunc) {
                                        System.out.println(regInfo.getRegName());
                                    } else {
                                        regInfo.setRegValue(value);
                                    }
                                    regInfo.setRegDelay(item.getDelay());
                                    bookInfo.getBaseRegisterInfoList().set(j, regInfo);
                                }
                            }
                        }
                    }
                    ++j;
                }
                excelData.getExcelWorkbookInfoList().set(i, bookInfo);
            }
            ++i;
        }
        excelData.setExcelWorkbookInfoList(excelData.getExcelWorkbookInfoList());
        ExcelDataHelper.setExcelDataforImport(excelData);
        boolean bl = error = this.errorWorkBook != null && this.errorRegister != null;
        if (error) {
            return false;
        }
        this.errorWorkBook = null;
        this.errorRegister = null;
        this.errorCode = 0;
        this.errorValue = 0;
        return true;
    }

    private void setStandyWakeupAndNormalBoot(ExcelWorkbookInfo bookInfo, CfgBinModule module) {
        if (module.getType() == CfgBinType.WAKEUP) {
            bookInfo.setExeForStandyWakeup(true);
            bookInfo.setExeForNormalBoot(false);
        } else if (module.getType() == CfgBinType.INIT) {
            bookInfo.setExeForStandyWakeup(false);
            bookInfo.setExeForNormalBoot(true);
        } else {
            bookInfo.setExeForStandyWakeup(true);
            bookInfo.setExeForNormalBoot(true);
        }
    }

    private boolean checkWorkBookName(String startupString, String workbookName) {
        boolean isIgnore = false;
        if (workbookName.contains("pin_mux_drv")) {
            if (startupString.equalsIgnoreCase("spi")) {
                if (workbookName.contains("nand") || workbookName.contains("emmc")) {
                    isIgnore = true;
                }
            } else if (startupString.equalsIgnoreCase("nand")) {
                if (workbookName.contains("spi") || workbookName.contains("emmc")) {
                    isIgnore = true;
                }
            } else if (startupString.equalsIgnoreCase("emmc") && (workbookName.contains("spi") || workbookName.contains("nand"))) {
                isIgnore = true;
            }
        }
        return isIgnore;
    }

    private String getStartupStr(String customName) {
        String startupString = "";
        if (customName.toLowerCase().contains("spi")) {
            startupString = "spi";
        } else if (customName.toLowerCase().contains("nand")) {
            startupString = "nand";
        } else if (customName.toLowerCase().contains("emmc-phy")) {
            startupString = "emmc-phy";
        } else if (customName.toLowerCase().contains("emmc")) {
            startupString = "emmc";
        } else if (customName.toLowerCase().contains("sd")) {
            startupString = "sd";
        }
        return startupString;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected boolean refreshBaseForCfgBinImport(CfgBinData binData, ExcelData excelData, ParsedMainData pmData) {
        try {
            String[] names;
            int regOffsetAddress;
            int regStartBit;
            pmData.setXlsVersion(Messages.PanelComposite_Cfg_NoVersion);
            String regBinName = binData.getmName().trim();
            if (!this.checkDemoName(pmData, regBinName)) {
                String errorName = regBinName;
                if (regBinName.isEmpty()) {
                    errorName = "null";
                }
                MessageDialog.openWarning((Shell)Display.getDefault().getActiveShell(), (String)Messages.Message_Warning, (String)NLS.bind((String)Messages.ImportDemoNameIsInvalid, (Object)ExcelDataHelper.extractDeviceName(errorName)));
                return false;
            }
            pmData.setCustomDemoName(regBinName);
            String deviceName = ExcelDataHelper.extractDeviceName(regBinName).trim();
            ArrayList<DemoBaseParam> demoList = pmData.getDemoList();
            LinkedHashMap<String, ArrayList<BaseRegisterInfo>> comboParamRegInfoMap = pmData.getComboParamRegInfoMap();
            for (Map.Entry<String, ArrayList<BaseRegisterInfo>> entry : comboParamRegInfoMap.entrySet()) {
                String paramName = entry.getKey();
                ArrayList<BaseRegisterInfo> paramRegList = entry.getValue();
                block3: for (BaseRegisterInfo baseRegisterInfo : paramRegList) {
                    int regValue = baseRegisterInfo.getRegValue();
                    regStartBit = baseRegisterInfo.getRegStartBit();
                    regOffsetAddress = baseRegisterInfo.getRegOffsetAddress();
                    int baseAddress = baseRegisterInfo.getRegAbsoluteAddress() - baseRegisterInfo.getRegOffsetAddress();
                    CfgBinItem cfgBinItem = binData.seekForItemForBase(baseAddress, regOffsetAddress, regStartBit);
                    if (cfgBinItem == null) {
                        return false;
                    }
                    int itemValue = cfgBinItem.getValue();
                    if (regValue != itemValue) continue;
                    String functionValue = baseRegisterInfo.getRegFunction();
                    for (DemoBaseParam demoBaseParam : demoList) {
                        Map<String, String> dynamicParamMap;
                        String demoName = demoBaseParam.getDemoName();
                        if (!deviceName.equalsIgnoreCase(demoName) || !(dynamicParamMap = demoBaseParam.getDynamicParamMap()).containsKey(paramName)) continue;
                        dynamicParamMap.remove(paramName);
                        dynamicParamMap.put(paramName, functionValue);
                        continue block3;
                    }
                }
            }
            String demoType = "";
            String ddrCapacity = "";
            String ddrBuswidth = "";
            String ddrPCBLayers = "";
            String[] baseAddress = names = regBinName.split("_");
            regOffsetAddress = names.length;
            regStartBit = 0;
            while (regStartBit < regOffsetAddress) {
                String name = baseAddress[regStartBit];
                if (name.toLowerCase().contains("ddr")) {
                    demoType = name;
                } else if (name.toLowerCase().contains("bit")) {
                    ddrBuswidth = name;
                } else if (name.toLowerCase().contains("layers")) {
                    ddrPCBLayers = name.substring(0, name.indexOf("layers") + "layers".length());
                } else if (name.toLowerCase().contains("byte")) {
                    ddrCapacity = name;
                }
                ++regStartBit;
            }
            for (DemoBaseParam demoBaseParam : demoList) {
                if (!demoBaseParam.getDemoName().equalsIgnoreCase(deviceName)) continue;
                demoBaseParam.setDdrBuswidth(ddrBuswidth);
                demoBaseParam.setDdrCapacity(ddrCapacity);
                demoBaseParam.setDemoType(demoType);
                demoBaseParam.setDdrPCBLayers(ddrPCBLayers);
                demoBaseParam.setCa(CAConfig.CA);
            }
            ExcelWorkbookInfo ethPhyCfgWorkbookInfo = excelData.getExcelWorkbookInfoByName("eth_phy_cfg");
            if (ethPhyCfgWorkbookInfo == null) return true;
            int ethPhyCfgBaseAddress = ethPhyCfgWorkbookInfo.getBaseAddress();
            ArrayList<NetworkConfig> netWorkConfigList = pmData.getNetWorkConfigList();
            ArrayList<MainNetconfig> mainNetconfigList = excelData.getExcelMainData().getMainNetconfigList();
            int excelMacIndex = 0;
            while (excelMacIndex < mainNetconfigList.size()) {
                MainNetconfig mainNetconfig = mainNetconfigList.get(excelMacIndex);
                String netMacName = mainNetconfig.getNetconfigName();
                MainRegInfo netPhyAddr = mainNetconfig.getNetPhyAddr();
                MainRegInfo netResetPin = mainNetconfig.getNetResetPin();
                String netPhyAddressReg = netPhyAddr.getRegName();
                String netResetPinReg = netResetPin.getRegName();
                ArrayList<BaseRegisterInfo> baseRegisterInfoList = ethPhyCfgWorkbookInfo.getBaseRegisterInfoList();
                NetworkConfig networkConfig = netWorkConfigList.get(excelMacIndex);
                int index = 0;
                while (index < baseRegisterInfoList.size()) {
                    int value;
                    CfgBinItem cfgBinItem;
                    BaseRegisterInfo baseRegisterInfo = baseRegisterInfoList.get(index);
                    int regOffsetAddress2 = baseRegisterInfo.getRegOffsetAddress();
                    int regStartBit2 = baseRegisterInfo.getRegStartBit();
                    String regName = baseRegisterInfo.getRegName();
                    if (regName.equalsIgnoreCase(netPhyAddressReg)) {
                        cfgBinItem = binData.seekForItemForBase(ethPhyCfgBaseAddress, regOffsetAddress2, regStartBit2);
                        if (cfgBinItem == null) {
                            return false;
                        }
                        value = cfgBinItem.getValue();
                        if (networkConfig.getNetMacName().equalsIgnoreCase(netMacName)) {
                            networkConfig.setNetPhyAddress(value);
                        }
                    }
                    if (netResetPinReg.contains(regName)) {
                        cfgBinItem = binData.seekForItemForBase(ethPhyCfgBaseAddress, regOffsetAddress2, regStartBit2);
                        if (cfgBinItem == null) {
                            return false;
                        }
                        value = cfgBinItem.getValue();
                        if (regName.endsWith("_BIT")) {
                            int gpioBit = ExcelDataHelper.getGpioBit(value);
                            networkConfig.setNetGpioBitNumber(gpioBit);
                        } else {
                            int gpioGroup = ExcelDataHelper.getGpioGroup(value);
                            networkConfig.setNetGpioGroupNumber(gpioGroup);
                        }
                    }
                    ++index;
                }
                ++excelMacIndex;
            }
            return true;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    public ArrayList<GpioData> getGpioParsedDataList() {
        return this.gpioParsedDataList;
    }

    public void setGpioParsedDataList(ArrayList<GpioData> gpioParsedDataList) {
        this.gpioParsedDataList = gpioParsedDataList;
    }
}

