/*
 * Decompiled with CFR 0.152.
 */
package com.hisilicon.hiloader.views;

import com.hisilicon.hiloader.Activator;
import com.hisilicon.hiloader.Messages;
import com.hisilicon.hiloader.controler.GlobleControler;
import com.hisilicon.hiloader.struct.ssu.SsuConstants;
import com.hisilicon.hiloader.ui.ControlFactory;
import com.hisilicon.hiloader.ui.HiLoaderComposite;
import com.hisilicon.hiloader.ui.ssu.SsuHiLoaderComposite;
import com.hisilicon.hiloader.ui.ssu.SsuaHiLoaderComposite;
import com.soyatec.hisilicon.platform.api.IDeviceChangedListener;
import com.soyatec.hisilicon.platform.api.IDeviceManager;
import com.soyatec.hisilicon.platform.api.chips.Chip;
import java.awt.Toolkit;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.window.Window;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.custom.StackLayout;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IPerspectiveDescriptor;
import org.eclipse.ui.IPerspectiveListener4;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPartReference;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.ScrolledForm;
import org.eclipse.ui.part.ViewPart;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;

public class HiLoaderView
extends ViewPart
implements IDeviceChangedListener,
IPerspectiveListener4,
ControlListener {
    public static final String ID = HiLoaderView.class.getName();
    private static String chipName;
    private static final String HI3751V350SERIESCHIPNAME = "Hi3751V350 Hi3751V351";
    private static final String HI3751V560SERIESCHIPNAME = "Hi3751V560";
    private HiLoaderComposite hisiComposite;
    private SsuHiLoaderComposite ssuComposite;
    private SsuaHiLoaderComposite ssuaComposite;
    private StackLayout stackLayout;
    private Composite comp;
    private FormToolkit toolkit;
    private ScrolledForm form;
    private Button oad;
    private ScrolledComposite scrolledComposite;
    private Composite parent;
    private int minHeight = 768;
    private int tablieHeight = 200;

    public static void setChipName(String chipName) {
        HiLoaderView.chipName = chipName;
    }

    public static boolean isHi3751V811Series() {
        return chipName.equals("Hi3751V810") || chipName.equals("Hi3751V811");
    }

    public static boolean isETSITS102006V141() {
        if (chipName == null) {
            return false;
        }
        return chipName.equalsIgnoreCase(HI3751V350SERIESCHIPNAME) || chipName.equalsIgnoreCase(HI3751V560SERIESCHIPNAME);
    }

    public void createPartControl(final Composite parent) {
        parent.addControlListener(new ControlListener(){

            public void controlMoved(ControlEvent e) {
            }

            public void controlResized(ControlEvent e) {
                parent.update();
                parent.layout();
            }
        });
        this.parent = parent;
        this.createControl();
    }

    public void deviceChanged() {
        if (this.parent != null && !this.parent.isDisposed()) {
            if (this.scrolledComposite != null && !this.scrolledComposite.isDisposed()) {
                this.scrolledComposite.dispose();
            }
            this.createControl();
            this.parent.layout();
        }
    }

    private void createControl() {
        this.scrolledComposite = new ScrolledComposite(this.parent, 2816);
        this.scrolledComposite.setBackground(SsuConstants.white);
        this.scrolledComposite.setExpandHorizontal(true);
        this.scrolledComposite.setExpandVertical(true);
        this.scrolledComposite.setMinWidth(1339);
        int screenHeight = Toolkit.getDefaultToolkit().getScreenSize().height;
        if (screenHeight <= this.minHeight) {
            this.scrolledComposite.setMinHeight(615);
        } else {
            this.scrolledComposite.setMinHeight(615 + this.tablieHeight);
        }
        Composite pubComposite = new Composite((Composite)this.scrolledComposite, 0);
        pubComposite.setBackground(SsuConstants.white);
        pubComposite.setLayout((Layout)new FillLayout());
        this.scrolledComposite.setContent((Control)pubComposite);
        Composite rootArea = this.createViewContainer(pubComposite);
        Group selectProcolArea = ControlFactory.createGroup(rootArea, Messages.SelectProtocolDialog_SelectInformation, 2);
        this.comp = ControlFactory.createStackComposite(rootArea, 1808);
        this.stackLayout = (StackLayout)this.comp.getLayout();
        SelectionAdapter hisiAdpater = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                GlobleControler.intance.setProtocol(GlobleControler.Protocol.HISI);
                ((HiLoaderView)HiLoaderView.this).stackLayout.topControl = HiLoaderView.this.hisiComposite;
                HiLoaderView.this.comp.layout();
            }
        };
        SelectionAdapter ssuAdpater = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                GlobleControler.intance.setProtocol(GlobleControler.Protocol.SSU);
                ((HiLoaderView)HiLoaderView.this).stackLayout.topControl = HiLoaderView.this.ssuComposite;
                HiLoaderView.this.comp.layout();
            }
        };
        boolean isV620 = false;
        boolean isV551 = false;
        if (chipName != null) {
            isV620 = chipName.equalsIgnoreCase("Hi3751V600") || chipName.equalsIgnoreCase("Hi3751V620");
            boolean bl = isV551 = chipName.equalsIgnoreCase("Hi3751V551") || chipName.equalsIgnoreCase("Hi3751V553") || chipName.equalsIgnoreCase("Hi3751V810") || chipName.equalsIgnoreCase("Hi3751V811") || chipName.equalsIgnoreCase(HI3751V350SERIESCHIPNAME) || chipName.equalsIgnoreCase(HI3751V560SERIESCHIPNAME);
        }
        if (isV620) {
            SelectionAdapter ssuaAdpater = new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    GlobleControler.intance.setProtocol(GlobleControler.Protocol.SSUA);
                    ((HiLoaderView)HiLoaderView.this).stackLayout.topControl = HiLoaderView.this.ssuaComposite;
                    HiLoaderView.this.comp.layout();
                }
            };
            this.oad = ControlFactory.createRadioButton((Composite)selectProcolArea, "OAD", "OAD", (SelectionListener)ssuaAdpater);
            this.oad.setSelection(true);
            GlobleControler.intance.setProtocol(GlobleControler.Protocol.SSUA);
            this.ssuaComposite = new SsuaHiLoaderComposite(this.comp, 0);
            this.comp.setData("SUPPORTTS", (Object)"NO");
        } else if (isV551) {
            Button hisi = ControlFactory.createRadioButton((Composite)selectProcolArea, "HISI", "HISI", (SelectionListener)hisiAdpater);
            hisi.setSelection(true);
            GlobleControler.intance.setProtocol(GlobleControler.Protocol.HISI);
            this.hisiComposite = new HiLoaderComposite(this.comp, 0);
            this.comp.setData("SUPPORTTS", (Object)"NO");
            SelectionAdapter ssuaAdpater = new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    GlobleControler.intance.setProtocol(GlobleControler.Protocol.SSUA);
                    ((HiLoaderView)HiLoaderView.this).stackLayout.topControl = HiLoaderView.this.ssuaComposite;
                    HiLoaderView.this.comp.layout();
                }
            };
            this.oad = ControlFactory.createRadioButton((Composite)selectProcolArea, "OAD", "OAD", (SelectionListener)ssuaAdpater);
            this.ssuaComposite = new SsuaHiLoaderComposite(this.comp, 0);
        } else {
            Button hisi = ControlFactory.createRadioButton((Composite)selectProcolArea, "HISI", "HISI", (SelectionListener)hisiAdpater);
            Button ssu = ControlFactory.createRadioButton((Composite)selectProcolArea, "SSU", "SSU", (SelectionListener)ssuAdpater);
            boolean result = GlobleControler.intance.isHisi();
            if (result) {
                hisi.setSelection(result);
                GlobleControler.intance.setProtocol(GlobleControler.Protocol.HISI);
            } else {
                ssu.setSelection(!result);
                GlobleControler.intance.setProtocol(GlobleControler.Protocol.SSU);
            }
            this.comp.setData("SUPPORTTS", (Object)"YES");
            this.hisiComposite = new HiLoaderComposite(this.comp, 0);
            this.ssuComposite = new SsuHiLoaderComposite(this.comp, 0);
        }
        if (GlobleControler.Protocol.HISI.equals((Object)GlobleControler.intance.getProtocol())) {
            this.stackLayout.topControl = this.hisiComposite;
        } else if (GlobleControler.Protocol.SSU.equals((Object)GlobleControler.intance.getProtocol())) {
            this.stackLayout.topControl = this.ssuComposite;
        } else if (GlobleControler.Protocol.SSUA.equals((Object)GlobleControler.intance.getProtocol())) {
            this.stackLayout.topControl = this.ssuaComposite;
        }
        ControlFactory.adaptComposit((Control)rootArea);
        this.toolkit.paintBordersFor(this.form.getBody());
    }

    protected Composite createViewContainer(Composite parent) {
        this.toolkit = new FormToolkit(parent.getDisplay());
        this.form = new ScrolledForm(parent, Window.getDefaultOrientation());
        this.form.setExpandHorizontal(true);
        this.form.setExpandVertical(true);
        this.form.setMinWidth(1339);
        this.form.setMinHeight(615);
        int screenHeight = Toolkit.getDefaultToolkit().getScreenSize().height;
        if (screenHeight <= this.minHeight) {
            this.form.setMinHeight(615);
        } else {
            this.form.setMinHeight(615 + this.tablieHeight);
        }
        this.form.setFont(JFaceResources.getHeaderFont());
        this.form.getBody().setLayout((Layout)new GridLayout());
        ControlFactory.setFormToolkit(this.toolkit);
        return this.form.getBody();
    }

    public void dispose() {
        this.toolkit.dispose();
        super.dispose();
    }

    public void setFocus() {
        this.parent.layout();
    }

    public void perspectiveOpened(IWorkbenchPage page, IPerspectiveDescriptor perspective) {
    }

    public void perspectiveClosed(IWorkbenchPage page, IPerspectiveDescriptor perspective) {
    }

    public void perspectiveDeactivated(IWorkbenchPage page, IPerspectiveDescriptor perspective) {
    }

    public void perspectiveSavedAs(IWorkbenchPage page, IPerspectiveDescriptor oldPerspective, IPerspectiveDescriptor newPerspective) {
    }

    public void perspectiveActivated(IWorkbenchPage page, IPerspectiveDescriptor perspective) {
    }

    public void perspectiveChanged(IWorkbenchPage page, IPerspectiveDescriptor perspective, String changeId) {
    }

    public void controlMoved(ControlEvent e) {
    }

    public void controlResized(ControlEvent e) {
    }

    public void perspectivePreDeactivate(IWorkbenchPage page, IPerspectiveDescriptor perspective) {
    }

    public void deviceChanged(Chip chip) {
        if (chip != null) {
            HiLoaderView.setChipName(chip.getName());
            this.setHi3716MV310Series(chip.getName());
            this.setBasicParameters(chip.getName());
            this.deviceChanged();
        }
    }

    private void setBasicParameters(String chipName) {
        boolean isHi3798cv200Series = false;
        if (chipName == null) {
            GlobleControler.intance.setHi3798CV200(false);
        } else {
            boolean bl = isHi3798cv200Series = chipName.equalsIgnoreCase("Hi3798cv200") || chipName.equalsIgnoreCase("Hi3798MV200") || chipName.equalsIgnoreCase("Hi3798MV200H") || chipName.equalsIgnoreCase("Hi3796MV200") || chipName.equalsIgnoreCase("Hi3716MV430") || chipName.equalsIgnoreCase("Hi3716MV430N") || chipName.equalsIgnoreCase("Hi3796CV300") || chipName.equalsIgnoreCase("Hi3796AV200") || chipName.equalsIgnoreCase("Hi3716MV450") || chipName.equalsIgnoreCase("Hi3798MV300") || chipName.equalsIgnoreCase("Hi3798MV300H") || chipName.equalsIgnoreCase("Hi3798MV310") || chipName.equalsIgnoreCase("Hi3798MV300E") || chipName.equalsIgnoreCase("Hi3798MV320") || chipName.equalsIgnoreCase("Hi3561MV100") || chipName.equalsIgnoreCase("Hi3716DV110") || chipName.equalsIgnoreCase("Hi3716DV110H");
        }
        if (isHi3798cv200Series) {
            GlobleControler.intance.setHi3798CV200(true);
        } else {
            GlobleControler.intance.setHi3798CV200(false);
        }
    }

    private void setHi3716MV310Series(String chipName) {
        boolean isHi3716MV310Series = false;
        if (chipName == null) {
            GlobleControler.intance.setIs32Bit(false);
        } else {
            boolean bl = isHi3716MV310Series = chipName.equalsIgnoreCase("Hi3716mv310") || chipName.equalsIgnoreCase("Hi3716mv320") || chipName.equalsIgnoreCase("Hi3716mv330") || chipName.equalsIgnoreCase("Hi3716MV330_CA") || chipName.equalsIgnoreCase("Hi3110ev500") || chipName.equalsIgnoreCase("Hi3716MV310_CA") || chipName.equalsIgnoreCase("Hi3110EV500_CA");
        }
        if (isHi3716MV310Series) {
            GlobleControler.intance.setIs32Bit(true);
        } else {
            GlobleControler.intance.setIs32Bit(false);
        }
    }

    public void init(IViewSite site) throws PartInitException {
        super.init(site);
        BundleContext bundleContext = Activator.getDefault().getBundle().getBundleContext();
        ServiceReference sreference = bundleContext.getServiceReference(IDeviceManager.class);
        if (sreference == null) {
            return;
        }
        IDeviceManager deviceManager = (IDeviceManager)bundleContext.getService(sreference);
        deviceManager.addDeviceChangedListener((IDeviceChangedListener)this);
        String currentDevice = deviceManager.getCurrentDevice();
        if (currentDevice == null || currentDevice.trim().length() == 0) {
            return;
        }
        Chip chip = deviceManager.findChipByName(currentDevice);
        HiLoaderView.setChipName(chip.getName());
        this.setHi3716MV310Series(chipName);
        this.setBasicParameters(chipName);
    }

    public void perspectiveChanged(IWorkbenchPage page, IPerspectiveDescriptor perspective, IWorkbenchPartReference partRef, String changeId) {
    }
}

