/*
 * Decompiled with CFR 0.152.
 */
package com.hisilicon.hiloader.util.ssu;

import com.hisilicon.hiloader.Messages;
import com.hisilicon.hiloader.controler.GlobleControler;
import com.hisilicon.hiloader.model.PartitionItem;
import com.hisilicon.hiloader.struct.FileSystem;
import com.hisilicon.hiloader.struct.FlashType;
import com.hisilicon.hiloader.struct.UpgradeFileInfo;
import com.hisilicon.hiloader.struct.ssu.SsuUpgradeInfo;
import com.hisilicon.hiloader.util.FileUtil;
import com.hisilicon.hiloader.util.InvalidDataFormatException;
import com.hisilicon.hiloader.util.StringUtil;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.osgi.util.NLS;
import org.eclipse.ui.WorkbenchEncoding;
import org.ini4j.Config;
import org.ini4j.Ini;
import org.ini4j.InvalidFileFormatException;
import org.ini4j.Profile;

public final class SsuIniFileParser {
    private String downloadGroupId;
    private String downloadPid;
    private String manufacturerId;
    private String softwareVersion;
    private String hardwareVersion;
    private String startSn;
    private String endSn;
    private String burnFileName;
    private String ts_File;
    private ArrayList<UpgradeFileInfo> upgradFiles;

    public SsuIniFileParser(String filename) throws InvalidFileFormatException, IOException, InvalidDataFormatException {
        Config.getGlobal().setComment(true);
        InputStreamReader reader = new InputStreamReader((InputStream)new FileInputStream(new File(filename)), WorkbenchEncoding.getWorkbenchDefaultEncoding());
        Ini ini = new Ini((Reader)reader);
        this.ts_File = this.getValue(ini, "packer_tsfilename", "ts_file_name");
        long bin_file_num = this.checkIntValue(ini, "packer_file", "bin_file_num", Messages.IniFileParser_FileNumberError);
        this.checkValue(ini, "packer_file", "bin_name" + bin_file_num, Messages.IniFileParser_FileNumberError);
        this.downloadGroupId = this.checkValue(ini, "packer_attr", "Download_GroupId", NLS.bind((String)Messages.IniFileParser_EmptyValue, (Object)"Download_GroupId"));
        this.checkStringRange(this.downloadGroupId, 2L, 65535L, NLS.bind((String)Messages.IniFileParser_ValueScopeError, (Object[])new Object[]{"Download_GroupId", "0x2~0xFFFF"}));
        this.downloadPid = this.checkValue(ini, "packer_attr", "Download_PID", NLS.bind((String)Messages.IniFileParser_EmptyValue, (Object)"Download_PID"));
        this.checkStringRange(this.downloadPid, 32L, 8190L, NLS.bind((String)Messages.IniFileParser_ValueScopeError, (Object[])new Object[]{"Download_PID", "0x20~0x1FFE"}));
        this.manufacturerId = this.checkValue(ini, "packer_attr", "STB_manufacturerID", NLS.bind((String)Messages.IniFileParser_EmptyValue, (Object)"STB_manufacturerID"));
        this.checkStringRange(this.manufacturerId, 0L, 65535L, NLS.bind((String)Messages.IniFileParser_ValueScopeError, (Object[])new Object[]{"STB_manufacturerID", "0x0~0xFFFF"}));
        this.softwareVersion = this.checkValue(ini, "packer_attr", "software_version", NLS.bind((String)Messages.IniFileParser_EmptyValue, (Object)"software_version"));
        this.checkStringRange(this.softwareVersion, 0L, 0xFFFFFFFFL, NLS.bind((String)Messages.IniFileParser_ValueScopeError, (Object[])new Object[]{"software_version", "0x0~0xFFFFFFFF"}));
        this.hardwareVersion = this.checkValue(ini, "packer_attr", "hardware_version", NLS.bind((String)Messages.IniFileParser_EmptyValue, (Object)"hardware_version"));
        this.checkStringRange(this.hardwareVersion, 0L, 0xFFFFFFFFL, NLS.bind((String)Messages.IniFileParser_ValueScopeError, (Object[])new Object[]{"hardware_version", "0x0~0xFFFFFFFF"}));
        this.startSn = this.checkValue(ini, "packer_attr", "start_sn", NLS.bind((String)Messages.IniFileParser_EmptyValue, (Object)"start_sn"));
        this.checkStringRange(this.startSn, 0L, 0xFFFFFFFFL, NLS.bind((String)Messages.IniFileParser_ValueScopeError, (Object[])new Object[]{"start_sn", "0x0~0xFFFFFFFF"}));
        this.endSn = this.checkValue(ini, "packer_attr", "end_sn", NLS.bind((String)Messages.IniFileParser_EmptyValue, (Object)"end_sn"));
        this.checkStringRange(this.endSn, 0L, 0xFFFFFFFFL, NLS.bind((String)Messages.IniFileParser_ValueScopeError, (Object[])new Object[]{"end_sn", "0x0~0xFFFFFFFF"}));
        this.burnFileName = this.checkValue(ini, "packer_tsfilename", "ts_file_name", null);
        if (this.burnFileName == null) {
            this.burnFileName = "packer.ts";
        }
        if (64L < bin_file_num) {
            throw new InvalidDataFormatException(String.format(Messages.HiLoaderComposite_88, 64));
        }
        this.upgradFiles = new ArrayList();
        int i = 0;
        while ((long)i < bin_file_num) {
            int fileLength;
            FlashType flashType = FlashType.nand;
            long flashIndex = 0L;
            String key = "flash_sel" + (i + 1);
            boolean select = false;
            long sel = (int)this.checkIntValue(ini, "packer_file", key, true);
            select = sel == 1L;
            key = "flash_PartitionName" + (i + 1);
            String PartitionName = this.checkValue(ini, "packer_file", key);
            key = "flash_PartitionVersion" + (i + 1);
            int partitionversion = (int)this.checkIntValue(ini, "packer_file", key, false);
            key = "flash_PartitionVersionTag" + (i + 1);
            int partitionversiontag = (int)this.checkIntValue(ini, "packer_file", key, false);
            key = "bin_name" + (i + 1);
            String partFilename = this.checkValue(ini, "packer_file", key, NLS.bind((String)Messages.IniFileParser_EmptyValue, (Object)key));
            partFilename = StringUtil.removeQuotes(partFilename);
            partFilename = StringUtil.removeQuotes(partFilename);
            if (!FileUtil.canReadFile(partFilename = this.getFileName(filename, partFilename), NLS.bind((String)Messages.IniFileParser_OpenFileError, (Object[])new Object[]{key, partFilename}))) break;
            key = "flash_addr" + (i + 1);
            long startAddr = this.checkIntValue(ini, "packer_file", key, NLS.bind((String)Messages.IniFileParser_EmptyValue, (Object)key));
            key = "flash_type" + (i + 1);
            long type = this.checkIntValue(ini, "packer_file", key, NLS.bind((String)Messages.IniFileParser_EmptyValue, (Object)key));
            this.checkRange(type, 0L, 3L, NLS.bind((String)Messages.IniFileParser_ErrorValue, (Object)key));
            flashType = FlashType.valueOf((int)type);
            FileSystem fileSystem = FileSystem.none;
            key = "flash_system" + (i + 1);
            String system = this.checkValue(ini, "packer_file", key, NLS.bind((String)Messages.IniFileParser_EmptyValue, (Object)key));
            fileSystem = FileSystem.valueOf(system);
            key = "flashindex" + (i + 1);
            flashIndex = this.checkIntValue(ini, "packer_file", key, NLS.bind((String)Messages.IniFileParser_EmptyValue, (Object)key));
            this.checkRange(type, 0L, 3L, NLS.bind((String)Messages.IniFileParser_ErrorValue, (Object)key));
            if (fileSystem.equals(FileSystem.yaffs)) {
                flashIndex |= 0x10000L;
            }
            long length = 0L;
            key = "file_length" + (i + 1);
            length = this.checkIntValue(ini, "packer_file", key, NLS.bind((String)Messages.IniFileParser_EmptyValue, (Object)key));
            UpgradeFileInfo f = new UpgradeFileInfo(select, PartitionName, partitionversion, partitionversiontag, partFilename, startAddr, startAddr + length, flashType, fileSystem, flashIndex, fileLength = (int)new File(partFilename).length(), length);
            if (!FileUtil.checkAddressConflict(f, this.upgradFiles)) {
                this.upgradFiles.add(f);
            }
            if (this.ts_File != null) {
                GlobleControler.intance.SSU_TS = StringUtil.removeQuotes(this.ts_File);
            }
            ++i;
        }
    }

    public SsuIniFileParser(List<PartitionItem> load) throws InvalidFileFormatException, IOException, InvalidDataFormatException {
        Config.getGlobal().setComment(true);
        long bin_file_num = load.size();
        if (this.burnFileName == null) {
            this.burnFileName = "packer.ts";
        }
        if (64L < bin_file_num) {
            throw new InvalidDataFormatException(String.format(Messages.HiLoaderComposite_88, 64));
        }
        this.upgradFiles = new ArrayList();
        int i = 0;
        while (i < load.size()) {
            PartitionItem hiBurnItem = load.get(i);
            FlashType flashType = FlashType.nand;
            long flashIndex = 0L;
            String partFilename = "";
            File file = hiBurnItem.getFile();
            if (file != null) {
                partFilename = hiBurnItem.getFile().getAbsolutePath();
            }
            long startAddr = hiBurnItem.getStart();
            flashType = hiBurnItem.getFlashType();
            FileSystem fileSystem = hiBurnItem.getFileSystem();
            if (FileSystem.yaffs.equals(fileSystem)) {
                flashIndex |= 0x10000L;
            }
            long length = hiBurnItem.getLength();
            int fileLength = (int)new File(partFilename).length();
            UpgradeFileInfo f = new UpgradeFileInfo(hiBurnItem.isChecked(), hiBurnItem.getName(), hiBurnItem.getPartitionVersione(), hiBurnItem.getPartitionVersionTag(), partFilename, startAddr, startAddr + length, flashType, fileSystem, flashIndex, fileLength, length);
            f.setSel(hiBurnItem.isChecked());
            f.setPartitionName(hiBurnItem.getName());
            if (!FileUtil.checkAddressConflict(f, this.upgradFiles)) {
                this.upgradFiles.add(f);
            }
            if (this.ts_File != null) {
                GlobleControler.intance.HISI_TS = StringUtil.removeQuotes(this.ts_File);
            }
            ++i;
        }
    }

    private String getFileName(String iniFilename, String partFilename) {
        int iniFilenameLast = iniFilename.lastIndexOf("\\");
        if (iniFilenameLast == -1) {
            iniFilenameLast = iniFilename.lastIndexOf("/");
        }
        if (iniFilenameLast != -1) {
            iniFilename = iniFilename.substring(0, iniFilenameLast);
        }
        iniFilename = iniFilename.replace("\\", "/");
        int lastIndexOf = partFilename.lastIndexOf("\\");
        if (lastIndexOf == -1) {
            lastIndexOf = partFilename.lastIndexOf("/");
        }
        String newPath = null;
        newPath = lastIndexOf != -1 || partFilename.trim().length() == 0 ? (partFilename.startsWith("./") ? (partFilename = String.valueOf(iniFilename) + "/" + partFilename.substring("./".length())) : partFilename) : String.valueOf(iniFilename) + "/" + partFilename;
        return newPath;
    }

    public String getBurnFileName() {
        return this.burnFileName;
    }

    public ArrayList<UpgradeFileInfo> getUpgradFiles() {
        return this.upgradFiles;
    }

    public SsuUpgradeInfo getUpgradeInfo() {
        SsuUpgradeInfo info = new SsuUpgradeInfo();
        if (this.downloadGroupId != null) {
            info.setDownloadGroupId((int)StringUtil.convertString(this.downloadGroupId));
        }
        if (this.downloadPid != null) {
            info.setDownloadPid((int)StringUtil.convertString(this.downloadPid));
        }
        if (this.manufacturerId != null) {
            info.setManufacturerId((int)StringUtil.convertString(this.manufacturerId));
        }
        if (this.hardwareVersion != null) {
            info.setHardwareVersion((int)StringUtil.convertString(this.hardwareVersion));
        }
        if (this.softwareVersion != null) {
            info.setSoftwareVersion((int)StringUtil.convertString(this.softwareVersion));
        }
        return info;
    }

    private void checkRange(long value, long min, long max, String errorMsg) throws InvalidDataFormatException {
        if (value < min || value > max) {
            throw new InvalidDataFormatException(errorMsg);
        }
    }

    private void checkStringRange(String input, long min, long max, String errorMsg) throws InvalidDataFormatException {
        long value = StringUtil.convertString(input);
        if (value < min || value > max) {
            throw new InvalidDataFormatException(errorMsg);
        }
    }

    private String checkValue(Ini ini, String sec, String key) throws InvalidDataFormatException {
        Profile.Section packer_file = (Profile.Section)ini.get((Object)sec);
        if (packer_file == null) {
            return null;
        }
        String str = packer_file.fetch((Object)key);
        if (str == null || str.trim().length() == 0) {
            return null;
        }
        return str;
    }

    private long checkIntValue(Ini ini, String sec, String key, boolean isSel) throws InvalidDataFormatException {
        Profile.Section packer_file = (Profile.Section)ini.get((Object)sec);
        if (packer_file == null) {
            return 0L;
        }
        String str = packer_file.fetch((Object)key);
        if (str == null) {
            if (isSel) {
                return 1L;
            }
            return 0L;
        }
        return StringUtil.convertString(str);
    }

    private long checkIntValue(Ini ini, String sec, String key, String errorMsg) throws InvalidDataFormatException {
        String value = this.checkValue(ini, sec, key, errorMsg);
        return StringUtil.convertString(value);
    }

    private String checkValue(Ini ini, String sec, String key, String errorMsg) throws InvalidDataFormatException {
        Profile.Section packer_file = (Profile.Section)ini.get((Object)sec);
        String str = packer_file.fetch((Object)key);
        if (str == null || str.trim().length() == 0) {
            if (errorMsg != null) {
                throw new InvalidDataFormatException(errorMsg);
            }
            return null;
        }
        return this.removeComment(str);
    }

    private String getValue(Ini ini, String sec, String key) {
        Profile.Section packer_file = (Profile.Section)ini.get((Object)sec);
        if (packer_file == null) {
            return null;
        }
        String str = packer_file.fetch((Object)key);
        if (str == null || str.trim().length() == 0) {
            return null;
        }
        return str;
    }

    private String removeComment(String str) {
        int pos = str.indexOf(59);
        if (pos > -1) {
            str = str.substring(0, pos);
        }
        return str.trim();
    }

    public String getDownloadGroupId() {
        return this.downloadGroupId;
    }

    public String getDownloadPid() {
        return this.downloadPid;
    }

    public String getManufacturerId() {
        return this.manufacturerId;
    }

    public String getSoftwareVersion() {
        return this.softwareVersion;
    }

    public String getHardwareVersion() {
        return this.hardwareVersion;
    }

    public String getStartSn() {
        return this.startSn;
    }

    public String getEndSn() {
        return this.endSn;
    }
}

