/*
 * Decompiled with CFR 0.152.
 */
package com.hisilicon.hiloader.util;

import com.hisilicon.hiloader.Messages;
import com.hisilicon.hiloader.controler.Builder;
import com.hisilicon.hiloader.controler.GlobleControler;
import com.hisilicon.hiloader.struct.UpgradeFileInfo;
import com.hisilicon.hiloader.struct.UpgradeInfo;
import com.hisilicon.hiloader.struct.UsbHeader;
import com.hisilicon.hiloader.struct.UsbImgMap;
import com.hisilicon.hiloader.struct.UsbManuInfo;
import com.hisilicon.hiloader.struct.ssu.SsuUpgradeInfo;
import com.hisilicon.hiloader.util.FileHelper;
import com.hisilicon.hiloader.util.FileUtil;
import com.hisilicon.hiloader.util.HiLoaderException;
import com.hisilicon.hiloader.util.ssu.SsuPackageOptions;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.math.BigInteger;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubProgressMonitor;

public class HisiUsbPackageBuilder
implements Builder {
    private static final int NumberOfManufacturer = 1;
    private static final long DownloadType = 1L;
    private static boolean is32Bit;
    private static boolean hi3798CV200;

    public static void setIs32Bit(boolean is32Bit) {
        HisiUsbPackageBuilder.is32Bit = is32Bit;
    }

    public static void setHi3798CV200(boolean hi3798cv200) {
        hi3798CV200 = hi3798cv200;
    }

    @Override
    public IStatus createPackage(List<UpgradeFileInfo> files, UpgradeInfo info, String file, IProgressMonitor monitor) throws IOException, HiLoaderException {
        monitor.setTaskName("Validate upgrade file list..");
        boolean success = FileHelper.validateUpdateFilesList(files, 0x1E000000L);
        HisiUsbPackageBuilder.setIs32Bit(GlobleControler.intance.isIs32Bit());
        HisiUsbPackageBuilder.setHi3798CV200(GlobleControler.intance.isHi3798CV200());
        if (!success) {
            return Status.CANCEL_STATUS;
        }
        int g_ulPartNum = files.size();
        monitor.setTaskName("Analysis of the part file");
        files = FileHelper.getRealBurnFileList(files, 0x1E000000L);
        if (64 < files.size()) {
            throw new HiLoaderException(String.format(Messages.HiLoaderComposite_MaxPartFile, 64));
        }
        if (monitor.isCanceled()) {
            FileUtil.deleteFile(file);
            return Status.CANCEL_STATUS;
        }
        monitor.beginTask("Package Usb File..", 100 * g_ulPartNum + 120);
        UsbHeader header = new UsbHeader();
        header.u32MagicNum.set(1280262468L);
        header.u16ManuNum.set(1);
        UsbManuInfo usbManuInfo = header.astManuInfo[0];
        monitor.worked(5);
        usbManuInfo.u32ManuId.set((long)info.getManufacturerId());
        usbManuInfo.u32HardVersion.set((long)info.getHardwareVersion());
        usbManuInfo.u32SoftVersion.set((long)info.getSoftwareVersion());
        monitor.worked(5);
        usbManuInfo.u32SnStart.set((long)info.getStartSn());
        usbManuInfo.u32SnEnd.set((long)info.getEndSn());
        usbManuInfo.u32DownloadType.set(1L);
        usbManuInfo.u32Reserved.set(0L);
        usbManuInfo.u16ImgMapNum.set(g_ulPartNum);
        if (monitor.isCanceled()) {
            FileUtil.deleteFile(file);
            return Status.CANCEL_STATUS;
        }
        monitor.worked(10);
        int i = 0;
        while (i < g_ulPartNum) {
            if (monitor.isCanceled()) {
                FileUtil.deleteFile(file);
                return Status.CANCEL_STATUS;
            }
            monitor.worked(100);
            UpgradeFileInfo f = files.get(i);
            UsbImgMap pImg = usbManuInfo.astImgMap[i];
            pImg.u32FileLength.set((long)f.getFileLength());
            pImg.setU64FlashAddr(f.getStartAddress());
            pImg.setU64Partition_endaddr(f.getEndAddress());
            pImg.uFlashType.set((Enum)f.getFlashType());
            pImg.lFlashIndex.set(new BigInteger(String.valueOf(f.getFlashIndex())));
            pImg.strFileName = f.getFileName();
            pImg.setU8PartitionName(f.getPartitionName());
            pImg.u32PartitionVersion.set((long)f.getPartitionVersion());
            pImg.u32PartitionVerifyTag.set((long)f.getPartitionVerifyTag());
            ++i;
        }
        header.u32HeaderLen.set((long)HisiUsbPackageBuilder.getHeaderLen(header));
        header.setU64FileLen(HisiUsbPackageBuilder.calcOffset(header));
        return HisiUsbPackageBuilder.createUsbPackage(header, file, new SubProgressMonitor(monitor, 100, 4));
    }

    /*
     * Exception decompiling
     */
    private static IStatus createUsbPackage(UsbHeader header, String file, SubProgressMonitor monitor) throws IOException, HiLoaderException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [24[WHILELOOP]], but top level block is 11[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private static void writeDword(ByteArrayOutputStream temp, byte[] PartitionNameS) {
        try {
            temp.write(PartitionNameS);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private static void writeToFile(FileOutputStream out, File f) throws IOException {
        FileInputStream inputStream = null;
        try {
            inputStream = new FileInputStream(f);
            byte[] buffer = new byte[0x100000];
            long length = f.length();
            while (length > 0L) {
                int read = inputStream.read(buffer);
                out.write(buffer, 0, read);
                length -= (long)read;
            }
        }
        finally {
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
    }

    private static void writeToFile(FileOutputStream out, byte[] buf) throws HiLoaderException {
        try {
            out.write(buf);
            out.flush();
        }
        catch (Exception e1) {
            throw new HiLoaderException(Messages.UsbPackageBuilder_WriteError);
        }
    }

    private static long calcOffset(UsbHeader header) {
        long offset = header.u32HeaderLen.get();
        int i = 0;
        int l = header.u16ManuNum.get();
        while (i < l) {
            int j = 0;
            int k = header.astManuInfo[i].u16ImgMapNum.get();
            while (j < k) {
                UsbImgMap pImg = header.astManuInfo[i].astImgMap[j];
                pImg.u32Offset.set(offset);
                offset += 8L;
                offset += pImg.u32FileLength.get();
                ++j;
            }
            ++i;
        }
        return offset;
    }

    public static int getMenuInfoLen(UsbManuInfo pManu) {
        int img_len = 0;
        int manu_len = 30;
        img_len = is32Bit ? 24 : 32;
        if (hi3798CV200) {
            int length = 0;
            int j = 0;
            int k = pManu.u16ImgMapNum.get();
            while (j < k) {
                UsbImgMap pImg = pManu.astImgMap[j];
                String name = pImg.getU8PartitionName();
                length = name == null || name.isEmpty() ? (length += img_len + 4 + 4 + 2 + 2) : (length += img_len + 4 + 4 + 2 + pImg.getU8PartitionName().length() + 2);
                ++j;
            }
            return manu_len + length;
        }
        return manu_len + img_len * pManu.u16ImgMapNum.get();
    }

    public static int getHeaderLen(UsbHeader header) {
        int len = 0;
        len = hi3798CV200 ? 18 : (is32Bit ? 18 : 22);
        if (header.u16ManuNum.get() > 3) {
            header.u16ManuNum.set(0);
        }
        int i = 0;
        int l = header.u16ManuNum.get();
        while (i < l) {
            len += HisiUsbPackageBuilder.getMenuInfoLen(header.astManuInfo[i]);
            ++i;
        }
        return len;
    }

    public static void writeLongword(OutputStream out, long val) throws IOException {
        out.write((byte)(val >> 56) & 0xFF);
        out.write((byte)(val >> 48) & 0xFF);
        out.write((byte)(val >> 40) & 0xFF);
        out.write((byte)(val >> 32) & 0xFF);
        out.write((byte)(val >> 24) & 0xFF);
        out.write((byte)(val >> 16) & 0xFF);
        out.write((byte)(val >> 8) & 0xFF);
        out.write((byte)(val & 0xFFL));
    }

    public static void writeDword(OutputStream out, long val) throws IOException {
        out.write((int)(val >>> 24 & 0xFFL));
        out.write((int)(val >>> 16 & 0xFFL));
        out.write((int)(val >>> 8 & 0xFFL));
        out.write((int)(val & 0xFFL));
    }

    public static void writeDwordLow8Bit(OutputStream out, long val) throws IOException {
        out.write(0);
        out.write(0);
        out.write(0);
        out.write((int)(val & 0xFFL));
    }

    public static void writeWordInt(OutputStream out, int val) throws IOException {
        out.write(val >>> 8 & 0xFF);
        out.write(val & 0xFF);
    }

    @Override
    public IStatus createPackage(List<UpgradeFileInfo> fileInfoList, SsuUpgradeInfo info, SsuPackageOptions packageOtions, String tsFileName, IProgressMonitor monitor) throws IOException, HiLoaderException {
        return null;
    }
}

