/*
 * Decompiled with CFR 0.152.
 */
package com.hisilicon.hiloader.util;

import com.hisilicon.hiloader.Messages;
import com.hisilicon.hiloader.sparse.SparseChunkHeader;
import com.hisilicon.hiloader.sparse.SparseFileAgent;
import com.hisilicon.hiloader.sparse.SparseHeader;
import com.hisilicon.hiloader.struct.FileSystem;
import com.hisilicon.hiloader.struct.UpgradeFileInfo;
import com.hisilicon.hiloader.util.FileUtil;
import com.hisilicon.hiloader.util.StringUtil;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;

public class FileHelper {
    public static final String SMALL_FILE_PATH = "hiloader_PartTemp/";
    static final int EMMC_BLOCKSZIE = 512;
    static final int SEPARATE_CHUNKLEN = 0x500000;
    static final int EMPTY_LEN = 0x500000;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static List<UpgradeFileInfo> splitLargeFileToSmallFileList(UpgradeFileInfo largeFileInfo, long filePartSize) throws IOException {
        long largeFileLength = largeFileInfo.getFileLength();
        String largeFileName = largeFileInfo.getFileName();
        ArrayList<UpgradeFileInfo> smallFileList = new ArrayList<UpgradeFileInfo>();
        if (largeFileLength <= filePartSize) {
            smallFileList.add(largeFileInfo);
            return smallFileList;
        }
        FileInputStream inputStream = null;
        try {
            byte[] buffer = new byte[0x200000];
            int times = 0;
            File file = new File(largeFileName);
            if (file != null && file.exists() && file.isFile()) {
                inputStream = new FileInputStream(file);
            }
            if (inputStream == null) {
                return null;
            }
            long address = largeFileInfo.getStartAddress();
            UpgradeFileInfo smallPartInfo = null;
            while (largeFileLength > 0L) {
                File partfile = null;
                int partLength = 0;
                int read = -1;
                String partFilePath = SMALL_FILE_PATH + file.getName() + ".part" + System.nanoTime() + "_" + times;
                partfile = new File(partFilePath);
                try {
                    partfile.createNewFile();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                FileOutputStream outputtream = null;
                smallPartInfo = largeFileInfo.copy();
                try {
                    outputtream = new FileOutputStream(partfile);
                    int length = (int)Math.min(filePartSize, (long)buffer.length);
                    while ((long)partLength < filePartSize && (read = inputStream.read(buffer, 0, length)) > 0) {
                        ((OutputStream)outputtream).write(buffer, 0, read);
                        length = filePartSize - (long)(partLength += read) < (long)buffer.length ? (int)(filePartSize - (long)partLength) : buffer.length;
                    }
                }
                finally {
                    if (outputtream != null) {
                        ((OutputStream)outputtream).close();
                    }
                }
                smallPartInfo.setFileName(partfile.getAbsolutePath());
                smallPartInfo.setFileLength(partLength);
                smallPartInfo.setStartAddress(address);
                if ((long)partLength < filePartSize) {
                    smallPartInfo.setEndAddress(largeFileInfo.getEndAddress());
                } else {
                    smallPartInfo.setEndAddress(address + filePartSize);
                }
                smallFileList.add(smallPartInfo);
                largeFileLength -= (long)partLength;
                address += filePartSize;
                ++times;
            }
            return smallFileList;
        }
        finally {
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (Exception exception) {}
            }
        }
    }

    public static long getRealSizeOfSparseFile(File sparseFile, boolean isSparse) throws IOException {
        if (!isSparse) {
            return 0L;
        }
        long partNeedSize = 0L;
        RandomAccessFile inFile = null;
        try {
            inFile = new RandomAccessFile(sparseFile, "r");
            int readLength = 0;
            byte[] sparseHeaderData = new byte[28];
            inFile.seek(0L);
            int index = inFile.read(sparseHeaderData);
            if (index > -1) {
                readLength += 28;
            }
            SparseHeader sparseHeader = new SparseHeader();
            sparseHeader.fromBytes(sparseHeaderData);
            int i = 0;
            while (i < sparseHeader.total_chunks) {
                inFile.seek(readLength);
                byte[] chunkHeaderData = new byte[12];
                int length = inFile.read(chunkHeaderData);
                if (length > -1) {
                    readLength += 12;
                }
                SparseChunkHeader chunkHeader = new SparseChunkHeader();
                chunkHeader.fromBytes(chunkHeaderData);
                int chunkLen = 0;
                if (chunkHeader.getChunk_type() == -13631) {
                    chunkLen = chunkHeader.getChunk_sz() * sparseHeader.blk_sz;
                    partNeedSize += (long)chunkLen;
                    int chunkDataSpaceCount = (chunkLen + 0x500000 - 1) / 0x500000;
                    int chunkDataSpaceSpace = chunkLen % 0x500000;
                    if (chunkDataSpaceCount == 0) {
                        byte[] chunkData = new byte[chunkLen];
                        int inFileLength = inFile.read(chunkData);
                        if (inFileLength > -1) {
                            readLength += chunkLen;
                        }
                    } else {
                        int j = 0;
                        while (j < chunkDataSpaceCount) {
                            int len;
                            byte[] chunkData = null;
                            if (j == chunkDataSpaceCount - 1) {
                                if (chunkDataSpaceSpace == 0) {
                                    chunkData = new byte[0x500000];
                                    len = 0x500000;
                                } else {
                                    chunkData = new byte[chunkDataSpaceSpace];
                                    len = chunkDataSpaceSpace;
                                }
                            } else {
                                chunkData = new byte[0x500000];
                                len = 0x500000;
                            }
                            int inFileLength = inFile.read(chunkData);
                            if (inFileLength > -1) {
                                readLength += len;
                            }
                            ++j;
                        }
                    }
                } else if (chunkHeader.getChunk_type() == -13629) {
                    chunkLen = chunkHeader.getChunk_sz() * sparseHeader.blk_sz;
                    partNeedSize += (long)chunkLen;
                } else {
                    throw new IOException(Messages.ValidationSpareseFailed);
                }
                ++i;
            }
        }
        finally {
            if (inFile != null) {
                try {
                    inFile.close();
                }
                catch (IOException iOException) {}
            }
        }
        return partNeedSize;
    }

    public static List<UpgradeFileInfo> splitLargeFileForEMMC(UpgradeFileInfo largeFileInfo, long filePartSize) throws IOException {
        boolean isSparse;
        List<UpgradeFileInfo> smallFileList = new ArrayList<UpgradeFileInfo>();
        File file = new File(largeFileInfo.getFileName());
        long largeFileLength = file.length();
        if (largeFileLength <= filePartSize) {
            smallFileList.add(largeFileInfo);
            return smallFileList;
        }
        boolean bl = isSparse = (largeFileInfo.getFileSystem() == FileSystem.ext3 || largeFileInfo.getFileSystem() == FileSystem.f2fs) && SparseFileAgent.isAndroidSparseFile(file);
        if (isSparse) {
            FileHelper.splitLargeFile(largeFileInfo, filePartSize, smallFileList, file);
        } else {
            smallFileList = FileHelper.splitLargeFileToSmallFileList(largeFileInfo, filePartSize);
        }
        return smallFileList;
    }

    private static void splitLargeFile(UpgradeFileInfo largeFileInfo, long filePartSize, List<UpgradeFileInfo> smallFileList, File file) throws FileNotFoundException, IOException {
        byte[] sparseHeaderData;
        int readLength;
        File tmpFile;
        long address;
        RandomAccessFile outFile;
        RandomAccessFile inFile;
        block29: {
            inFile = null;
            outFile = null;
            address = largeFileInfo.getStartAddress();
            inFile = new RandomAccessFile(file, "r");
            tmpFile = new File(SMALL_FILE_PATH + file.getName() + System.nanoTime() + ".tmp");
            readLength = 0;
            sparseHeaderData = new byte[28];
            inFile.seek(0L);
            int headerLength = inFile.read(sparseHeaderData);
            if (headerLength >= 0) break block29;
            FileHelper.closeStream(outFile);
            FileHelper.closeStream(inFile);
            return;
        }
        try {
            readLength += 28;
            SparseHeader sparseHeader = new SparseHeader();
            sparseHeader.fromBytes(sparseHeaderData);
            long partNeedSize = 0L;
            int partBlk = 0;
            int partChunkNum = 0;
            FileUtil.deleteFile(tmpFile);
            outFile = new RandomAccessFile(tmpFile, "rw");
            outFile.seek(0L);
            outFile.write(SparseHeader.getEmpty());
            int i = 0;
            while (i < sparseHeader.total_chunks) {
                boolean isEnough;
                inFile.seek(readLength);
                byte[] chunkHeaderData = new byte[12];
                SparseChunkHeader chunkHeader = new SparseChunkHeader();
                int length = inFile.read(chunkHeaderData);
                if (length > -1) {
                    readLength += 12;
                    chunkHeader.fromBytes(chunkHeaderData);
                }
                int chunkLen = 0;
                if (chunkHeader.getChunk_type() == -13631) {
                    chunkLen = chunkHeader.getChunk_sz() * sparseHeader.blk_sz;
                    partBlk += chunkHeader.getChunk_sz();
                    partNeedSize += (long)chunkLen;
                    ++partChunkNum;
                    outFile.write(chunkHeaderData);
                    int chunkDataSpaceCount = (chunkLen + 0x500000 - 1) / 0x500000;
                    int chunkDataSpaceSpace = chunkLen % 0x500000;
                    if (chunkDataSpaceCount == 0) {
                        byte[] chunkData = new byte[chunkLen];
                        int inlength = inFile.read(chunkData);
                        if (inlength > -1) {
                            readLength += chunkLen;
                            outFile.write(chunkData);
                        }
                    } else {
                        int j = 0;
                        while (j < chunkDataSpaceCount) {
                            int len;
                            byte[] chunkData = null;
                            if (j == chunkDataSpaceCount - 1) {
                                if (chunkDataSpaceSpace == 0) {
                                    chunkData = new byte[0x500000];
                                    len = 0x500000;
                                } else {
                                    chunkData = new byte[chunkDataSpaceSpace];
                                    len = chunkDataSpaceSpace;
                                }
                            } else {
                                chunkData = new byte[0x500000];
                                len = 0x500000;
                            }
                            int index = inFile.read(chunkData);
                            if (index > -1) {
                                readLength += len;
                                outFile.write(chunkData);
                            }
                            ++j;
                        }
                    }
                } else {
                    if (chunkHeader.getChunk_type() != -13629) break;
                    chunkLen = chunkHeader.getChunk_sz() * sparseHeader.blk_sz;
                    partBlk += chunkHeader.getChunk_sz();
                    partNeedSize += (long)chunkLen;
                    ++partChunkNum;
                    outFile.write(chunkHeaderData);
                }
                SparseChunkHeader nextChunkHeader = null;
                if (i < sparseHeader.total_chunks - 1) {
                    nextChunkHeader = new SparseChunkHeader();
                    byte[] nextChunkHeaderData = new byte[12];
                    int inFilelength = inFile.read(nextChunkHeaderData);
                    if (inFilelength > -1) {
                        nextChunkHeader.fromBytes(nextChunkHeaderData);
                    }
                }
                int measureValue = 0;
                if (nextChunkHeader != null) {
                    if (nextChunkHeader.getChunk_type() == -13631) {
                        measureValue = (int)partNeedSize + nextChunkHeader.getChunk_sz() * sparseHeader.blk_sz;
                    } else {
                        if (nextChunkHeader.getChunk_type() != -13629) break;
                        measureValue = (int)partNeedSize + nextChunkHeader.getChunk_sz() * sparseHeader.blk_sz;
                    }
                }
                boolean bl = isEnough = (long)measureValue > filePartSize || nextChunkHeader == null;
                if (isEnough) {
                    SparseHeader partHeader = new SparseHeader();
                    partHeader.magic = sparseHeader.magic;
                    partHeader.major_version = sparseHeader.major_version;
                    partHeader.minor_version = sparseHeader.minor_version;
                    partHeader.file_hdr_sz = (short)28;
                    partHeader.chunk_hdr_sz = (short)12;
                    partHeader.blk_sz = sparseHeader.blk_sz;
                    partHeader.total_blks = partBlk;
                    partHeader.total_chunks = partChunkNum;
                    partHeader.image_checksum = 0;
                    outFile.seek(0L);
                    outFile.write(partHeader.toBytes());
                    UpgradeFileInfo tempInfo = largeFileInfo.copy();
                    tempInfo.setFileName(tmpFile.getAbsolutePath());
                    tempInfo.setFileLength((int)tmpFile.length());
                    tempInfo.setStartAddress(address);
                    if (nextChunkHeader == null) {
                        tempInfo.setEndAddress(largeFileInfo.getEndAddress());
                    } else {
                        tempInfo.setEndAddress(address + partNeedSize);
                    }
                    smallFileList.add(tempInfo);
                    address += partNeedSize;
                    partNeedSize = 0L;
                    partBlk = 0;
                    partChunkNum = 0;
                    if (i < sparseHeader.total_chunks - 1) {
                        if (i + 1 == sparseHeader.total_chunks - 1) {
                            inFile.seek(readLength);
                            nextChunkHeader = new SparseChunkHeader();
                            byte[] nextChunkHeaderData = new byte[12];
                            int inFilelength = inFile.read(nextChunkHeaderData);
                            if (inFilelength > -1) {
                                nextChunkHeader.fromBytes(nextChunkHeaderData);
                            }
                            if (nextChunkHeader.getChunk_type() == -13629) break;
                        }
                        tmpFile = new File(SMALL_FILE_PATH + file.getName() + System.nanoTime() + ".tmp");
                        FileHelper.closeStream(outFile);
                        outFile = new RandomAccessFile(tmpFile, "rw");
                        outFile.seek(0L);
                        outFile.write(SparseHeader.getEmpty());
                    }
                }
                ++i;
            }
        }
        catch (Throwable throwable) {
            FileHelper.closeStream(outFile);
            FileHelper.closeStream(inFile);
            throw throwable;
        }
        FileHelper.closeStream(outFile);
        FileHelper.closeStream(inFile);
    }

    private static void closeStream(RandomAccessFile outFile) {
        try {
            if (outFile != null) {
                outFile.close();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static List<UpgradeFileInfo> getRealBurnFileList(List<UpgradeFileInfo> infoList, long filePartSize) throws IOException {
        ArrayList<UpgradeFileInfo> realInfoList = new ArrayList<UpgradeFileInfo>();
        for (UpgradeFileInfo info : infoList) {
            realInfoList.addAll(FileHelper.splitLargeFileForEMMC(info, filePartSize));
        }
        return realInfoList;
    }

    public static void deleteFile(String rootPath) {
        File[] listFiles;
        File file = new File(rootPath);
        if (!file.exists()) {
            return;
        }
        File[] fileArray = listFiles = file.listFiles();
        int n = listFiles.length;
        int n2 = 0;
        while (n2 < n) {
            File tempFile = fileArray[n2];
            try {
                tempFile.delete();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            ++n2;
        }
    }

    public static void createFile(String rootPath) {
        File rootFile = new File(rootPath);
        if (!rootFile.exists()) {
            try {
                rootFile.mkdirs();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public static void createTempPartFile() {
        FileHelper.createFile(SMALL_FILE_PATH);
    }

    public static void deleteTempPartFile() {
        FileHelper.deleteFile(SMALL_FILE_PATH);
    }

    public static boolean checkUpgradeFileInfo(List<UpgradeFileInfo> upgradeInfos) {
        for (UpgradeFileInfo info : upgradeInfos) {
            if (!info.isSel() || info.getFileName() != null && !info.getFileName().isEmpty()) continue;
            MessageDialog.openError((Shell)Display.getDefault().getActiveShell(), (String)Messages.HiLoaderComposite_10, (String)Messages.HiLoaderComposite_SelectFile);
            return false;
        }
        return true;
    }

    public static void addFileLenth(List<UpgradeFileInfo> updateFiles) throws IOException {
        UpgradeFileInfo info = null;
        File tempFile = null;
        int i = 0;
        while (i < updateFiles.size()) {
            info = updateFiles.get(i);
            tempFile = new File(info.getFileName());
            if (tempFile == null || !tempFile.exists() || tempFile.isDirectory()) {
                String message = String.format(NLS.bind((String)Messages.HiLoaderComposite_InvalidFile, (Object)(i + 1)), new Object[0]);
                throw new IOException(message);
            }
            info.setFileLength((int)tempFile.length());
            ++i;
        }
    }

    public static boolean validateUpdateFilesList(List<UpgradeFileInfo> updateFiles, long part) throws IOException {
        UpgradeFileInfo info = null;
        File tempFile = null;
        int i = 0;
        while (i < updateFiles.size()) {
            info = updateFiles.get(i);
            tempFile = new File(info.getFileName());
            if (tempFile == null || !tempFile.exists() || tempFile.isDirectory()) {
                String message = String.format(NLS.bind((String)Messages.HiLoaderComposite_InvalidFile, (Object)(i + 1)), new Object[0]);
                throw new IOException(message);
            }
            info.setFileLength((int)tempFile.length());
            if (info.getLength() < (long)info.getFileLength()) {
                String message = String.format(Messages.HiLoaderComposite_InvalidFileLength, i + 1);
                throw new IOException(message);
            }
            if ((long)info.getFileLength() > part) {
                boolean isSparse;
                boolean bl = isSparse = (info.getFileSystem() == FileSystem.ext3 || info.getFileSystem() == FileSystem.f2fs) && SparseFileAgent.isAndroidSparseFile(new File(info.getFileName()));
                if (isSparse) {
                    long realFileLength = FileHelper.getRealSizeOfSparseFile(new File(info.getFileName()), isSparse);
                    if (info.getLength() < realFileLength) {
                        throw new IOException(NLS.bind((String)Messages.HiLoaderComposite_InvalidFileLength2, (Object[])new Object[]{StringUtil.convertUnit(realFileLength), i + 1}));
                    }
                }
            }
            ++i;
        }
        return true;
    }
}

