/*
 * Decompiled with CFR 0.152.
 */
package com.hisilicon.hiloader.ui.ssu;

import com.hisilicon.hiloader.Messages;
import com.hisilicon.hiloader.struct.UpgradeInfo;
import com.hisilicon.hiloader.struct.ssu.SsuUpgradeInfo;
import com.hisilicon.hiloader.ui.ComboField;
import com.hisilicon.hiloader.ui.LabelTextField;
import com.hisilicon.hiloader.util.StringUtil;
import com.hisilicon.hiloader.util.ssu.SsuIniFileParser;
import com.hisilicon.hiloader.views.HiLoaderView;
import java.math.BigInteger;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;

public class SsuUpgradeInfoGroup {
    private LabelTextField downloadGroupId;
    private LabelTextField downloadPid;
    private LabelTextField manufacturerId;
    private LabelTextField softwareId;
    private LabelTextField hardwareMode;
    private LabelTextField startSn;
    private LabelTextField endSn;
    private LabelTextField hardwareId;
    private LabelTextField softwareMode;
    private ComboField upgradeMode;
    private static final int labelWidth = 200;
    private SsuUpgradeInfo input;
    private String manufacturerIdMin = "0x0000";
    private String manufacturerIdMax = "0xFFFF";
    private String manufacturerIdDefault = "0x0003";
    private String manufacturerIdRange = "0x0000~0xFFFF";
    private String hardwareIdMin = "0x00000000";
    private String hardwareIdMax = "0xFFFFFFFF";
    private String hardwareIdDefault = "0x00000001";
    private String hardwareIdRange = "0x00000000~0xFFFFFFFF";
    private String softwareIdMin = "0x00000000";
    private String softwareIdMax = "0xFFFFFFFF";
    private String softwareIdDefault = "0x01010101";
    private String softwareIdRange = "0x00000000~0xFFFFFFFF";
    private String startSnMin = "0x00000000";
    private String startSnMax = "0xFFFFFFFF";
    private String endSnMin = "0x00000000";
    private String endSnMax = "0xFFFFFFFF";

    public SsuUpgradeInfoGroup(Composite parent) {
        this.createControls(parent);
    }

    private void createControls(Composite group) {
        if (HiLoaderView.isETSITS102006V141()) {
            this.manufacturerIdDefault = "0x000003";
            this.manufacturerIdRange = "0x000000~0xFFFFFF";
            this.hardwareIdDefault = "0x0001";
            this.hardwareIdRange = "0x0000~0xFFFF";
            this.softwareIdDefault = "0x0001";
            this.softwareIdRange = "0x0000~0xFFFF";
            this.startSnMin = "0x0000";
            this.startSnMax = "0xFFFF";
            this.endSnMin = "0x0000";
            this.endSnMax = "0xFFFF";
        }
        this.downloadGroupId = new LabelTextField(group, Messages.SsuUpgradeInfoGroup_groupId, 200, null, "0x2", "0x2~0xFFFF");
        this.downloadPid = new LabelTextField(group, Messages.UpgradeInfoGroup_1, 200, null, "0x1b58", "0x20~0x1FFE");
        this.manufacturerId = new LabelTextField(group, Messages.UpgradeInfoGroup_5, 200, null, this.manufacturerIdDefault, this.manufacturerIdRange);
        if (HiLoaderView.isETSITS102006V141()) {
            this.hardwareMode = new LabelTextField(group, Messages.UpgradeInfoGroup_HardwareMode, 200, null, "0x0001", "0x0000~0xFFFF");
            this.softwareMode = new LabelTextField(group, Messages.UpgradeInfoGroup_SoftwareMode, 200, null, "0x0001", "0x0000~0xFFFF");
        }
        this.hardwareId = new LabelTextField(group, Messages.UpgradeInfoGroup_7, 200, null, this.hardwareIdDefault, this.hardwareIdRange);
        this.softwareId = new LabelTextField(group, Messages.UpgradeInfoGroup_9, 200, null, this.softwareIdDefault, this.softwareIdRange);
        if (HiLoaderView.isETSITS102006V141()) {
            this.startSn = new LabelTextField(group, Messages.UpgradeInfoGroup_Start_Sn, 200, null, "0x0000", "0x0000~0xFFFF");
            this.endSn = new LabelTextField(group, Messages.UpgradeInfoGroup_End_Sn, 200, null, "0xffff", "0x0000~0xFFFF");
            this.upgradeMode = new ComboField(group, Messages.UpgradeInfoGroup_UpgradeMode, 80, new String[]{Messages.UpgradeInfoGroup_Simple, Messages.UpgradeInfoGroup_Enhance});
        } else {
            this.startSn = new LabelTextField(group, Messages.UpgradeInfoGroup_Start_Sn, 200, null, "0x00000000", "0x00000000~0xFFFFFFFF");
            this.endSn = new LabelTextField(group, Messages.UpgradeInfoGroup_End_Sn, 200, null, "0xffffffff", "0x00000000~0xFFFFFFFF");
        }
    }

    public void setInput(SsuIniFileParser parser, SsuUpgradeInfo info) {
        this.input = info;
        if (parser.getDownloadGroupId() != null) {
            this.downloadGroupId.getTextControl().setText(parser.getDownloadGroupId());
        }
        if (parser.getDownloadPid() != null) {
            this.downloadPid.getTextControl().setText(parser.getDownloadPid());
        }
        if (parser.getManufacturerId() != null) {
            this.manufacturerId.getTextControl().setText(parser.getManufacturerId());
        }
        if (parser.getHardwareVersion() != null) {
            this.hardwareId.getTextControl().setText(parser.getHardwareVersion());
        }
        if (parser.getSoftwareVersion() != null) {
            this.softwareId.getTextControl().setText(parser.getSoftwareVersion());
        }
        if (parser.getStartSn() != null) {
            this.startSn.getTextControl().setText(parser.getStartSn());
        }
        if (parser.getEndSn() != null) {
            this.endSn.getTextControl().setText(parser.getEndSn());
        }
    }

    public SsuUpgradeInfo getInput() {
        if (this.input == null) {
            this.input = new SsuUpgradeInfo();
        }
        this.input.setDownloadGroupId((int)StringUtil.convertString(this.getDownloadGroupId()));
        this.input.setDownloadPid((int)StringUtil.convertString(this.getDownloadPid()));
        this.input.setManufacturerId((int)StringUtil.convertString(this.getManufacturerId()));
        this.input.setHardwareVersion((int)StringUtil.convertString(this.getHardwareVersion()));
        this.input.setSoftwareVersion((int)StringUtil.convertString(this.getSoftwareVersion()));
        this.input.setStartSn((int)StringUtil.convertString(this.getStartSn()));
        this.input.setEndSn((int)StringUtil.convertString(this.getEndSn()));
        if (HiLoaderView.isETSITS102006V141()) {
            this.input.setHardwareMode((int)StringUtil.convertString(this.getHardwareMode()));
            this.input.setSoftwareMode((int)StringUtil.convertString(this.getSoftwareMode()));
            this.input.setUpgradeMode(this.getUpgradeMode());
        }
        return this.input;
    }

    public boolean validateInput() {
        block18: {
            block17: {
                block16: {
                    block15: {
                        block14: {
                            block13: {
                                block12: {
                                    block11: {
                                        try {
                                            if (this.validateInputV141()) break block11;
                                            return false;
                                        }
                                        catch (NumberFormatException e) {
                                            this.showError(Messages.UpgradeInfoGroup_InputInvalid);
                                            return false;
                                        }
                                    }
                                    if (this.downloadGroupId == null || StringUtil.hexInRange(this.downloadGroupId.getText(), "0x2", "0xFFFF")) break block12;
                                    this.showError(Messages.SsuUpgradeInfoGroup_GroupIdInputError);
                                    return false;
                                }
                                if (StringUtil.hexInRange(this.downloadPid.getText(), "0x20", "0x1FFE")) break block13;
                                this.showError(Messages.UpgradeInfoGroup_23);
                                return false;
                            }
                            if (StringUtil.hexInRange(this.manufacturerId.getText(), this.manufacturerIdMin, this.manufacturerIdMax)) break block14;
                            this.showError(NLS.bind((String)Messages.UpgradeInfoGroup_29, (Object[])new Object[]{this.manufacturerIdMin, this.manufacturerIdMax}));
                            return false;
                        }
                        if (StringUtil.hexInRange(this.hardwareId.getText(), this.hardwareIdMin, this.hardwareIdMax)) break block15;
                        this.showError(NLS.bind((String)Messages.UpgradeInfoGroup_32, (Object[])new Object[]{this.hardwareIdMin, this.hardwareIdMax}));
                        return false;
                    }
                    if (StringUtil.hexInRange(this.softwareId.getText(), this.softwareIdMin, this.softwareIdMax)) break block16;
                    this.showError(NLS.bind((String)Messages.UpgradeInfoGroup_35, (Object[])new Object[]{this.softwareIdMin, this.softwareIdMax}));
                    return false;
                }
                if (StringUtil.hexInRange(this.startSn.getText(), this.startSnMin, this.startSnMax)) break block17;
                this.showError(NLS.bind((String)Messages.UpgradeInfoGroup_StartSnInputError, (Object[])new Object[]{this.startSnMin, this.startSnMax}));
                return false;
            }
            if (StringUtil.hexInRange(this.endSn.getText(), this.endSnMin, this.endSnMax)) break block18;
            this.showError(NLS.bind((String)Messages.UpgradeInfoGroup_EndSnInputError, (Object[])new Object[]{this.endSnMin, this.endSnMax}));
            return false;
        }
        BigInteger sn = StringUtil.toBigInteger(this.startSn.getText());
        BigInteger en = StringUtil.toBigInteger(this.endSn.getText());
        if (sn.compareTo(en) >= 0) {
            this.showError(Messages.UpgradeInfoGroup_StartSnAndEndSnInputError);
            return false;
        }
        return true;
    }

    private boolean validateInputV141() {
        if (!HiLoaderView.isETSITS102006V141()) {
            return true;
        }
        this.manufacturerIdMin = "0x000000";
        this.manufacturerIdMax = "0xFFFFFF";
        this.hardwareIdMin = "0x0000";
        this.hardwareIdMax = "0xFFFF";
        this.softwareIdMin = "0x0000";
        this.softwareIdMax = "0xFFFF";
        if (!StringUtil.hexInRange(this.hardwareMode.getText(), this.hardwareIdMin, this.hardwareIdMax)) {
            this.showError(NLS.bind((String)Messages.UpgradeInfoGroup_HardwareMode_Error, (Object[])new Object[]{this.hardwareIdMin, this.hardwareIdMax}));
            return false;
        }
        if (!StringUtil.hexInRange(this.softwareMode.getText(), this.hardwareIdMin, this.hardwareIdMax)) {
            this.showError(NLS.bind((String)Messages.UpgradeInfoGroup_SoftwareMode_Error, (Object[])new Object[]{this.hardwareIdMin, this.hardwareIdMax}));
            return false;
        }
        return true;
    }

    private void showError(String message) {
        MessageDialog.openError((Shell)Display.getDefault().getActiveShell(), (String)Messages.UpgradeInfoGroup_36, (String)message);
    }

    public boolean hasInputText() {
        return this.downloadGroupId.hasInputText(Messages.SsuUpgradeInfoGroup_GroupIdIsEmpty) && this.downloadPid.hasInputText(Messages.UpgradeInfoGroup_2) && this.manufacturerId.hasInputText(Messages.UpgradeInfoGroup_13) && this.hardwareId.hasInputText(Messages.UpgradeInfoGroup_14) && this.softwareId.hasInputText(Messages.UpgradeInfoGroup_15) && this.startSn.hasInputText(Messages.UpgradeInfoGroup_start_sn_isEmpty) && this.endSn.hasInputText(Messages.UpgradeInfoGroup_end_sn_isEmpty);
    }

    public String getDownloadGroupId() {
        return this.downloadGroupId.getText();
    }

    public String getDownloadPid() {
        return this.downloadPid.getText();
    }

    public String getManufacturerId() {
        return this.manufacturerId.getText();
    }

    public String getSoftwareVersion() {
        return this.softwareId.getText();
    }

    public String getHardwareVersion() {
        return this.hardwareId.getText();
    }

    public String getStartSn() {
        return this.startSn.getText();
    }

    public String getEndSn() {
        return this.endSn.getText();
    }

    public String getHardwareMode() {
        return this.hardwareMode.getText();
    }

    public String getSoftwareMode() {
        return this.softwareMode.getText();
    }

    public UpgradeInfo.UpgradeMode getUpgradeMode() {
        if (UpgradeInfo.UpgradeMode.ENHANCE.ordinal() == this.upgradeMode.getCombo().getSelectionIndex()) {
            return UpgradeInfo.UpgradeMode.ENHANCE;
        }
        return UpgradeInfo.UpgradeMode.SIMPLE;
    }
}

