/*
 * Decompiled with CFR 0.152.
 */
package com.hisilicon.hiloader.ui.ssu;

import com.hisilicon.hiloader.Messages;
import com.hisilicon.hiloader.util.ssu.SsuPackageOptions;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class SsuPackageOptionsInfoGroup {
    private Button insertLinkedDescriptorBtn;
    private Button insertEmptyPacketBtn;
    private Label transferModeLabel;
    private Combo transferModeCombo;
    private Label upgradetypeLabel;
    private Combo upgradetypeCombo;
    private Label symbolRateLabel;
    private Text symbolRateText;
    private Label validSymbolRateLabel;
    private Text validSymbolRateText;
    private Label mbpsLabel;
    private Label mbpsLabel1;
    private Label centreFrequencyLabel;
    private Text centreFrequencyText;
    private Label centerFrequencyValid;
    private Label bandwidthLabel;
    private Combo bandwidthCombo;
    private Label constellationLabel;
    private Combo constellationCombo;
    private Label cableModulationLabel;
    private Combo cableModulationCombo;
    private Label cableFrequencyLabel;
    private Text cableFrequencyText;
    private Label cableFrequencyGHz;
    private SsuPackageOptions input;

    public SsuPackageOptionsInfoGroup(Composite parent) {
        this.createControls(parent);
    }

    private void setSelectButton(final Button btn, Composite group) {
        btn.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                if (btn.getData("number") == null) {
                    return;
                }
                int number = (Integer)btn.getData("number");
                if (btn.getSelection()) {
                    if (number == 0) {
                        SsuPackageOptionsInfoGroup.this.setEnabledInsertLinked(true);
                    } else if (1 == number) {
                        SsuPackageOptionsInfoGroup.this.setEnabledInsertEmpty(true);
                    }
                } else if (number == 0) {
                    SsuPackageOptionsInfoGroup.this.setEnabledInsertLinked(false);
                } else if (1 == number) {
                    SsuPackageOptionsInfoGroup.this.setEnabledInsertEmpty(false);
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
    }

    private void setSelectText(Text text, int number) {
        text.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
    }

    private void createControls(Composite group) {
        group.setLayout((Layout)new GridLayout(1, false));
        Composite com = new Composite(group, 0);
        com.setLayout((Layout)new GridLayout(3, false));
        GridData gridData = new GridData(4, 1, true, false);
        com.setLayoutData((Object)gridData);
        SsuPackageOptionsInfoGroup.fillGridFill((Control)group);
        GridLayout gridLayout = null;
        this.insertLinkedDescriptorBtn = new Button(com, 32);
        this.insertLinkedDescriptorBtn.setText(Messages.InsertLinkedDescriptor);
        this.insertLinkedDescriptorBtn.setData("number", (Object)0);
        this.setSelectButton(this.insertLinkedDescriptorBtn, group);
        this.insertEmptyPacketBtn = new Button(com, 32);
        this.insertEmptyPacketBtn.setText(Messages.InsertEmptyPacket);
        this.insertEmptyPacketBtn.setData("number", (Object)1);
        this.setSelectButton(this.insertEmptyPacketBtn, group);
        Composite comLayout = new Composite(group, 0);
        gridLayout = new GridLayout(10, false);
        gridLayout.horizontalSpacing = 12;
        gridLayout.marginTop = 0;
        gridLayout.marginHeight = 0;
        gridLayout.marginWidth = 0;
        comLayout.setLayout((Layout)gridLayout);
        this.upgradetypeLabel = new Label(comLayout, 0);
        this.upgradetypeLabel.setText(String.valueOf(Messages.UpgradeType) + ":");
        SsuPackageOptionsInfoGroup.fillHorizontal((Control)this.upgradetypeLabel);
        this.upgradetypeCombo = new Combo(comLayout, 8);
        this.upgradetypeCombo.setItems(new String[]{Messages.Undefined, Messages.Forcibleupgrade, Messages.Nonforcibleupgrade});
        this.upgradetypeCombo.select(1);
        SsuPackageOptionsInfoGroup.fillHorizontal((Control)this.upgradetypeCombo);
        this.transferModeLabel = new Label(comLayout, 0);
        this.transferModeLabel.setText(String.valueOf(Messages.TransferMode) + ":");
        SsuPackageOptionsInfoGroup.fillHorizontal((Control)this.transferModeLabel);
        this.transferModeCombo = new Combo(comLayout, 8);
        this.transferModeCombo.setItems(new String[]{Messages.Cable, Messages.Terrestrial});
        this.transferModeCombo.select(0);
        SsuPackageOptionsInfoGroup.fillHorizontal((Control)this.transferModeCombo);
        this.transferModeCombo.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                if (SsuPackageOptionsInfoGroup.this.transferModeCombo.getSelectionIndex() == 0) {
                    SsuPackageOptionsInfoGroup.this.setTransferModeSelect(SsuPackageOptionsInfoGroup.this.transferModeCombo.getSelectionIndex(), true);
                } else if (SsuPackageOptionsInfoGroup.this.transferModeCombo.getSelectionIndex() == 1) {
                    SsuPackageOptionsInfoGroup.this.setTransferModeSelect(SsuPackageOptionsInfoGroup.this.transferModeCombo.getSelectionIndex(), true);
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        int integerBits = 3;
        int fractionalBits = 4;
        this.symbolRateLabel = new Label(comLayout, 16384);
        this.symbolRateLabel.setText(String.valueOf(Messages.SymbolRate) + ":");
        SsuPackageOptionsInfoGroup.fillHorizontal((Control)this.symbolRateLabel, 210);
        this.symbolRateText = new Text(comLayout, 16779268);
        this.symbolRateText.setText("6875");
        this.symbolRateText.setTextLimit(5);
        this.setVerifyIntText(this.symbolRateText, Messages.SymbolRate, 1000, 99999L, integerBits, fractionalBits);
        SsuPackageOptionsInfoGroup.fillHorizontal((Control)this.symbolRateText, 50);
        this.setSelectText(this.symbolRateText, 0);
        this.mbpsLabel = new Label(comLayout, 0x1000000);
        this.mbpsLabel.setText("KS/s");
        SsuPackageOptionsInfoGroup.fillHorizontal((Control)this.mbpsLabel, 50);
        this.validSymbolRateLabel = new Label(comLayout, 16384);
        this.validSymbolRateLabel.setText(String.valueOf(Messages.ValidSymbolRate) + ":");
        SsuPackageOptionsInfoGroup.fillHorizontal((Control)this.validSymbolRateLabel, 180);
        this.validSymbolRateText = new Text(comLayout, 16779268);
        this.validSymbolRateText.setText("1000");
        this.validSymbolRateText.setTextLimit(5);
        SsuPackageOptionsInfoGroup.fillHorizontal((Control)this.validSymbolRateText, 50);
        this.setVerifyIntText(this.validSymbolRateText, Messages.ValidSymbolRate, 1000, 99999L, integerBits, fractionalBits);
        this.setSelectText(this.validSymbolRateText, 1);
        this.mbpsLabel1 = new Label(comLayout, 0x1000000);
        this.mbpsLabel1.setText("KS/s");
        SsuPackageOptionsInfoGroup.fillHorizontal((Control)this.mbpsLabel1, 50);
        this.createCableControls(group);
        this.createTerrestrialControls(group);
        this.setEnabledAll(false);
    }

    private void createCableControls(Composite group) {
        Composite comLayout = new Composite(group, 0);
        SsuPackageOptionsInfoGroup.fillGridFill((Control)group);
        GridLayout gridLayout = new GridLayout(10, false);
        gridLayout.horizontalSpacing = 12;
        gridLayout.marginTop = 0;
        gridLayout.marginHeight = 0;
        gridLayout.marginWidth = 0;
        comLayout.setLayout((Layout)gridLayout);
        this.cableModulationLabel = new Label(comLayout, 0);
        this.cableModulationLabel.setText(String.valueOf(Messages.CableModulation) + ":");
        SsuPackageOptionsInfoGroup.fillHorizontal((Control)this.cableModulationLabel);
        this.cableModulationCombo = new Combo(comLayout, 8);
        this.cableModulationCombo.setItems(new String[]{Messages.CableModulation00, Messages.CableModulation01, Messages.CableModulation02, Messages.CableModulation03, Messages.CableModulation04, Messages.CableModulation05});
        this.cableModulationCombo.select(3);
        SsuPackageOptionsInfoGroup.fillHorizontal((Control)this.cableModulationCombo);
        this.cableFrequencyLabel = new Label(comLayout, 0);
        this.cableFrequencyLabel.setText(String.valueOf(Messages.CableFrequency) + ":");
        SsuPackageOptionsInfoGroup.fillHorizontal((Control)this.cableFrequencyLabel);
        this.cableFrequencyText = new Text(comLayout, 16779268);
        this.cableFrequencyText.setText("618");
        int min = 1;
        long max = 9999L;
        int integerBits = 4;
        int fractionalBits = 4;
        this.setVerifyIntText(this.cableFrequencyText, "Frequency", min, max, integerBits, fractionalBits);
        this.cableFrequencyText.setTextLimit(9);
        SsuPackageOptionsInfoGroup.fillHorizontal((Control)this.cableFrequencyText);
        this.cableFrequencyGHz = new Label(comLayout, 0);
        this.cableFrequencyGHz.setText("MHz");
        SsuPackageOptionsInfoGroup.fillHorizontal((Control)this.cableFrequencyGHz);
    }

    public static GridData fillHorizontal(Control control, int widthHint) {
        GridData layoutData = new GridData(768);
        layoutData.widthHint = widthHint;
        control.setLayoutData((Object)layoutData);
        return layoutData;
    }

    public static GridData fillHorizontal(Control control) {
        GridData layoutData = new GridData(768);
        layoutData.widthHint = 110;
        control.setLayoutData((Object)layoutData);
        return layoutData;
    }

    private void createTerrestrialControls(Composite group) {
        Composite comLayout = new Composite(group, 0);
        SsuPackageOptionsInfoGroup.fillGridFill((Control)group);
        GridLayout gridLayout = new GridLayout(10, false);
        gridLayout.horizontalSpacing = 12;
        gridLayout.marginTop = 0;
        gridLayout.marginHeight = 0;
        gridLayout.marginWidth = 0;
        comLayout.setLayout((Layout)gridLayout);
        this.bandwidthLabel = new Label(comLayout, 0);
        this.bandwidthLabel.setText(String.valueOf(Messages.TerrestrialBandwidth) + ":");
        SsuPackageOptionsInfoGroup.fillHorizontal((Control)this.bandwidthLabel);
        this.bandwidthCombo = new Combo(comLayout, 8);
        this.bandwidthCombo.setItems(new String[]{Messages.TerrestrialBandwidthValue000, Messages.TerrestrialBandwidthValue001, Messages.TerrestrialBandwidthValue010});
        this.bandwidthCombo.select(1);
        SsuPackageOptionsInfoGroup.fillHorizontal((Control)this.bandwidthCombo);
        this.centreFrequencyLabel = new Label(comLayout, 0);
        this.centreFrequencyLabel.setText(String.valueOf(Messages.TerrestrialCentreFrequency) + ":");
        SsuPackageOptionsInfoGroup.fillHorizontal((Control)this.centreFrequencyLabel);
        this.centreFrequencyText = new Text(comLayout, 16779268);
        this.centreFrequencyText.setText("177500000");
        this.centreFrequencyText.setTextLimit(11);
        SsuPackageOptionsInfoGroup.fillHorizontal((Control)this.centreFrequencyText);
        this.setVerifyLongText(this.centreFrequencyText, Messages.TerrestrialCentreFrequency, 10, 0x9FFFFFFF6L);
        this.centerFrequencyValid = new Label(comLayout, 0);
        this.centerFrequencyValid.setText("(10 ~ 42,949,672,950Hz)");
        SsuPackageOptionsInfoGroup.fillHorizontal((Control)this.centerFrequencyValid, 200);
        this.constellationLabel = new Label(comLayout, 0);
        this.constellationLabel.setText(String.valueOf(Messages.TerrestrialConstellation) + ":");
        SsuPackageOptionsInfoGroup.fillHorizontal((Control)this.constellationLabel);
        this.constellationCombo = new Combo(comLayout, 8);
        this.constellationCombo.setItems(new String[]{Messages.TerrestrialConstellation000, Messages.TerrestrialConstellation001, Messages.TerrestrialConstellation010});
        this.constellationCombo.select(2);
        SsuPackageOptionsInfoGroup.fillHorizontal((Control)this.constellationCombo);
    }

    private void setEnabledInsertLinked(boolean bool) {
        if (this.insertEmptyPacketBtn.getSelection()) {
            this.transferModeLabel.setVisible(bool);
            this.transferModeCombo.setVisible(bool);
            this.upgradetypeLabel.setVisible(bool);
            this.upgradetypeCombo.setVisible(bool);
        } else {
            this.transferModeLabel.setVisible(bool);
            this.transferModeCombo.setVisible(bool);
            this.upgradetypeLabel.setVisible(bool);
            this.upgradetypeCombo.setVisible(bool);
            this.symbolRateLabel.setVisible(bool);
            this.symbolRateText.setVisible(bool);
            this.mbpsLabel.setVisible(bool);
        }
        if (this.transferModeCombo.getSelectionIndex() == 0) {
            this.cableModulationLabel.setVisible(bool);
            this.cableModulationCombo.setVisible(bool);
            this.cableFrequencyLabel.setVisible(bool);
            this.cableFrequencyText.setVisible(bool);
            this.cableFrequencyGHz.setVisible(bool);
        } else if (this.transferModeCombo.getSelectionIndex() == 1) {
            this.centreFrequencyLabel.setVisible(bool);
            this.centreFrequencyText.setVisible(bool);
            this.centerFrequencyValid.setVisible(bool);
            this.bandwidthLabel.setVisible(bool);
            this.bandwidthCombo.setVisible(bool);
            this.constellationLabel.setVisible(bool);
            this.constellationCombo.setVisible(bool);
        }
    }

    private void setTransferModeSelect(int index, boolean select) {
        if (index == 0) {
            this.cableModulationLabel.setVisible(select);
            this.cableModulationCombo.setVisible(select);
            this.cableFrequencyLabel.setVisible(select);
            this.cableFrequencyText.setVisible(select);
            this.cableFrequencyGHz.setVisible(select);
            this.centreFrequencyLabel.setVisible(false);
            this.centreFrequencyText.setVisible(false);
            this.centerFrequencyValid.setVisible(false);
            this.bandwidthLabel.setVisible(false);
            this.bandwidthCombo.setVisible(false);
            this.constellationLabel.setVisible(false);
            this.constellationCombo.setVisible(false);
        } else if (index == 1) {
            this.centreFrequencyLabel.setVisible(select);
            this.centreFrequencyText.setVisible(select);
            this.centerFrequencyValid.setVisible(select);
            this.bandwidthLabel.setVisible(select);
            this.bandwidthCombo.setVisible(select);
            this.constellationLabel.setVisible(select);
            this.constellationCombo.setVisible(select);
            this.cableModulationLabel.setVisible(false);
            this.cableModulationCombo.setVisible(false);
            this.cableFrequencyLabel.setVisible(false);
            this.cableFrequencyText.setVisible(false);
            this.cableFrequencyGHz.setVisible(false);
        }
    }

    private void setEnabledInsertEmpty(boolean bool) {
        if (this.insertLinkedDescriptorBtn.getSelection()) {
            this.validSymbolRateLabel.setVisible(bool);
            this.validSymbolRateText.setVisible(bool);
            this.mbpsLabel1.setVisible(bool);
        } else {
            this.symbolRateLabel.setVisible(bool);
            this.symbolRateText.setVisible(bool);
            this.mbpsLabel.setVisible(bool);
            this.validSymbolRateLabel.setVisible(bool);
            this.validSymbolRateText.setVisible(bool);
            this.mbpsLabel1.setVisible(bool);
        }
    }

    private void setEnabledAll(boolean bool) {
        this.transferModeLabel.setVisible(bool);
        this.transferModeCombo.setVisible(bool);
        this.upgradetypeLabel.setVisible(bool);
        this.upgradetypeCombo.setVisible(bool);
        this.symbolRateLabel.setVisible(bool);
        this.symbolRateText.setVisible(bool);
        this.validSymbolRateLabel.setVisible(bool);
        this.validSymbolRateText.setVisible(bool);
        this.mbpsLabel.setVisible(bool);
        this.mbpsLabel1.setVisible(bool);
        this.cableModulationLabel.setVisible(bool);
        this.cableModulationCombo.setVisible(bool);
        this.cableFrequencyLabel.setVisible(bool);
        this.cableFrequencyText.setVisible(bool);
        this.cableFrequencyGHz.setVisible(bool);
        this.centreFrequencyLabel.setVisible(bool);
        this.centreFrequencyText.setVisible(bool);
        this.centerFrequencyValid.setVisible(bool);
        this.bandwidthLabel.setVisible(bool);
        this.bandwidthCombo.setVisible(bool);
        this.constellationLabel.setVisible(bool);
        this.constellationCombo.setVisible(bool);
    }

    public SsuPackageOptions getInput() {
        if (this.input == null) {
            this.input = new SsuPackageOptions();
        }
        this.input.setInsertLinkedDescriptorBtn(this.getInsertLinkedDescriptorBtn());
        this.input.setInsertEmptyPacket(this.getInsertEmptyPacket());
        this.input.setTransferModeCombo(this.getTransferModeCombo());
        this.input.setSymbolRate(this.getSymbolRateText());
        this.input.setValidSymbolRate(this.getValidSymbolRateText());
        this.input.setUpgradeTypeCombo(this.getUpgradetypeCombo());
        if (this.getTransferModeCombo() == 0) {
            this.input.setCableModulation(this.getCableModulationCombo());
            this.input.setCableFrequency(this.getCableFrequencyText());
        } else if (this.getTransferModeCombo() == 1) {
            Long frequency = this.getCentreFrequencyText();
            if (frequency == null) {
                return null;
            }
            this.input.setCentreFrequency(frequency);
            this.input.setConstellation(this.getConstellationCombo());
            this.input.setBandWidth(this.getBandwidthCombo());
        }
        return this.input;
    }

    public boolean getInsertLinkedDescriptorBtn() {
        return this.insertLinkedDescriptorBtn.getSelection();
    }

    public boolean getInsertEmptyPacket() {
        return this.insertEmptyPacketBtn.getSelection();
    }

    public int getUpgradetypeCombo() {
        return this.upgradetypeCombo.getSelectionIndex();
    }

    public int getTransferModeCombo() {
        return this.transferModeCombo.getSelectionIndex();
    }

    private Long getCentreFrequencyText() {
        try {
            return Long.valueOf(this.centreFrequencyText.getText()) / 10L;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public int getBandwidthCombo() {
        return this.bandwidthCombo.getSelectionIndex();
    }

    public int getConstellationCombo() {
        return this.constellationCombo.getSelectionIndex();
    }

    public int getSymbolRateText() {
        try {
            return Integer.parseInt(this.symbolRateText.getText());
        }
        catch (Exception e) {
            e.printStackTrace();
            return 0;
        }
    }

    public int getValidSymbolRateText() {
        try {
            return Integer.parseInt(this.validSymbolRateText.getText());
        }
        catch (Exception e) {
            e.printStackTrace();
            return 0;
        }
    }

    private void setVerifyIntText(final Text fileSize, final String title, final int min, final long max, int integerBits, final int fractionalBits) {
        if (title == null) {
            return;
        }
        fileSize.addFocusListener(new FocusListener(){

            public void focusGained(FocusEvent e) {
            }

            public void focusLost(FocusEvent e) {
                String verifyText = fileSize.getText();
                double size = 0.0;
                try {
                    if (verifyText.length() == 0) {
                        MessageDialog.openWarning((Shell)Display.getDefault().getActiveShell(), (String)Messages.Warning, (String)NLS.bind((String)Messages.FileSize_Null, (Object)title));
                        fileSize.setFocus();
                        return;
                    }
                    if (verifyText.length() > 0) {
                        String[] result;
                        if (verifyText.startsWith(".")) {
                            MessageDialog.openWarning((Shell)Display.getDefault().getActiveShell(), (String)Messages.Warning, (String)Messages.FileSize_Value);
                            fileSize.setFocus();
                            return;
                        }
                        size = Double.parseDouble(verifyText);
                        if (size < (double)min) {
                            MessageDialog.openWarning((Shell)Display.getDefault().getActiveShell(), (String)Messages.Warning, (String)NLS.bind((String)Messages.FileSize_Minimum, (Object)min));
                            fileSize.setFocus();
                            return;
                        }
                        if (size > (double)max) {
                            MessageDialog.openWarning((Shell)Display.getDefault().getActiveShell(), (String)Messages.Warning, (String)NLS.bind((String)Messages.FileSize_Maximum, (Object)max));
                            fileSize.setFocus();
                            return;
                        }
                        if (verifyText.indexOf(".") > 0 && (result = verifyText.split("\\."))[1].length() > fractionalBits) {
                            MessageDialog.openWarning((Shell)Display.getDefault().getActiveShell(), (String)Messages.Warning, (String)Messages.CableModuValue);
                            fileSize.setFocus();
                            return;
                        }
                        if (title.equals(Messages.TerrestrialCentreFrequency) && size % 10.0 != 0.0) {
                            MessageDialog.openWarning((Shell)Display.getDefault().getActiveShell(), (String)Messages.Warning, (String)Messages.FileSizeMultiples);
                            fileSize.setFocus();
                            return;
                        }
                    }
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                    MessageDialog.openWarning((Shell)Display.getDefault().getActiveShell(), (String)Messages.Warning, (String)Messages.FileSize_Value);
                    fileSize.setFocus();
                    return;
                }
            }
        });
    }

    private void setVerifyLongText(final Text fileSize, final String title, final int min, final long max) {
        if (title == null) {
            return;
        }
        fileSize.addFocusListener(new FocusListener(){

            public void focusGained(FocusEvent e) {
            }

            public void focusLost(FocusEvent e) {
                String verifyText = fileSize.getText();
                long size = 0L;
                try {
                    if (verifyText.length() == 0) {
                        MessageDialog.openWarning((Shell)Display.getDefault().getActiveShell(), (String)Messages.Warning, (String)NLS.bind((String)Messages.FileSize_Null, (Object)title));
                        fileSize.setFocus();
                        return;
                    }
                    if (verifyText.length() > 0) {
                        size = Long.parseLong(verifyText);
                        if (size < (long)min) {
                            MessageDialog.openWarning((Shell)Display.getDefault().getActiveShell(), (String)Messages.Warning, (String)NLS.bind((String)Messages.FileSize_Minimum, (Object)min));
                            fileSize.setFocus();
                            return;
                        }
                        if (size > max) {
                            MessageDialog.openWarning((Shell)Display.getDefault().getActiveShell(), (String)Messages.Warning, (String)NLS.bind((String)Messages.FileSize_Maximum, (Object)max));
                            fileSize.setFocus();
                            return;
                        }
                        if (title.equals(Messages.TerrestrialCentreFrequency) && size % 10L != 0L) {
                            MessageDialog.openWarning((Shell)Display.getDefault().getActiveShell(), (String)Messages.Warning, (String)Messages.FileSizeMultiples);
                            fileSize.setFocus();
                            return;
                        }
                    }
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                    MessageDialog.openWarning((Shell)Display.getDefault().getActiveShell(), (String)Messages.Warning, (String)Messages.FileSize_Value);
                    fileSize.setFocus();
                    return;
                }
            }
        });
    }

    public int getCableModulationCombo() {
        return this.cableModulationCombo.getSelectionIndex();
    }

    public double getCableFrequencyText() {
        try {
            return Double.parseDouble(this.cableFrequencyText.getText());
        }
        catch (Exception e) {
            e.printStackTrace();
            return 0.0;
        }
    }

    public static GridData fillGridFill(Control control) {
        GridData layoutData = new GridData(4, 1, true, false);
        control.setLayoutData((Object)layoutData);
        return layoutData;
    }
}

