/*
 * Decompiled with CFR 0.152.
 */
package com.hisilicon.hiloader.ui.ssu;

import com.hisilicon.hiloader.Messages;
import com.hisilicon.hiloader.controler.GlobleControler;
import com.hisilicon.hiloader.model.PartitionItem;
import com.hisilicon.hiloader.struct.UpgradeFileInfo;
import com.hisilicon.hiloader.struct.ssu.SsuUpgradeInfo;
import com.hisilicon.hiloader.ui.AbstractComposite;
import com.hisilicon.hiloader.ui.ControlFactory;
import com.hisilicon.hiloader.ui.FileField;
import com.hisilicon.hiloader.ui.ssu.SsuPackageOptionsInfoGroup;
import com.hisilicon.hiloader.ui.ssu.SsuUpgradeInfoGroup;
import com.hisilicon.hiloader.util.FileHelper;
import com.hisilicon.hiloader.util.FileUtil;
import com.hisilicon.hiloader.util.InvalidDataFormatException;
import com.hisilicon.hiloader.util.StringUtil;
import com.hisilicon.hiloader.util.ssu.SsuIniFileParser;
import com.hisilicon.hiloader.util.ssu.SsuPackageOptions;
import com.hisilicon.hiloader.util.ssu.SsuTsPackageBuilder;
import java.awt.Toolkit;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.dom4j.DocumentException;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Shell;
import org.ini4j.Ini;
import org.ini4j.InvalidFileFormatException;
import org.ini4j.Profile;

public class SsuHiLoaderComposite
extends AbstractComposite {
    private static final String[] CHIPS = new String[]{"chip 0"};
    private static final String[] INI_FILTER_NAMES = new String[]{"xml Files(*.xml)", "ini Files (*.ini)"};
    private static final String[] INI_FILTER_EXTS = new String[]{"*.xml", "*.ini"};
    private SsuUpgradeInfoGroup upgradeInfo;
    private SsuPackageOptionsInfoGroup packageOptionsInfo;
    private FileField ssuTsFileField;
    private Button ssuTsButton;

    public SsuHiLoaderComposite(Composite parent, int style) {
        super(parent, style);
    }

    private void createTsGroup(Composite parent, String path) {
        String title = Messages.HiLoaderComposite_49;
        Composite group = this.createGroup(parent, title, 4);
        this.ssuTsFileField = new FileField(group, Messages.HiLoaderComposite_50, 80, Messages.HiLoaderComposite_51, 80, 0x10002000, "ssuTsFileField");
        if (path == null) {
            this.ssuTsFileField.setDefaultFileName(GlobleControler.intance.SSU_TS);
        } else {
            this.ssuTsFileField.setDefaultFileName(path);
        }
        this.ssuTsFileField.setFileExtensions(new String[]{"*.ts", "*.*"});
        this.ssuTsButton = ControlFactory.createPushButton(group, Messages.HiLoaderComposite_53);
        this.ssuTsButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                if (!SsuHiLoaderComposite.this.validateInput()) {
                    return;
                }
                String file = SsuHiLoaderComposite.this.ssuTsFileField.getFilePath();
                if (!FileUtil.isContinue(file)) {
                    return;
                }
                SsuUpgradeInfo info = SsuHiLoaderComposite.this.upgradeInfo.getInput();
                SsuPackageOptions packageOtions = SsuHiLoaderComposite.this.packageOptionsInfo.getInput();
                ArrayList<UpgradeFileInfo> selUpdateFiles = new ArrayList<UpgradeFileInfo>();
                int i = 0;
                while (i < SsuHiLoaderComposite.this.updateFiles.size()) {
                    UpgradeFileInfo fileInfo = (UpgradeFileInfo)SsuHiLoaderComposite.this.updateFiles.get(i);
                    if (fileInfo.isSel()) {
                        selUpdateFiles.add(fileInfo);
                    }
                    ++i;
                }
                if (selUpdateFiles.size() > 0) {
                    GlobleControler.runner.createRunnerJob("Packaged Ts (SSU)", selUpdateFiles, info, packageOtions, file, new SsuTsPackageBuilder());
                } else {
                    SsuHiLoaderComposite.this.showError(Messages.SELECTFILE);
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
    }

    protected Composite createGroup(Composite parent, String title, int num) {
        return ControlFactory.createGroup(parent, title, num);
    }

    protected void createPackageOptions(Composite container) {
        Composite group = this.createGroup(container, Messages.PackageOptions, 8);
        this.packageOptionsInfo = new SsuPackageOptionsInfoGroup(group);
    }

    protected void createUpgradeInfoGroup(Composite container) {
        Composite group = this.createGroup(container, Messages.UpgradeInfoGroup_0, 8);
        this.upgradeInfo = new SsuUpgradeInfoGroup(group);
    }

    @Override
    protected void saveIni(String path) {
        if (!this.validateInput()) {
            return;
        }
        FileDialog dlg = new FileDialog(this.getShell(), 8196);
        dlg.setFilterNames(INI_FILTER_NAMES);
        dlg.setFilterExtensions(INI_FILTER_EXTS);
        dlg.setFileName(path);
        dlg.setOverwrite(true);
        String filename = dlg.open();
        if (filename != null && !filename.isEmpty()) {
            if (filename.toUpperCase().indexOf("INI") > 0) {
                String file = this.ssuTsFileField.getFilePath();
                try {
                    Ini ini = new Ini();
                    ini.add("packer_tsfilename").put((Object)"ts_file_name", (Object)StringUtil.addQuote(file));
                    Profile.Section attrSec = ini.add("packer_attr");
                    attrSec.put((Object)"Download_GroupId", (Object)StringUtil.convertString(this.upgradeInfo.getDownloadGroupId(), 2));
                    attrSec.put((Object)"Download_PID", (Object)StringUtil.convertString(this.upgradeInfo.getDownloadPid(), 2));
                    attrSec.put((Object)"STB_manufacturerID", (Object)StringUtil.convertString(this.upgradeInfo.getManufacturerId(), 4));
                    attrSec.put((Object)"hardware_version", (Object)StringUtil.convertString(this.upgradeInfo.getHardwareVersion(), 8));
                    attrSec.put((Object)"software_version", (Object)StringUtil.convertString(this.upgradeInfo.getSoftwareVersion(), 8));
                    attrSec.put((Object)"start_sn", (Object)StringUtil.convertString(this.upgradeInfo.getStartSn(), 8));
                    attrSec.put((Object)"end_sn", (Object)StringUtil.convertString(this.upgradeInfo.getEndSn(), 8));
                    Profile.Section fileSec = ini.add("packer_file");
                    fileSec.put("bin_file_num", (Object)this.updateFiles.size());
                    int i = 1;
                    while (i <= this.updateFiles.size()) {
                        UpgradeFileInfo f = (UpgradeFileInfo)this.updateFiles.get(i - 1);
                        String sel = null;
                        sel = f.isSel() ? "1" : "0";
                        fileSec.put((Object)("flash_sel" + i), (Object)sel);
                        fileSec.put((Object)("flash_PartitionName" + i), (Object)f.getPartitionName());
                        fileSec.put("flash_PartitionVersion" + i, (Object)f.getPartitionVersion());
                        fileSec.put("flash_PartitionVersionTag" + i, (Object)f.getPartitionVerifyTag());
                        fileSec.put((Object)("bin_name" + i), (Object)StringUtil.addQuote(f.getFileName()));
                        fileSec.put((Object)("flash_addr" + i), (Object)StringUtil.toHexString(f.getStartAddress(), 8));
                        fileSec.put("flash_type" + i, (Object)f.getFlashType().ordinal());
                        fileSec.put((Object)("flash_system" + i), (Object)f.getFileSystem().name());
                        fileSec.put("flashindex" + i, (Object)f.getFlashIndex());
                        fileSec.put("file_length" + i, (Object)f.getLength());
                        ++i;
                    }
                    ini.store(new File(filename));
                    this.showMessage(Messages.HiLoaderComposite_85);
                }
                catch (IOException e) {
                    this.showError(Messages.HiLoaderComposite_12);
                }
            } else if (filename.toUpperCase().indexOf("XML") > 0) {
                try {
                    File out = new File(filename);
                    ArrayList<PartitionItem> hiburn = new ArrayList<PartitionItem>();
                    int i = 0;
                    while (i < this.updateFiles.size()) {
                        UpgradeFileInfo f = (UpgradeFileInfo)this.updateFiles.get(i);
                        f.validateFileName();
                        PartitionItem item = new PartitionItem();
                        item.setChecked(f.isSel());
                        item.setPartitionVersione(f.getPartitionVersion());
                        item.setPartitionVersionTag(f.getPartitionVerifyTag());
                        item.setFile(new File(f.getFileName()));
                        item.setFileSystem(f.getFileSystem());
                        item.setFlashType(f.getFlashType());
                        item.setLength(f.getLength());
                        item.setName(f.getPartitionName());
                        item.setStart(f.getStartAddress());
                        hiburn.add(item);
                        ++i;
                    }
                    PartitionItem.save(out, hiburn);
                    this.showMessage(Messages.HiLoaderComposite_85);
                }
                catch (Exception e) {
                    this.showError(Messages.HiLoaderComposite_12);
                }
            }
        }
    }

    @Override
    protected String loadIni() {
        FileDialog dlg = new FileDialog(this.getShell(), 4100);
        dlg.setFilterNames(INI_FILTER_NAMES);
        dlg.setFilterExtensions(INI_FILTER_EXTS);
        String fileName = dlg.open();
        if (fileName != null && !fileName.isEmpty()) {
            if (fileName.toUpperCase().endsWith("INI")) {
                try {
                    SsuIniFileParser parser = new SsuIniFileParser(fileName);
                    this.upgradeInfo.setInput(parser, parser.getUpgradeInfo());
                    this.ssuTsFileField.setDefaultFileName(GlobleControler.intance.SSU_TS);
                    this.updateFiles = parser.getUpgradFiles();
                    this.getViewer().refresh();
                }
                catch (InvalidDataFormatException e) {
                    this.showError(e.getMessage());
                }
                catch (Exception e) {
                    this.showError(Messages.HiLoaderComposite_86);
                }
                return fileName;
            }
            if (fileName.toUpperCase().endsWith("XML")) {
                List<PartitionItem> load = null;
                try {
                    load = PartitionItem.load(new File(fileName), true);
                }
                catch (DocumentException e) {
                    this.showError(Messages.XMLINVALID);
                }
                if (load == null) {
                    return "";
                }
                if (load.isEmpty()) {
                    try {
                        throw new DocumentException();
                    }
                    catch (DocumentException e) {
                        e.printStackTrace();
                    }
                }
                try {
                    SsuIniFileParser parser = new SsuIniFileParser(load);
                    this.ssuTsFileField.setDefaultFileName(GlobleControler.intance.HISI_TS);
                    this.upgradeInfo.setInput(parser, parser.getUpgradeInfo());
                    this.updateFiles = parser.getUpgradFiles();
                }
                catch (InvalidFileFormatException e) {
                    e.printStackTrace();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                catch (InvalidDataFormatException e) {
                    e.printStackTrace();
                }
                return fileName;
            }
            return "";
        }
        return "";
    }

    private boolean validateInput() {
        if (this.updateFiles.size() == 0) {
            this.showError(Messages.HiLoaderComposite_87);
            return false;
        }
        if (!FileHelper.checkUpgradeFileInfo(this.updateFiles)) {
            return false;
        }
        if (this.updateFiles.size() > 64) {
            String message = String.format(Messages.HiLoaderComposite_88, 64);
            this.showError(message);
            return false;
        }
        for (UpgradeFileInfo file : this.updateFiles) {
            try {
                FileUtil.checkAddressConflict(file, this.updateFiles);
            }
            catch (InvalidDataFormatException e) {
                this.showError(e.getMessage());
                return false;
            }
        }
        if (!this.upgradeInfo.hasInputText()) {
            return false;
        }
        if (!this.upgradeInfo.validateInput()) {
            return false;
        }
        if (!this.ssuTsFileField.hasInputText(Messages.HiLoaderComposite_5)) {
            return false;
        }
        SsuPackageOptions ssu = this.packageOptionsInfo.getInput();
        if (ssu != null && ssu.getInsertEmptyPacket()) {
            double SymbolRate = ssu.getSymbolRate();
            int ValidSymbolRate = ssu.getValidSymbolRate();
            String message = NLS.bind((String)Messages.FileSize_Error, (Object[])new Object[]{Messages.SymbolRate, Messages.ValidSymbolRate});
            if (SymbolRate == (double)ValidSymbolRate || (double)ValidSymbolRate > SymbolRate) {
                MessageDialog.openWarning((Shell)Display.getDefault().getActiveShell(), (String)Messages.Warning, (String)message);
                return false;
            }
        }
        return true;
    }

    @Override
    public void createLoaderContents(Composite comp) {
        int screenHeight = Toolkit.getDefaultToolkit().getScreenSize().height;
        if (screenHeight <= 768) {
            this.createPartFileContentControl(comp, 100);
        } else {
            this.createPartFileContentControl(comp, 300);
        }
        String tsPath = null;
        ArrayList<String> pathList = FileField.loadFilterPath("tempPath.ini");
        for (String str : pathList) {
            if (!str.startsWith("ssuitspath")) continue;
            tsPath = str.split("=")[1];
        }
        this.createUpgradeInfoGroup(comp);
        this.createPackageOptions(comp);
        this.createTsGroup(comp, tsPath);
    }

    @Override
    protected String[] getChipList() {
        return CHIPS;
    }

    @Override
    public void start() {
        if (this.ssuTsButton.isDisposed()) {
            return;
        }
        this.ssuTsButton.setEnabled(false);
    }

    @Override
    public void stop() {
        if (this.ssuTsButton.isDisposed()) {
            return;
        }
        this.ssuTsButton.setEnabled(true);
    }
}

