/*
 * Decompiled with CFR 0.152.
 */
package com.hisilicon.hiloader.ui;

import com.hisilicon.hiloader.ui.ControlFactory;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class LabelTextField {
    private String labelText;
    private Label label;
    Text textField;
    private String tooltip;
    private int labelWidth;
    private String defaultValue;
    private String scopeText;

    public LabelTextField(Composite parent, String labelText, int labelWidth, String tooltip, String defaultValue, String scopeText) {
        this.labelText = labelText;
        this.labelWidth = labelWidth;
        this.tooltip = tooltip;
        this.defaultValue = defaultValue;
        this.scopeText = scopeText;
        this.createControl(parent);
    }

    public boolean isEmpty() {
        String text = this.textField.getText();
        return text == null || text.isEmpty();
    }

    public boolean hasInputText(String errorMessage) {
        if (this.isEmpty()) {
            MessageDialog.openError((Shell)this.textField.getShell(), (String)"Error", (String)errorMessage);
            return false;
        }
        return true;
    }

    public Text getTextControl() {
        return this.textField;
    }

    public String getText() {
        return this.textField.getText();
    }

    private void createControl(Composite parent) {
        this.label = ControlFactory.createLabel(parent, this.labelText);
        GridData gd = new GridData();
        gd.widthHint = this.labelWidth;
        this.label.setLayoutData((Object)gd);
        gd = new GridData();
        gd.horizontalSpan = this.tooltip == null ? 2 : 1;
        this.textField = ControlFactory.createTextField(parent, 2052);
        gd.widthHint = this.labelWidth;
        this.textField.setLayoutData((Object)gd);
        this.textField.setFont(parent.getFont());
        if (this.defaultValue != null) {
            this.textField.setText(this.defaultValue);
        }
        if (this.tooltip != null) {
            this.textField.setToolTipText(this.tooltip);
            gd = new GridData();
            gd.horizontalAlignment = 128;
            this.label.setLayoutData((Object)gd);
        }
        this.label = ControlFactory.createLabel(parent, "(" + this.scopeText + ")");
        gd = (GridData)this.label.getLayoutData();
        gd.grabExcessHorizontalSpace = false;
        gd.widthHint = this.labelWidth;
    }
}

