/*
 * Decompiled with CFR 0.152.
 */
package com.hisilicon.hiloader.ui;

import com.hisilicon.hiloader.Activator;
import com.hisilicon.hiloader.ImageFactory;
import com.hisilicon.hiloader.Messages;
import com.hisilicon.hiloader.controler.GlobleControler;
import com.hisilicon.hiloader.controler.IRunnerStateChangedListener;
import com.hisilicon.hiloader.struct.BurnType;
import com.hisilicon.hiloader.struct.FileSystem;
import com.hisilicon.hiloader.struct.FlashType;
import com.hisilicon.hiloader.struct.UpgradeFileInfo;
import com.hisilicon.hiloader.ui.ControlFactory;
import com.hisilicon.hiloader.ui.DialogUtil;
import com.hisilicon.hiloader.ui.FileCellEditor;
import com.hisilicon.hiloader.util.FileUtil;
import com.hisilicon.hiloader.util.StringUtil;
import java.awt.Toolkit;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.layout.TableColumnLayout;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnPixelData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.ComboBoxCellEditor;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICellEditorListener;
import org.eclipse.jface.viewers.ICellModifier;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.custom.TableEditor;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.PlatformUI;

public abstract class AbstractComposite
extends Composite
implements IRunnerStateChangedListener {
    private static int COL_SEL;
    private static int PARTITIONNAMECOL;
    private static int PARTITIONVERSIONCOL;
    private static int PARTITIONVERIFYTAGCOL;
    private static int COL_ADD;
    private static int FILE_NAME_COL;
    private static int File_Length_COL;
    private static int START_ADDRESS_COL;
    private static int FLASH_INDEX_COL;
    private static int FILE_SYSTEM_COL;
    private static int FLASH_TYPE_COL;
    private CheckboxTableViewer viewer;
    protected List<UpgradeFileInfo> updateFiles;
    private static String[] COLUMN_PROPERTIES;
    private static String[] TABLE_HEADERS;
    private int labelWidth = 0;
    private int minHeight = 768;
    private ComboBoxCellEditor flashTypeEditor;
    private ComboBoxCellEditor fileSystemEditor;
    private Text textField;

    public int getLabelWidth() {
        return this.labelWidth;
    }

    public void setLabelWidth(int labelWidth) {
        this.labelWidth = labelWidth;
    }

    public AbstractComposite(Composite parent, int style) {
        super(parent, style);
        GridLayout layout = new GridLayout();
        layout.verticalSpacing = 15;
        this.setLayout((Layout)layout);
        this.createLoaderContents(this);
    }

    protected abstract void createLoaderContents(Composite var1);

    protected abstract String[] getChipList();

    protected abstract void saveIni(String var1);

    protected abstract String loadIni();

    protected TableViewer getViewer() {
        return this.viewer;
    }

    protected void createPartFileContentControl(Composite parent, int heightHint) {
        Group partGroup = ControlFactory.createGroup(parent, Messages.HiLoaderComposite_43, 4);
        int width = 150;
        Label label = ControlFactory.createLabel((Composite)partGroup, Messages.HiLoaderComposite_ConfigFile);
        GridData gd = new GridData();
        gd.widthHint = 150;
        label.setLayoutData((Object)gd);
        int partGroupWidth = 830;
        this.textField = ControlFactory.createTsTextField((Composite)partGroup, 2052, 830);
        this.textField.setFont(partGroup.getFont());
        Button loadButton = new Button((Composite)partGroup, 8);
        gd = new GridData();
        loadButton.setLayoutData((Object)gd);
        FileUtil.setWidthForOS(gd, 150, 150);
        loadButton.setText(Messages.SelectFileDialog_24);
        loadButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                String filePath = AbstractComposite.this.loadIni();
                AbstractComposite.this.textField.setText(filePath);
                AbstractComposite.this.viewer.refresh();
                AbstractComposite.this.updateSelection();
            }
        });
        Button saveButton = new Button((Composite)partGroup, 8);
        gd = new GridData();
        saveButton.setLayoutData((Object)gd);
        FileUtil.setWidthForOS(gd, 150, 150);
        saveButton.setText(Messages.SelectFileDialog_SaveConfig);
        saveButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                AbstractComposite.this.saveIni(AbstractComposite.this.textField.getText());
            }
        });
        this.createTableViewer((Composite)partGroup, heightHint);
        GlobleControler.intance.addRunnerStateChangedListener(this);
    }

    protected void createTableViewer(final Composite parent, int heightHint) {
        Composite control = new Composite(parent, 2048);
        TableColumnLayout tcl = new TableColumnLayout();
        control.setLayout((Layout)tcl);
        GridData gd = null;
        int screenHeight = Toolkit.getDefaultToolkit().getScreenSize().height;
        if (screenHeight <= this.minHeight) {
            gd = new GridData();
            gd.widthHint = 1300;
        } else {
            gd = new GridData(1808);
        }
        gd.horizontalSpan = 4;
        gd.heightHint = heightHint;
        control.setLayoutData((Object)gd);
        this.viewer = CheckboxTableViewer.newCheckList((Composite)control, (int)66064);
        this.viewer.setContentProvider((IContentProvider)new ViewContentProvider());
        this.viewer.setLabelProvider((IBaseLabelProvider)new ViewLabelProvider());
        final Table table = this.viewer.getTable();
        table.setHeaderVisible(true);
        table.setLinesVisible(true);
        table.addListener(41, new Listener(){

            public void handleEvent(Event event) {
                event.width = table.getGridLineWidth();
                event.height = (int)Math.floor((double)event.gc.getFontMetrics().getHeight() * 1.5);
            }
        });
        int minWeidth = 20;
        TableColumn column = null;
        column = new TableColumn(table, 0x1000000, COL_SEL);
        column.setImage(Activator.getImage("icons/check.bmp"));
        column.setResizable(false);
        column.setMoveable(true);
        column.setAlignment(0x1000000);
        tcl.setColumnData((Widget)column, (ColumnLayoutData)new ColumnPixelData(35, false));
        column.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                if (AbstractComposite.this.updateFiles != null && AbstractComposite.this.updateFiles.size() > 0) {
                    for (UpgradeFileInfo info : AbstractComposite.this.updateFiles) {
                        info.setSel(!this.isAllchecked());
                    }
                    AbstractComposite.this.updateSelection();
                }
            }

            private boolean isAllchecked() {
                Object[] checkedElements = AbstractComposite.this.viewer.getCheckedElements();
                return checkedElements.length == AbstractComposite.this.updateFiles.size();
            }
        });
        this.viewer.addCheckStateListener(new ICheckStateListener(){

            public void checkStateChanged(CheckStateChangedEvent event) {
                UpgradeFileInfo info = (UpgradeFileInfo)event.getElement();
                info.setSel(event.getChecked());
            }
        });
        if (GlobleControler.intance.isHi3798CV200()) {
            PARTITIONNAMECOL = 1;
            PARTITIONVERSIONCOL = 2;
            PARTITIONVERIFYTAGCOL = 3;
            COL_ADD = 10;
            FILE_NAME_COL = 4;
            File_Length_COL = 9;
            START_ADDRESS_COL = 8;
            FLASH_INDEX_COL = 7;
            FILE_SYSTEM_COL = 6;
            FLASH_TYPE_COL = 5;
            COLUMN_PROPERTIES = new String[]{"sel", "name", "version", "verify", "file", "type", "system", "index", "start", "length"};
            TABLE_HEADERS = new String[]{Messages.SEL, Messages.PARTITIONNAMECOL, Messages.PARTITIONVERSIONCOL, Messages.PARTITIONVERIFYTAGCOL, Messages.HiLoaderComposite_4, Messages.HiLoaderComposite_0, Messages.HiLoaderComposite_FileSystem, Messages.HiLoaderComposite_1, Messages.HiLoaderComposite_2, Messages.HiLoaderComposite_3};
            column = new TableColumn(table, 16384, PARTITIONNAMECOL);
            column.setResizable(false);
            column.setMoveable(false);
            column.setText(TABLE_HEADERS[PARTITIONNAMECOL]);
            column.setAlignment(131072);
            tcl.setColumnData((Widget)column, (ColumnLayoutData)new ColumnWeightData(2, 20, false));
            column = new TableColumn(table, 16384, PARTITIONVERSIONCOL);
            column.setResizable(false);
            column.setMoveable(false);
            column.setText(TABLE_HEADERS[PARTITIONVERSIONCOL]);
            column.setAlignment(131072);
            tcl.setColumnData((Widget)column, (ColumnLayoutData)new ColumnWeightData(2, 20, false));
            column = new TableColumn(table, 16384, PARTITIONVERIFYTAGCOL);
            column.setResizable(false);
            column.setMoveable(false);
            column.setText(TABLE_HEADERS[PARTITIONVERIFYTAGCOL]);
            column.setAlignment(131072);
            tcl.setColumnData((Widget)column, (ColumnLayoutData)new ColumnWeightData(2, 20, false));
        } else {
            COL_ADD = 7;
            FILE_NAME_COL = 1;
            File_Length_COL = 6;
            START_ADDRESS_COL = 5;
            FLASH_INDEX_COL = 4;
            FILE_SYSTEM_COL = 3;
            FLASH_TYPE_COL = 2;
            COLUMN_PROPERTIES = new String[]{"sel", "file", "type", "system", "index", "start", "length"};
            TABLE_HEADERS = new String[]{Messages.SEL, Messages.HiLoaderComposite_4, Messages.HiLoaderComposite_0, Messages.HiLoaderComposite_FileSystem, Messages.HiLoaderComposite_1, Messages.HiLoaderComposite_2, Messages.HiLoaderComposite_3};
        }
        column = new TableColumn(table, 16384, FILE_NAME_COL);
        column.setResizable(false);
        column.setMoveable(false);
        column.setText(TABLE_HEADERS[FILE_NAME_COL]);
        column.setAlignment(131072);
        tcl.setColumnData((Widget)column, (ColumnLayoutData)new ColumnWeightData(6, 20, false));
        column = new TableColumn(table, 0x1000000, FLASH_TYPE_COL);
        column.setResizable(false);
        column.setMoveable(false);
        column.setText(TABLE_HEADERS[FLASH_TYPE_COL]);
        column.setAlignment(0x1000000);
        tcl.setColumnData((Widget)column, (ColumnLayoutData)new ColumnWeightData(2, 20, false));
        column = new TableColumn(table, 0x1000000, FILE_SYSTEM_COL);
        column.setResizable(false);
        column.setMoveable(false);
        column.setText(TABLE_HEADERS[FILE_SYSTEM_COL]);
        column.setAlignment(0x1000000);
        tcl.setColumnData((Widget)column, (ColumnLayoutData)new ColumnWeightData(2, 20, false));
        column = new TableColumn(table, 0x1000000, FLASH_INDEX_COL);
        column.setResizable(false);
        column.setMoveable(false);
        column.setText(TABLE_HEADERS[FLASH_INDEX_COL]);
        column.setAlignment(0x1000000);
        tcl.setColumnData((Widget)column, (ColumnLayoutData)new ColumnWeightData(2, 20, false));
        column = new TableColumn(table, 0x1000000, START_ADDRESS_COL);
        column.setResizable(false);
        column.setMoveable(false);
        column.setText(TABLE_HEADERS[START_ADDRESS_COL]);
        column.setAlignment(0x1000000);
        tcl.setColumnData((Widget)column, (ColumnLayoutData)new ColumnWeightData(2, 20, false));
        column = new TableColumn(table, 0x1000000, File_Length_COL);
        column.setResizable(false);
        column.setMoveable(false);
        column.setText(TABLE_HEADERS[File_Length_COL]);
        column.setAlignment(0x1000000);
        tcl.setColumnData((Widget)column, (ColumnLayoutData)new ColumnWeightData(2, 20, false));
        TableColumn addCol = new TableColumn(table, 0x1000000, COL_ADD);
        addCol.setAlignment(0x1000000);
        addCol.setMoveable(false);
        addCol.setResizable(false);
        tcl.setColumnData((Widget)addCol, (ColumnLayoutData)new ColumnPixelData(50, false));
        addCol.setImage(ImageFactory.getImage("/icons/add.jpg"));
        addCol.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                if (AbstractComposite.this.updateFiles.size() == 64) {
                    DialogUtil.displayWarning(String.format(Messages.HiLoaderComposite_88, 64));
                    return;
                }
                AbstractComposite.this.handleAddNewPartition();
                parent.layout();
            }
        });
        final TableEditor dataEditor = new TableEditor(table);
        dataEditor.horizontalAlignment = 0x1000000;
        dataEditor.grabHorizontal = true;
        dataEditor.minimumWidth = 20;
        this.viewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                TableItem[] selection;
                Control oldEditor = dataEditor.getEditor();
                if (oldEditor != null) {
                    oldEditor.dispose();
                }
                if ((selection = AbstractComposite.this.viewer.getTable().getSelection()).length == 0) {
                    return;
                }
                TableItem item = selection[0];
                if (item == null) {
                    return;
                }
                Button newEditor = new Button((Composite)table, 0);
                newEditor.setImage(ImageFactory.getImage("/icons/delrow.ico"));
                newEditor.addSelectionListener(new SelectionListener(){

                    public void widgetSelected(SelectionEvent e) {
                        AbstractComposite.this.removeFile();
                    }

                    public void widgetDefaultSelected(SelectionEvent e) {
                    }
                });
                dataEditor.setEditor((Control)newEditor, item, COL_ADD);
                UpgradeFileInfo info = (UpgradeFileInfo)item.getData();
                if (info == null) {
                    return;
                }
                AbstractComposite.this.fileSystemEditor.setItems(FileSystem.getItems(info.getFlashType()));
                String[] items = AbstractComposite.this.fileSystemEditor.getItems();
                FileSystem fileSystem = info.getFileSystem();
                if (fileSystem == null) {
                    return;
                }
                int index = 0;
                int i = 0;
                while (i < items.length) {
                    if (items[i].equals(fileSystem.name())) {
                        index = i;
                        break;
                    }
                    ++i;
                }
                AbstractComposite.this.fileSystemEditor.setValue((Object)index);
            }
        });
        this.addCellEditors();
        this.updateFiles = new ArrayList<UpgradeFileInfo>();
        this.viewer.setInput(this.updateFiles);
    }

    protected void handleAddNewPartition() {
        UpgradeFileInfo info;
        StructuredSelection selection = (StructuredSelection)this.viewer.getSelection();
        int index = -1;
        FlashType flashType = null;
        int flashIndex = 0;
        if (!selection.isEmpty()) {
            info = (UpgradeFileInfo)selection.getFirstElement();
            flashType = info.getFlashType();
            flashIndex = info.getFlashIndex();
            index = this.updateFiles.indexOf(info);
        } else if (this.updateFiles.size() > 0) {
            info = this.updateFiles.get(this.updateFiles.size() - 1);
            flashType = info.getFlashType();
            flashIndex = info.getFlashIndex();
        }
        if (flashType == null) {
            flashType = FlashType.nand;
        }
        UpgradeFileInfo newItem = new UpgradeFileInfo();
        newItem.setFlashType(flashType);
        newItem.setFileSystem(FileSystem.valueOf(FileSystem.getItems()[0]));
        newItem.setFlashIndex(flashIndex & 0xFFFF);
        if (index != -1 && index <= this.updateFiles.size() - 1) {
            UpgradeFileInfo lastFileInfo = this.updateFiles.get(index);
            long calcAddress = lastFileInfo.getStartAddress() + lastFileInfo.getLength() < 0L ? 0L : lastFileInfo.getStartAddress() + lastFileInfo.getLength();
            newItem.setStartAddress(calcAddress);
            newItem.setEndAddress(calcAddress);
        }
        this.updateFiles.add(++index, newItem);
        this.updateAddressesForAddNew(newItem, index);
        this.viewer.refresh();
        this.viewer.setSelection((ISelection)new StructuredSelection((Object)newItem), true);
    }

    private void updateSelection() {
        TableItem[] items;
        TableItem[] tableItemArray = items = this.viewer.getTable().getItems();
        int n = items.length;
        int n2 = 0;
        while (n2 < n) {
            TableItem tableItem = tableItemArray[n2];
            UpgradeFileInfo info = (UpgradeFileInfo)tableItem.getData();
            tableItem.setChecked(info.isSel());
            ++n2;
        }
    }

    private void addCellEditors() {
        this.flashTypeEditor = new ComboBoxCellEditor((Composite)this.viewer.getTable(), FlashType.getItems(), 8);
        this.flashTypeEditor.addListener(new ICellEditorListener(){

            public void editorValueChanged(boolean oldValidState, boolean newValidState) {
            }

            public void cancelEditor() {
            }

            public void applyEditorValue() {
                if (AbstractComposite.this.flashTypeEditor.getValue() == null) {
                    return;
                }
                int index = (Integer)AbstractComposite.this.flashTypeEditor.getValue();
                String type = AbstractComposite.this.flashTypeEditor.getItems()[index];
                AbstractComposite.this.fileSystemEditor.setItems(FileSystem.getItems(type));
            }
        });
        this.fileSystemEditor = new ComboBoxCellEditor((Composite)this.viewer.getTable(), FileSystem.getItems(this.flashTypeEditor.getItems()[0]), 8);
        ComboBoxCellEditor chipTypeEditor = new ComboBoxCellEditor((Composite)this.viewer.getTable(), this.getChipList(), 8);
        TextCellEditor startAddressEditor = new TextCellEditor((Composite)this.viewer.getTable());
        TextCellEditor fileLengthEditor = new TextCellEditor((Composite)this.viewer.getTable());
        FileCellEditor fileEditor = new FileCellEditor((Composite)this.viewer.getTable());
        TextCellEditor partitionNameEditor = new TextCellEditor((Composite)this.viewer.getTable());
        TextCellEditor partitionVersionEditor = new TextCellEditor((Composite)this.viewer.getTable());
        TextCellEditor partitionverity = new TextCellEditor((Composite)this.viewer.getTable());
        if (GlobleControler.intance.isHi3798CV200()) {
            CellEditor[] cellEditorArray = new CellEditor[11];
            cellEditorArray[1] = partitionNameEditor;
            cellEditorArray[2] = partitionVersionEditor;
            cellEditorArray[3] = partitionverity;
            cellEditorArray[4] = fileEditor;
            cellEditorArray[5] = this.flashTypeEditor;
            cellEditorArray[6] = this.fileSystemEditor;
            cellEditorArray[7] = chipTypeEditor;
            cellEditorArray[8] = startAddressEditor;
            cellEditorArray[9] = fileLengthEditor;
            this.viewer.setCellEditors(cellEditorArray);
        } else {
            CellEditor[] cellEditorArray = new CellEditor[8];
            cellEditorArray[1] = fileEditor;
            cellEditorArray[2] = this.flashTypeEditor;
            cellEditorArray[3] = this.fileSystemEditor;
            cellEditorArray[4] = chipTypeEditor;
            cellEditorArray[5] = startAddressEditor;
            cellEditorArray[6] = fileLengthEditor;
            this.viewer.setCellEditors(cellEditorArray);
        }
        this.viewer.setColumnProperties(COLUMN_PROPERTIES);
        this.viewer.setCellModifier(new ICellModifier(){

            public boolean canModify(Object element, String property) {
                return true;
            }

            public Object getValue(Object element, String property) {
                if (element instanceof UpgradeFileInfo) {
                    UpgradeFileInfo info = (UpgradeFileInfo)element;
                    if (property.equals(COLUMN_PROPERTIES[FLASH_TYPE_COL])) {
                        FlashType flashType = info.getFlashType();
                        String[] items = AbstractComposite.this.flashTypeEditor.getItems();
                        int i = 0;
                        while (i < items.length) {
                            if (items[i].equals(flashType.name())) {
                                return i;
                            }
                            ++i;
                        }
                        return 0;
                    }
                    if (property.equals(COLUMN_PROPERTIES[FILE_SYSTEM_COL])) {
                        String[] items = AbstractComposite.this.fileSystemEditor.getItems();
                        int i = 0;
                        while (i < items.length) {
                            if (items[i].equals(info.getFileSystem().name())) {
                                return i;
                            }
                            ++i;
                        }
                        return 0;
                    }
                    if (property.equals(COLUMN_PROPERTIES[FLASH_INDEX_COL])) {
                        return info.getFlashIndex();
                    }
                    if (GlobleControler.intance.isHi3798CV200()) {
                        if (property.equals(COLUMN_PROPERTIES[PARTITIONNAMECOL])) {
                            return info.getPartitionName() == null ? "" : info.getPartitionName();
                        }
                        if (property.equals(COLUMN_PROPERTIES[PARTITIONVERSIONCOL])) {
                            return "0x" + Integer.toHexString(info.getPartitionVersion());
                        }
                        if (property.equals(COLUMN_PROPERTIES[PARTITIONVERIFYTAGCOL])) {
                            return String.valueOf(info.getPartitionVerifyTag());
                        }
                    }
                    if (property.equals(COLUMN_PROPERTIES[START_ADDRESS_COL])) {
                        return StringUtil.convertUnit(info.getStartAddress());
                    }
                    if (property.equals(COLUMN_PROPERTIES[File_Length_COL])) {
                        long length = info.getLength();
                        if (length == -1L) {
                            return "-";
                        }
                        return StringUtil.convertUnit(length);
                    }
                    if (property.equals(COLUMN_PROPERTIES[FILE_NAME_COL])) {
                        return info.getFileName() == null ? "" : info.getFileName();
                    }
                }
                return null;
            }

            public void modify(Object element, String property, Object value) {
                block58: {
                    try {
                        File file;
                        String valueStr;
                        Object oldValue;
                        String string;
                        Integer index;
                        TableItem item = (TableItem)element;
                        UpgradeFileInfo info = (UpgradeFileInfo)item.getData();
                        if (property.equals(COLUMN_PROPERTIES[FLASH_TYPE_COL])) {
                            index = (Integer)value;
                            if (index == -1) {
                                index = 0;
                            }
                            string = AbstractComposite.this.flashTypeEditor.getItems()[index];
                            oldValue = info.getFlashType();
                            if (oldValue != FlashType.valueOf(string)) {
                                if (oldValue.equals((Object)FlashType.emmc) || FlashType.valueOf(string).equals((Object)FlashType.emmc)) {
                                    info.setFileSystem(FileSystem.none);
                                }
                                info.setFlashType(FlashType.valueOf(string));
                                AbstractComposite.this.updateAddressAtControlChanged(info, (FlashType)((Object)oldValue), info.getFlashIndex());
                            }
                        }
                        if (property.equals(COLUMN_PROPERTIES[FILE_SYSTEM_COL])) {
                            FileSystem valueOf;
                            index = (Integer)value;
                            if (index == -1) {
                                index = 0;
                            }
                            string = AbstractComposite.this.fileSystemEditor.getItems()[index];
                            oldValue = info.getFileSystem();
                            if (oldValue != (valueOf = FileSystem.valueOf(string))) {
                                info.setFileSystem(valueOf);
                                if (info.getFileSystem().equals(FileSystem.yaffs)) {
                                    info.setFlashIndex(info.getFlashIndex() | 0x10000);
                                } else {
                                    info.setFlashIndex(info.getFlashIndex() & 0xFFFF);
                                }
                            }
                        }
                        if (property.equals(COLUMN_PROPERTIES[FLASH_INDEX_COL])) {
                            int oldIndex;
                            int index2 = (Integer)value;
                            if (index2 == -1) {
                                index2 = 0;
                            }
                            if ((oldIndex = info.getFlashIndex()) != index2) {
                                if (info.getFileSystem().equals(FileSystem.yaffs)) {
                                    info.setFlashIndex(index2 | 0x10000);
                                } else {
                                    info.setFlashIndex(index2 & 0xFFFF);
                                }
                                AbstractComposite.this.updateAddressAtControlChanged(info, info.getFlashType(), oldIndex);
                            }
                        }
                        if (property.equals(COLUMN_PROPERTIES[START_ADDRESS_COL])) {
                            long convertToNumber;
                            valueStr = (String)value;
                            if (valueStr.equals("")) {
                                convertToNumber = 0L;
                            } else {
                                convertToNumber = StringUtil.convertToNumber(valueStr);
                                if (convertToNumber % 1024L != 0L) {
                                    MessageDialog.openWarning((Shell)AbstractComposite.this.getShell(), (String)Messages.HiLoaderComposite_9, (String)Messages.HiLoaderComposite_InvalidUnit);
                                    AbstractComposite.this.updateAddress(info);
                                    return;
                                }
                            }
                            long oldAddress = info.getStartAddress();
                            if (convertToNumber != info.getStartAddress()) {
                                info.setStartAddress(convertToNumber);
                                AbstractComposite.this.updateAddress(info);
                                if (AbstractComposite.this.checkAddressIsConflict(info, AbstractComposite.this.updateFiles)) {
                                    info.setStartAddress(oldAddress);
                                    AbstractComposite.this.updateAddress(info);
                                }
                            }
                        }
                        if (GlobleControler.intance.isHi3798CV200()) {
                            if (property.equals(COLUMN_PROPERTIES[PARTITIONNAMECOL])) {
                                String valueStr2 = (String)value;
                                if (valueStr2 != null && !valueStr2.isEmpty()) {
                                    if (valueStr2.length() >= 30) {
                                        AbstractComposite.this.showError(Messages.SsuUpgradeInfoGroup_NameInputError);
                                    } else {
                                        info.setPartitionName(valueStr2.trim());
                                    }
                                } else {
                                    info.setPartitionName("");
                                }
                            }
                            if (property.equals(COLUMN_PROPERTIES[PARTITIONVERSIONCOL])) {
                                String valueStr3 = (String)value;
                                if (!StringUtil.hexInRange(valueStr3, "0x0", "0xFFFFFFFF")) {
                                    AbstractComposite.this.showError(Messages.SsuUpgradeInfoGroup_PartitionVersionInputError);
                                } else {
                                    info.setPartitionVersion(StringUtil.toBigInteger(valueStr3).intValue());
                                }
                            }
                            if (property.equals(COLUMN_PROPERTIES[PARTITIONVERIFYTAGCOL])) {
                                String valueStr4 = (String)value;
                                info.setPartitionVerifyTag(Integer.parseInt(valueStr4));
                            }
                        }
                        if (property.equals(COLUMN_PROPERTIES[File_Length_COL])) {
                            valueStr = (String)value;
                            if (valueStr.equals("")) {
                                long convertToNumber = 0L;
                            } else if (valueStr.equals("-") && AbstractComposite.this.updateFiles.size() > 0 && AbstractComposite.this.updateFiles.get(AbstractComposite.this.updateFiles.size() - 1) == info) {
                                if (info.getLength() != -1L) {
                                    info.setLength(-1L);
                                    AbstractComposite.this.viewer.refresh();
                                    AbstractComposite.this.updateAddress(info);
                                }
                            } else {
                                long convertToNumber = StringUtil.convertToNumber(valueStr);
                                if (convertToNumber % 1024L != 0L) {
                                    MessageDialog.openWarning((Shell)AbstractComposite.this.getShell(), (String)Messages.HiLoaderComposite_9, (String)Messages.Length_should_be_with_unit_KorM_or_1024_times);
                                } else if (info.getLength() != convertToNumber) {
                                    if (info.getFileLength() == 0) {
                                        MessageDialog.openWarning((Shell)AbstractComposite.this.getShell(), (String)Messages.HiLoaderComposite_9, (String)Messages.HiLoaderComposite_SelectFileFirst);
                                        return;
                                    }
                                    if (convertToNumber < (long)info.getFileLength()) {
                                        MessageDialog.openWarning((Shell)AbstractComposite.this.getShell(), (String)Messages.HiLoaderComposite_9, (String)Messages.InvalidFileLength);
                                        return;
                                    }
                                    info.setLength(convertToNumber);
                                    AbstractComposite.this.updateAddress(info);
                                }
                            }
                        }
                        if (!property.equals(COLUMN_PROPERTIES[FILE_NAME_COL])) break block58;
                        if (value == null) {
                            return;
                        }
                        if (((String)value).equals(info.getFileName())) {
                            return;
                        }
                        String str = (String)value;
                        if (str.length() > 0 && (file = new File(str)).length() == 0L) {
                            MessageDialog.openWarning((Shell)AbstractComposite.this.getShell(), (String)Messages.HiLoaderComposite_9, (String)Messages.InvalidLengthFileName);
                            return;
                        }
                        try {
                            info.setFileName((String)value);
                            if (info.getFileName() != null) {
                                info.setFileLength((int)new File(info.getFileName()).length());
                            }
                        }
                        catch (NumberFormatException e) {
                            AbstractComposite.this.showError(Messages.HiLoaderComposite_InvalidInput);
                        }
                    }
                    finally {
                        AbstractComposite.this.viewer.refresh();
                    }
                }
            }
        });
    }

    protected void showMessage(String message) {
        MessageDialog.openInformation((Shell)this.viewer.getControl().getShell(), (String)Messages.HiLoaderComposite_9, (String)message);
    }

    protected void showError(String message) {
        MessageDialog.openError((Shell)Display.getDefault().getActiveShell(), (String)Messages.HiLoaderComposite_10, (String)message);
    }

    protected void removeFile() {
        IStructuredSelection selection = (IStructuredSelection)this.viewer.getSelection();
        UpgradeFileInfo info = (UpgradeFileInfo)selection.getFirstElement();
        if (info == null) {
            return;
        }
        this.updateFiles.remove(info);
        this.viewer.refresh();
    }

    protected void updateAddressAtControlChanged(UpgradeFileInfo part, FlashType oldType, int flashIndex) {
        part.setStartAddress(this.getLastAddress(part));
        this.updateAddress(part);
        long address = 0L;
        for (UpgradeFileInfo item : this.updateFiles) {
            if (item.getFlashType() != oldType || (item.getFlashIndex() & 0xFFFF) != (flashIndex & 0xFFFF)) continue;
            if (address == 0L) {
                address = item.getStartAddress();
            } else {
                item.setStartAddress(address);
                item.setEndAddress(address + item.getLength());
            }
            address += item.getLength();
        }
        this.viewer.refresh();
    }

    protected long getLastAddress(UpgradeFileInfo part) {
        if (!this.updateFiles.contains(part)) {
            return 0L;
        }
        long address = 0L;
        int curPartIndex = this.updateFiles.indexOf(part);
        int lastPartIndex = -1;
        UpgradeFileInfo lastPart = null;
        while ((lastPartIndex = curPartIndex - 1) != -1) {
            lastPart = this.updateFiles.get(lastPartIndex);
            if (part.getFlashType() == lastPart.getFlashType() && (part.getFlashIndex() & 0xFFFF) == (lastPart.getFlashIndex() & 0xFFFF)) {
                address += lastPart.getStartAddress();
                if (lastPart.getLength() <= 0L) break;
                address += lastPart.getLength();
                break;
            }
            --curPartIndex;
        }
        return address;
    }

    protected void updateAddress(UpgradeFileInfo part) {
        long address = 0L;
        for (UpgradeFileInfo item : this.updateFiles) {
            if (address > 0L && item.getFlashType() == part.getFlashType() && (item.getFlashIndex() & 0xFFFF) == (part.getFlashIndex() & 0xFFFF)) {
                item.setStartAddress(address);
                if (item.getLength() > 0L) {
                    address += item.getLength();
                }
                item.setEndAddress(address);
            }
            if (item != part) continue;
            address = part.getStartAddress() + (part.getLength() < 0L ? 0L : part.getLength());
            item.setEndAddress(part.getStartAddress() + part.getLength());
        }
        this.viewer.refresh();
    }

    protected boolean checkAddressIsConflict(UpgradeFileInfo newFile, List<UpgradeFileInfo> files) {
        if (files == null || files.size() == 0) {
            return false;
        }
        UpgradeFileInfo file = null;
        int i = 0;
        while (i < files.size()) {
            file = files.get(i);
            if (!file.equals(newFile) && file.getFlashType().equals((Object)newFile.getFlashType()) && (file.getFlashIndex() & 0xFFFF) == (newFile.getFlashIndex() & 0xFFFF) && (FlashType.emmc != newFile.getFlashType() || BurnType.HI_BURN_TYPE_PART != newFile.getBurnType()) && (file.getStartAddress() <= newFile.getStartAddress() && newFile.getStartAddress() < file.getEndAddress() || newFile.getStartAddress() <= file.getStartAddress() && file.getStartAddress() < newFile.getEndAddress())) {
                this.showError(Messages.SelectFileDialog_39);
                return true;
            }
            ++i;
        }
        return false;
    }

    protected void updateAddressesForAddNew(UpgradeFileInfo part, int index) {
        UpgradeFileInfo item = this.updateFiles.get(index);
        long address = item.getStartAddress();
        if (item.getStartAddress() > 0L) {
            address += item.getLength();
        }
        int i = index + 1;
        while (i < this.updateFiles.size()) {
            item = this.updateFiles.get(i);
            if (item.getFlashType() == part.getFlashType() && (item.getFlashIndex() & 0xFFFF) == (part.getFlashIndex() & 0xFFFF)) {
                item.setStartAddress(address);
                if (item.getLength() > 0L) {
                    address += item.getLength();
                }
                item.setEndAddress(address);
            }
            ++i;
        }
        this.viewer.refresh();
    }

    public void dispose() {
        GlobleControler.intance.removeRunnerStateChangedListener(this);
        super.dispose();
    }

    class ViewContentProvider
    implements IStructuredContentProvider {
        ViewContentProvider() {
        }

        public void inputChanged(Viewer v, Object oldInput, Object newInput) {
        }

        public void dispose() {
        }

        public Object[] getElements(Object parent) {
            return AbstractComposite.this.updateFiles.toArray();
        }
    }

    class ViewLabelProvider
    extends LabelProvider
    implements ITableLabelProvider {
        ViewLabelProvider() {
        }

        public String getColumnText(Object obj, int index) {
            UpgradeFileInfo info = (UpgradeFileInfo)obj;
            if (GlobleControler.intance.isHi3798CV200()) {
                switch (index) {
                    case 1: {
                        String name = info.getPartitionName();
                        return name == null ? "" : name;
                    }
                    case 2: {
                        int version = info.getPartitionVersion();
                        return StringUtil.toHexString(version, 0);
                    }
                    case 3: {
                        int verify = info.getPartitionVerifyTag();
                        return String.valueOf(verify);
                    }
                    case 5: {
                        FlashType flashType = info.getFlashType();
                        return flashType == null ? "" : flashType.name();
                    }
                    case 6: {
                        FileSystem fileSystem = info.getFileSystem();
                        return fileSystem == null ? "" : fileSystem.name();
                    }
                    case 7: {
                        return AbstractComposite.this.getChipList()[info.getFlashIndex() & 0xFFFF];
                    }
                    case 8: {
                        return StringUtil.convertUnit(info.getStartAddress());
                    }
                    case 9: {
                        if (info.getLength() == -1L) {
                            return "-";
                        }
                        return StringUtil.convertUnit(info.getLength());
                    }
                    case 4: {
                        return info.getFileName() == null ? "" : info.getFileName();
                    }
                }
            } else {
                switch (index) {
                    case 2: {
                        FlashType flashType = info.getFlashType();
                        return flashType == null ? "" : flashType.name();
                    }
                    case 3: {
                        FileSystem fileSystem = info.getFileSystem();
                        return fileSystem == null ? "" : fileSystem.name();
                    }
                    case 4: {
                        return AbstractComposite.this.getChipList()[info.getFlashIndex() & 0xFFFF];
                    }
                    case 5: {
                        return StringUtil.convertUnit(info.getStartAddress());
                    }
                    case 6: {
                        if (info.getLength() == -1L) {
                            return "-";
                        }
                        return StringUtil.convertUnit(info.getLength());
                    }
                    case 1: {
                        return info.getFileName() == null ? "" : info.getFileName();
                    }
                }
            }
            return "";
        }

        public Image getColumnImage(Object obj, int index) {
            return null;
        }

        public Image getImage(Object obj) {
            return PlatformUI.getWorkbench().getSharedImages().getImage("IMG_OBJ_ELEMENTS");
        }
    }
}

