/*
 * Decompiled with CFR 0.152.
 */
package com.hisilicon.hiloader.struct;

import com.hisilicon.hiloader.Messages;
import com.hisilicon.hiloader.struct.BurnType;
import com.hisilicon.hiloader.struct.FileSystem;
import com.hisilicon.hiloader.struct.FlashType;
import com.hisilicon.hiloader.util.HiLoaderException;
import java.io.File;

public class UpgradeFileInfo {
    private String partitionName;
    private int partitionVersion;
    private int partitionVerifyTag;
    private String fileName;
    private long startAddress = 0L;
    private long endAddress = 0L;
    private FlashType flashType = FlashType.nand;
    private BurnType burnType = BurnType.HI_BURN_TYPE_RAW;
    private FileSystem fileSystem = FileSystem.none;
    private int flashIndex = 0;
    private static final String compareString = "<>&\"'";
    private int fileLength;
    private long length;
    private boolean sel;

    public boolean isSel() {
        return this.sel;
    }

    public void setSel(boolean sel) {
        this.sel = sel;
    }

    public UpgradeFileInfo() {
    }

    public UpgradeFileInfo(boolean sel, String partitionName, int partitionVersion, int partitionVerifyTag, String fileName, long startAddress, long endAddress, FlashType flashType, FileSystem fileSystem, long flashIndex, long fileLength, long length) {
        this.sel = sel;
        this.partitionName = partitionName;
        this.partitionVersion = partitionVersion;
        this.partitionVerifyTag = partitionVerifyTag;
        this.fileName = fileName;
        this.startAddress = startAddress;
        this.endAddress = endAddress;
        this.flashType = flashType;
        this.fileSystem = fileSystem;
        this.flashIndex = (int)flashIndex;
        this.fileLength = (int)fileLength;
        this.length = length;
    }

    public void validate() throws HiLoaderException {
        if (this.fileName == null || this.fileName.length() == 0 || this.startAddress == -1L || this.endAddress == -1L) {
            throw new HiLoaderException(Messages.UpgradeInfoGroup_InputError);
        }
        File f = new File(this.fileName);
        if (!f.exists()) {
            throw new HiLoaderException(String.format(Messages.UpgradeInfoGroup_FileNotFound, this.fileName));
        }
        this.fileLength = (int)f.length();
        if (this.fileLength == 0) {
            throw new HiLoaderException(Messages.UpgradeInfoGroup_FileIsEmpty);
        }
        if ((FlashType.emmc != this.flashType || FlashType.emmc == this.flashType && BurnType.HI_BURN_TYPE_RAW == this.burnType) && this.startAddress + (long)this.fileLength > this.endAddress) {
            throw new HiLoaderException(Messages.UpgradeInfoGroup_BurningSpaceError);
        }
    }

    public void validateFileName() throws HiLoaderException {
        if (this.fileName == null) {
            throw new HiLoaderException(Messages.UpgradeInfoGroup_InputError);
        }
        int i = 0;
        while (i < compareString.length()) {
            String temp = String.valueOf(compareString.charAt(i));
            if (this.fileName.contains(temp)) {
                throw new HiLoaderException(String.format(Messages.UpgradeInfoGroup_InputError, this.fileName));
            }
            ++i;
        }
    }

    public String getFileName() {
        return this.fileName;
    }

    public void setFileName(String fileName) {
        this.fileName = fileName;
    }

    public long getStartAddress() {
        return this.startAddress;
    }

    public void setStartAddress(long startAddress) {
        this.startAddress = startAddress;
    }

    public long getEndAddress() {
        return this.endAddress;
    }

    public void setEndAddress(long endAddress) {
        this.endAddress = endAddress;
    }

    public FlashType getFlashType() {
        return this.flashType;
    }

    public void setFlashType(FlashType flashType) {
        this.flashType = flashType;
    }

    public int getFlashIndex() {
        return this.flashIndex;
    }

    public void setFlashIndex(int flashIndex) {
        this.flashIndex = flashIndex;
    }

    public int getFileLength() {
        return this.fileLength;
    }

    public void setFileLength(int fileLength) {
        this.fileLength = fileLength;
    }

    public BurnType getBurnType() {
        return this.burnType;
    }

    public void setBurnType(BurnType burnType) {
        this.burnType = burnType;
    }

    public FileSystem getFileSystem() {
        return this.fileSystem;
    }

    public void setFileSystem(FileSystem fileSystem) {
        this.fileSystem = fileSystem;
    }

    public String getPartitionName() {
        return this.partitionName;
    }

    public void setPartitionName(String partitionName) {
        this.partitionName = partitionName;
    }

    public UpgradeFileInfo copy() {
        UpgradeFileInfo info = new UpgradeFileInfo();
        info.setBurnType(this.getBurnType());
        info.setFlashIndex(this.getFlashIndex());
        info.setFlashType(this.getFlashType());
        info.setFileSystem(this.getFileSystem());
        info.setLength(this.getLength());
        info.setPartitionName(this.getPartitionName());
        info.setPartitionVersion(this.getPartitionVersion());
        info.setPartitionVerifyTag(this.getPartitionVerifyTag());
        info.setSel(this.isSel());
        return info;
    }

    public long getLength() {
        return this.length;
    }

    public void setLength(long length) {
        this.length = length;
    }

    public int getPartitionVersion() {
        return this.partitionVersion;
    }

    public void setPartitionVersion(int partitionVersion) {
        this.partitionVersion = partitionVersion;
    }

    public int getPartitionVerifyTag() {
        return this.partitionVerifyTag;
    }

    public void setPartitionVerifyTag(int partitionVerifyTag) {
        this.partitionVerifyTag = partitionVerifyTag;
    }
}

