/*
 * Decompiled with CFR 0.152.
 */
package com.hisilicon.hiloader.struct;

import java.io.IOException;
import java.io.OutputStream;
import java.math.BigInteger;
import java.nio.ByteOrder;
import javolution.io.Struct;

public class AbstractStruct
extends Struct {
    public ByteOrder byteOrder() {
        return ByteOrder.LITTLE_ENDIAN;
    }

    public class Unsigned64
    extends Struct.Member {
        public Unsigned64() {
            super((Struct)AbstractStruct.this, 64, 8);
        }

        public Unsigned64(int nbrOfBits) {
            super((Struct)AbstractStruct.this, nbrOfBits, 8);
        }

        public void write(OutputStream out, ByteOrder o) throws IOException {
            int index = AbstractStruct.this.getByteBufferPosition() + this.offset();
            long val = AbstractStruct.this.getByteBuffer().getLong(index);
            if (o != null && ByteOrder.BIG_ENDIAN.equals(o)) {
                out.write((int)(val >>> 24 & 0xFFL));
                out.write((int)(val >>> 16 & 0xFFL));
                out.write((int)(val >>> 8 & 0xFFL));
                out.write((int)(val & 0xFFL));
            } else {
                out.write((int)(val & 0xFFL));
                out.write((int)(val >>> 8 & 0xFFL));
                out.write((int)(val >>> 16 & 0xFFL));
                out.write((int)(val >>> 24 & 0xFFL));
            }
        }

        public BigInteger get() {
            int index = AbstractStruct.this.getByteBufferPosition() + this.offset();
            long word = AbstractStruct.this.getByteBuffer().getLong(index);
            return this.toBigInt(word);
        }

        public BigInteger toBigInt(long word) {
            byte[] bytes = new byte[8];
            int i = 0;
            while (i < bytes.length) {
                bytes[bytes.length - 1 - i] = (byte)(word & 0xFFL);
                word >>>= 8;
                ++i;
            }
            return new BigInteger(1, bytes);
        }

        public void set(BigInteger big) {
            byte[] bytes = big.toByteArray();
            long l = 0L;
            int i = 0;
            while (i < bytes.length) {
                l = l << 8 | (long)(bytes[i] & 0xFF);
                ++i;
            }
            int index = AbstractStruct.this.getByteBufferPosition() + this.offset();
            if (this.bitLength() == 64) {
                AbstractStruct.this.getByteBuffer().putLong(index, l);
            }
        }

        public String toString() {
            return String.valueOf(this.get());
        }
    }
}

