/*
 * Decompiled with CFR 0.152.
 */
package com.hisilicon.hiloader.model;

import com.hisilicon.hiloader.struct.FileSystem;
import com.hisilicon.hiloader.struct.FlashType;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.Element;
import org.dom4j.io.SAXReader;

public class PartitionItem {
    public static final String PART = "Part";
    private static final String att_Sel = "Sel";
    private static final String att_PartitionName = "PartitionName";
    private static final String att_PartitionVersione = "PartitionVersion";
    private static final String att_PartitionVersionTag = "PartitionVersionTag";
    private static final String att_FlashType = "FlashType";
    private static final String att_FileSystem = "FileSystem";
    private static final String att_Start = "Start";
    private static final String att_Length = "Length";
    private static final String att_SelectFile = "SelectFile";
    private static final String BLANK = " ";
    private static final String VALUE_START = "=\"";
    private static final String VALUE_END = "\"";
    private boolean checked;
    private String partitionName;
    private int PartitionVersione;
    private int PartitionVersionTag;
    private FlashType flashType = FlashType.nand;
    private FileSystem fileSystem = FileSystem.none;
    private long start;
    private long length;
    private File file;

    public File getFile() {
        return this.file;
    }

    public FileSystem getFileSystem() {
        return this.fileSystem;
    }

    public FlashType getFlashType() {
        return this.flashType;
    }

    public long getLength() {
        return this.length;
    }

    public String getName() {
        return this.partitionName;
    }

    public long getStart() {
        return this.start;
    }

    public void setFile(File file) {
        this.file = file;
    }

    public void setFileSystem(FileSystem fileSystem) {
        this.fileSystem = fileSystem;
    }

    public void setFlashType(FlashType flashType) {
        this.flashType = flashType;
    }

    public void setLength(long length) {
        this.length = length;
    }

    public void setName(String name) {
        this.partitionName = name;
    }

    public void setStart(long start) {
        this.start = start;
    }

    public boolean isChecked() {
        return this.checked;
    }

    public void setChecked(boolean checked) {
        this.checked = checked;
    }

    public int getPartitionVersione() {
        return this.PartitionVersione;
    }

    public void setPartitionVersione(int partitionVersione) {
        this.PartitionVersione = partitionVersione;
    }

    public int getPartitionVersionTag() {
        return this.PartitionVersionTag;
    }

    public void setPartitionVersionTag(int partitionVersionTag) {
        this.PartitionVersionTag = partitionVersionTag;
    }

    public static List<PartitionItem> load(File file, boolean xmlPathDefault) throws DocumentException {
        ArrayList<PartitionItem> results = new ArrayList<PartitionItem>();
        if (!file.exists() || !file.isFile()) {
            return results;
        }
        SAXReader reader = new SAXReader();
        Document document = reader.read(file);
        Element root = document.getRootElement();
        File home = new File(file.getParent());
        Iterator parent = root.elementIterator(PART);
        while (parent.hasNext()) {
            Element part = (Element)parent.next();
            PartitionItem PartitionItem2 = PartitionItem.convert(part, home, xmlPathDefault);
            if (PartitionItem2 == null) continue;
            results.add(PartitionItem2);
        }
        return results;
    }

    public final String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("<Part").append(BLANK).append(att_Sel).append(VALUE_START).append(this.isChecked() ? "1" : "0").append(VALUE_END).append(BLANK).append(att_PartitionName).append(VALUE_START).append(this.getName() == null ? "" : this.getName()).append(VALUE_END).append(BLANK).append(att_PartitionVersione).append(VALUE_START).append(String.valueOf(this.getPartitionVersione())).append(VALUE_END).append(BLANK).append(att_PartitionVersionTag).append(VALUE_START).append(String.valueOf(this.getPartitionVersionTag())).append(VALUE_END).append(BLANK).append(att_FlashType).append(VALUE_START).append(this.getFlashType() == null ? "" : this.getFlashType().name()).append(VALUE_END).append(BLANK).append(att_FileSystem).append(VALUE_START).append(this.getFileSystem() == null ? "" : this.getFileSystem().name()).append(VALUE_END).append(BLANK).append(att_Start).append(VALUE_START).append(PartitionItem.convertUnit(this.getStart())).append(VALUE_END).append(BLANK).append(att_Length).append(VALUE_START).append(this.getLength() == -1L ? "-" : PartitionItem.convertUnit(this.getLength())).append(VALUE_END).append(BLANK).append(att_SelectFile).append(VALUE_START).append(this.getFile() == null ? "" : this.getFile().getAbsolutePath()).append(VALUE_END).append("/>\n");
        return sb.toString();
    }

    public static String convertUnit(long num) {
        String unit = "";
        if (num == 0L) {
            return "0";
        }
        if (num % 1024L != 0L) {
            return String.valueOf(num);
        }
        unit = "K";
        if ((num /= 1024L) < 1024L) {
            return String.valueOf(num) + unit;
        }
        if (num % 1024L != 0L) {
            return String.valueOf(num) + unit;
        }
        unit = "M";
        return String.valueOf(num /= 1024L) + unit;
    }

    public static PartitionItem convert(Element part, File home, boolean xmlPathDefault) {
        String PartitionVersionTag;
        String PartitionVersion;
        if (part == null || !part.getName().equals(PART)) {
            return null;
        }
        String sel = part.attributeValue(att_Sel);
        int parseInt = Integer.parseInt(sel);
        if (parseInt != 0 && parseInt != 1) {
            return null;
        }
        PartitionItem item = new PartitionItem();
        item.setChecked(parseInt == 1);
        String partitionName = part.attributeValue(att_PartitionName);
        if (partitionName != null) {
            item.setName(partitionName.toLowerCase());
        }
        if ((PartitionVersion = part.attributeValue(att_PartitionVersione)) != null) {
            item.setPartitionVersione((int)PartitionItem.convertToNumber(PartitionVersion));
        }
        if ((PartitionVersionTag = part.attributeValue(att_PartitionVersionTag)) != null) {
            item.setPartitionVersionTag((int)PartitionItem.convertToNumber(PartitionVersionTag));
        }
        String strFlashType = part.attributeValue(att_FlashType);
        FlashType flashType = FlashType.valueOf(strFlashType.toLowerCase());
        item.setFlashType(flashType);
        String strFileSystem = part.attributeValue(att_FileSystem);
        FileSystem fileSystem = FileSystem.valueOf(strFileSystem.toLowerCase());
        item.setFileSystem(fileSystem);
        String strStart = part.attributeValue(att_Start);
        long convert = PartitionItem.convertToNumber(strStart);
        item.setStart(convert);
        String strLength = part.attributeValue(att_Length);
        if (!strLength.equals("-")) {
            long length = PartitionItem.convertToNumber(strLength);
            item.setLength(length);
        } else {
            item.setLength(-1L);
        }
        String strSelectFile = part.attributeValue(att_SelectFile);
        int lastIndexOf = strSelectFile.lastIndexOf("\\");
        if (lastIndexOf == -1) {
            lastIndexOf = strSelectFile.lastIndexOf("/");
        }
        String newPath = null;
        File newFile = null;
        if (lastIndexOf != -1 || strSelectFile.trim().length() == 0) {
            if (strSelectFile.startsWith("./")) {
                newPath = strSelectFile = String.valueOf(home.getAbsolutePath()) + "/" + strSelectFile.substring("./".length());
                newFile = new File(newPath);
            } else {
                newPath = strSelectFile;
                if (xmlPathDefault) {
                    strSelectFile = strSelectFile.substring(lastIndexOf + 1);
                    newPath = String.valueOf(home.getAbsolutePath()) + "/" + strSelectFile;
                    newFile = new File(newPath);
                } else {
                    newFile = new File(strSelectFile);
                }
            }
        } else {
            newPath = String.valueOf(home.getAbsolutePath()) + "/" + strSelectFile;
            newFile = new File(newPath);
        }
        if (!(newFile == null || newFile.exists() && strSelectFile.length() != 0)) {
            newFile = null;
        }
        item.setFile(newFile);
        return item;
    }

    public static long convertToNumber(String strNum) {
        if (strNum == null || strNum.trim().length() == 0) {
            return -1L;
        }
        strNum = strNum.toLowerCase();
        long unit = 1L;
        int index = strNum.length();
        index = strNum.indexOf("g");
        if (index != -1) {
            unit = 0x40000000L;
        } else {
            index = strNum.indexOf("k");
            if (index != -1) {
                unit = 1024L;
            } else {
                index = strNum.indexOf("m");
                if (index != -1) {
                    unit = 0x100000L;
                } else {
                    index = strNum.indexOf("b");
                    if (index != -1) {
                        unit = 1L;
                    } else {
                        index = strNum.length();
                    }
                }
            }
        }
        try {
            return Long.parseLong(strNum.substring(0, index)) * unit;
        }
        catch (NumberFormatException e) {
            return -1L;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void save(File tableFile, List<PartitionItem> children) {
        FileOutputStream out = null;
        try {
            try {
                out = new FileOutputStream(tableFile);
                ((OutputStream)out).write("<?xml version=\"1.0\" encoding=\"GB2312\" ?>\n".getBytes("GB2312"));
                ((OutputStream)out).write("<Partition_Info>\n".getBytes("GB2312"));
                for (PartitionItem item : children) {
                    ((OutputStream)out).write(item.toString().getBytes("GB2312"));
                }
                ((OutputStream)out).write("</Partition_Info>\n".getBytes("GB2312"));
                return;
            }
            catch (FileNotFoundException e) {
                e.printStackTrace();
                if (out == null) return;
                try {
                    ((OutputStream)out).close();
                    return;
                }
                catch (IOException e2) {
                    e2.printStackTrace();
                }
                return;
            }
            catch (IOException e) {
                e.printStackTrace();
                if (out == null) return;
                try {
                    ((OutputStream)out).close();
                    return;
                }
                catch (IOException e3) {
                    e3.printStackTrace();
                }
                return;
            }
        }
        finally {
            if (out != null) {
                try {
                    ((OutputStream)out).close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }
}

