/*
 * Decompiled with CFR 0.152.
 */
package org.soyatec.console;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.HashMap;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.text.DocumentEvent;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.WorkbenchEncoding;
import org.eclipse.ui.console.MessageConsole;
import org.eclipse.ui.console.MessageConsoleStream;

public class HiConsole
extends MessageConsole
implements IDocumentListener {
    protected static final RGB RGB_DEFAULT = new RGB(0, 0, 0);
    protected static final RGB RGB_RECEIVED = new RGB(255, 0, 0);
    protected static final RGB RGB_WARNING = new RGB(255, 0, 255);
    protected static final RGB RGB_INFO = new RGB(0, 0, 255);
    protected static final String DEFAULT = "DEFAULT";
    protected static final String RECEIVED = "RECEIVED";
    protected static final String INFO = "INFO";
    protected static final String WARNING = "WARNING";
    private File backup = null;
    FileOutputStream out = null;
    protected HashMap<String, MessageConsoleStream> streams = new HashMap();

    public HiConsole(String name, ImageDescriptor imageDescriptor) {
        super(name, imageDescriptor);
        this.initConsole();
        this.setBackup(new File(this.getConsoleDirectory(), this.getBackupName()));
        try {
            this.out = new FileOutputStream(this.getBackup());
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
            System.err.println("Failed to create File for console " + name);
        }
        this.setWaterMarks(400000, 500000);
        IDocument document = this.getDocument();
        document.addDocumentListener((IDocumentListener)this);
    }

    private String getBackupName() {
        return String.valueOf(this.getName()) + ".console";
    }

    private File getConsoleDirectory() {
        File file = new File("configuration");
        if (!file.exists() || !file.isDirectory()) {
            String path = Platform.getInstallLocation().getURL().toString();
            file = new File(String.valueOf(path.substring(1)) + "consoleLog");
        } else {
            file = new File("consoleLog");
        }
        if (!file.exists() && !file.mkdirs()) {
            return null;
        }
        return file;
    }

    public HiConsole(String name) {
        this(name, null);
    }

    public HiConsole() {
        this("HiConsole", null);
    }

    private void initConsole() {
        HiConsole.updateColor(this.getDefaultStream(), RGB_DEFAULT);
        HiConsole.updateColor(this.getReceivedStream(), RGB_RECEIVED);
        HiConsole.updateColor(this.getInfoStream(), RGB_INFO);
        HiConsole.updateColor(this.getWarningStream(), RGB_WARNING);
    }

    public MessageConsoleStream getDefaultStream() {
        MessageConsoleStream stream = this.streams.get(DEFAULT);
        if (stream == null) {
            stream = new MessageConsoleStream((MessageConsole)this);
            this.streams.put(DEFAULT, stream);
            RGB rgb = RGB_DEFAULT;
            HiConsole.updateColor(stream, rgb);
        }
        return stream;
    }

    public MessageConsoleStream getReceivedStream() {
        MessageConsoleStream stream = this.streams.get(RECEIVED);
        if (stream == null) {
            stream = new MessageConsoleStream((MessageConsole)this);
            this.streams.put(RECEIVED, stream);
            RGB rgb = RGB_RECEIVED;
            HiConsole.updateColor(stream, rgb);
        }
        return stream;
    }

    public MessageConsoleStream getWarningStream() {
        MessageConsoleStream stream = this.streams.get(WARNING);
        if (stream == null) {
            stream = new MessageConsoleStream((MessageConsole)this);
            this.streams.put(WARNING, stream);
            RGB rgb = RGB_WARNING;
            HiConsole.updateColor(stream, rgb);
        }
        return stream;
    }

    public MessageConsoleStream getInfoStream() {
        MessageConsoleStream stream = this.streams.get(INFO);
        if (stream == null || stream.isClosed()) {
            stream = new MessageConsoleStream((MessageConsole)this);
            this.streams.put(INFO, stream);
            RGB rgb = RGB_INFO;
            HiConsole.updateColor(stream, rgb);
        }
        return stream;
    }

    public static void updateColor(final MessageConsoleStream stream, final RGB color) {
        if (stream == null || color == null) {
            return;
        }
        final Color current = stream.getColor();
        if (current == null || !color.equals((Object)current.getRGB())) {
            Display.getDefault().asyncExec(new Runnable(){

                @Override
                public void run() {
                    stream.setColor(new Color(null, color));
                    if (current != null) {
                        current.dispose();
                    }
                }
            });
        }
    }

    protected void dispose() {
        super.dispose();
        if (this.out != null) {
            try {
                this.out.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public boolean isClosed() {
        return this.getDocument() == null;
    }

    public void documentAboutToBeChanged(DocumentEvent event) {
    }

    public void documentChanged(DocumentEvent event) {
        String txt = event.fText;
        if (this.out != null) {
            try {
                this.out.write(txt.getBytes(WorkbenchEncoding.getWorkbenchDefaultEncoding()));
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public final File getBackup() {
        return this.backup;
    }

    private final void setBackup(File backup) {
        this.backup = backup;
    }
}

