/*
 * Decompiled with CFR 0.152.
 */
package com.sun.glass.ui.monocle;

import java.util.Arrays;

class IntSet {
    private int[] elements = new int[4];
    private int size = 0;

    IntSet() {
    }

    void addInt(int n) {
        int n2 = this.getIndex(n);
        if (n2 < 0) {
            int n3 = -1 - n2;
            if (this.size == this.elements.length) {
                this.elements = Arrays.copyOf(this.elements, this.size * 2);
            }
            if (n3 != this.size) {
                System.arraycopy(this.elements, n3, this.elements, n3 + 1, this.size - n3);
            }
            this.elements[n3] = n;
            ++this.size;
        }
    }

    void removeInt(int n) {
        int n2 = this.getIndex(n);
        if (n2 >= 0) {
            if (n2 < this.size - 1) {
                System.arraycopy(this.elements, n2 + 1, this.elements, n2, this.size - n2 - 1);
            }
            --this.size;
        }
    }

    boolean containsInt(int n) {
        return this.getIndex(n) >= 0;
    }

    private int getIndex(int n) {
        int n2;
        for (n2 = 0; n2 < this.size; ++n2) {
            if (this.elements[n2] == n) {
                return n2;
            }
            if (this.elements[n2] <= n) continue;
            return -n2 - 1;
        }
        return -n2 - 1;
    }

    int get(int n) {
        return this.elements[n];
    }

    void difference(IntSet intSet, IntSet intSet2) {
        int n = 0;
        int n2 = 0;
        while (n < this.size && n2 < intSet2.size) {
            int n3 = this.elements[n];
            int n4 = intSet2.elements[n2];
            if (n3 < n4) {
                intSet.addInt(n3);
                ++n;
                continue;
            }
            if (n3 > n4) {
                ++n2;
                continue;
            }
            ++n;
            ++n2;
        }
        while (n < this.size) {
            intSet.addInt(this.elements[n]);
            ++n;
        }
    }

    void clear() {
        this.size = 0;
    }

    int size() {
        return this.size;
    }

    boolean isEmpty() {
        return this.size == 0;
    }

    void copyTo(IntSet intSet) {
        if (intSet.elements.length < this.size) {
            intSet.elements = Arrays.copyOf(this.elements, this.elements.length);
        } else {
            System.arraycopy(this.elements, 0, intSet.elements, 0, this.size);
        }
        intSet.size = this.size;
    }

    public boolean equals(IntSet intSet) {
        if (intSet.size == this.size) {
            for (int i = 0; i < this.size; ++i) {
                if (intSet.elements[i] == this.elements[i]) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public boolean equals(Object object) {
        if (object instanceof IntSet) {
            return this.equals((IntSet)object);
        }
        return false;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer("IntSet[");
        for (int i = 0; i < this.size; ++i) {
            stringBuffer.append(this.elements[i]);
            if (i >= this.size - 1) continue;
            stringBuffer.append(",");
        }
        stringBuffer.append("]");
        return stringBuffer.toString();
    }
}

