/*
 * Decompiled with CFR 0.152.
 */
package com.hisilicon.fastplay.processor;

import com.hisilicon.fastplay.Messages;
import com.hisilicon.fastplay.model.ts.TSParam;
import com.hisilicon.fastplay.processor.IBniParamServer;
import com.hisilicon.fastplay.utility.FileUtil;
import com.hisilicon.fastplay.utility.FileUtils;
import com.hisilicon.fastplay.utility.HiToolUtils;
import com.hisilicon.fastplay.utility.StatusUtility;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;

public class TSParamProcess
implements IBniParamServer {
    private static final String filesuffix = ".jpg";
    private static final String tsName = "animation.h264";
    private static final String srcFile = "img_%03d.jpg";
    private static final String param = " -i ";
    private static final String param2 = " -pix_fmt yuv420p ";
    private static final String ffmpeg = "ffmpeg";
    private static final String hiFastplay = "HiFastplay";
    private static final String resDir = "Resources";
    private static final String ffmpetexe = "ffmpeg.exe";
    private String param1 = " -vcodec h264 -pix_fmt yuv420p -s 1920*1080 ";
    private String ffmpegPath;
    private String tempPath;
    private TSParam tsParam;

    @Override
    public Object paramProcess(Object obj) {
        this.tsParam = (TSParam)obj;
        String cmd = this.makeCmdCommand(obj);
        String[] srcFiles = this.tsParam.getSrcFiles();
        String checkFfmpegPath = "";
        String osName = System.getProperties().getProperty("os.name");
        checkFfmpegPath = osName.toLowerCase().startsWith("linux") ? (String.valueOf(this.ffmpegPath) + ffmpeg).replace("\\", "/") : (String.valueOf(this.ffmpegPath) + ffmpetexe).replace("\\", "/");
        if (!new File(checkFfmpegPath).exists()) {
            MessageDialog.openError((Shell)Display.getDefault().getActiveShell(), (String)Messages.SettingComposite_14, (String)Messages.TSParamProcessCheck_2);
            return StatusUtility.error(Messages.TSParamProcessCheck_2);
        }
        int picNum = srcFiles.length;
        String[] clearTargetFiles = new String[picNum];
        String tempName = null;
        int i = 0;
        while (i < picNum) {
            tempName = i + 1 >= 10 ? "img_0" + (i + 1) + filesuffix : "img_00" + (i + 1) + filesuffix;
            clearTargetFiles[i] = osName.toLowerCase().startsWith("linux") ? String.valueOf(this.tempPath) + tempName : (String.valueOf(this.tempPath) + tempName).replace("/", "\\");
            FileUtil.copyFile(srcFiles[i], clearTargetFiles[i]);
            ++i;
        }
        try {
            Runtime runtime = Runtime.getRuntime();
            System.out.println("cmd: " + cmd);
            Process exec = runtime.exec(cmd);
            InputStream errorStream = exec.getErrorStream();
            new PrintStream(errorStream).start();
            exec.waitFor();
            if (!FileUtils.isExists(String.valueOf(this.tempPath) + tsName)) {
                MessageDialog.openWarning((Shell)Display.getDefault().getActiveShell(), (String)Messages.commom_msg_warning, (String)("Command is " + cmd + "\r\n" + Messages.TSComposite_ParamProcess));
                return Status.CANCEL_STATUS;
            }
        }
        catch (IOException e) {
            e.printStackTrace();
            MessageDialog.openError((Shell)Display.getDefault().getActiveShell(), (String)Messages.SettingComposite_14, (String)("Command is " + cmd + "\r\n" + e.getMessage()));
            return StatusUtility.error(e.getMessage());
        }
        catch (InterruptedException e) {
            e.printStackTrace();
            MessageDialog.openError((Shell)Display.getDefault().getActiveShell(), (String)Messages.SettingComposite_14, (String)("Command is " + cmd + "\r\n" + e.getMessage()));
            return StatusUtility.error(e.getMessage());
        }
        String tsPath = "";
        tsPath = osName.toLowerCase().startsWith("linux") ? String.valueOf(this.tempPath) + tsName : (String.valueOf(this.tempPath) + tsName).replace("/", "\\");
        this.tsParam.setTsSrcPath(tsPath);
        return Status.OK_STATUS;
    }

    private String makeCmdCommand(Object obj) {
        String osName = System.getProperties().getProperty("os.name");
        if (osName.toLowerCase().startsWith("linux")) {
            this.ffmpegPath = String.valueOf(File.separator) + this.tsParam.getTsSrcPath() + resDir + File.separator + hiFastplay + File.separator + ffmpeg + File.separator;
            this.tempPath = String.valueOf(HiToolUtils.getInstallPath()) + ffmpeg + File.separator;
        } else {
            this.ffmpegPath = String.valueOf(this.tsParam.getTsSrcPath()) + resDir + File.separator + hiFastplay + File.separator + ffmpeg + File.separator;
            this.tempPath = String.valueOf(System.getenv("TEMP")) + File.separator + ffmpeg + File.separator;
        }
        System.out.println("tempPath= " + this.tempPath);
        this.clearFile();
        this.checkWinTempDir(this.tempPath);
        StringBuilder cmdbd = new StringBuilder();
        if (osName.toLowerCase().startsWith("linux")) {
            cmdbd.append(this.ffmpegPath);
            cmdbd.append(ffmpeg);
            cmdbd.append(param2);
            cmdbd.append(param);
            cmdbd.append(this.tempPath);
            cmdbd.append(srcFile);
            cmdbd.append(this.param1);
            cmdbd.append(" ");
            cmdbd.append(this.tempPath);
            cmdbd.append(tsName);
            return cmdbd.toString();
        }
        cmdbd.append(this.ffmpegPath);
        cmdbd.append(ffmpetexe);
        cmdbd.append(param2);
        cmdbd.append(param);
        cmdbd.append("\"");
        cmdbd.append(this.tempPath);
        cmdbd.append(srcFile);
        cmdbd.append("\"");
        cmdbd.append(this.param1);
        cmdbd.append(" ");
        cmdbd.append("\"");
        cmdbd.append(this.tempPath);
        cmdbd.append(tsName);
        cmdbd.append("\"");
        return cmdbd.toString().replace("/", "\\");
    }

    private void checkWinTempDir(String tempDir) {
        if (!new File(tempDir).exists()) {
            boolean bl = new File(tempDir).mkdir();
        }
    }

    public void clearFile() {
        if (new File(this.tempPath).exists()) {
            File[] delFile = new File(this.tempPath).listFiles();
            int i = 0;
            while (i < delFile.length) {
                if (delFile[i].getName() != null && !ffmpetexe.equals(delFile[i].getName())) {
                    boolean bl = delFile[i].delete();
                }
                ++i;
            }
        }
    }

    static class PrintStream
    extends Thread {
        InputStream is = null;

        public PrintStream(InputStream is) {
            this.is = is;
        }

        @Override
        public void run() {
            try {
                while (this != null) {
                    int ch = this.is.read();
                    if (ch != -1) {
                        System.out.print((char)ch);
                        continue;
                    }
                    break;
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }
}

