/*
 * Decompiled with CFR 0.152.
 */
package org.soyatec.preferences;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.WorkbenchEncoding;
import org.soyatec.preferences.Messages;

public class HiBurnState {
    public static final HiBurnState INSTANCE = new HiBurnState();
    private File partitionPath;
    private String partitionContent;
    private File emmcParitionPath;
    private String emmcPartitionContent;

    private HiBurnState() {
    }

    public String getPartionContent() {
        return this.partitionContent;
    }

    public void setPartitionContent(String partionContent) {
        this.partitionContent = partionContent;
    }

    public String getEmmcPartitionContent() {
        return this.emmcPartitionContent;
    }

    public void setEmmcPartitionContent(String emmcPartitionContent) {
        this.emmcPartitionContent = emmcPartitionContent;
    }

    public void clear() {
        this.clearEmmcPartition();
        this.clearPartition();
    }

    public void clearEmmcPartition() {
        this.setEmmcParitionPath(null);
        this.setEmmcPartitionContent(null);
    }

    public void clearPartition() {
        this.setPartitionContent(null);
        this.setPartitionPath(null);
    }

    public boolean needToSave() {
        return this.getPartionContent() != null || this.getEmmcPartitionContent() != null;
    }

    public int promptToSave(boolean canCancel) {
        Shell shell;
        int open;
        block13: {
            open = 0;
            if (!this.needToSave()) {
                return open;
            }
            IWorkbenchWindow activeWorkbenchWindow = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
            shell = activeWorkbenchWindow.getShell();
            try {
                try {
                    boolean openConfirm;
                    if (this.getPartionContent() != null && (openConfirm = MessageDialog.openConfirm((Shell)shell, (String)"HiBurn", (String)Messages.HiBurn_Whether_to_save_partitions))) {
                        this.savePartitionTable(this.getPartitionPath(), this.getPartionContent());
                    }
                }
                catch (IOException e) {
                    e.printStackTrace();
                    this.clearPartition();
                    break block13;
                }
            }
            catch (Throwable throwable) {
                this.clearPartition();
                throw throwable;
            }
            this.clearPartition();
        }
        try {
            try {
                boolean openConfirm;
                if (this.getEmmcPartitionContent() != null && (openConfirm = MessageDialog.openConfirm((Shell)shell, (String)"HiBurn", (String)Messages.HiBurn_Whether_to_save_emmc_partitions))) {
                    this.savePartitionTable(this.getEmmcParitionPath(), this.getEmmcPartitionContent());
                }
            }
            catch (IOException e) {
                e.printStackTrace();
                this.clearEmmcPartition();
            }
        }
        finally {
            this.clearEmmcPartition();
        }
        return open;
    }

    protected void savePartitionTable(File file, String content) throws IOException {
        Shell shell = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell();
        FileDialog fileDialog = new FileDialog(shell, 8192);
        if (file != null) {
            fileDialog.setFilterPath(file.getAbsolutePath());
        }
        fileDialog.setFilterExtensions(new String[]{"*.xml"});
        String open = fileDialog.open();
        if (open != null) {
            File target = new File(open);
            FileOutputStream out = new FileOutputStream(target);
            out.write(content.getBytes(WorkbenchEncoding.getWorkbenchDefaultEncoding()));
            out.close();
        }
    }

    public File getPartitionPath() {
        return this.partitionPath;
    }

    public void setPartitionPath(File partitionPath) {
        this.partitionPath = partitionPath;
    }

    public File getEmmcParitionPath() {
        return this.emmcParitionPath;
    }

    public void setEmmcParitionPath(File emmcParitionPath) {
        this.emmcParitionPath = emmcParitionPath;
    }
}

